/*
 * Copyright 2002 Niels Provos <provos@citi.umich.edu>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by Niels Provos.
 * 4. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
#ifndef _ROUTER_H_
#define _ROUTER_H_

struct network {
	struct network *left;
	struct network *mid;
	struct network *right;

	uint16_t	depth;
	struct addr	net;

	void	*data;
};

enum net_order
{
	NET_PRECEEDS,
	NET_FOLLOWS,
	NET_EQUALS,
	NET_CONTAINS,
	NET_CONTAINED
};

enum route_type {ROUTE_LINK = 0, ROUTE_NET, ROUTE_UNREACH, ROUTE_TUNNEL};

struct link_drop {
	int low;
	int high;
};

struct link_entry {
	SPLAY_ENTRY(link_entry) node;

	struct addr dst;

	/* Link characteristics */
	int latency;
	int packetloss;		/* percent x 100 */
	int bandwidth;		/* multiplier to get delay in us */
	int divider;		/* value to divide by */

	struct link_drop red;	/* Random Early Drop thresholds */

	struct timeval tv_busy;	/* time that we are busy sending */
};

struct router_entry {
	SPLAY_ENTRY(router_entry) node;

	struct router *parent;
	struct router *gw;
	struct addr net;

	struct link_entry *link;
	
	enum route_type type;

	struct addr tunnel_src;
	struct addr tunnel_dst;
};

struct router {
	SPLAY_ENTRY(router) node;

	struct network *routes;

	struct addr addr;		/* IP address of router */
	struct addr network;		/* Responsible (entry router only) */

	SPLAY_HEAD(linktree, link_entry) links;

	int flags;
};

#define ROUTER_ISENTRY	0x0001

extern int router_used;
extern struct network *entry_routers;

void router_init(void);
struct router *router_new(struct addr *);
int router_start(struct addr *, struct addr *);
void router_end(void);
struct router *router_find(struct addr *);
int router_add_link(struct router *, struct addr *);
int router_add_unreach(struct router *, struct addr *);
int router_add_net(struct router *, struct addr *, struct router *, int, int,
    int, struct link_drop *);
int router_add_tunnel(struct router *, struct addr *, struct addr *, struct addr *);

struct link_entry *link_entry_find(struct linktree *, struct addr *);
struct link_entry *link_entry_new(struct addr *);

struct router_entry *router_find_tunnel(struct addr *, struct addr *);
struct router_entry *router_find_nexthop(struct router *, struct addr *);

void *network_lookup(struct network *, struct addr *);
#endif
