/*
 * Copyright 2003 Niels Provos <provos@citi.umich.edu>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by Niels Provos.
 * 4. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <sys/param.h>
#include <sys/types.h>

#include "config.h"
#ifdef HAVE_SYS_TIME_H
#include <sys/time.h>
#endif

#include <sys/stat.h>
#include <sys/tree.h>
#include <sys/wait.h>
#include <sys/queue.h>

#include <err.h>
#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <syslog.h>
#include <unistd.h>
#include <dnet.h>
#include <ctype.h>
#ifdef HAVE_TIME_H
#include <time.h>
#endif

#undef timeout_pending
#undef timeout_initialized

#include <event.h>

#include "honeyd.h"
#include "template.h"
#include "personality.h"
#include "condition.h"
#include "pfvar.h"
#include "osfp.h"

/*
 * Match an operating system (p0f) fingerprint
 */

int
condition_match_osfp(struct template *tmpl, struct ip_hdr *ip, u_short iplen,
    void *arg)
{
	pf_osfp_t fp = *(pf_osfp_t *)arg;

	return (honeyd_osfp_match(ip, fp));
}

/*
 * Match the source address of a machine
 */

int
condition_match_addr(struct template *tmpl, struct ip_hdr *ip, u_short iplen,
    void *arg)
{
	struct addr *tmp = arg;
	struct addr addr_start, addr_end, src;

	addr_pack(&src, ADDR_TYPE_IP, IP_ADDR_BITS, &ip->ip_src, IP_ADDR_LEN);

	addr_start = *tmp;
	addr_start.addr_bits = IP_ADDR_BITS;

	addr_bcast(tmp, &addr_end);
	addr_end.addr_bits = IP_ADDR_BITS;

	if (addr_cmp(&src, &addr_start) < 0)
		return (0);
	if (addr_cmp(&src, &addr_end) > 0)
		return (0);

	return (1);
}

static int
daysec(struct tm *tm)
{
	int seconds;

	seconds = (tm->tm_hour * 60 + tm->tm_min) * 60 + tm->tm_sec;

	return (seconds);
}

/*
 * Match the time of access
 */

int
condition_match_time(struct template *tmpl, struct ip_hdr *ip, u_short iplen,
    void *arg)
{
	time_t tmp;
	struct tm now;
	int start_sec, now_sec, end_sec;
	struct timeval tv;
	struct condition_time *cdt = arg;

	gettimeofday(&tv, NULL);

	tmp = tv.tv_sec; localtime_r(&tmp, &now);

	start_sec = daysec(&cdt->tm_start);
	now_sec = daysec(&now);
	end_sec = daysec(&cdt->tm_end);
	
	return (start_sec <= now_sec && now_sec <= end_sec);
}
