#ifndef _REWRITE_H
#define _REWRITE_H

#include <stdbool.h>
#include <regex.h>
#include "liblist.h"

#define RW_ERROR        -1
#define RW_RETURN        0
#define RW_EXIT          1
#define RW_REDIRECT    301
#define RW_DENY_ACCESS 403

#define IU_EXISTS        0
#define IU_ISFILE        1
#define IU_ISDIR         2

typedef enum { rw_match_rewrite, rw_match_goto, rw_match_call, rw_match_return, 
               rw_match_exit, rw_match_skip, rw_call, rw_match_deny_access,
			   rw_match_redirect, rw_skip, rw_requesturi} t_rewrite_action;
typedef enum { am_nothing, am_return, am_exit } t_after_rewrite;

typedef struct type_rewrite_rule {
	regex_t pattern;
	t_rewrite_action action;
	t_after_rewrite after_rewrite;
	int match_loop;
	char *parameter;
	int value;

	struct type_rewrite_rule *next;
} t_rewrite_rule;

typedef struct type_url_rewrite {
	char *rewrite_id;
	struct type_rewrite_rule *rewrite_rule;

	struct type_url_rewrite *next;
} t_url_rewrite;

t_url_rewrite *find_url_rewrite(char *rewrite_id, t_url_rewrite *url_rewrite);
bool url_rewrite_setting(char *key, char *value, t_url_rewrite *rewrite);
bool rewrite_rules_oke(t_url_rewrite *url_rewrite);
int rewrite_url(char *url, char *rewrite_id, t_url_rewrite *url_rewrite, char **new_url, char *website_root);

#endif
