#include "config.h"

#ifdef HAVE_PLUGIN

#include <stdio.h>
#include <stdlib.h>
#include <stdbool.h>
#include <string.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/socket.h>
#include "plugin.h"

#define MAX_CHUNK_SIZE 2048

extern char *chunked;
static char *chunkbuffer;
static int chunksize;

char *hiaw = "             Hiawatha webserver "VERSION"\n"
             "             _______  ____________\n"
             "        ,,/\\/    /  \\/  //  /  /  \\\\\n"
             "=\\\\\\\\\\\\\\============================-\n"
             "        ``\\ \\  \\\\   \\    \\   /\\  \\ /\n"
             "           ----- ------------  ---\n";
int hiaw_len = 0;
char *plugin_uri = "hiawatha";

static int send_buffer(t_request_info *request_info, char *buffer, int size) {
	int bytes_sent, total_sent = 0;

	do {
		if ((bytes_sent = send(request_info->fd, buffer + total_sent, size - total_sent, 0)) == -1) {
			close(request_info->fd);
			return -1;
		}
		total_sent += bytes_sent;
	} while (total_sent < size);

	return 0;
}

static int send_chunk(t_request_info *request_info, char *chunk, int size) {
	char hex[10];
	bool must_send = false, copy_chunk = false, last_chunk = false;
	int result = 0;

	if (chunk != NULL) {
		if (chunksize + size <= MAX_CHUNK_SIZE) {
			if (chunksize > 0) {
				memcpy(chunkbuffer + chunksize, chunk, size);
				chunksize += size;
			} else {
				copy_chunk = true;
			}
		} else {
			must_send = true;
			copy_chunk = true;
		}
	} else {
		must_send = true;
		last_chunk = true;
	}

	if (must_send && (chunksize > 0)) {
		if (request_info->keep_alive) {
			hex[9] = '\0';
			snprintf(hex, 9, "%x\r\n", chunksize);
			result = send_buffer(request_info, hex, strlen(hex));
		}
		if (result == 0) {
			send_buffer(request_info, chunkbuffer, chunksize);
		}
		if (request_info->keep_alive && (result == 0)) {
			result = send_buffer(request_info, "\r\n", 2);
		}
		free(chunkbuffer);
		chunksize = 0;
	}

	if (last_chunk && request_info->keep_alive && (result == 0)) {
		send_buffer(request_info, "0\r\n\r\n", 5);
	}

	if (copy_chunk) {
		if ((chunkbuffer = (char*)malloc(MAX_CHUNK_SIZE)) != NULL) {
			memcpy(chunkbuffer, chunk, size);
			chunksize = size;
		} else {
			result = -1;
		}
	}

	return result;
}

static void chunk_init(t_request_info *request_info) {
	chunkbuffer = NULL;
	chunksize = 0;

	send_buffer(request_info, chunked, 28);
}

static void chunk_destroy(t_request_info *request_info) {
	send_chunk(request_info, NULL, 0);
}

/* START CODING HERE */

int plugin_init(void) {
	hiaw_len = strlen(hiaw);

	return 0;
}

char *get_plugin_uri(void) {
	return plugin_uri;
}

void plugin_timer(void) {
}

void plugin_request(t_request_info *request_info) {
	char *contyp = "Content-Type: text/plain\r\n";

/*
	if (request_info->keep_alive) {
		chunk_init(request_info);
		send_buffer(request_info, contyp, 26);
		send_buffer(request_info, "\r\n", 2);

		send_chunk(request_info, hiaw, hiaw_len);

		chunk_destroy(request_info);
	} else {
*/
		fprintf(request_info->fp, contyp);
		fprintf(request_info->fp, "Content-Length: %d\r\n\r\n", hiaw_len);

		fprintf(request_info->fp, hiaw);
//	}
}

void plugin_destroy(void) {
}

#endif
