#ifndef _LIBSSL_H
#define _LIBSSL_H

#ifdef HAVE_SSL
#include <stdbool.h>
#include <openssl/err.h>
#include <openssl/ssl.h>

void sslInit(void);
SSL_CTX *ssl_binding(const char* sslKeyFile, const char* sslPassword);
bool ssl_accept(int socketFD, SSL **ssl, SSL_CTX *sslContext);
int  ssl_receive(SSL *ssl, char *buffer, unsigned int maxlength);
int  ssl_send(SSL *ssl, char *buffer, unsigned int length);
int  ssl_close(SSL *ssl);
void ssl_cleanup(SSL_CTX *sslContext);
void ssl_set_environment(SSL *ssl_data);

#endif

#endif
