/* Hiawatha | userconfig.c
 *
 * All the routines for loading the configuration files
 */
#include "config.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <pwd.h>
#include <grp.h>
#include "libstr.h"
#include "userconfig.h"

void init_groups(t_groups *groups) {
	groups->number = 0;
	groups->array = NULL;
}

int parse_userid(char *userid, uid_t *uid) {
	struct passwd *pwd;

	if ((*uid = str2int(userid)) == -1) {
		if ((pwd = getpwnam(userid)) == NULL) {
			return -1;
		}
		*uid = pwd->pw_uid;
	}
	if (*uid == 0) {
		return 0;
	}

	return 1;
}

static gid_t parse_groupid(char *groupid, gid_t *gid) {
	struct passwd *pwd;

	if ((*gid = str2int(groupid)) == -1) {
		if ((pwd = getpwnam(groupid)) == NULL) {
			return -1;
		}
		*gid = pwd->pw_gid;
	}
	if (*gid == 0) {
		return 0;
	}

	return 1;
}

int parse_groups(char *groupid, gid_t *gid, t_groups *groups) {
	int i, count = 0, result = 0;
	gid_t *id;
	char *c;

	c = groupid;
	while (*c != '\0') {
		if (*c == ',') {
			count++;
			*c = '\0';
		}
		c++;
	}

	if ((result = parse_groupid(groupid, gid)) == -1) {
		return -1;
	} else if ((groups->number = count) == 0) {
		return result;
	} else if ((groups->array = id = (gid_t*)malloc(groups->number * sizeof(gid_t))) == NULL) {
		return -1;
	}

	for (i = 0; i < count; i++) {
		groupid = groupid + strlen(groupid) + 1;
		switch (parse_groupid(groupid, id)) {
			case -1:
				free(groups->array);
				return -1;
			case 0:
				result = 0;
				break;
		}
		id++;
	}

	return result;
}

static bool is_member(char *user, char **group) {
	while (*group != NULL) {
		if (strcmp(user, *group) == 0) {
			return true;
		}
		group++;
	}

	return false;
}

int lookup_group_ids(uid_t uid, gid_t *gid, t_groups *groups) {
	struct passwd *pwd;
	struct group *grp;
	int size, result;
	gid_t *id;

	if ((pwd = getpwuid(uid)) == NULL) {
		return -1;
	}
	if ((*gid = pwd->pw_gid) == 0) {
		result = 0;
	} else {
		result = 1;
	}

	groups->number = size = 0;
	groups->array = NULL;
	while ((grp = getgrent()) != NULL) {
		if (is_member(pwd->pw_name, grp->gr_mem)) {
			if (grp->gr_gid == 0) {
				result = 0;
			}
			if (groups->number == size) {
				size += 10;
				if ((id = realloc(groups->array, size * sizeof(gid_t))) == NULL) {
					free(groups->array);
					return -1;
				}
				groups->array = id;
			}
			*(groups->array + groups->number) = grp->gr_gid;
			groups->number++;
		}
	}
	endgrent();

	return result;
}
