/*****************************************************
 Common Functions for the Heartbeat Client and Server
******************************************************
 $Author: jeroen $
 $Id: common.c,v 1.2 2003/10/26 14:29:58 jeroen Exp $
 $Date: 2003/10/26 14:29:58 $
*****************************************************/

#include <stdio.h>
#include <errno.h>
#include <unistd.h>
#include <stdarg.h>
#include <stdlib.h>
#include <string.h>
#include <strings.h>
#include <ctype.h>
#include <time.h>
#include <syslog.h>
#include <signal.h>

#include "config.h"

extern int g_daemonize;

void hblog(int level, char *fmt, ...)
{
	va_list ap;
	va_start(ap, fmt);
	if (g_daemonize) vsyslog(LOG_LOCAL7|level, fmt, ap);
	else vprintf(fmt, ap);
	va_end(ap);
}

int huprunning()
{
	int pid;

	FILE *f = fopen(HEARTBEAT_PID, "r");
	if (!f) return 0;
	fscanf(f, "%d", &pid);
	fclose(f);
	// If we can HUP it, it still runs
	return (kill(pid, SIGHUP) == 0 ? 1 : 0);
}

void savepid()
{
	FILE *f = fopen(HEARTBEAT_PID, "w");
	if (!f) return;
	fprintf(f, "%d", getpid());
	fclose(f);

	hblog(LOG_INFO, "Running as PID %d", getpid());
}

void cleanpid(int i)
{
	hblog(LOG_INFO, "Exiting...");
	unlink(HEARTBEAT_PID);
	exit(0);
}

