#!/usr/bin/perl
#
# Hatchet event viewer cgi
# v 0.9
# Jason Dixon <jason@dixongroup.net>
# http://www.dixongroup.net/hatchet/
#

use strict;
use Time::Local qw( timelocal );

our ($chroot_db_file, $mem_tables, $ipv6, $url_service, $url_address, $css_file);
require "../conf/hatchet.conf";


my $dbh = DBI->connect("DBI:SQLite:dbname=$chroot_db_file", "", "") || die $DBI::errstr;
my $cgi = CGI->new;

my $select_query = "select * from logs where date >= ? and date <= ?";

if ($cgi->param('sort')) {
	$select_query .= " order by ";

	SWITCH: {
		if ($cgi->param('sort') eq 'rule') { $select_query .= "rulenum"; last SWITCH; }
		if ($cgi->param('sort') eq 'proto') { $select_query .= "proto"; last SWITCH; }
		if ($cgi->param('sort') eq 'action') { $select_query .= "action"; last SWITCH; }
		if ($cgi->param('sort') eq 'intf') { $select_query .= "interface"; last SWITCH; }
		if ($cgi->param('sort') eq 'src') { $select_query .= "src_host"; last SWITCH; }
		if ($cgi->param('sort') eq 'dst') { $select_query .= "dst_host"; last SWITCH; }
		if ($cgi->param('sort') eq 'svc') { $select_query .= "dst_port"; last SWITCH; }
		$select_query .= "date";
	}

	if ($cgi->param('d')) {
		$select_query .= " desc" if ($cgi->param('d') eq 'desc');
	}
}

# Set our tmp directory for temp SQLite tables
$dbh->do("PRAGMA temp_store=1");
$dbh->do("PRAGMA temp_store_directory='../tmp'");

my $sth = $dbh->prepare($select_query);
my ($date, $month, $day, $month_num);
my @timestamp = localtime(time);

# From navigation form
if ($cgi->param('month')) {
	$month = $cgi->param('month');
	$day = sprintf("%02d", $cgi->param('day'));
# From column links
} elsif ($cgi->param('date')) {
	$date = $cgi->param('date');
	($month, $day) = split(/ /, $date);
	$day = sprintf("%02d", $day);
# Everywhere else
} else {
	$month = $timestamp[4];
	$day = sprintf("%02d", $timestamp[3]);
	$month_num = 1;
}

$date = "$month $day";
my $date_param = '&date=' . $date;
my $year = $timestamp[5];
if (!$month_num) {
	my %months = qw( Jan 0 Feb 1 Mar 2 Apr 3 May 4 Jun 5 Jul 6 Aug 7 Sep 8 Oct 9 Nov 10 Dec 11 );
	$month = $months{$month};
}
my $epoch_start_of_day = timelocal(0, 0, 0, $day, $month, $year);
my $epoch_end_of_day = timelocal(59, 59, 23, $day, $month, $year);
print STDERR "$select_query, $epoch_start_of_day, $epoch_end_of_day\n";
$sth->execute($epoch_start_of_day, $epoch_end_of_day);
my @log_loop;


my $alt = 0;
while (my $result = $sth->fetchrow_hashref) {
	next if ((($result->{'src_host'} =~ /\:/) || ($result->{'dst_host'} =~ /\:/)) && ($ipv6 == 0));
	my $epoch = $result->{'date'};
	my ($sec, $min, $hour, $mday, $month) = (localtime($epoch))[0..4];
	my @months = qw( Jan Feb Mar Apr May Jun Jul Aug Sep Oct Nov Dec );
	$month = $months[$month];
	$hour = sprintf("%02d", $hour);
	$min = sprintf("%02d", $min);
	$sec = sprintf("%02d", $sec);
	$result->{'date'} = "$month $mday $hour:$min:$sec";
	unless ($result->{'src_host'} eq 'encrypted') {
		#$result->{'src_host'} = "<a href=\"http://www.dnsstuff.com/tools/ptr.ch?ip=$result->{'src_host'}\" target=\"new\">$result->{'src_host'}</a>";
		$result->{'src_host'} = '<a href="' . $url_address . $result->{'src_host'} . '" target="new">' . $result->{'src_host'} . '</a>';
	}
	if ($result->{'dst_port'} =~ /^\d+$/) {
		$result->{'dst_port'} = '<a href="' . $url_service . $result->{'dst_port'} . '" target="new">' . $result->{'dst_port'} . '</a>';
	}
	$result->{'alt'} = ' class="alt"' if ($alt % 2 == 0);
	$alt++;
	push(@log_loop, $result);
}

my $template = HTML::Template->new(filename => 'templates/output.tmpl', die_on_bad_params => 0);
my $time = localtime;
$template->param("month${timestamp[4]}" => ' selected="selected"');
$template->param(time => $time, date => $date_param, data => \@log_loop);
$template->param(opts => '&d=desc') unless ($cgi->param('d') eq 'desc');
$template->param(css_file => $css_file);
print "Content-Type: text/html\n\n", $template->output;

