#include "ptyx.h"
#include <stdlib.h>

#if OPT_HANGUL

#define MAXHISTENT 40
#define MAXHISTBUF 256

typedef struct {
    Char line[MAXHISTBUF];
} HIST_ENTRY;

static HIST_ENTRY *the_history[MAXHISTENT];
static HIST_ENTRY hist_buf[MAXHISTENT];

static int history_offset;
static int history_length;

void 
history_init(void)
{
    int i;

    for (i = 0; i < MAXHISTENT; i++ ) {
	the_history[i] = & hist_buf[i];
    }

}

void 
history_reset(void)
{
    history_offset = history_length;
}

void 
history_add(Char *str, int len)
{
    int i;
    HIST_ENTRY *temp;

    if ((len <= 0) || (len >= MAXHISTBUF))
	return;

    if (history_length == MAXHISTENT) {
	temp = the_history[0];
	for (i = 0; i < history_length-1; i++)
	    the_history[i] = the_history[i + 1];
	the_history[history_length-1] = temp;
    }
    else
	history_length ++;

    strncpy((char *)the_history[history_length-1]->line, (char *)str, len);
    the_history[history_length-1]->line[len] = 0;
}

Char *
history_previous(void)
{
    if (history_length == 0)
	return NULL;
    else if (history_offset == 0)
	return the_history[0]->line;
    else
	return the_history[--history_offset]->line;
}

Char *
history_next(void)
{
    if (history_offset >= history_length - 1) {
	history_offset = history_length;
	return NULL;
    } else
	return the_history[++history_offset]->line;
}

#endif /* OPT_HANGUL */

