# hanterm-xf RPM spec file

%define name	    hanterm-xf
%define ver	    2.0.6
%define patchlevel  177
%define rel	    %{patchlevel}.1

# To share hangul_keyboard file with ami
%define prefix	/usr
%define datadir %{prefix}/share
%define mandir %{prefix}/share/man

# XXX: need to check 'devel' package
%define withXaw95 %(if [ -n "`rpm -qa | grep Xaw95`" ]; then echo 1; else echo 0; fi)
%if %{withXaw95}
%define withneXtaw 0
%define withXaw3d 0
%else
%define withneXtaw %(if [ -n "`rpm -qa | grep neXtaw`" ]; then echo 1; else echo 0; fi)
%endif
%if %{withXaw95} || %{withneXtaw}
%define withXaw3d 0
%else
%define withXaw3d %(if [ -n "`rpm -qa | grep Xaw3d`" ]; then echo 1; else echo 0; fi)
%endif

Summary		: Hangul Terminal for X
Summary(ko)     : X 쿡   ִ ѱ ͹̳
Name		: %{name}
Version		: %{ver}
Release		: %{rel}
License	        : MIT
Group		: Desktops
Source0		: http://hanterm-xf.kldp.net/%{name}-%{ver}-%{patchlevel}.tar.gz
Requires	: XFree86-libs
%if %{withXaw95} == 1
Requires	: Xaw95
#XXX: BuildPrereq	: Xaw3d-devel
%endif
%if %{withneXtaw} == 1
Requires	: neXtaw
#XXX: BuildPrereq	: Xaw3d-devel
%endif
%if %{withXaw3d} == 1
Requires	: Xaw3d
BuildPrereq	: Xaw3d-devel
%endif
Obsoletes	: hanterm, hanterm-xf86

BuildRoot	: %{_tmppath}/%{name}-root

%description
Hangul terminal for X. it is based on the xterm in XFree86.

%description -l ko
XFree86  ִ xterm   ѱ ͹̳ Դϴ.

%prep
%setup -q -n %{name}-%{ver}-%{patchlevel}
 
%build
xawopt=
%if %{withXaw95} == 1
xawopt="--with-Xaw95"
%endif
%if %{withneXtaw} == 1
xawopt="--with-neXtaw"
%endif
%if %{withXaw3d} == 1
xawopt="--with-Xaw3d"
%endif
CFLAGS="$RPM_OPT_FLAGS" ./configure --prefix=%{prefix} ${xawopt} \
    --enable-boxchar --enable-ansi-color
# --enable-256-color --enable-tcap-query
make

%install
mkdir -p $RPM_BUILD_ROOT%{prefix}/bin
install -c -s -m 4711 hanterm  $RPM_BUILD_ROOT%{prefix}/bin

mkdir -p $RPM_BUILD_ROOT%{mandir}/ko/man1
%if "%{_vendor}" == "redhat"
iconv -c -f EUC-KR -t UTF-8 hanterm.man -o hanterm.man-utf8
install -m444 hanterm.man-utf8 $RPM_BUILD_ROOT%{mandir}/ko/man1/hanterm.1
rm -f hanterm.man-utf8
%else
install -m444 hanterm.man $RPM_BUILD_ROOT%{mandir}/ko/man1/hanterm.1
%endif

mkdir -p $RPM_BUILD_ROOT/usr/X11R6/{lib/X11/app-defaults,lib/X11/ko/app-defaults}
install -m444 Hanterm.ad \
	$RPM_BUILD_ROOT/usr/X11R6/lib/X11/ko/app-defaults/Hanterm
install -m444 Hanterm-col.ad \
	$RPM_BUILD_ROOT/usr/X11R6/lib/X11/ko/app-defaults/Hanterm-color

mkdir -p $RPM_BUILD_ROOT%{datadir}/hangul_keyboard
install -m444 keyboard/*.kbd $RPM_BUILD_ROOT%{datadir}/hangul_keyboard
install -m444 keyboard/*.map $RPM_BUILD_ROOT%{datadir}/hangul_keyboard

# strip binaries
strip `file $RPM_BUILD_ROOT%{prefix}/bin/* | awk -F':' '/executable/ { print $1 }'`

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root)

%doc docs/*
%{prefix}/bin/hanterm
%{mandir}/ko/man1/hanterm.*
%config /usr/X11R6/lib/X11/ko/app-defaults/Hanterm
%config /usr/X11R6/lib/X11/ko/app-defaults/Hanterm-color
%config(noreplace) %{datadir}/hangul_keyboard

%changelog
* Thu Jul 01 2004 Nam SungHyun  <namsh@kldp.org>
- if vendor is redhat, convert manual page to UTF-8
- change manual page install path

* Fri Jun  1 2001 Nam SungHyun <namsh@kldp.org>
- modified version of mizi hanterm-xf.spec
