/* hangul drawing routine */

/*#define DEBUG*/
#ifdef HAVE_CONFIG_H
#include "xtermcfg.h"
#endif

#if OPT_HANGUL

#include <stdio.h>
#include <stdlib.h> /* malloc */

#include "ptyx.h"
#include "data.h"
#include "hangul.h"
#include "xterm.h"
#include "johabcode.h"
#include "hfont.h"

/* _xutf8 */
extern int _xutf8;

int han_eng_lift;
int han_eng_ascent;
int han_eng_descent;

static int (*convert_code_to_font)(Char *, XChar2b *, int);


static int st_mode_x = -1, st_mode_len;
static int st_code_x, st_code_len;
static int st_kbd_x, st_kbd_len;
static int st_total_len;

static Char *str_hangul, *str_eng;
static Char *str_2bul, *str_3bul;
static Char *str_wansung, *str_johab;
static Char *str_codeinput = S_CODEINPUT;
static Char * str_codeinput_johab;


static int code_input(int fd, Char *str, int len);
static void set_mode_line(void);

void 
HandleToggleHangul(Widget w, XEvent *event, String *params, Cardinal *nparams)
{
#if OPT_CHAT
    if (chat_mode)
	chat_mode_toggle_hangul();
    else
#endif /* OPT_CHAT */
	unparseputc(-1, term->screen.respond);
}

void 
HandleToggleChat(Widget w, XEvent *event, String *params, Cardinal *nparams)
{
#if OPT_CHAT
    chat_callback = v_write;
    toggle_chat_mode("");
#endif /* OPT_CHAT */
}

void 
HandleChangeKeyboard(Widget w, XEvent *event, String *params, Cardinal *nparams)
{
#if OPT_CHAT
    if (chat_mode)
	chat_mode_flush_hangul();
    else
#endif /* OPT_CHAT */
	unparseputc(-2, term->screen.respond);
    if (term->screen.han_kbd == 2)
	term->screen.han_kbd = 3;
    else
	term->screen.han_kbd = 2;
    han_show_status(&term->screen, 0, 0);
    hangul_set_keyboard(term->screen.han_kbd);
}

void 
HandleChangeCode(Widget w, XEvent *event, String *params, Cardinal *nparams)
{
	term->screen.han_code++;
	if (term->screen.han_code == C_UTF8) {
		term->screen.han_code = C_WANSUNG;
		_xutf8 = 1;
	} else {
		term->screen.han_code = ( _xutf8 ) ? C_WANSUNG : C_JOHAB;
		_xutf8 = 0;
	}
    if (term->screen.han_code == C_WANSUNG) {
	convert_code_to_font = kscode_to_font[term->screen.han_font_type];
    } else {
	convert_code_to_font = johabcode_to_font[term->screen.han_font_type];
    }
    hangul_set_code(term->screen.han_code);
    han_show_status(&term->screen, 0, 0);
}

static int 
code_input(int fd, Char *str, int len)
{
    int code = 0;
    Char buf[2];

    sscanf(str + strlen((char *)str_codeinput), "%x", &code);
    if (code >= 0xa1a1 && code <= 0xfefe) {
	buf[0] = code >> 8;
	buf[1] = code & 0xff;
	v_write(fd, buf, 2);
    }
    return -1;
}

void 
HandleCodeInput(Widget w, XEvent *event, String *params, Cardinal *nparams)
{
    /* FIXME */
#if OPT_CHAT
    if (!chat_mode && !hanja_mode) {
	chat_callback = code_input;
	if (term->screen.han_code == C_WANSUNG) {
	    toggle_chat_mode(str_codeinput);	/* ڵ */
	} else {
	    toggle_chat_mode(str_codeinput_johab);	/* ڵ */
	}
    }
#endif /* OPT_CHAT */
}

/* hanja */
void 
HandleHanjaInput(Widget w, XEvent *event, String *params, Cardinal *nparams)
{
    int hangulcode = term->screen.han_code;
    unsigned int han_code;
    Char tmp[8];

    if (!chat_mode)
    {
	han_code = (han_compose_buf[0] << 8) + han_compose_buf[1];
	if (hangulcode == C_JOHAB) {
	    johab_to_wansung(tmp, han_code);
	    han_code = (tmp[0] << 8) + tmp[1];
	} 
	toggle_hanja_mode(han_code);	/*  Է  */
    }
}

void
han_set_code_to_font(char *charset_registry)
{
    if( strstr(charset_registry,"KSC5601.1987-0") != NULL ||
        strstr(charset_registry,"ksc5601.1987-0") != NULL ||
        strstr(charset_registry,"KSX1001.1997-0") != NULL ||
        strstr(charset_registry,"ksx1001.1997-0") != NULL ) {
	/* wansung font */
	term->screen.han_font_type = HANGUL_FONT_TYPE_KS;
    } else if( strstr(charset_registry,"ksc5601.1987-1") != NULL ||
               strstr(charset_registry,"KSC5601.1987-1") != NULL ) {
	/* wansung font */
	term->screen.han_font_type = HANGUL_FONT_TYPE_KS1;
    } else if( strstr(charset_registry,"johab8") != NULL ||
               strstr(charset_registry,"JOHAB8") != NULL) {
	term->screen.han_font_type = HANGUL_FONT_TYPE_JOHAB844;
    } else if( strstr(charset_registry,"johab") != NULL ||
               strstr(charset_registry,"JOHAB") != NULL) {
	/* johab font */
	term->screen.han_font_type = HANGUL_FONT_TYPE_JOHAB;
    } else if (strstr(charset_registry, "FontSpec") != NULL) {
	term->screen.han_font_type = HANGUL_FONT_TYPE_KS;
    } else {
	/* default */
	fprintf(stderr,"can't identify hangul font type %s\n",charset_registry);
	fprintf(stderr,
		"If this font is not wangsung type, "
		"specify the correct type with -hftype option\n");
	term->screen.han_font_type = HANGUL_FONT_TYPE_KS;
    }
    if (term->screen.han_code == C_WANSUNG) {
	convert_code_to_font = kscode_to_font[term->screen.han_font_type];
    } else {
	convert_code_to_font = johabcode_to_font[term->screen.han_font_type];
    }
}


/* str + n - 1  ִ ĳͰ ѱ ù° Ʈ 1  ݴϴ. */

int 
han_adjust_string(Char *str, int n)
{
    while (n > 0) {
	if (*str & 0x80) {
	    str += 2;
	    n -= 2;
	} else {
	    str += 1;
	    n -= 1;
	}
    }
    return (n != 0);
}

static void 
set_mode_line(void)
{
    Misc *misc = &(term->misc);
    str_hangul = misc->han_status_han_label;
    str_eng = misc->han_status_eng_label;

    str_2bul = misc->han_status_dubyol_label;
    str_3bul = misc->han_status_sebyol_label;

    str_wansung = misc->han_status_wansung_label;
    str_johab = misc->han_status_johab_label;


    st_mode_x = 0;
    st_mode_len = strlen(str_hangul);
    st_total_len = st_mode_x + st_mode_len;
    if (!term->misc.han_no_status_code) {
	st_code_x = st_total_len;
	st_code_len = strlen(str_wansung);
	st_total_len += st_code_len;
    } else {
	st_code_x = -1;
    }
    if (!term->misc.han_no_status_kbd) {
	st_kbd_x = st_total_len;
	st_kbd_len = strlen(str_2bul);
	st_total_len = st_kbd_x + st_kbd_len;
    } else {
	st_kbd_x = -1;
    }
    str_codeinput_johab = malloc(strlen(str_codeinput)+1);
    johab_from_wansung_str(str_codeinput_johab, str_codeinput, strlen(str_codeinput));
}

int 
length_of_statusline(void)
{
    return st_total_len + 1;
}

int 
han_is_mode_button(int col)
{
#if 0
    if (st_mode_x < 0)
	set_mode_line();
#endif
    if (col >= st_mode_x && col < (st_mode_x + st_mode_len))
	return 1;
    return 0;
}

int 
han_is_code_button(int col)
{
#if 0
    if (st_mode_x < 0)
	set_mode_line();
#endif
    if (st_code_x > 0 && col >= st_code_x && col < (st_code_x + st_code_len))
	return 1;
    return 0;
}

int 
han_is_kbd_button(int col)
{
#if 0
    if (st_mode_x < 0)
	set_mode_line();
#endif
    if (st_kbd_x > 0 && col >= st_kbd_x && col < (st_kbd_x + st_kbd_len))
	return 1;
    return 0;
}

void 
han_show_status(TScreen *screen, int leftcol, int ncols)
{
    Char *mode_str;
    Char *code_str;
    Char *keyboard_str;
    int x, y;

    if(screen->han_status_height <= 0) return;

    if (st_mode_x < 0)
	set_mode_line();

    mode_str = hangul_state ? str_hangul : str_eng;
	if ( _xutf8 )
		code_str = S_UTF8;
	else
		code_str = (screen->han_code == C_WANSUNG) ? str_wansung : str_johab;

    keyboard_str = (screen->han_kbd == 2) ? str_2bul : str_3bul;

    if (screen->han_code == C_JOHAB) 
	convert_code_to_font = kscode_to_font[screen->han_font_type];

    x = OriginX(screen) + FontWidth(screen) * st_mode_x;
    y = FullHeight(screen) - screen->border - screen->han_descent;
    set_default_color(screen);
    if (leftcol < st_mode_len)
	HDrawImageString(screen->display, TextWindow(screen),
		     NormalGC(screen), NormalHGC(screen), x, y, mode_str,
			 st_mode_len);
    if (st_code_x > 0) {
	x = OriginX(screen) + FontWidth(screen) * st_code_x;
	HDrawImageString(screen->display, TextWindow(screen),
		     NormalGC(screen), NormalHGC(screen),
		     x, y, code_str, st_code_len);
    }
    if (st_kbd_x > 0) {
	x = OriginX(screen) + FontWidth(screen) * st_kbd_x;
	HDrawImageString(screen->display, TextWindow(screen),
		     NormalGC(screen), NormalHGC(screen),
		     x, y, keyboard_str, st_kbd_len);
    }

    if (screen->han_code == C_JOHAB) 
	convert_code_to_font = johabcode_to_font[screen->han_font_type];

#if OPT_CHAT
    if (leftcol + ncols > 7)
	show_chat_buf();
#endif /* OPT_CHAT */
}

void 
HDrawImageString(Display *d, Window w, GC gc, GC hgc, 
    int x, int y, Char *str, int len)
{
    TScreen *screen = &term->screen;
    static XChar2b buf[TEXT_BUF_SIZE];
    int n, width;
    Char *p;
    XGCValues values;
    static GC fill_gc = NULL;
    if (!fill_gc) {
	fill_gc = XCreateGC(d, w, 0, NULL);
    }
    while (len > 0) {
	if (*str & 0x80) {
	    if (screen->han_code == C_WANSUNG)
		for (p = str; len > 1 && (*p & 0x80) && (*(p + 1) & 0x80);
		     p += 2, len -= 2);
	    else
		for (p = str; len > 1 && (*p & 0x80); p += 2, len -= 2);
	    n = convert_code_to_font(str, buf, (int) (p - str));
	    if (n) {
		XDrawImageString16(d, w, hgc, x, y, buf, n);
		width = (p - str) * FontWidth(screen);
		if (screen->han_ascent > screen->han_fnt_norm->ascent) {
		    XGetGCValues(d, hgc, GCBackground, &values);
		    XSetForeground(d, fill_gc, values.background);
		    XFillRectangle(d, w, fill_gc, x, y - screen->han_ascent,
				   width,
				   screen->han_ascent - screen->han_fnt_norm->ascent);
		}
		if (screen->han_descent > screen->han_fnt_norm->descent) {
		    XGetGCValues(d, hgc, GCBackground, &values);
		    XSetForeground(d, fill_gc, values.background);
		    XFillRectangle(d, w, fill_gc, x,
				   y + screen->han_fnt_norm->descent, width,
				   screen->han_descent -
				   screen->han_fnt_norm->descent);
		}
		x += width;
		str = p;
	    }
	}
	if (len <= 0)
	    break;
	p = str;
	for (p++, len--; len > 0 && !(*p & 0x80); p++, len--) {
	}
	XDrawImageString(d, w, gc, x, y - han_eng_lift, str, (int) (p - str));
	width = (p - str) * FontWidth(screen);
	if (screen->han_ascent > han_eng_ascent) {
	    XGetGCValues(d, hgc, GCBackground, &values);
	    XSetForeground(d, fill_gc, values.background);
	    XFillRectangle(d, w, fill_gc, x,
			   y - screen->han_ascent, width,
			   screen->han_ascent - han_eng_ascent);
	}
	if (screen->han_descent > han_eng_descent) {
	    XGetGCValues(d, hgc, GCBackground, &values);
	    XSetForeground(d, fill_gc, values.background);
	    XFillRectangle(d, w, fill_gc, x,
			   y + screen->fnt_norm->descent, width,
			   screen->han_descent - han_eng_descent);
	}
	x += width;
	str = p;
    }
}

void 
HDrawString(Display *d, Window w, GC gc, GC hgc, 
    int x, int y, Char *str, int len)
{
    register TScreen *screen = &term->screen;
    XChar2b buf[200];
    int n;
    Char *p;

    while (len > 0) {
	if (*str & 0x80) {
	    if (screen->han_code == C_WANSUNG)
		for (p = str; len > 1 && (*p & 0x80) && (*(p + 1) & 0x80);
		     p += 2, len -= 2);
	    else
		for (p = str; len > 1 && (*p & 0x80); p += 2, len -= 2);
	    n = convert_code_to_font(str, buf, (int) (p - str));
	    if (n) {
		XDrawString16(d, w, hgc, x, y, buf, n);
		x += (p - str) * FontWidth(screen);
		str = p;
	    }
	}
	if (len <= 0)
	    break;
	p = str;
	for (len--, p++; len > 0 && !(*p & 0x80); p++, len--) {
	}
	XDrawString(d, w, gc, x, y - han_eng_lift, str, p - str);
	x += (p - str) * FontWidth(screen);
	str = p;
    }
}

#if OPT_NOW_CHAT_SCROLL_PATCH
int
ScrnMoveLine (register ScrnBuf sb, int src, int dest, int n, int size)
{
    char *save;
    n *= MAX_PTRS * sizeof(char *);
    if ((save = alloca(n)) == NULL)
    {
	fprintf(stderr, "ScrnMoveLine: alloca failed (size=%d)!\n", n);
	return 0;
    }
    memcpy(save, &sb[MAX_PTRS * src], n);
    memcpy(&sb[MAX_PTRS * src], &sb[MAX_PTRS * dest], n);
    memcpy(&sb[MAX_PTRS * dest], save, n);
}
#endif /* OPT_NOW_CHAT_SCROLL_PATCH */

#endif /* OPT_HANGUL */

