#!/usr/bin/python2.4
# run with: c:\Python24\python.exe py23exe_setup.py py2exe
# from 'C:\Program Files\Common Files\GTK\2.0' copy 'etc', 'lib', and
# 'share' directories to the created 'dist' directory.  Then run the
# installer.iss script innosetup.
from distutils.core import setup
import py2exe

setup(name='GutenPy',
      version='0.3.0',
      description='Text Reader and Catalog Browser for Project Gutenberg',
      long_description="GutenPy's text reader features: bookmarking (automatic or manual), easy mouse paging, a handy sidebar for browsing bookmarks and files, and word definitions with a middle mouse click.  It's catalog browser features: regular expression filters (author, title, subject and language), remember filters between sessions, and a save-able selected booklist.  GutenPy is written with Python GTK2.",
      author='Lee Bigelow',
      author_email='ligelowbee@yahoo.com',
      url='http://gutenpy.sourceforge.net',
      license='GPL version 2',
      packages=['GutenPy'],
      scripts=['gutenpy.py'],
      data_files = [ ('icons', 
                        ['icons/book.ico',
                         'icons/book-lg.png',
                         'icons/book-sm.png',
                         'icons/bookmark.png',
                         'icons/dict_org.png',
                         'icons/gutenberg_org.png',
                         'icons/sidebar.png']),
                     ('docs',
                        ['docs/help.txt',
                         'docs/COPYING.txt',
                         'docs/MIRRORS_ALL.txt',
                         'docs/Regular_Expression_HOWTO.htm',
                         'docs/Regular_Expression_Syntax.html']) ],
      windows = [ { 'script': 'gutenpy.py',
                    'icon_resources': [(1, "icons/book.ico")],
                    }],
      options = { 'py2exe' : {
                    'packages': 'encodings',
                    'includes': 'cairo, pango, pangocairo, atk, gobject',}
                  }
     )
