/***************************************************************************
                          point2d.cpp  -  description
                             -------------------
    begin                : Tue Jan 8 2002
    copyright            : (C) 1999-2002 by Jacques Fortier & Brian Ashe
    email                : gtkpool@seul.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <math.h>
#include "point2d.h"
#include "vec2d.h"

Point2D::Point2D(){
}
Point2D::Point2D(double x, double y){
	setPos(x, y);
}
Point2D::~Point2D(){
}

double Point2D::dist (const Point2D &loc) {
	double xSq = loc.x - x;
	double ySq = loc.y - y;
	return sqrt((xSq * xSq) + (ySq * ySq));
}

Point2D Point2D::setPos (double x, double y)
{
	this->x = x;
	this->y = y;
	return *this;
}

Point2D Point2D::addPos (const Vec2D &vel) {
	return setPos(x + vel.dx, y + vel.dy);
}
