#include <gtk/gtk.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/soundcard.h>
#include <sys/ioctl.h>
#include <errno.h>
#include "sound.hh"

int audio_fd;
bool sound_enabled;

	// must add error checking!
	// must add error checking!!!
	// must add error checking!!!!!
	// must add error checking!!!!!!!
	// must add error checking!!!!!
	// must add error checking!!!
	// must add error checking!

void play_sound(char *sound, int count)
{
	if(!sound_enabled)
	{
		g_message("Sound not available.");
		return;
	}
	if(audio_fd < 0)
	{
		g_message("Sound device not open.");
		return;
	}
	if(write(audio_fd, sound, count) < 0)
	{
		g_message("Write to sound device failed.");
		return;
	}
	ioctl(audio_fd, SNDCTL_DSP_POST, 0);
}

int load_sound(char *file, char *buffer, int *count)
{
	int fd = open(file, O_RDONLY);
	*count = read(fd, buffer, *count);
	close(fd);
	return *count;
}

void open_sound_device(char *name)
{
	audio_fd = open(name, O_WRONLY);
	if(audio_fd < 0)
		throw SoundError(strerror(errno), SE_OPENFAIL);
}

void configure_sound_device()
{
	int fragment = 0x7fff0008;
	if( ioctl(audio_fd, SNDCTL_DSP_SETFRAGMENT, &fragment) < 0 )
		throw SoundError(strerror(errno), SE_FRAGFAIL, fragment);
	if((fragment & 0x0000ffff) != 8)
		throw SoundError("Sound card does not support appropriate fragment size", SE_FRAGFAIL, fragment);
	sound_enabled = true;
}
