/*************************************************************************\
*    gtkpool -- a so far not-so-great pool game                           *
*    Copyright (C) 1999 Jacques Fortier                                   *
*                                                                         *
*    This program is free software; you can redistribute it and/or modify *
*    it under the terms of the GNU General Public License as published by *
*    the Free Software Foundation; either version 2 of the License, or    *
*    (at your option) any later version.                                  *
*                                                                         *
*    This program is distributed in the hope that it will be useful,      *
*    but WITHOUT ANY WARRANTY; without even the implied warranty of       *
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
*    GNU General Public License for more details.                         *
*                                                                         *
*    You should have received a copy of the GNU General Public License    *
*    along with this program; if not, write to the Free Software          *
*    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
\*************************************************************************/
#ifndef __POOL_HH
#define __POOL_HH

#include <gtk/gtk.h>
#include "myconfig.hh"

#define YELLOW 0
#define BLUE 1
#define RED 2
#define PURPLE 3
#define ORANGE 4
#define GREEN 5
#define BROWN 6
#define EIGHT 7

#define YELLOW_S 8
#define BLUE_S 9
#define RED_S 10
#define PURPLE_S 11
#define ORANGE_S 12
#define GREEN_S 13
#define BROWN_S 14
#define SHADOW 15
#define CUE 16

#define NUM_BALLS 17

const int BALL_SIZE = 14;

class Point2D;

void update_dirty(int, int, int, int);

class Vec2D {
	public:
	double   dx, dy;
	
	Vec2D()
	{
		dx = dy = 0;
	}
	Vec2D (double dx, double dy) {
		setVec(dx, dy);
	}
	Vec2D (const Point2D &p1, const Point2D &p2);
	Vec2D (const Vec2D &v)
	{
		dx = v.dx; dy = v.dy;
	}
	
	
	double mag () {
		return sqrt(dx * dx + dy * dy);
	}
	
	Vec2D addVec (const Vec2D vec) {
		return setVec(dx + vec.dx, dy + vec.dy);
	}
	Vec2D subVec (const Vec2D vec) {
		return setVec(dx - vec.dx, dy - vec.dy);
	}
	Vec2D unitVec () {
		double m = mag();
		return setVec(dx / m, dy / m);
	}
	Vec2D mulVec (double scale) {
		return setVec(dx * scale, dy * scale);
	}
	double dotProd (Vec2D vec2) {
		return dx * vec2.dx + dy * vec2.dy;
	}
	Vec2D setVec (double dx, double dy) {
		this->dx = dx;
		this->dy = dy;
		return *this;
	}
	Vec2D setVec (const Vec2D &vec) {
		return setVec(vec.dx, vec.dy);
	}

	
	Vec2D copy () {
		return Vec2D(dx, dy);
	}
};



class Point2D {
	public:
	double    x, y;
	
	Point2D()
	{
	}
	Point2D (double x, double y) {
		setPos(x, y);
	}
	Point2D setPos (double x, double y);
	Point2D addPos (const Vec2D &vel);
	double dist (const Point2D &loc);
};

class Circle : public Point2D {
	public:
	int   diam;
	double radius;
	Circle()
	{
		diam = 0;
	}
	Circle (double x, double y, int d) : Point2D(x, y)
	{
		radius = (diam = d) / 2;
	}
	virtual void draw (GdkDrawable *, GdkGC *) = 0;
};

class Ball : public Point2D {
	public:
	int diam;
	double radius;
	Vec2D      vel;
	double hCol, vCol;
	bool is_cue, is_eight;
	GdkPixmap *picture;
	GdkBitmap *clip_bmp;
	GdkPixmap *big_picture;
	GdkPixmap *big_clip_bmp;
	int ball_num;
	Vec2D bnc;
	Vec2D tvec;
	GdkColor *clr;
	
	Ball(void)
	{
		vel.dx = 0;
		vel.dy = 0;
		radius = diam = 0;
	}
	
	Ball (double x, double y, int d, GdkColor *c, bool isq = false,
	      bool ise = false) : vel(0, 0), bnc(0, 0), tvec(0, 0),
	                          Point2D(x, y)
	{
		radius = (diam = d) / 2;
		clr = c;
		is_cue = isq; is_eight = ise;
		picture = (GdkPixmap *)NULL;
		ball_num = 15;
	}
	Ball (double x, double y, int d, int bn, GdkPixmap *pixmap,
	      GdkBitmap *c_bmp, GdkPixmap *b_pixmap, GdkBitmap *b_clip_bmp,
	      bool isq = false, bool ise = false) :
		    vel(0, 0), bnc(0, 0), tvec(0, 0), Point2D(x, y)
	{
		radius = (diam = d) / 2;
		clr = (GdkColor *)NULL;
		is_cue = isq; is_eight = ise;
		picture = pixmap;
		clip_bmp = c_bmp;
		big_picture = b_pixmap;
		big_clip_bmp = b_clip_bmp;
		ball_num = bn;
	}

	bool moving ();
	void decel (double val);
	double pathIntercept (Ball b);
	void collide (Ball *b, double);
	double edgeIntercept (GdkRectangle bd);
	void bounce (double t, double);
	void move (double t);
	void draw (GdkDrawable *pixmap, GdkGC *gc) const;
	void shoot (GdkPoint ptr);
	bool touches (int mx, int my);

};

#endif
