#include <iostream>
#include <vector>
#include <gtk--/box.h>
#include <gtk--/button.h>
#include <gtk--/ctree.h>
#include <gtk--/window.h>
#include <gtk--/main.h>

using std::cout;
using std::endl;

using std::vector;

class AppWindow: public Gtk::Window
  {
    Gtk::CTree* tree;
    public:
      AppWindow();
      virtual ~AppWindow();
      virtual gint delete_event_impl (GdkEventAny*);
  };

AppWindow::AppWindow()
    : Gtk::Window()
  {
    // create a tree with 2 columns (you can not resize it later)
    vector<char*> titles;
    titles.push_back("Items");
    titles.push_back("Column2");
    tree=manage(new Gtk::CTree(titles));
    tree->column(0).set_width(100);

    // Add some items
    { using namespace Gtk::CTree_Helpers;
    RowList::iterator i;
    vector<char*> item;
    item.push_back("fruit");
    item.push_back("1");
    tree->rows().push_back(Element(item));

    i=--tree->rows().end();
    item[0]="peaches";
    i->subtree().push_back(Element(item));
    item[0]="apples";
    i->subtree().push_back(Element(item));
    item[0]="pears";
    i->subtree().push_back(Element(item));

    item[0]="animals";
    tree->rows().push_back(BranchElem(item)); // with no children

    // demonstrate traversing the list
    cout << "traverse row list (forward)"<<endl;
    for (RowList::iterator i1=tree->rows().begin(); 
         i1!=tree->rows().end(); ++i1)
       cout << (*i1)[0].get_text() <<endl; 

    cout << "traverse tree list (forward)"<<endl;
    for (TreeList::iterator i1=tree->tree().begin(); 
         i1!=tree->tree().end(); ++i1)
       cout << (*i1)[0].get_text() <<endl; 

// FIXME reverse is broken
//    cout << "traverse row list (backward)"<<endl;
//    for (RowList::reverse_iterator i2=tree->rows().rbegin(); 
//         i2!=tree->rows().rend(); ++i2)
//       cout << (*i2)[0].get_text() <<endl; 

    } /* using Gtk::CTree_Helpers */

    // set up widget layout
    tree->set_usize(300,300);
    add(*tree);
    show_all();
  }

AppWindow::~AppWindow()
  {} 

gint AppWindow::delete_event_impl (GdkEventAny*)
  {
    Gtk::Main::quit();
    return 0;
  }

int main (int argc, char *argv[])
{
  Gtk::Main kit(argc, argv);
  AppWindow arrows;

  kit.run ();
  return 0;
}
