/* GtkBalls
 * Copyright (C) 1998-1999 Eugene V. Morozov
 * Modifyed in 2001 by drF_ckoff
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <errno.h>
#include <unistd.h>
#include <gtk/gtk.h>


#include "gtkballs.h"
#include "scoreboard.h"

#define BUFFER_SIZE 1024

/* "for feature reference" =) */
#if 0
gchar *score_file=NULL;

gboolean sb_init_score(void) {
  	struct stat entry_stat;
        gint fd;
        gint uid=getuid();

        if(score_file) {
                g_free(score_file);
                score_file=NULL;
        }
        if(!(score_file=g_strdup_printf(LOCALSTATEDIR "/gtkballs/score.%u", uid))) {
                return FALSE;
        }
        if(stat(score_file, &entry_stat)!=0) {
                /* create */
        	if((fd=open(score_file, O_CREAT | O_RDWR, 0600))==-1) {
                	printf("cannot create %s: %s\n", score_file, strerror(errno));
                	return FALSE;
                }
        } else if(!S_ISREG(entry_stat.st_mode)) {
                /* file exist, but not a regular file. */
                printf("%s exist, but not a regular file.\n", score_file);
                return FALSE;
        } else if(uid != entry_stat.st_uid) {
                /* owner of file doesnt match user running programm. sad thing. =) */
                printf("owner of %s (%u) doesnt match user running programm (%u).\n", score_file, entry_stat.st_uid, uid);
                return FALSE;
        } else if(entry_stat.st_mode & S_IWUSR) {
                printf("%s isnt writable for owner.\n", score_file);
                return FALSE;
        }

        return TRUE;
}

gint sb_write_score(struct score_board *b) {

}

gint sb_read_score(struct score_board *b) {

}
#endif

gint write_score(struct score_board *b, struct score_board_full *bf, gint nbf) {
  	int fd;
  	gint i;
  	gchar *buf;
  	sigset_t sset;
  	struct flock lockinfo;

  	/* block signals before writing, to prevent possible file corruption */
  	sigemptyset(&sset);
  	sigaddset(&sset, SIGHUP);
  	sigaddset(&sset, SIGINT);
  	sigaddset(&sset, SIGQUIT);
  	sigaddset(&sset, SIGTERM);
  	sigprocmask(SIG_BLOCK, &sset, NULL);

  	if((fd=open(LOCALSTATEDIR "/gtkballs-scores", O_WRONLY | O_TRUNC)) == -1) {
    		/* unable to save score */
    		return FALSE;
        }

  	/* get write lock before writing scores */
  	lockinfo.l_whence=SEEK_SET;
  	lockinfo.l_start=0;
  	lockinfo.l_len=0;
  	i=0;
  	while(1) {
    		lockinfo.l_type=F_WRLCK;
    		if(!fcntl(fd, F_SETLK, &lockinfo)) break;
    		if(i>=3) {
      			close(fd);
      			return FALSE;
    		}
    		i++;
  	}
  
  	for(i=0; i<10; i++) {
    		if(strlen(b[i].name)) {
      			buf=g_strdup_printf("%s\t%i\t%s\t%d\t%d\t%d\t%d\t%d\n", b[i].name, b[i].score, b[i].date, Rules.xsize, Rules.ysize, Rules.colors, Rules.next, Rules.destroy);
    			write(fd, buf, strlen(buf));
                	g_free(buf);
    		}
  	}
  	for(i=0; i<nbf; i++) {
    		if(strlen(bf[i].name)) {
      			buf=g_strdup_printf("%s\t%i\t%s\t%d\t%d\t%d\t%d\t%d\n", bf[i].name, bf[i].score, bf[i].date, bf[i].rules.xsize, bf[i].rules.ysize, bf[i].rules.colors, bf[i].rules.next, bf[i].rules.destroy);
    			write(fd, buf, strlen(buf));
                	g_free(buf);
   		}
        }

  	close(fd);

  	sigprocmask(SIG_UNBLOCK, &sset, NULL);
  	return TRUE;
}

int score_sort(const void *a, const void *b) {
        if(((const struct score_board *)a)->score == ((const struct score_board *)b)->score) return 0;
        if(((const struct score_board *)a)->score < ((const struct score_board *)b)->score) return 1;
	return -1;
}

gint read_score(struct score_board *b, struct score_board_full **bf, gint *nbf) {
  	FILE *fp;
  	gchar buffer[BUFFER_SIZE];
  	gchar **str_val;
        gint  i, valid, sc, fsc;
        GtkbGameRules rules;

        for(i=0; i<10; i++) {
                b[i].name[0] = '\0';
                b[i].score = 0;
                b[i].date[0] = '\0';
        }

        if(*bf) {
                g_free(*bf);
                *bf=NULL;
        }

  	if(!(fp=fopen(LOCALSTATEDIR "/gtkballs-scores", "r"))) {
		return FALSE;
        }

        sc = 0;
        fsc = 0;
      	while(fgets(buffer, BUFFER_SIZE, fp)) {
        	g_strchomp(buffer);
        	str_val=g_strsplit(buffer, "\t", SBFNUM);
        	if(str_val[0] && str_val[0][0] &&
		   str_val[1] && str_val[1][0] &&
		   str_val[2] && str_val[2][0]) {
                        valid=0;
                   	if(!str_val[3]) {
                        	memcpy(&rules, &ClassicRules, sizeof(rules));
                                valid=1;
                   	} else {
                        	if(str_val[3][0] &&
                           	   str_val[4] && str_val[4][0] &&
                           	   str_val[5] && str_val[5][0] &&
                           	   str_val[6] && str_val[6][0] &&
                           	   str_val[7] && str_val[7][0]) {
                                	rules.xsize = strtol(str_val[3], NULL, 10);
		                        rules.ysize = strtol(str_val[4], NULL, 10);
                	                rules.colors = strtol(str_val[5], NULL, 10);
                        	        rules.next = strtol(str_val[6], NULL, 10);
                                	rules.destroy = strtol(str_val[7], NULL, 10);
                                	valid=1;
                        	}
                   	}
                        if(valid && g_strcasecmp(str_val[0],"<none>")) {
                                if(memcmp(&rules, &Rules, sizeof(rules)) == 0) {
                                	strncpy(b[sc].name, str_val[0], 15);
    					b[sc].score=strtol(str_val[1], NULL, 10);
    					if((b[sc].score==LONG_MIN) || (b[sc].score==LONG_MAX)) {
      						b[sc].score=0;
                                	}
                                	strncpy(b[sc].date, str_val[2], 30);
                			sc++;
                                } else {
                                        *bf=g_realloc(*bf, sizeof(struct score_board_full)*(fsc+1));
                                	strncpy((*bf)[fsc].name, str_val[0], 15);
    					(*bf)[fsc].score=strtol(str_val[1], NULL, 10);
    					if(((*bf)[fsc].score==LONG_MIN) || ((*bf)[fsc].score==LONG_MAX)) {
      						(*bf)[fsc].score=0;
                                	}
                                	strncpy((*bf)[fsc].date, str_val[2], 30);
                                        memcpy(&((*bf)[fsc].rules), &rules, sizeof(rules));
                                        fsc++;
                                }
                        }
        	}
                g_strfreev(str_val);
        }
        fclose(fp);

        qsort(b, 10, sizeof(struct score_board), score_sort);


        *nbf = fsc;

  	return TRUE;
}

gint insert_entry_in_score_board(struct score_board *board, struct score_board entry) {
  	gint i=0,j;

  	if(entry.score<=0) {
    		return -1;
        }

  	while(i<10 && board[i].score>entry.score) {
    		i++;
        }

  	if(i>9) {
    		return -1;
        }

  	for(j=8;j>=i;j--) {
      		strncpy(board[j+1].name, board[j].name, 15);
      		strncpy(board[j+1].date, board[j].date, 30);
      		board[j+1].score=board[j].score;
    	}

  	strncpy(board[i].name, entry.name, 15);
  	strncpy(board[i].date, entry.date, 30);
  	board[i].score = entry.score;

  	return i;
}
