/* GtkBalls
 * Copyright (C) 1998-1999 Eugene V. Morozov
 * Modifyed in 2001 by drF_ckoff
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#include <config.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <dirent.h>
#include <unistd.h>
#include <gtk/gtk.h>

#include "gtkballs.h"
#include "gtkutils.h"
#include "interface.h"
#include "preferences.h"
#include "gfx.h"

#define BUFFER_SIZE 1024
#define CONFIG_FILE_NAME ".gtkballsrc"

static GtkWidget *dialog;
static GtkWidget *show_hints_button,*show_path_button,*show_footprints_button,*show_destroy_button;
gchar  **Available_Themes;
gint   Available_Themes_Number=0;
gint   SelectedTheme=0;

void theme_selection_made(GtkWidget *clist, gint row, gint column, GdkEventButton *event, gpointer data);
void preferences_ok(GtkWidget *widget, gpointer data);
void preferences_cancel(GtkWidget *widget, gpointer data);
void preferences_apply(GtkWidget *widget, gpointer data);
gint get_available_themes();

/* find gtkballsrc file location. returns NULL on out of memory =) */
gchar *find_rc_file(void) {
        gchar *rc_file;

  	if(getenv("HOME")) {
		rc_file=g_strdup_printf("%s/" CONFIG_FILE_NAME, getenv ("HOME"));
    	} else { /* unable to read $HOME, assuming current directory */
    		rc_file=g_strdup(CONFIG_FILE_NAME);
        }
        if(!rc_file) {
                g_warning(_("Cannot determine rc file name. ($HOME is toooooo long?)"));
                return NULL;
        }
        return rc_file;
}

/* converts string to TRUE/FALSE. "true", "yes" or "1" is TRUE, otherwise - FALSE */
gboolean pref_str_to_bool(gchar *val) {
        if(!g_strcasecmp(val, "true") || !g_strcasecmp(val, "yes") || !g_strcasecmp(val, "1")) {
                return TRUE;
        }
        return FALSE;
}

/* converts boolean to string
   returns _pointer_ to "yes" or "no". returned string should NOT be free()'d! */
gchar *pref_bool_to_str(gboolean val) {
        return val ? "yes" : "no";
}

/* we use very lame preferences file format: ``property=value\n''.
   so - there must be no whitespaces on begin/end of line =) */
void load_preferences(void) {
  	FILE *fp;
        gchar *rc_file;
  	gchar buffer[BUFFER_SIZE];
        gchar **prop_val;

        if(!(rc_file=find_rc_file())) return;
  	if((fp=fopen(rc_file, "r"))) {
      		while(fgets(buffer, BUFFER_SIZE, fp)) {
                        g_strchomp(buffer);
                        prop_val=g_strsplit(buffer,"=",2);
                        if(prop_val[0] && prop_val[0][1] && prop_val[1] && prop_val[1][1]) {
                                if(!g_strcasecmp(prop_val[0],"show_hints")) {
                                        Show_next_colors=pref_str_to_bool(prop_val[1]);
                                } else if(!g_strcasecmp(prop_val[0],"show_path")) {
                                        Show_path=pref_str_to_bool(prop_val[1]);
                                } else if(!g_strcasecmp(prop_val[0],"show_footprints")) {
                                        Show_footprints=pref_str_to_bool(prop_val[1]);
                                } else if(!g_strcasecmp(prop_val[0],"show_destroy")) {
                                        Show_destroy=pref_str_to_bool(prop_val[1]);
                                } else if(!g_strcasecmp(prop_val[0],"theme_name")) {
                                        if(Current_theme_name) g_free(Current_theme_name);
                                        Current_theme_name=g_strdup(prop_val[1]);
                                        Theme_name=Current_theme_name;
                                }
                        }
                        g_strfreev(prop_val);
		}
      		fclose(fp);
    	}
        g_free(rc_file);
}

/* writes ``property=value\n'' to fp.
   why i made it separate function? for "feature purposes" =) */
void write_pref_string(FILE *fp, gchar *property, gchar *value) {
                fprintf(fp, "%s=%s\n", property, value);
}

void save_preferences(void) {
  	FILE *fp;
  	gchar *rc_file;

        if(!(rc_file=find_rc_file())) return;
  	if((fp=fopen(rc_file, "w"))) {
                write_pref_string(fp, "show_hints", pref_bool_to_str(Show_next_colors));
                write_pref_string(fp, "show_path", pref_bool_to_str(Show_path));
                write_pref_string(fp, "show_footprints", pref_bool_to_str(Show_footprints));
                write_pref_string(fp, "show_destroy", pref_bool_to_str(Show_destroy));
                write_pref_string(fp, "theme_name", Theme_name);
        	fclose(fp);
    	} else {
      		g_warning(_("Can't write to %s: %s"), rc_file, strerror(errno));
    	}
        g_free(rc_file);
}

void preferences_dialog(void) {
  	GtkWidget *frame;
  	GtkWidget *big_vbox,*vbox,*buttons_box;
  	GtkWidget *theme_clist,*theme_scrolled_window;
  	gchar     *theme_titles[1] = {_("Select Theme")};
  	GtkWidget *separator;
  	GtkWidget *ok_button,*cancel_button,*apply_button;
  	gint      i;
  
  	dialog=gtk_window_new(GTK_WINDOW_TOPLEVEL);
  	gtk_window_set_title(GTK_WINDOW(dialog), _("Preferences"));
        gtk_window_set_wmclass(GTK_WINDOW(dialog), "GtkBalls_Preferences", "GtkBalls");
  	gtk_signal_connect(GTK_OBJECT(dialog), "key_press_event", GTK_SIGNAL_FUNC(key_pressed), NULL);
  	gtk_container_border_width(GTK_CONTAINER(dialog), 5);

  	big_vbox=gtk_vbox_new(FALSE, 0);
  	gtk_container_add(GTK_CONTAINER(dialog), big_vbox);

  	frame=gtk_frame_new(_("Preferences"));
  	gtk_box_pack_start(GTK_BOX(big_vbox), frame, FALSE, FALSE, 0);

	vbox=gtk_vbox_new(FALSE, 0);
  	gtk_container_add(GTK_CONTAINER(frame), vbox);

        show_hints_button=ut_check_button_new(_("Show colors that will appear on next turn"), Show_next_colors, vbox);
        show_path_button=ut_check_button_new(_("Show path of the ball"), Show_path, vbox);
        show_footprints_button=ut_check_button_new(_("Show footprints of the ball"), Show_footprints, vbox);
        show_destroy_button=ut_check_button_new(_("Show animation of disappearing of the ball"), Show_destroy, vbox);

	/* theme selector */
  	theme_scrolled_window=gtk_scrolled_window_new(NULL, NULL);
  	gtk_box_pack_start(GTK_BOX(vbox), theme_scrolled_window, FALSE, FALSE, 0);
  	theme_clist=gtk_clist_new_with_titles(1, theme_titles);
  	gtk_widget_set_usize(theme_clist, -1, 90);
  	gtk_signal_connect(GTK_OBJECT(theme_clist), "select_row", GTK_SIGNAL_FUNC(theme_selection_made), NULL);
  	gtk_clist_set_selection_mode(GTK_CLIST(theme_clist), GTK_SELECTION_BROWSE);

  	Available_Themes_Number=get_available_themes();
	/* remove it, when default internal theme will be made */
  	if(!Available_Themes_Number) {
        	g_error(_("No themes available! =(\n"));
  	}
  	for(i=0;i<Available_Themes_Number;i++) {
        	gtk_clist_append(GTK_CLIST(theme_clist), &Available_Themes[i]);
        	if(!i || !strcmp(Available_Themes[i], Theme_name)) {
                	gtk_clist_select_row(GTK_CLIST(theme_clist), i, 0);
                	SelectedTheme=i;
        	}
  	}

  	gtk_container_add(GTK_CONTAINER(theme_scrolled_window), theme_clist);
	/* theme selector end */

  	separator=gtk_hseparator_new();
  	gtk_box_pack_start(GTK_BOX(big_vbox), separator, FALSE, FALSE, 5);

  	buttons_box=gtk_hbutton_box_new();
        gtk_button_box_set_layout(GTK_BUTTON_BOX(buttons_box), GTK_BUTTONBOX_SPREAD);
  	gtk_box_pack_start(GTK_BOX(big_vbox), buttons_box, TRUE, TRUE, 0);

	ok_button=ut_button_new(_("OK"), GTK_SIGNAL_FUNC(preferences_ok), NULL, buttons_box);
	cancel_button=ut_button_new(_("Cancel"), GTK_SIGNAL_FUNC(preferences_cancel), GTK_OBJECT(dialog), buttons_box);
	apply_button=ut_button_new(_("Apply"), GTK_SIGNAL_FUNC(preferences_apply), NULL, buttons_box);

  	gtk_widget_show_all(dialog);
        gtk_widget_grab_default(ok_button);
  	gtk_grab_add(dialog);
}

/* find all available themes. if some of *alloc() fails - abort... stupid, heh? */
gint get_available_themes(void) {
  	DIR *directory;
  	struct dirent *dir_entry;
  	struct stat entry_stat;
  	gchar *entry,*currdir,*homedir,*rcentry;
  	gint i,j,num,flag;

  	for(i=0;i<Available_Themes_Number;i++) free(Available_Themes[i]);
  	if(Available_Themes_Number) free(Available_Themes);
  	Available_Themes=NULL;
  	num=0;
  	currdir=installpath;
  	for(j=0;j<2;j++) {
        	if((directory=opendir(currdir))) {
                	while((dir_entry=readdir(directory))) {
                        	if(strncmp(dir_entry->d_name,".",2) && strncmp(dir_entry->d_name,"..",3)
				   && (entry=g_strconcat(currdir,dir_entry->d_name,NULL))) {
                                	if(!stat(entry,&entry_stat) && S_ISDIR(entry_stat.st_mode) && (rcentry=g_strconcat(entry,"/","themerc",NULL)) && !stat(rcentry,&entry_stat)) {
                                        	flag=0;
                                        	for(i=0;i<num && !flag;i++) {
                                                	if(!strcmp(Available_Themes[i],dir_entry->d_name)) {
								flag++;
                                                        }
                                        	}
                                        	if(!flag) {
                                                	num++;
                                                	Available_Themes=g_realloc(Available_Themes,num*sizeof(gchar *));
                                                        if(!(Available_Themes[num-1]=g_strdup(dir_entry->d_name))) {
                                                            	g_error(_("Cannot allocate %d bytes!"),strlen(dir_entry->d_name));
                                                        }
                                                }
                                        	g_free(rcentry);
                                        	g_free(entry);
                                	}
                        	}
                	}
                	closedir(directory);
        	}
        	if(!(homedir=getenv("HOME")) || !(currdir=g_strconcat(homedir,themeprefix,NULL))) {
                	return num;
        	}
  	}
	g_free(currdir);
  	return num;
}

void theme_selection_made(GtkWidget *clist, gint row, gint column, GdkEventButton *event, gpointer data) {
  	SelectedTheme=row;
}

void preferences_ok(GtkWidget *widget, gpointer data) {
  	preferences_apply(NULL, NULL);
  	gtk_widget_destroy(dialog);
}

void preferences_cancel(GtkWidget *widget, gpointer data) {
  	gtk_widget_destroy(dialog);
}

void preferences_apply(GtkWidget *widget, gpointer data) {
        gchar *msg, *save;

        if(strcmp(Available_Themes[SelectedTheme],Theme_name)!=0) {
                save=g_strdup(Theme_name);
                if(Current_theme_name) {
                        g_free(Current_theme_name);
                }
                Current_theme_name=g_strdup(Available_Themes[SelectedTheme]);
  		if(!load_theme(Current_theme_name)) {
                        msg=g_strconcat(_("Failed loading theme \""), Current_theme_name, "\"!\n", NULL);
                        simple_message_box(msg, _("OK"));
                        g_free(msg);
                        g_free(Current_theme_name);
                	Current_theme_name=g_strdup(save);
        	} else {
                	phase=0;
                	draw_board(DrawingArea, Pixmap);
                	draw_next_balls();
                }
  		Theme_name=Current_theme_name;
                g_free(save);
        }

        show_hide_next_balls((Show_next_colors=GTK_TOGGLE_BUTTON(show_hints_button)->active));
        Show_path=GTK_TOGGLE_BUTTON(show_path_button)->active;
        Show_footprints=GTK_TOGGLE_BUTTON(show_footprints_button)->active;
        Show_destroy=GTK_TOGGLE_BUTTON(show_destroy_button)->active;
  	save_preferences();
}
