/* GtkBalls
 * Copyright (C) 1998-1999 Eugene V. Morozov
 * Modifyed in 2001 by drF_ckoff
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#include <stdio.h>
#include <stdlib.h>
#include <math.h>


/* returns x coordinate of the node
   number_of_cells: number of cells in the row 
   returns -1 on error */
int __find_x_of_the_node(int node, int number_of_x_cells, int number_of_y_cells) {
  	if((node>=(number_of_x_cells*number_of_y_cells)) || (node<0)) return -1;
  	return node % number_of_x_cells;
}

/* returns y coordinate of the node
   number_of_cells: number of cells in the row 
   returns -1 on error */
int __find_y_of_the_node(int node, int number_of_x_cells, int number_of_y_cells) {
  	if((node>=(number_of_x_cells*number_of_y_cells)) || (node<0)) return -1;
  	return node / number_of_x_cells;
}

/* returns x and y coordinates of the node
   number_of_cells: number of cells in the row */
void find_x_y_of_the_node (int *x, int *y, int node, int number_of_x_cells, int number_of_y_cells) {
        *x=__find_x_of_the_node(node, number_of_x_cells, number_of_y_cells);
        *y=__find_y_of_the_node(node, number_of_x_cells, number_of_y_cells);
}

/* find number of the node by its coordinates
   number_of_cells: number of cells in the row
   returns -1 on error */
int find_node_by_coords(int x, int y, int number_of_x_cells, int number_of_y_cells) {
  	if((x>=number_of_x_cells) || (y>=number_of_y_cells) || (x<0) || (y<0)) return -1;
  	return y*number_of_x_cells+x;
}

/* mark all neighbouring nodes of the nodes
   source_nodes: source nodes
   neighbours: neighbouring nodes
   mark: number to mark neighbours
   number_of_cells: number of cells in the row
   returns number of marked nodes */
int mark_neighbours_of_the_nodes(int *nodes, int *source_nodes, int *neighbours, int mark,
       			         int number_of_x_cells, int number_of_y_cells) {
  	int i,j,neighbours_count=0;
  	int x,y,node;
        int xses[4]={ 0,0,1,-1};
        int yses[4]={-1,1,0, 0};

  	for(i=1;i<=source_nodes[0];i++) {
      		find_x_y_of_the_node(&x, &y, source_nodes[i], number_of_x_cells, number_of_y_cells);
      		if(x!=-1 && y!=-1) {
                	for(j=0;j<4;j++) {
                        	node=find_node_by_coords(x+xses[j], y+yses[j], number_of_x_cells, number_of_y_cells);
      				if((node!=-1) && !nodes[node]) {
	  				nodes[node]=mark;
		  			neighbours[++neighbours_count]=node;
				}
                	}
                }
    	}
  	neighbours[0] = neighbours_count;
        return neighbours_count;
}

/* find the path between source_node and the target_node
   result stored in path
   returns 0 on failure and 1 on success */
int find_path(int *nodes, int source_node, int target_node, int *path,
	      int number_of_x_cells, int number_of_y_cells) {
	int waves[number_of_x_cells*number_of_y_cells][number_of_x_cells*number_of_y_cells];
  	int prototypes[5],path_node[2];
  	int i,j,k,l,finish=0;

  	if((target_node>=(number_of_x_cells*number_of_y_cells)) || (target_node<0)) {
    		return 0;
        }

  	k=1;
  	waves[0][0]=1;
  	waves[0][1]=source_node;

  	path[0]=0;
  	do {
       		if(!mark_neighbours_of_the_nodes(nodes, waves[k-1], waves[k], k,
				    	         number_of_x_cells, number_of_y_cells)) {
      			/* the destination can never be reached */
			return 0;
                }
      		for(i=1;i<=waves[k][0];i++) {
			if(waves[k][i]==target_node) {
	    			finish=1;
	    			break;
	  		}
                }
      		if(finish) {
			break;
                }
      		k++;
    	} while(1);

  	for(i=0;i<(number_of_x_cells*number_of_y_cells);i++) {
    		if(nodes[i]>0) {
      			nodes[i]=0;
    		} else {
      			nodes[i]=-1;
                }
        }

  	path_node[0]=1;
  	path_node[1]=target_node;
  	path[0]=0;
  	for(i=k-1;i>=1;i--) {
      		mark_neighbours_of_the_nodes(nodes, path_node, prototypes, i,
				             number_of_x_cells, number_of_y_cells);
      		finish=0;
      		for(j=1;j<=prototypes[0];j++) {
	  		for(l=1;l<=waves[i][0];l++) {
	      			if(prototypes[j]==waves[i][l]) {
		  			finish=1;
		  			break;
				}
	    		}
	  		if(finish) break;
		}
      		if(!finish) {
	  		printf("Unexpected error.\n");
	  		return 0;
		}
      		path_node[1]=prototypes[j];
      		path[0]++;
      		path[path[0]]=path_node[1];
    	}
  	path[0]++;
  	path[path[0]]=target_node;

  	return 1;
}
