/* GtkBalls
 * Copyright (C) 1998 Eugene V. Morozov
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#include <stdio.h>
#include <string.h>
#include <gtk/gtk.h>

#include "scoreboard.h"

int 
write_score (struct score_board *b)
{
  FILE *score_file;
  int i;

  score_file = fopen (PREFIX "/share/gtkballs/score", "w");
  if (!score_file)
    /* unable to save score */
    return FALSE;

  for (i = 0; i < 10; i++)
    if (strlen (b[i].name) != 0)
      fprintf (score_file, "%15s\t%i\n", b[i].name, b[i].score);
    else
      fprintf (score_file, "<none>\t0\n");

  fclose (score_file);

  return TRUE;
}

int 
read_score (struct score_board *b)
{
  FILE *score_file;
  int i, j;

  score_file = fopen (PREFIX "/share/gtkballs/score", "r");
  if (!score_file)
    /* unable to load score */
    return FALSE;

  for (i = 0; (i < 10) && (!feof (score_file)); i++)
    {
      fscanf (score_file, "%15s %d", b[i].name, &(b[i].score));
      if (strcmp (b[i].name, "<none>") == 0)
	b[i].name[0] = '\0';
    }

  if (i < 9)
    for (j = i; j < 10; j++)
      {
	b[j].name[0] = '\0';
	b[j].score = 0;
      }

  fclose (score_file);

  return TRUE;
}

void 
insert_entry_in_score_board (struct score_board *board, struct score_board entry)
{
  int i = 0, j;

  if (entry.score <= 0)
    return;

  while (board[i].score > entry.score)
    i++;

  if (i > 9)
    return;

  for (j = 8; j >= i; j--)
    {
      strcpy (board[j + 1].name, board[j].name);
      board[j + 1].score = board[j].score;
    }

  strcpy (board[i].name, entry.name);
  board[i].score = entry.score;
}
