/* GtkBalls
 * Copyright (C) 1998 Eugene V. Morozov
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#include <stdio.h>
#include <stdlib.h>
#include <gtk/gtk.h>

#include "interface.h"
#include "license.h"

void
gnu_license_dialog (void)
{
  GtkWidget *window;
  GtkWidget *vbox, *hbox, *button_box;
  GtkWidget *license;
  GtkWidget *vscrollbar;
  GtkWidget *separator;
  GtkWidget *ok_button;
  FILE *fLicense;
  long nFileSize;
  char *GNU_License;

  fLicense = fopen (PREFIX "/share/gtkballs/COPYING", "r");
  if (fLicense == NULL)
    {
      simple_message_box ("Can't open license file", "OK");
      return;
    }
  if (fseek (fLicense, 0, SEEK_END) != 0)
    {
      simple_message_box ("Can't determine file size", "OK");
      fclose (fLicense);
      return;
    }
  nFileSize = ftell (fLicense);
  if (nFileSize == -1)
    {
      simple_message_box ("Can't determine file size", "OK");
      fclose (fLicense);
      return;
    }
  GNU_License = (char *) malloc (nFileSize);
  if (GNU_License == NULL)
    {
      simple_message_box ("Not enough memory", "OK");
      fclose (fLicense);
      return;
    }
  if (fseek (fLicense, 0, SEEK_SET) != 0)
    {
      simple_message_box ("Can't determine file size", "OK");
      free (GNU_License);
      fclose (fLicense);
      return;
    }
  fread (GNU_License, 1, nFileSize, fLicense);
  fclose (fLicense);

  window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_signal_connect (GTK_OBJECT (window), "destroy",
		      GTK_SIGNAL_FUNC (gtk_widget_destroyed), &window);
  gtk_widget_set_usize (window, 602, 460);
  gtk_window_set_title (GTK_WINDOW (window), "GNU Public License");
  gtk_container_border_width (GTK_CONTAINER (window), 5);

  vbox = gtk_vbox_new (FALSE, 0);
  gtk_container_border_width (GTK_CONTAINER (vbox), 5);
  gtk_container_add (GTK_CONTAINER (window), vbox);
  gtk_widget_show (vbox);

  hbox = gtk_hbox_new (FALSE, 0);
  gtk_box_pack_start (GTK_BOX (vbox), hbox, TRUE, TRUE, 0);
  gtk_widget_show (hbox);

  license = gtk_text_new (NULL, NULL);
  gtk_text_set_editable (GTK_TEXT (license), FALSE);
  gtk_box_pack_start (GTK_BOX (hbox), license, TRUE, TRUE, 0);
  gtk_widget_show (license);

  vscrollbar = gtk_vscrollbar_new (GTK_TEXT (license)->vadj);
  gtk_box_pack_start (GTK_BOX (hbox), vscrollbar, FALSE, FALSE, 0);
  gtk_widget_show (vscrollbar);

  separator = gtk_hseparator_new ();
  gtk_box_pack_start (GTK_BOX (vbox), separator, FALSE, FALSE, 5);  
  gtk_widget_show (separator);
  
  button_box = gtk_hbox_new (TRUE, 0);
  gtk_box_pack_start (GTK_BOX (vbox), button_box, FALSE, TRUE, 0);
  gtk_widget_show (button_box);

  ok_button = gtk_button_new_with_label (" OK ");
  gtk_signal_connect_object (GTK_OBJECT (ok_button), "clicked",
			     GTK_SIGNAL_FUNC (gtk_widget_destroy),
			     GTK_OBJECT (window));
  gtk_box_pack_start (GTK_BOX (button_box), ok_button, FALSE, FALSE, 0);
  gtk_widget_show (ok_button);

  gtk_widget_show (window);
  gtk_text_insert (GTK_TEXT (license), NULL, NULL, NULL, GNU_License, -1);

  free (GNU_License);
}
