/* GtkamlParser.vala
 * 
 * Copyright (C) 2008 Vlad Grecescu
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with main.c; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor Boston, MA 02110-1301,  USA
 *
 * Author:
 *        Vlad Grecescu (b100dian@gmail.com)
 */

#ifndef __GTKAMLPARSER_H__
#define __GTKAMLPARSER_H__

#include <glib.h>
#include <glib-object.h>
#include <vala/valaparser.h>
#include <vala/valacodecontext.h>
#include <stdlib.h>
#include <string.h>
#include <vala/valasourcefile.h>

G_BEGIN_DECLS


#define GTKAML_TYPE_PARSER (gtkaml_parser_get_type ())
#define GTKAML_PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTKAML_TYPE_PARSER, GtkamlParser))
#define GTKAML_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GTKAML_TYPE_PARSER, GtkamlParserClass))
#define GTKAML_IS_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTKAML_TYPE_PARSER))
#define GTKAML_IS_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTKAML_TYPE_PARSER))
#define GTKAML_PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GTKAML_TYPE_PARSER, GtkamlParserClass))

typedef struct _GtkamlParser GtkamlParser;
typedef struct _GtkamlParserClass GtkamlParserClass;
typedef struct _GtkamlParserPrivate GtkamlParserPrivate;

/**
 * gtkaml entry point
 */
struct _GtkamlParser {
	ValaParser parent_instance;
	GtkamlParserPrivate * priv;
};

struct _GtkamlParserClass {
	ValaParserClass parent_class;
	void (*parse_gtkaml_file) (GtkamlParser* self, ValaSourceFile* gtkaml_source_file);
};


GtkamlParser* gtkaml_parser_construct (GType object_type);
GtkamlParser* gtkaml_parser_new (void);
void gtkaml_parser_parse (GtkamlParser* self, ValaCodeContext* context, char** implicits_directories, int implicits_directories_length1);
void gtkaml_parser_parse_gtkaml_file (GtkamlParser* self, ValaSourceFile* gtkaml_source_file);
GType gtkaml_parser_get_type (void);


G_END_DECLS

#endif
