/* GtkamlSimpleAttribute.vala
 * 
 * Copyright (C) 2008 Vlad Grecescu
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with main.c; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor Boston, MA 02110-1301,  USA
 *
 * Author:
 *        Vlad Grecescu (b100dian@gmail.com)
 */

#include "GtkamlSimpleAttribute.h"




struct _GtkamlSimpleAttributePrivate {
	char* _value;
};

#define GTKAML_SIMPLE_ATTRIBUTE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GTKAML_TYPE_SIMPLE_ATTRIBUTE, GtkamlSimpleAttributePrivate))
enum  {
	GTKAML_SIMPLE_ATTRIBUTE_DUMMY_PROPERTY,
	GTKAML_SIMPLE_ATTRIBUTE_VALUE
};
static gpointer gtkaml_simple_attribute_parent_class = NULL;
static void gtkaml_simple_attribute_finalize (GObject* obj);



GtkamlSimpleAttribute* gtkaml_simple_attribute_construct (GType object_type, const char* name, const char* value) {
	GtkamlSimpleAttribute * self;
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (value != NULL, NULL);
	self = g_object_newv (object_type, 0, NULL);
	gtkaml_attribute_set_name ((GtkamlAttribute*) self, name);
	gtkaml_simple_attribute_set_value (self, value);
	return self;
}


GtkamlSimpleAttribute* gtkaml_simple_attribute_new (const char* name, const char* value) {
	return gtkaml_simple_attribute_construct (GTKAML_TYPE_SIMPLE_ATTRIBUTE, name, value);
}


const char* gtkaml_simple_attribute_get_value (GtkamlSimpleAttribute* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_value;
}


void gtkaml_simple_attribute_set_value (GtkamlSimpleAttribute* self, const char* value) {
	char* _tmp2;
	const char* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_value = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : g_strdup (_tmp1)), self->priv->_value = (g_free (self->priv->_value), NULL), _tmp2);
	g_object_notify ((GObject *) self, "value");
}


static void gtkaml_simple_attribute_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GtkamlSimpleAttribute * self;
	gpointer boxed;
	self = GTKAML_SIMPLE_ATTRIBUTE (object);
	switch (property_id) {
		case GTKAML_SIMPLE_ATTRIBUTE_VALUE:
		g_value_set_string (value, gtkaml_simple_attribute_get_value (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void gtkaml_simple_attribute_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GtkamlSimpleAttribute * self;
	self = GTKAML_SIMPLE_ATTRIBUTE (object);
	switch (property_id) {
		case GTKAML_SIMPLE_ATTRIBUTE_VALUE:
		gtkaml_simple_attribute_set_value (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void gtkaml_simple_attribute_class_init (GtkamlSimpleAttributeClass * klass) {
	gtkaml_simple_attribute_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GtkamlSimpleAttributePrivate));
	G_OBJECT_CLASS (klass)->get_property = gtkaml_simple_attribute_get_property;
	G_OBJECT_CLASS (klass)->set_property = gtkaml_simple_attribute_set_property;
	G_OBJECT_CLASS (klass)->finalize = gtkaml_simple_attribute_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GTKAML_SIMPLE_ATTRIBUTE_VALUE, g_param_spec_string ("value", "value", "value", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void gtkaml_simple_attribute_instance_init (GtkamlSimpleAttribute * self) {
	self->priv = GTKAML_SIMPLE_ATTRIBUTE_GET_PRIVATE (self);
}


static void gtkaml_simple_attribute_finalize (GObject* obj) {
	GtkamlSimpleAttribute * self;
	self = GTKAML_SIMPLE_ATTRIBUTE (obj);
	self->priv->_value = (g_free (self->priv->_value), NULL);
	G_OBJECT_CLASS (gtkaml_simple_attribute_parent_class)->finalize (obj);
}


GType gtkaml_simple_attribute_get_type (void) {
	static GType gtkaml_simple_attribute_type_id = 0;
	if (gtkaml_simple_attribute_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (GtkamlSimpleAttributeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gtkaml_simple_attribute_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GtkamlSimpleAttribute), 0, (GInstanceInitFunc) gtkaml_simple_attribute_instance_init, NULL };
		gtkaml_simple_attribute_type_id = g_type_register_static (GTKAML_TYPE_ATTRIBUTE, "GtkamlSimpleAttribute", &g_define_type_info, 0);
	}
	return gtkaml_simple_attribute_type_id;
}




