/* GtkamlImplicitsStore.vala
 * 
 * Copyright (C) 2008 Vlad Grecescu
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with main.c; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor Boston, MA 02110-1301,  USA
 *
 * Author:
 *        Vlad Grecescu (b100dian@gmail.com)
 */

#include "GtkamlImplicitsStore.h"
#include <gee/arraylist.h>
#include <gee/hashmap.h>
#include <gee/map.h>
#include <gee/collection.h>
#include <gee/iterable.h>
#include <gee/iterator.h>
#include <glib/gstdio.h>
#include <vala/valareport.h>
#include <vala/valasourcereference.h>
#include <vala/valasymbol.h>
#include <vala/valacreationmethod.h>
#include <vala/valaformalparameter.h>




enum  {
	GTKAML_IMPLICITS_PARAMETER_DUMMY_PROPERTY
};
static gpointer gtkaml_implicits_parameter_parent_class = NULL;
static void gtkaml_implicits_parameter_finalize (GObject* obj);
enum  {
	GTKAML_KEY_FILE_WRAPPER_DUMMY_PROPERTY
};
static GObject * gtkaml_key_file_wrapper_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static gpointer gtkaml_key_file_wrapper_parent_class = NULL;
static void gtkaml_key_file_wrapper_finalize (GObject* obj);
struct _GtkamlImplicitsStorePrivate {
	GeeList* implicits_dirs;
	GeeMap* loaded_ns;
};

#define GTKAML_IMPLICITS_STORE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GTKAML_TYPE_IMPLICITS_STORE, GtkamlImplicitsStorePrivate))
enum  {
	GTKAML_IMPLICITS_STORE_DUMMY_PROPERTY
};
static GeeList* gtkaml_implicits_store_get_ns (GtkamlImplicitsStore* self, const char* ns);
static gpointer gtkaml_implicits_store_parent_class = NULL;
static void gtkaml_implicits_store_finalize (GObject* obj);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);
static int _vala_strcmp0 (const char * str1, const char * str2);



/** a method parameter as it came from an .implicits file, with its default value */
GtkamlImplicitsParameter* gtkaml_implicits_parameter_construct (GType object_type) {
	GtkamlImplicitsParameter * self;
	self = g_object_newv (object_type, 0, NULL);
	return self;
}


GtkamlImplicitsParameter* gtkaml_implicits_parameter_new (void) {
	return gtkaml_implicits_parameter_construct (GTKAML_TYPE_IMPLICITS_PARAMETER);
}


static void gtkaml_implicits_parameter_class_init (GtkamlImplicitsParameterClass * klass) {
	gtkaml_implicits_parameter_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = gtkaml_implicits_parameter_finalize;
}


static void gtkaml_implicits_parameter_instance_init (GtkamlImplicitsParameter * self) {
}


static void gtkaml_implicits_parameter_finalize (GObject* obj) {
	GtkamlImplicitsParameter * self;
	self = GTKAML_IMPLICITS_PARAMETER (obj);
	self->name = (g_free (self->name), NULL);
	self->default_value = (g_free (self->default_value), NULL);
	G_OBJECT_CLASS (gtkaml_implicits_parameter_parent_class)->finalize (obj);
}


GType gtkaml_implicits_parameter_get_type (void) {
	static GType gtkaml_implicits_parameter_type_id = 0;
	if (gtkaml_implicits_parameter_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (GtkamlImplicitsParameterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gtkaml_implicits_parameter_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GtkamlImplicitsParameter), 0, (GInstanceInitFunc) gtkaml_implicits_parameter_instance_init, NULL };
		gtkaml_implicits_parameter_type_id = g_type_register_static (G_TYPE_OBJECT, "GtkamlImplicitsParameter", &g_define_type_info, 0);
	}
	return gtkaml_implicits_parameter_type_id;
}


gboolean gtkaml_key_file_wrapper_has_key (GtkamlKeyFileWrapper* self, const char* group, const char* key) {
	GError * inner_error;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (group != NULL, FALSE);
	g_return_val_if_fail (key != NULL, FALSE);
	inner_error = NULL;
	{
		gboolean _tmp0;
		_tmp0 = g_key_file_has_key (self->key_file, group, key, &inner_error);
		if (inner_error != NULL) {
			if (inner_error->domain == G_KEY_FILE_ERROR) {
				goto __catch4_g_key_file_error;
			}
			goto __finally4;
		}
		return _tmp0;
	}
	goto __finally4;
	__catch4_g_key_file_error:
	{
		GError * e;
		e = inner_error;
		inner_error = NULL;
		{
			gboolean _tmp2;
			return (_tmp2 = FALSE, (e == NULL) ? NULL : (e = (g_error_free (e), NULL)), _tmp2);
		}
	}
	__finally4:
	if (inner_error != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
		g_clear_error (&inner_error);
		return FALSE;
	}
}


char** gtkaml_key_file_wrapper_get_string_list (GtkamlKeyFileWrapper* self, const char* group, const char* key, int* result_length1) {
	GError * inner_error;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (group != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	inner_error = NULL;
	{
		char** _tmp2;
		gint _tmp1_size;
		gint _tmp1_length1;
		gint _tmp0;
		char** _tmp1;
		char** _tmp3;
		_tmp2 = NULL;
		_tmp1 = (_tmp2 = g_key_file_get_string_list (self->key_file, group, key, &_tmp0, &inner_error), _tmp1_length1 = _tmp0, _tmp1_size = _tmp1_length1, _tmp2);
		if (inner_error != NULL) {
			goto __catch5_g_error;
			goto __finally5;
		}
		_tmp3 = NULL;
		return (_tmp3 = _tmp1, *result_length1 = _tmp1_length1, _tmp3);
	}
	goto __finally5;
	__catch5_g_error:
	{
		GError * e;
		e = inner_error;
		inner_error = NULL;
		{
			char** _tmp5;
			char** _tmp6;
			_tmp5 = NULL;
			_tmp6 = NULL;
			return (_tmp6 = (_tmp5 = g_new0 (char*, 0 + 1), *result_length1 = 0, _tmp5), (e == NULL) ? NULL : (e = (g_error_free (e), NULL)), _tmp6);
		}
	}
	__finally5:
	if (inner_error != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
		g_clear_error (&inner_error);
		return NULL;
	}
}


/**
 * GObject-ification of KeyFile
 */
GtkamlKeyFileWrapper* gtkaml_key_file_wrapper_construct (GType object_type) {
	GtkamlKeyFileWrapper * self;
	self = g_object_newv (object_type, 0, NULL);
	return self;
}


GtkamlKeyFileWrapper* gtkaml_key_file_wrapper_new (void) {
	return gtkaml_key_file_wrapper_construct (GTKAML_TYPE_KEY_FILE_WRAPPER);
}


static GObject * gtkaml_key_file_wrapper_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GtkamlKeyFileWrapperClass * klass;
	GObjectClass * parent_class;
	GtkamlKeyFileWrapper * self;
	klass = GTKAML_KEY_FILE_WRAPPER_CLASS (g_type_class_peek (GTKAML_TYPE_KEY_FILE_WRAPPER));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = GTKAML_KEY_FILE_WRAPPER (obj);
	{
		GKeyFile* _tmp0;
		_tmp0 = NULL;
		self->key_file = (_tmp0 = g_key_file_new (), (self->key_file == NULL) ? NULL : (self->key_file = (g_key_file_free (self->key_file), NULL)), _tmp0);
	}
	return obj;
}


static void gtkaml_key_file_wrapper_class_init (GtkamlKeyFileWrapperClass * klass) {
	gtkaml_key_file_wrapper_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->constructor = gtkaml_key_file_wrapper_constructor;
	G_OBJECT_CLASS (klass)->finalize = gtkaml_key_file_wrapper_finalize;
}


static void gtkaml_key_file_wrapper_instance_init (GtkamlKeyFileWrapper * self) {
}


static void gtkaml_key_file_wrapper_finalize (GObject* obj) {
	GtkamlKeyFileWrapper * self;
	self = GTKAML_KEY_FILE_WRAPPER (obj);
	(self->key_file == NULL) ? NULL : (self->key_file = (g_key_file_free (self->key_file), NULL));
	G_OBJECT_CLASS (gtkaml_key_file_wrapper_parent_class)->finalize (obj);
}


GType gtkaml_key_file_wrapper_get_type (void) {
	static GType gtkaml_key_file_wrapper_type_id = 0;
	if (gtkaml_key_file_wrapper_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (GtkamlKeyFileWrapperClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gtkaml_key_file_wrapper_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GtkamlKeyFileWrapper), 0, (GInstanceInitFunc) gtkaml_key_file_wrapper_instance_init, NULL };
		gtkaml_key_file_wrapper_type_id = g_type_register_static (G_TYPE_OBJECT, "GtkamlKeyFileWrapper", &g_define_type_info, 0);
	}
	return gtkaml_key_file_wrapper_type_id;
}


GeeReadOnlyList* gtkaml_implicits_store_get_implicits_dirs (GtkamlImplicitsStore* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return gee_read_only_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, self->priv->implicits_dirs);
}


void gtkaml_implicits_store_add_implicits_dir (GtkamlImplicitsStore* self, const char* directory) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (directory != NULL);
	gee_collection_add ((GeeCollection*) self->priv->implicits_dirs, directory);
}


static GeeList* gtkaml_implicits_store_get_ns (GtkamlImplicitsStore* self, const char* ns) {
	GError * inner_error;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (ns != NULL, NULL);
	inner_error = NULL;
	if (gee_map_contains (self->priv->loaded_ns, ns)) {
		return (GeeList*) gee_map_get (self->priv->loaded_ns, ns);
	} else {
		GeeArrayList* key_file_list;
		key_file_list = gee_array_list_new (GTKAML_TYPE_KEY_FILE_WRAPPER, (GBoxedCopyFunc) g_object_ref, g_object_unref, g_direct_equal);
		{
			GeeIterator* _implicits_dir_it;
			_implicits_dir_it = gee_iterable_iterator ((GeeIterable*) self->priv->implicits_dirs);
			while (gee_iterator_next (_implicits_dir_it)) {
				char* implicits_dir;
				char* _tmp1;
				char* _tmp2;
				char* file_name;
				implicits_dir = (char*) gee_iterator_get (_implicits_dir_it);
				_tmp1 = NULL;
				_tmp2 = NULL;
				file_name = (_tmp2 = g_build_filename (implicits_dir, _tmp1 = g_strconcat (ns, ".implicits", NULL), NULL), _tmp1 = (g_free (_tmp1), NULL), _tmp2);
				if (g_file_test (file_name, G_FILE_TEST_EXISTS)) {
					GtkamlKeyFileWrapper* key_file_wrapper;
					key_file_wrapper = gtkaml_key_file_wrapper_new ();
					{
						g_key_file_load_from_file (key_file_wrapper->key_file, file_name, G_KEY_FILE_NONE, &inner_error);
						if (inner_error != NULL) {
							goto __catch6_g_error;
							goto __finally6;
						}
						gee_collection_add ((GeeCollection*) key_file_list, key_file_wrapper);
					}
					goto __finally6;
					__catch6_g_error:
					{
						GError * e;
						e = inner_error;
						inner_error = NULL;
						{
							char* _tmp3;
							_tmp3 = NULL;
							vala_report_warning (NULL, _tmp3 = g_strdup_printf ("Invalid implicits file %s", file_name));
							_tmp3 = (g_free (_tmp3), NULL);
							(e == NULL) ? NULL : (e = (g_error_free (e), NULL));
						}
					}
					__finally6:
					if (inner_error != NULL) {
						(key_file_wrapper == NULL) ? NULL : (key_file_wrapper = (g_object_unref (key_file_wrapper), NULL));
						implicits_dir = (g_free (implicits_dir), NULL);
						file_name = (g_free (file_name), NULL);
						(_implicits_dir_it == NULL) ? NULL : (_implicits_dir_it = (gee_collection_object_unref (_implicits_dir_it), NULL));
						(key_file_list == NULL) ? NULL : (key_file_list = (gee_collection_object_unref (key_file_list), NULL));
						g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
						g_clear_error (&inner_error);
						return NULL;
					}
					(key_file_wrapper == NULL) ? NULL : (key_file_wrapper = (g_object_unref (key_file_wrapper), NULL));
				}
				implicits_dir = (g_free (implicits_dir), NULL);
				file_name = (g_free (file_name), NULL);
			}
			(_implicits_dir_it == NULL) ? NULL : (_implicits_dir_it = (gee_collection_object_unref (_implicits_dir_it), NULL));
		}
		/*even an empty list does it: so that we don't scan the directories again*/
		gee_map_set (self->priv->loaded_ns, ns, (GeeList*) key_file_list);
		return (GeeList*) key_file_list;
	}
}


GeeList* gtkaml_implicits_store_get_adds (GtkamlImplicitsStore* self, const char* ns, const char* class_name) {
	GeeList* adds;
	GeeList* kf_ns;
	GeeList* _tmp3;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (ns != NULL, NULL);
	g_return_val_if_fail (class_name != NULL, NULL);
	adds = (GeeList*) gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_direct_equal);
	kf_ns = gtkaml_implicits_store_get_ns (self, ns);
	{
		GeeIterator* _kfw_it;
		_kfw_it = gee_iterable_iterator ((GeeIterable*) kf_ns);
		while (gee_iterator_next (_kfw_it)) {
			GtkamlKeyFileWrapper* kfw;
			kfw = (GtkamlKeyFileWrapper*) gee_iterator_get (_kfw_it);
			if (gtkaml_key_file_wrapper_has_key (kfw, class_name, "adds")) {
				char** _tmp1;
				gint kf_adds_size;
				gint kf_adds_length1;
				gint _tmp0;
				char** kf_adds;
				_tmp1 = NULL;
				kf_adds = (_tmp1 = gtkaml_key_file_wrapper_get_string_list (kfw, class_name, "adds", &_tmp0), kf_adds_length1 = _tmp0, kf_adds_size = kf_adds_length1, _tmp1);
				{
					char** add_collection;
					int add_collection_length1;
					int add_it;
					add_collection = kf_adds;
					add_collection_length1 = kf_adds_length1;
					for (add_it = 0; add_it < kf_adds_length1; add_it = add_it + 1) {
						const char* _tmp2;
						char* add;
						_tmp2 = NULL;
						add = (_tmp2 = add_collection[add_it], (_tmp2 == NULL) ? NULL : g_strdup (_tmp2));
						{
							/*stderr.printf ("store contains %s\n", add);*/
							gee_collection_add ((GeeCollection*) adds, add);
							add = (g_free (add), NULL);
						}
					}
				}
				kf_adds = (_vala_array_free (kf_adds, kf_adds_length1, (GDestroyNotify) g_free), NULL);
			}
			(kfw == NULL) ? NULL : (kfw = (g_object_unref (kfw), NULL));
		}
		(_kfw_it == NULL) ? NULL : (_kfw_it = (gee_collection_object_unref (_kfw_it), NULL));
	}
	_tmp3 = NULL;
	return (_tmp3 = adds, (kf_ns == NULL) ? NULL : (kf_ns = (gee_collection_object_unref (kf_ns), NULL)), _tmp3);
}


GeeList* gtkaml_implicits_store_get_method_parameters (GtkamlImplicitsStore* self, const char* ns, const char* class_name, const char* method_name) {
	GeeList* parameters;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (ns != NULL, NULL);
	g_return_val_if_fail (class_name != NULL, NULL);
	g_return_val_if_fail (method_name != NULL, NULL);
	parameters = (GeeList*) gee_array_list_new (GTKAML_TYPE_IMPLICITS_PARAMETER, (GBoxedCopyFunc) g_object_ref, g_object_unref, g_direct_equal);
	{
		GeeList* _tmp0;
		GeeIterator* _tmp1;
		GeeIterator* _kfw_it;
		_tmp0 = NULL;
		_tmp1 = NULL;
		_kfw_it = (_tmp1 = gee_iterable_iterator ((GeeIterable*) (_tmp0 = gtkaml_implicits_store_get_ns (self, ns))), (_tmp0 == NULL) ? NULL : (_tmp0 = (gee_collection_object_unref (_tmp0), NULL)), _tmp1);
		while (gee_iterator_next (_kfw_it)) {
			GtkamlKeyFileWrapper* kfw;
			kfw = (GtkamlKeyFileWrapper*) gee_iterator_get (_kfw_it);
			if (gtkaml_key_file_wrapper_has_key (kfw, class_name, method_name)) {
				char** _tmp3;
				gint kf_parameters_size;
				gint kf_parameters_length1;
				gint _tmp2;
				char** kf_parameters;
				GeeList* _tmp11;
				_tmp3 = NULL;
				kf_parameters = (_tmp3 = gtkaml_key_file_wrapper_get_string_list (kfw, class_name, method_name, &_tmp2), kf_parameters_length1 = _tmp2, kf_parameters_size = kf_parameters_length1, _tmp3);
				{
					char** parameter_collection;
					int parameter_collection_length1;
					int parameter_it;
					parameter_collection = kf_parameters;
					parameter_collection_length1 = kf_parameters_length1;
					for (parameter_it = 0; parameter_it < kf_parameters_length1; parameter_it = parameter_it + 1) {
						const char* _tmp10;
						char* parameter;
						_tmp10 = NULL;
						parameter = (_tmp10 = parameter_collection[parameter_it], (_tmp10 == NULL) ? NULL : g_strdup (_tmp10));
						{
							GtkamlImplicitsParameter* implicits_parameter;
							char** _tmp5;
							gint name_value_size;
							gint name_value_length1;
							char** _tmp4;
							char** name_value;
							char* _tmp7;
							const char* _tmp6;
							char* _tmp9;
							const char* _tmp8;
							implicits_parameter = gtkaml_implicits_parameter_new ();
							_tmp5 = NULL;
							_tmp4 = NULL;
							name_value = (_tmp5 = _tmp4 = g_strsplit (parameter, "=", 0), name_value_length1 = _vala_array_length (_tmp4), name_value_size = name_value_length1, _tmp5);
							_tmp7 = NULL;
							_tmp6 = NULL;
							implicits_parameter->name = (_tmp7 = (_tmp6 = name_value[0], (_tmp6 == NULL) ? NULL : g_strdup (_tmp6)), implicits_parameter->name = (g_free (implicits_parameter->name), NULL), _tmp7);
							_tmp9 = NULL;
							_tmp8 = NULL;
							implicits_parameter->default_value = (_tmp9 = (_tmp8 = name_value[1], (_tmp8 == NULL) ? NULL : g_strdup (_tmp8)), implicits_parameter->default_value = (g_free (implicits_parameter->default_value), NULL), _tmp9);
							/*either null or not*/
							gee_collection_add ((GeeCollection*) parameters, implicits_parameter);
							parameter = (g_free (parameter), NULL);
							(implicits_parameter == NULL) ? NULL : (implicits_parameter = (g_object_unref (implicits_parameter), NULL));
							name_value = (_vala_array_free (name_value, name_value_length1, (GDestroyNotify) g_free), NULL);
						}
					}
				}
				_tmp11 = NULL;
				return (_tmp11 = parameters, kf_parameters = (_vala_array_free (kf_parameters, kf_parameters_length1, (GDestroyNotify) g_free), NULL), (kfw == NULL) ? NULL : (kfw = (g_object_unref (kfw), NULL)), (_kfw_it == NULL) ? NULL : (_kfw_it = (gee_collection_object_unref (_kfw_it), NULL)), _tmp11);
			}
			(kfw == NULL) ? NULL : (kfw = (g_object_unref (kfw), NULL));
		}
		(_kfw_it == NULL) ? NULL : (_kfw_it = (gee_collection_object_unref (_kfw_it), NULL));
	}
	return parameters;
}


/*empty*/
GeeList* gtkaml_implicits_store_determine_parameter_names_and_default_values (GtkamlImplicitsStore* self, GtkamlClassDefinition* class_definition, ValaMethod* method) {
	char* ns;
	const char* _tmp0;
	char* clazz;
	GeeArrayList* result;
	const char* _tmp1;
	char* method_name;
	GeeList* result_array;
	GeeList* _tmp9;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (class_definition != NULL, NULL);
	g_return_val_if_fail (method != NULL, NULL);
	ns = vala_symbol_get_full_name (vala_symbol_get_parent_symbol (vala_symbol_get_parent_symbol ((ValaSymbol*) method)));
	_tmp0 = NULL;
	clazz = (_tmp0 = vala_symbol_get_name (vala_symbol_get_parent_symbol ((ValaSymbol*) method)), (_tmp0 == NULL) ? NULL : g_strdup (_tmp0));
	/*stderr.printf ("determine_parameter_names_and_default_values %s %s of %s.%s\n", class_definition.base_full_name, method.name, ns, clazz);*/
	result = gee_array_list_new (GTKAML_TYPE_IMPLICITS_PARAMETER, (GBoxedCopyFunc) g_object_ref, g_object_unref, g_direct_equal);
	_tmp1 = NULL;
	method_name = (_tmp1 = vala_symbol_get_name ((ValaSymbol*) method), (_tmp1 == NULL) ? NULL : g_strdup (_tmp1));
	if (VALA_IS_CREATION_METHOD (method)) {
		if (_vala_strcmp0 (vala_symbol_get_name ((ValaSymbol*) method), "new") != 0) {
			char* _tmp2;
			_tmp2 = NULL;
			method_name = (_tmp2 = g_strconcat ("new.", vala_symbol_get_name ((ValaSymbol*) method), NULL), method_name = (g_free (method_name), NULL), _tmp2);
		}
	} else {
		char* _tmp3;
		_tmp3 = NULL;
		method_name = (_tmp3 = g_strconcat ("add.", vala_symbol_get_name ((ValaSymbol*) method), NULL), method_name = (g_free (method_name), NULL), _tmp3);
	}
	result_array = gtkaml_implicits_store_get_method_parameters (self, ns, clazz, method_name);
	if (gee_collection_get_size ((GeeCollection*) result_array) != 0) {
		{
			GeeIterator* _result_item_it;
			_result_item_it = gee_iterable_iterator ((GeeIterable*) result_array);
			while (gee_iterator_next (_result_item_it)) {
				GtkamlImplicitsParameter* result_item;
				result_item = (GtkamlImplicitsParameter*) gee_iterator_get (_result_item_it);
				if (result_item->default_value != NULL) {
				}
				/*stderr.printf ("default value for %s=<%s>\n", result_item.name, result_item.default_value);*/
				gee_collection_add ((GeeCollection*) result, result_item);
				(result_item == NULL) ? NULL : (result_item = (g_object_unref (result_item), NULL));
			}
			(_result_item_it == NULL) ? NULL : (_result_item_it = (gee_collection_object_unref (_result_item_it), NULL));
		}
	} else {
		{
			GeeList* _tmp4;
			GeeIterator* _tmp5;
			GeeIterator* _p_it;
			_tmp4 = NULL;
			_tmp5 = NULL;
			_p_it = (_tmp5 = gee_iterable_iterator ((GeeIterable*) (_tmp4 = vala_method_get_parameters (method))), (_tmp4 == NULL) ? NULL : (_tmp4 = (gee_collection_object_unref (_tmp4), NULL)), _tmp5);
			while (gee_iterator_next (_p_it)) {
				ValaFormalParameter* p;
				p = (ValaFormalParameter*) gee_iterator_get (_p_it);
				if (!vala_formal_parameter_get_ellipsis (p)) {
					GtkamlImplicitsParameter* new_implicits_parameter;
					char* _tmp7;
					const char* _tmp6;
					char* _tmp8;
					/*hack for add_with_parameters (widget, ...)*/
					new_implicits_parameter = gtkaml_implicits_parameter_new ();
					_tmp7 = NULL;
					_tmp6 = NULL;
					new_implicits_parameter->name = (_tmp7 = (_tmp6 = vala_symbol_get_name ((ValaSymbol*) p), (_tmp6 == NULL) ? NULL : g_strdup (_tmp6)), new_implicits_parameter->name = (g_free (new_implicits_parameter->name), NULL), _tmp7);
					_tmp8 = NULL;
					new_implicits_parameter->default_value = (_tmp8 = NULL, new_implicits_parameter->default_value = (g_free (new_implicits_parameter->default_value), NULL), _tmp8);
					/*here we can go for "zero"es and "false"s*/
					gee_collection_add ((GeeCollection*) result, new_implicits_parameter);
					(new_implicits_parameter == NULL) ? NULL : (new_implicits_parameter = (g_object_unref (new_implicits_parameter), NULL));
				}
				(p == NULL) ? NULL : (p = (vala_code_node_unref (p), NULL));
			}
			(_p_it == NULL) ? NULL : (_p_it = (gee_collection_object_unref (_p_it), NULL));
		}
	}
	_tmp9 = NULL;
	return (_tmp9 = (GeeList*) result, ns = (g_free (ns), NULL), clazz = (g_free (clazz), NULL), method_name = (g_free (method_name), NULL), (result_array == NULL) ? NULL : (result_array = (gee_collection_object_unref (result_array), NULL)), _tmp9);
}


/** 
 * collects $(ns).implicits key files and provides key information from all of them
 */
GtkamlImplicitsStore* gtkaml_implicits_store_construct (GType object_type) {
	GtkamlImplicitsStore * self;
	self = g_object_newv (object_type, 0, NULL);
	return self;
}


GtkamlImplicitsStore* gtkaml_implicits_store_new (void) {
	return gtkaml_implicits_store_construct (GTKAML_TYPE_IMPLICITS_STORE);
}


static void gtkaml_implicits_store_class_init (GtkamlImplicitsStoreClass * klass) {
	gtkaml_implicits_store_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GtkamlImplicitsStorePrivate));
	G_OBJECT_CLASS (klass)->finalize = gtkaml_implicits_store_finalize;
}


static void gtkaml_implicits_store_instance_init (GtkamlImplicitsStore * self) {
	self->priv = GTKAML_IMPLICITS_STORE_GET_PRIVATE (self);
	self->priv->implicits_dirs = (GeeList*) gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_str_equal);
	self->priv->loaded_ns = (GeeMap*) gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, GEE_TYPE_LIST, (GBoxedCopyFunc) gee_collection_object_ref, gee_collection_object_unref, g_str_hash, g_str_equal, g_direct_equal);
}


static void gtkaml_implicits_store_finalize (GObject* obj) {
	GtkamlImplicitsStore * self;
	self = GTKAML_IMPLICITS_STORE (obj);
	(self->priv->implicits_dirs == NULL) ? NULL : (self->priv->implicits_dirs = (gee_collection_object_unref (self->priv->implicits_dirs), NULL));
	(self->priv->loaded_ns == NULL) ? NULL : (self->priv->loaded_ns = (gee_collection_object_unref (self->priv->loaded_ns), NULL));
	G_OBJECT_CLASS (gtkaml_implicits_store_parent_class)->finalize (obj);
}


GType gtkaml_implicits_store_get_type (void) {
	static GType gtkaml_implicits_store_type_id = 0;
	if (gtkaml_implicits_store_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (GtkamlImplicitsStoreClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gtkaml_implicits_store_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GtkamlImplicitsStore), 0, (GInstanceInitFunc) gtkaml_implicits_store_instance_init, NULL };
		gtkaml_implicits_store_type_id = g_type_register_static (G_TYPE_OBJECT, "GtkamlImplicitsStore", &g_define_type_info, 0);
	}
	return gtkaml_implicits_store_type_id;
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




