/* GtkamlAttribute.vala
 *
 * Copyright (C) 2008 Vlad Grecescu
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with main.c; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor Boston, MA 02110-1301,  USA
 *
 * Author:
 *        Vlad Grecescu (b100dian@gmail.com)
 */

#include "GtkamlAttribute.h"




struct _GtkamlAttributePrivate {
	char* _name;
	ValaSymbol* _target_type;
};

#define GTKAML_ATTRIBUTE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GTKAML_TYPE_ATTRIBUTE, GtkamlAttributePrivate))
enum  {
	GTKAML_ATTRIBUTE_DUMMY_PROPERTY,
	GTKAML_ATTRIBUTE_NAME,
	GTKAML_ATTRIBUTE_TARGET_TYPE
};
static gpointer gtkaml_attribute_parent_class = NULL;
static void gtkaml_attribute_finalize (GObject* obj);



const char* gtkaml_attribute_get_name (GtkamlAttribute* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_name;
}


void gtkaml_attribute_set_name (GtkamlAttribute* self, const char* value) {
	char* _tmp2;
	const char* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_name = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : g_strdup (_tmp1)), self->priv->_name = (g_free (self->priv->_name), NULL), _tmp2);
	g_object_notify ((GObject *) self, "name");
}


ValaSymbol* gtkaml_attribute_get_target_type (GtkamlAttribute* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_target_type;
}


void gtkaml_attribute_set_target_type (GtkamlAttribute* self, ValaSymbol* value) {
	ValaSymbol* _tmp2;
	ValaSymbol* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_target_type = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : vala_code_node_ref (_tmp1)), (self->priv->_target_type == NULL) ? NULL : (self->priv->_target_type = (vala_code_node_unref (self->priv->_target_type), NULL)), _tmp2);
	g_object_notify ((GObject *) self, "target-type");
}


static void gtkaml_attribute_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GtkamlAttribute * self;
	gpointer boxed;
	self = GTKAML_ATTRIBUTE (object);
	switch (property_id) {
		case GTKAML_ATTRIBUTE_NAME:
		g_value_set_string (value, gtkaml_attribute_get_name (self));
		break;
		case GTKAML_ATTRIBUTE_TARGET_TYPE:
		vala_value_set_code_node (value, gtkaml_attribute_get_target_type (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void gtkaml_attribute_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GtkamlAttribute * self;
	self = GTKAML_ATTRIBUTE (object);
	switch (property_id) {
		case GTKAML_ATTRIBUTE_NAME:
		gtkaml_attribute_set_name (self, g_value_get_string (value));
		break;
		case GTKAML_ATTRIBUTE_TARGET_TYPE:
		gtkaml_attribute_set_target_type (self, vala_value_get_code_node (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void gtkaml_attribute_class_init (GtkamlAttributeClass * klass) {
	gtkaml_attribute_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GtkamlAttributePrivate));
	G_OBJECT_CLASS (klass)->get_property = gtkaml_attribute_get_property;
	G_OBJECT_CLASS (klass)->set_property = gtkaml_attribute_set_property;
	G_OBJECT_CLASS (klass)->finalize = gtkaml_attribute_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GTKAML_ATTRIBUTE_NAME, g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GTKAML_ATTRIBUTE_TARGET_TYPE, vala_param_spec_code_node ("target-type", "target-type", "target-type", VALA_TYPE_SYMBOL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void gtkaml_attribute_instance_init (GtkamlAttribute * self) {
	self->priv = GTKAML_ATTRIBUTE_GET_PRIVATE (self);
}


static void gtkaml_attribute_finalize (GObject* obj) {
	GtkamlAttribute * self;
	self = GTKAML_ATTRIBUTE (obj);
	self->priv->_name = (g_free (self->priv->_name), NULL);
	(self->priv->_target_type == NULL) ? NULL : (self->priv->_target_type = (vala_code_node_unref (self->priv->_target_type), NULL));
	G_OBJECT_CLASS (gtkaml_attribute_parent_class)->finalize (obj);
}


GType gtkaml_attribute_get_type (void) {
	static GType gtkaml_attribute_type_id = 0;
	if (gtkaml_attribute_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (GtkamlAttributeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gtkaml_attribute_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GtkamlAttribute), 0, (GInstanceInitFunc) gtkaml_attribute_instance_init, NULL };
		gtkaml_attribute_type_id = g_type_register_static (G_TYPE_OBJECT, "GtkamlAttribute", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	}
	return gtkaml_attribute_type_id;
}




