/* GtkamlXmlNamespace.vala
 * 
 * Copyright (C) 2008 Vlad Grecescu
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with main.c; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor Boston, MA 02110-1301,  USA
 *
 * Author:
 *        Vlad Grecescu (b100dian@gmail.com)
 */

#ifndef __GTKAMLXMLNAMESPACE_H__
#define __GTKAMLXMLNAMESPACE_H__

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>

G_BEGIN_DECLS


#define TYPE_XML_NAMESPACE (xml_namespace_get_type ())
#define XML_NAMESPACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_XML_NAMESPACE, XmlNamespace))
#define XML_NAMESPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_XML_NAMESPACE, XmlNamespaceClass))
#define IS_XML_NAMESPACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_XML_NAMESPACE))
#define IS_XML_NAMESPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_XML_NAMESPACE))
#define XML_NAMESPACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_XML_NAMESPACE, XmlNamespaceClass))

typedef struct _XmlNamespace XmlNamespace;
typedef struct _XmlNamespaceClass XmlNamespaceClass;
typedef struct _XmlNamespacePrivate XmlNamespacePrivate;

/**
 * an xml namespace, often referred to as 'prefix'
 */
struct _XmlNamespace {
	GObject parent_instance;
	XmlNamespacePrivate * priv;
	char* prefix;
	char* URI;
};

struct _XmlNamespaceClass {
	GObjectClass parent_class;
};


XmlNamespace* xml_namespace_construct (GType object_type);
XmlNamespace* xml_namespace_new (void);
GType xml_namespace_get_type (void);


G_END_DECLS

#endif
