/* GtkamlSAXParser.vala
 * 
 * Copyright (C) 2008 Vlad Grecescu
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with main.c; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor Boston, MA 02110-1301,  USA
 *
 * Author:
 *        Vlad Grecescu (b100dian@gmail.com)
 */

#ifndef __GTKAMLSAXPARSER_H__
#define __GTKAMLSAXPARSER_H__

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <vala/valacodecontext.h>
#include <vala/valasourcefile.h>
#include <vala/valaclass.h>
#include <gee/list.h>
#include <vala/valasourcereference.h>
#include "GtkamlRootClassDefinition.h"
#include "GtkamlClassDefinition.h"

G_BEGIN_DECLS


#define GTKAML_TYPE_SAX_PARSER (gtkaml_sax_parser_get_type ())
#define GTKAML_SAX_PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTKAML_TYPE_SAX_PARSER, GtkamlSAXParser))
#define GTKAML_SAX_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GTKAML_TYPE_SAX_PARSER, GtkamlSAXParserClass))
#define GTKAML_IS_SAX_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTKAML_TYPE_SAX_PARSER))
#define GTKAML_IS_SAX_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTKAML_TYPE_SAX_PARSER))
#define GTKAML_SAX_PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GTKAML_TYPE_SAX_PARSER, GtkamlSAXParserClass))

typedef struct _GtkamlSAXParser GtkamlSAXParser;
typedef struct _GtkamlSAXParserClass GtkamlSAXParserClass;
typedef struct _GtkamlSAXParserPrivate GtkamlSAXParserPrivate;

/** this is the Flying Spaghetti Monster */
struct _GtkamlSAXParser {
	GObject parent_instance;
	GtkamlSAXParserPrivate * priv;
	void* xmlCtxt;
	char* gtkaml_prefix;
};

struct _GtkamlSAXParserClass {
	GObjectClass parent_class;
	GtkamlRootClassDefinition* (*parse) (GtkamlSAXParser* self);
};


GtkamlSAXParser* gtkaml_sax_parser_construct (GType object_type, ValaCodeContext* context, ValaSourceFile* source_file);
GtkamlSAXParser* gtkaml_sax_parser_new (ValaCodeContext* context, ValaSourceFile* source_file);
GtkamlRootClassDefinition* gtkaml_sax_parser_parse (GtkamlSAXParser* self);
void gtkaml_sax_parser_start_parsing (GtkamlSAXParser* self, const char* contents, gulong length);
void gtkaml_sax_parser_stop_parsing (GtkamlSAXParser* self);
gint gtkaml_sax_parser_column_number (GtkamlSAXParser* self);
gint gtkaml_sax_parser_line_number (GtkamlSAXParser* self);
void gtkaml_sax_parser_start_element (GtkamlSAXParser* self, const char* localname, const char* prefix, const char* URI, gint nb_namespaces, char** namespaces, gint nb_attributes, gint nb_defaulted, char** attributes);
void gtkaml_sax_parser_characters (GtkamlSAXParser* self, const char* data, gint len);
void gtkaml_sax_parser_end_element (GtkamlSAXParser* self, const char* localname, const char* prefix, const char* URI);
void gtkaml_sax_parser_cdata_block (GtkamlSAXParser* self, const char* cdata, gint len);
ValaSourceReference* gtkaml_sax_parser_create_source_reference (GtkamlSAXParser* self);
GtkamlRootClassDefinition* gtkaml_sax_parser_get_root_definition (GtkamlSAXParser* self, ValaClass* clazz, GeeList* attrs, const char* prefix);
GtkamlClassDefinition* gtkaml_sax_parser_get_child_for_container (GtkamlSAXParser* self, ValaClass* clazz, GtkamlClassDefinition* container_definition, GeeList* attrs, const char* prefix);
ValaCodeContext* gtkaml_sax_parser_get_context (GtkamlSAXParser* self);
ValaSourceFile* gtkaml_sax_parser_get_source_file (GtkamlSAXParser* self);
GType gtkaml_sax_parser_get_type (void);


G_END_DECLS

#endif
