/* GtkamlRootClassDefinition.vala
 * 
 * Copyright (C) 2008 Vlad Grecescu
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with main.c; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor Boston, MA 02110-1301,  USA
 *
 * Author:
 *        Vlad Grecescu (b100dian@gmail.com)
 */

#ifndef __GTKAMLROOTCLASSDEFINITION_H__
#define __GTKAMLROOTCLASSDEFINITION_H__

#include <glib.h>
#include <glib-object.h>
#include <gee/list.h>
#include <vala/valasourcereference.h>
#include <stdlib.h>
#include <string.h>
#include <vala/valaclass.h>
#include <gee/map.h>
#include "GtkamlClassDefinition.h"

G_BEGIN_DECLS


#define GTKAML_TYPE_ROOT_CLASS_DEFINITION (gtkaml_root_class_definition_get_type ())
#define GTKAML_ROOT_CLASS_DEFINITION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTKAML_TYPE_ROOT_CLASS_DEFINITION, GtkamlRootClassDefinition))
#define GTKAML_ROOT_CLASS_DEFINITION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GTKAML_TYPE_ROOT_CLASS_DEFINITION, GtkamlRootClassDefinitionClass))
#define GTKAML_IS_ROOT_CLASS_DEFINITION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTKAML_TYPE_ROOT_CLASS_DEFINITION))
#define GTKAML_IS_ROOT_CLASS_DEFINITION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTKAML_TYPE_ROOT_CLASS_DEFINITION))
#define GTKAML_ROOT_CLASS_DEFINITION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GTKAML_TYPE_ROOT_CLASS_DEFINITION, GtkamlRootClassDefinitionClass))

typedef struct _GtkamlRootClassDefinition GtkamlRootClassDefinition;
typedef struct _GtkamlRootClassDefinitionClass GtkamlRootClassDefinitionClass;
typedef struct _GtkamlRootClassDefinitionPrivate GtkamlRootClassDefinitionPrivate;

/** represents the definition of the root tag */
struct _GtkamlRootClassDefinition {
	GtkamlClassDefinition parent_instance;
	GtkamlRootClassDefinitionPrivate * priv;
};

struct _GtkamlRootClassDefinitionClass {
	GtkamlClassDefinitionClass parent_class;
};


GtkamlRootClassDefinition* gtkaml_root_class_definition_construct (GType object_type, ValaSourceReference* source_reference, const char* identifier, const char* base_ns, ValaClass* base_type, DefinitionScope definition_scope, GtkamlClassDefinition* parent_container);
GtkamlRootClassDefinition* gtkaml_root_class_definition_new (ValaSourceReference* source_reference, const char* identifier, const char* base_ns, ValaClass* base_type, DefinitionScope definition_scope, GtkamlClassDefinition* parent_container);
GeeMap* gtkaml_root_class_definition_get_prefixes_namespaces (GtkamlRootClassDefinition* self);
void gtkaml_root_class_definition_set_prefixes_namespaces (GtkamlRootClassDefinition* self, GeeMap* value);
const char* gtkaml_root_class_definition_get_target_name (GtkamlRootClassDefinition* self);
void gtkaml_root_class_definition_set_target_name (GtkamlRootClassDefinition* self, const char* value);
const char* gtkaml_root_class_definition_get_target_namespace (GtkamlRootClassDefinition* self);
void gtkaml_root_class_definition_set_target_namespace (GtkamlRootClassDefinition* self, const char* value);
GeeList* gtkaml_root_class_definition_get_code (GtkamlRootClassDefinition* self);
void gtkaml_root_class_definition_set_code (GtkamlRootClassDefinition* self, GeeList* value);
gint gtkaml_root_class_definition_get_original_first_code_line (GtkamlRootClassDefinition* self);
void gtkaml_root_class_definition_set_original_first_code_line (GtkamlRootClassDefinition* self, gint value);
const char* gtkaml_root_class_definition_get_implements (GtkamlRootClassDefinition* self);
void gtkaml_root_class_definition_set_implements (GtkamlRootClassDefinition* self, const char* value);
GType gtkaml_root_class_definition_get_type (void);


G_END_DECLS

#endif
