/* GtkamlImplicitsResolver.vala
 * 
 * Copyright (C) 2008 Vlad Grecescu
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with main.c; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor Boston, MA 02110-1301,  USA
 *
 * Author:
 *        Vlad Grecescu (b100dian@gmail.com)
 */

#include "GtkamlImplicitsResolver.h"
#include <gee/collection.h>
#include <vala/valareport.h>
#include <vala/valasourcereference.h>
#include <gee/arraylist.h>
#include <vala/valamethod.h>
#include <vala/valasymbol.h>
#include <vala/valaobjecttypesymbol.h>
#include <vala/valainterface.h>
#include <vala/valadatatype.h>
#include <vala/valaunresolvedtype.h>
#include <vala/valaunresolvedsymbol.h>
#include <vala/valamember.h>
#include <vala/valascope.h>
#include <vala/valanamespace.h>
#include <vala/valacreationmethod.h>
#include "GtkamlReferenceClassDefinition.h"
#include "GtkamlAttribute.h"
#include "GtkamlComplexAttribute.h"
#include "GtkamlMethod.h"
#include "GtkamlSimpleAttribute.h"
#include "GtkamlMethodMatcher.h"




struct _GtkamlImplicitsResolverPrivate {
	GtkamlImplicitsStore* _implicits_store;
	ValaCodeContext* _context;
};

#define GTKAML_IMPLICITS_RESOLVER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GTKAML_TYPE_IMPLICITS_RESOLVER, GtkamlImplicitsResolverPrivate))
enum  {
	GTKAML_IMPLICITS_RESOLVER_DUMMY_PROPERTY,
	GTKAML_IMPLICITS_RESOLVER_IMPLICITS_STORE,
	GTKAML_IMPLICITS_RESOLVER_CONTEXT
};
static void gtkaml_implicits_resolver_determine_add_method (GtkamlImplicitsResolver* self, GtkamlClassDefinition* child_definition);
static void gtkaml_implicits_resolver_determine_construct_method (GtkamlImplicitsResolver* self, GtkamlClassDefinition* class_definition);
static void gtkaml_implicits_resolver_lookup_container_add_methods_for_class (GtkamlImplicitsResolver* self, const char* ns, ValaClass* container_class_implicits_entry, const char* ns2, ValaObjectTypeSymbol* container_class_holding_methods, GeeList* methods);
static char* gtkaml_implicits_resolver_get_unresolved_type_ns (GtkamlImplicitsResolver* self, ValaUnresolvedType* dt);
static void gtkaml_implicits_resolver_determine_attribute_types (GtkamlImplicitsResolver* self, GtkamlClassDefinition* class_definition);
static ValaMember* gtkaml_implicits_resolver_member_lookup_inherited (GtkamlImplicitsResolver* self, ValaClass* clazz, const char* member);
static ValaObjectTypeSymbol* gtkaml_implicits_resolver_lookup_class (GtkamlImplicitsResolver* self, const char* xmlNamespace, const char* name);
static GeeList* gtkaml_implicits_resolver_lookup_constructors (GtkamlImplicitsResolver* self, ValaClass* clazz);
static void gtkaml_implicits_resolver_set_implicits_store (GtkamlImplicitsResolver* self, GtkamlImplicitsStore* value);
static void gtkaml_implicits_resolver_set_context (GtkamlImplicitsResolver* self, ValaCodeContext* value);
static gpointer gtkaml_implicits_resolver_parent_class = NULL;
static void gtkaml_implicits_resolver_finalize (GObject* obj);
static int _vala_strcmp0 (const char * str1, const char * str2);



GtkamlImplicitsResolver* gtkaml_implicits_resolver_construct (GType object_type, ValaCodeContext* context, GtkamlImplicitsStore* implicits_store) {
	GParameter * __params;
	GParameter * __params_it;
	GtkamlImplicitsResolver * self;
	g_return_val_if_fail (context != NULL, NULL);
	g_return_val_if_fail (implicits_store != NULL, NULL);
	__params = g_new0 (GParameter, 1);
	__params_it = __params;
	__params_it->name = "implicits-store";
	g_value_init (&__params_it->value, GTKAML_TYPE_IMPLICITS_STORE);
	g_value_set_object (&__params_it->value, implicits_store);
	__params_it++;
	self = g_object_newv (object_type, __params_it - __params, __params);
	gtkaml_implicits_resolver_set_context (self, context);
	while (__params_it > __params) {
		--__params_it;
		g_value_unset (&__params_it->value);
	}
	g_free (__params);
	return self;
}


GtkamlImplicitsResolver* gtkaml_implicits_resolver_new (ValaCodeContext* context, GtkamlImplicitsStore* implicits_store) {
	return gtkaml_implicits_resolver_construct (GTKAML_TYPE_IMPLICITS_RESOLVER, context, implicits_store);
}


void gtkaml_implicits_resolver_resolve (GtkamlImplicitsResolver* self, GtkamlClassDefinition* class_definition) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (class_definition != NULL);
	/*determine which constructor shall we use
	references don't have to be constructed*/
	if (!(GTKAML_IS_REFERENCE_CLASS_DEFINITION (class_definition))) {
		gtkaml_implicits_resolver_determine_construct_method (self, class_definition);
	}
	/*then determine the container add function, if applicable*/
	if (gtkaml_class_definition_get_parent_container (class_definition) != NULL) {
		gtkaml_implicits_resolver_determine_add_method (self, class_definition);
	}
	/*References should have no other attributes than the 'attached' ones (woa.. i learned xaml)*/
	if (GTKAML_IS_REFERENCE_CLASS_DEFINITION (class_definition) && gee_collection_get_size (((GeeCollection*) (gtkaml_class_definition_get_attrs (class_definition)))) != 0 && gtkaml_class_definition_get_parent_container (class_definition) != NULL) {
		vala_report_error (gtkaml_class_definition_get_source_reference (class_definition), "No attributes other than the container add parameters are allowed on existing widgets which are not standalone");
	}
	/*resolve the rest of the attr types*/
	gtkaml_implicits_resolver_resolve_complex_attributes (self, class_definition);
	gtkaml_implicits_resolver_determine_attribute_types (self, class_definition);
	{
		GeeList* child_collection;
		int child_it;
		child_collection = gtkaml_class_definition_get_children (class_definition);
		for (child_it = 0; child_it < gee_collection_get_size (GEE_COLLECTION (child_collection)); child_it = child_it + 1) {
			GtkamlClassDefinition* child;
			child = ((GtkamlClassDefinition*) (gee_list_get (GEE_LIST (child_collection), child_it)));
			{
				gtkaml_implicits_resolver_resolve (self, child);
				(child == NULL ? NULL : (child = (g_object_unref (child), NULL)));
			}
		}
	}
}


void gtkaml_implicits_resolver_resolve_complex_attributes (GtkamlImplicitsResolver* self, GtkamlClassDefinition* class_definition) {
	gboolean first;
	g_return_if_fail (self != NULL);
	g_return_if_fail (class_definition != NULL);
	{
		GeeList* attr_collection;
		int attr_it;
		attr_collection = gtkaml_class_definition_get_attrs (class_definition);
		for (attr_it = 0; attr_it < gee_collection_get_size (GEE_COLLECTION (attr_collection)); attr_it = attr_it + 1) {
			GtkamlAttribute* attr;
			attr = ((GtkamlAttribute*) (gee_list_get (GEE_LIST (attr_collection), attr_it)));
			{
				if (GTKAML_IS_COMPLEX_ATTRIBUTE (attr)) {
					GtkamlAttribute* _tmp0;
					_tmp0 = NULL;
					gtkaml_implicits_resolver_resolve (self, gtkaml_complex_attribute_get_complex_type (((_tmp0 = attr, (GTKAML_IS_COMPLEX_ATTRIBUTE (_tmp0) ? ((GtkamlComplexAttribute*) (_tmp0)) : NULL)))));
				}
				(attr == NULL ? NULL : (attr = (g_object_unref (attr), NULL)));
			}
		}
	}
	if (gtkaml_class_definition_get_construct_method (class_definition) != NULL && gtkaml_method_get_parameter_attributes (((GtkamlMethod*) (gtkaml_class_definition_get_construct_method (class_definition)))) != NULL) {
		{
			GeeList* attr_collection;
			int attr_it;
			attr_collection = gtkaml_method_get_parameter_attributes (((GtkamlMethod*) (gtkaml_class_definition_get_construct_method (class_definition))));
			for (attr_it = 0; attr_it < gee_collection_get_size (GEE_COLLECTION (attr_collection)); attr_it = attr_it + 1) {
				GtkamlAttribute* attr;
				attr = ((GtkamlAttribute*) (gee_list_get (GEE_LIST (attr_collection), attr_it)));
				{
					if (GTKAML_IS_COMPLEX_ATTRIBUTE (attr)) {
						GtkamlAttribute* _tmp1;
						_tmp1 = NULL;
						gtkaml_implicits_resolver_resolve (self, gtkaml_complex_attribute_get_complex_type (((_tmp1 = attr, (GTKAML_IS_COMPLEX_ATTRIBUTE (_tmp1) ? ((GtkamlComplexAttribute*) (_tmp1)) : NULL)))));
					}
					(attr == NULL ? NULL : (attr = (g_object_unref (attr), NULL)));
				}
			}
		}
	}
	first = TRUE;
	/*do not generate the first parameter of the container add child method*/
	if (gtkaml_class_definition_get_add_method (class_definition) != NULL && gtkaml_method_get_parameter_attributes (((GtkamlMethod*) (gtkaml_class_definition_get_add_method (class_definition)))) != NULL) {
		{
			GeeList* attr_collection;
			int attr_it;
			attr_collection = gtkaml_method_get_parameter_attributes (((GtkamlMethod*) (gtkaml_class_definition_get_add_method (class_definition))));
			for (attr_it = 0; attr_it < gee_collection_get_size (GEE_COLLECTION (attr_collection)); attr_it = attr_it + 1) {
				GtkamlAttribute* attr;
				attr = ((GtkamlAttribute*) (gee_list_get (GEE_LIST (attr_collection), attr_it)));
				{
					if (GTKAML_IS_COMPLEX_ATTRIBUTE (attr) && !first) {
						GtkamlAttribute* _tmp2;
						_tmp2 = NULL;
						gtkaml_implicits_resolver_resolve (self, gtkaml_complex_attribute_get_complex_type (((_tmp2 = attr, (GTKAML_IS_COMPLEX_ATTRIBUTE (_tmp2) ? ((GtkamlComplexAttribute*) (_tmp2)) : NULL)))));
					}
					first = FALSE;
					(attr == NULL ? NULL : (attr = (g_object_unref (attr), NULL)));
				}
			}
		}
	}
}


/**
 * Determines which add method of parent container would be useful
 */
static void gtkaml_implicits_resolver_determine_add_method (GtkamlImplicitsResolver* self, GtkamlClassDefinition* child_definition) {
	GeeList* adds;
	ValaMethod* determined_add;
	GtkamlAddMethod* new_method;
	GeeList* to_remove;
	GtkamlComplexAttribute* first_parameter;
	GtkamlMethodMatcher* method_matcher;
	g_return_if_fail (self != NULL);
	g_return_if_fail (child_definition != NULL);
	adds = ((GeeList*) (gee_array_list_new (VALA_TYPE_METHOD, ((GBoxedCopyFunc) (vala_code_node_ref)), vala_code_node_unref, g_direct_equal)));
	gtkaml_implicits_resolver_lookup_container_add_methods (self, gtkaml_class_definition_get_base_ns (gtkaml_class_definition_get_parent_container (child_definition)), gtkaml_class_definition_get_base_type (gtkaml_class_definition_get_parent_container (child_definition)), adds);
	determined_add = NULL;
	new_method = gtkaml_add_method_new ();
	to_remove = ((GeeList*) (gee_array_list_new (GTKAML_TYPE_ATTRIBUTE, ((GBoxedCopyFunc) (g_object_ref)), g_object_unref, g_direct_equal)));
	/*pass one: see if we find an explicitly specified add method*/
	{
		GeeList* add_collection;
		int add_it;
		add_collection = adds;
		for (add_it = 0; add_it < gee_collection_get_size (GEE_COLLECTION (add_collection)); add_it = add_it + 1) {
			ValaMethod* add;
			add = ((ValaMethod*) (gee_list_get (GEE_LIST (add_collection), add_it)));
			{
				{
					GeeList* attr_collection;
					int attr_it;
					attr_collection = gtkaml_class_definition_get_attrs (child_definition);
					for (attr_it = 0; attr_it < gee_collection_get_size (GEE_COLLECTION (attr_collection)); attr_it = attr_it + 1) {
						GtkamlAttribute* attr;
						attr = ((GtkamlAttribute*) (gee_list_get (GEE_LIST (attr_collection), attr_it)));
						{
							GtkamlAttribute* _tmp0;
							_tmp0 = NULL;
							if (GTKAML_IS_SIMPLE_ATTRIBUTE (attr) && _vala_strcmp0 (gtkaml_attribute_get_name (attr), vala_symbol_get_name (((ValaSymbol*) (add)))) == 0 && _vala_strcmp0 (gtkaml_simple_attribute_get_value (((_tmp0 = attr, (GTKAML_IS_SIMPLE_ATTRIBUTE (_tmp0) ? ((GtkamlSimpleAttribute*) (_tmp0)) : NULL)))), "true") == 0) {
								ValaMethod* _tmp2;
								ValaMethod* _tmp1;
								_tmp2 = NULL;
								_tmp1 = NULL;
								determined_add = (_tmp2 = (_tmp1 = add, (_tmp1 == NULL ? NULL : vala_code_node_ref (_tmp1))), (determined_add == NULL ? NULL : (determined_add = (vala_code_node_unref (determined_add), NULL))), _tmp2);
								gee_collection_add (((GeeCollection*) (to_remove)), attr);
								(attr == NULL ? NULL : (attr = (g_object_unref (attr), NULL)));
								break;
							}
							(attr == NULL ? NULL : (attr = (g_object_unref (attr), NULL)));
						}
					}
				}
				(add == NULL ? NULL : (add = (vala_code_node_unref (add), NULL)));
			}
		}
	}
	first_parameter = gtkaml_complex_attribute_new ("widget", child_definition);
	method_matcher = gtkaml_method_matcher_new (self->priv->_implicits_store, gtkaml_class_definition_get_parent_container (child_definition), "container add method", first_parameter);
	/*pass two: the first who matches the most parameters + warning if there are more*/
	if (determined_add == NULL) {
		ValaMethod* _tmp3;
		{
			GeeList* method_collection;
			int method_it;
			method_collection = adds;
			for (method_it = 0; method_it < gee_collection_get_size (GEE_COLLECTION (method_collection)); method_it = method_it + 1) {
				ValaMethod* method;
				method = ((ValaMethod*) (gee_list_get (GEE_LIST (method_collection), method_it)));
				{
					gtkaml_method_matcher_add_method (method_matcher, method);
					(method == NULL ? NULL : (method = (vala_code_node_unref (method), NULL)));
				}
			}
		}
		_tmp3 = NULL;
		determined_add = (_tmp3 = gtkaml_method_matcher_determine_matching_method (method_matcher), (determined_add == NULL ? NULL : (determined_add = (vala_code_node_unref (determined_add), NULL))), _tmp3);
		if (determined_add == NULL) {
			(adds == NULL ? NULL : (adds = (gee_collection_object_unref (adds), NULL)));
			(determined_add == NULL ? NULL : (determined_add = (vala_code_node_unref (determined_add), NULL)));
			(new_method == NULL ? NULL : (new_method = (g_object_unref (new_method), NULL)));
			(to_remove == NULL ? NULL : (to_remove = (gee_collection_object_unref (to_remove), NULL)));
			(first_parameter == NULL ? NULL : (first_parameter = (g_object_unref (first_parameter), NULL)));
			(method_matcher == NULL ? NULL : (method_matcher = (g_object_unref (method_matcher), NULL)));
			return;
		}
	} else {
		ValaMethod* _tmp4;
		gboolean _tmp5;
		gtkaml_method_matcher_add_method (method_matcher, determined_add);
		_tmp4 = NULL;
		if ((_tmp5 = NULL == (_tmp4 = gtkaml_method_matcher_determine_matching_method (method_matcher)), (_tmp4 == NULL ? NULL : (_tmp4 = (vala_code_node_unref (_tmp4), NULL))), _tmp5)) {
			(adds == NULL ? NULL : (adds = (gee_collection_object_unref (adds), NULL)));
			(determined_add == NULL ? NULL : (determined_add = (vala_code_node_unref (determined_add), NULL)));
			(new_method == NULL ? NULL : (new_method = (g_object_unref (new_method), NULL)));
			(to_remove == NULL ? NULL : (to_remove = (gee_collection_object_unref (to_remove), NULL)));
			(first_parameter == NULL ? NULL : (first_parameter = (g_object_unref (first_parameter), NULL)));
			(method_matcher == NULL ? NULL : (method_matcher = (g_object_unref (method_matcher), NULL)));
			return;
		}
	}
	gtkaml_method_matcher_set_method_parameters (method_matcher, ((GtkamlMethod*) (new_method)), determined_add);
	{
		GeeList* attr_collection;
		int attr_it;
		attr_collection = to_remove;
		for (attr_it = 0; attr_it < gee_collection_get_size (GEE_COLLECTION (attr_collection)); attr_it = attr_it + 1) {
			GtkamlAttribute* attr;
			attr = ((GtkamlAttribute*) (gee_list_get (GEE_LIST (attr_collection), attr_it)));
			{
				gee_collection_remove (((GeeCollection*) (gtkaml_class_definition_get_attrs (child_definition))), attr);
				(attr == NULL ? NULL : (attr = (g_object_unref (attr), NULL)));
			}
		}
	}
	gtkaml_class_definition_set_add_method (child_definition, new_method);
	(adds == NULL ? NULL : (adds = (gee_collection_object_unref (adds), NULL)));
	(determined_add == NULL ? NULL : (determined_add = (vala_code_node_unref (determined_add), NULL)));
	(new_method == NULL ? NULL : (new_method = (g_object_unref (new_method), NULL)));
	(to_remove == NULL ? NULL : (to_remove = (gee_collection_object_unref (to_remove), NULL)));
	(first_parameter == NULL ? NULL : (first_parameter = (g_object_unref (first_parameter), NULL)));
	(method_matcher == NULL ? NULL : (method_matcher = (g_object_unref (method_matcher), NULL)));
}


static void gtkaml_implicits_resolver_determine_construct_method (GtkamlImplicitsResolver* self, GtkamlClassDefinition* class_definition) {
	GeeList* constructors;
	ValaMethod* determined_constructor;
	GtkamlConstructMethod* new_method;
	GeeList* to_remove;
	GtkamlMethodMatcher* method_matcher;
	g_return_if_fail (self != NULL);
	g_return_if_fail (class_definition != NULL);
	constructors = gtkaml_implicits_resolver_lookup_constructors (self, gtkaml_class_definition_get_base_type (class_definition));
	determined_constructor = NULL;
	new_method = gtkaml_construct_method_new ();
	to_remove = ((GeeList*) (gee_array_list_new (GTKAML_TYPE_ATTRIBUTE, ((GBoxedCopyFunc) (g_object_ref)), g_object_unref, g_direct_equal)));
	/*pass one: see if we find an explicitly specified constructor*/
	{
		GeeList* constructor_collection;
		int constructor_it;
		constructor_collection = constructors;
		for (constructor_it = 0; constructor_it < gee_collection_get_size (GEE_COLLECTION (constructor_collection)); constructor_it = constructor_it + 1) {
			ValaMethod* constructor;
			constructor = ((ValaMethod*) (gee_list_get (GEE_LIST (constructor_collection), constructor_it)));
			{
				{
					GeeList* attr_collection;
					int attr_it;
					attr_collection = gtkaml_class_definition_get_attrs (class_definition);
					for (attr_it = 0; attr_it < gee_collection_get_size (GEE_COLLECTION (attr_collection)); attr_it = attr_it + 1) {
						GtkamlAttribute* attr;
						attr = ((GtkamlAttribute*) (gee_list_get (GEE_LIST (attr_collection), attr_it)));
						{
							GtkamlAttribute* _tmp0;
							_tmp0 = NULL;
							if (GTKAML_IS_SIMPLE_ATTRIBUTE (attr) && _vala_strcmp0 (gtkaml_attribute_get_name (attr), vala_symbol_get_name (((ValaSymbol*) (constructor)))) == 0 && _vala_strcmp0 (gtkaml_simple_attribute_get_value (((_tmp0 = attr, (GTKAML_IS_SIMPLE_ATTRIBUTE (_tmp0) ? ((GtkamlSimpleAttribute*) (_tmp0)) : NULL)))), "true") == 0) {
								ValaMethod* _tmp2;
								ValaMethod* _tmp1;
								_tmp2 = NULL;
								_tmp1 = NULL;
								determined_constructor = (_tmp2 = (_tmp1 = constructor, (_tmp1 == NULL ? NULL : vala_code_node_ref (_tmp1))), (determined_constructor == NULL ? NULL : (determined_constructor = (vala_code_node_unref (determined_constructor), NULL))), _tmp2);
								gee_collection_add (((GeeCollection*) (to_remove)), attr);
								(attr == NULL ? NULL : (attr = (g_object_unref (attr), NULL)));
								break;
							}
							(attr == NULL ? NULL : (attr = (g_object_unref (attr), NULL)));
						}
					}
				}
				(constructor == NULL ? NULL : (constructor = (vala_code_node_unref (constructor), NULL)));
			}
		}
	}
	method_matcher = gtkaml_method_matcher_new (self->priv->_implicits_store, class_definition, "constructor", NULL);
	/*pass two: the first who matches the most parameters + warning if there are more*/
	if (determined_constructor == NULL) {
		ValaMethod* _tmp3;
		{
			GeeList* method_collection;
			int method_it;
			method_collection = constructors;
			for (method_it = 0; method_it < gee_collection_get_size (GEE_COLLECTION (method_collection)); method_it = method_it + 1) {
				ValaMethod* method;
				method = ((ValaMethod*) (gee_list_get (GEE_LIST (method_collection), method_it)));
				{
					gtkaml_method_matcher_add_method (method_matcher, method);
					(method == NULL ? NULL : (method = (vala_code_node_unref (method), NULL)));
				}
			}
		}
		_tmp3 = NULL;
		determined_constructor = (_tmp3 = gtkaml_method_matcher_determine_matching_method (method_matcher), (determined_constructor == NULL ? NULL : (determined_constructor = (vala_code_node_unref (determined_constructor), NULL))), _tmp3);
		if (determined_constructor == NULL) {
			(constructors == NULL ? NULL : (constructors = (gee_collection_object_unref (constructors), NULL)));
			(determined_constructor == NULL ? NULL : (determined_constructor = (vala_code_node_unref (determined_constructor), NULL)));
			(new_method == NULL ? NULL : (new_method = (g_object_unref (new_method), NULL)));
			(to_remove == NULL ? NULL : (to_remove = (gee_collection_object_unref (to_remove), NULL)));
			(method_matcher == NULL ? NULL : (method_matcher = (g_object_unref (method_matcher), NULL)));
			return;
		}
	} else {
		ValaMethod* _tmp4;
		gboolean _tmp5;
		gtkaml_method_matcher_add_method (method_matcher, determined_constructor);
		_tmp4 = NULL;
		if ((_tmp5 = NULL == (_tmp4 = gtkaml_method_matcher_determine_matching_method (method_matcher)), (_tmp4 == NULL ? NULL : (_tmp4 = (vala_code_node_unref (_tmp4), NULL))), _tmp5)) {
			(constructors == NULL ? NULL : (constructors = (gee_collection_object_unref (constructors), NULL)));
			(determined_constructor == NULL ? NULL : (determined_constructor = (vala_code_node_unref (determined_constructor), NULL)));
			(new_method == NULL ? NULL : (new_method = (g_object_unref (new_method), NULL)));
			(to_remove == NULL ? NULL : (to_remove = (gee_collection_object_unref (to_remove), NULL)));
			(method_matcher == NULL ? NULL : (method_matcher = (g_object_unref (method_matcher), NULL)));
			return;
		}
	}
	gtkaml_method_matcher_set_method_parameters (method_matcher, ((GtkamlMethod*) (new_method)), determined_constructor);
	{
		GeeList* attr_collection;
		int attr_it;
		attr_collection = to_remove;
		for (attr_it = 0; attr_it < gee_collection_get_size (GEE_COLLECTION (attr_collection)); attr_it = attr_it + 1) {
			GtkamlAttribute* attr;
			attr = ((GtkamlAttribute*) (gee_list_get (GEE_LIST (attr_collection), attr_it)));
			{
				gee_collection_remove (((GeeCollection*) (gtkaml_class_definition_get_attrs (class_definition))), attr);
				(attr == NULL ? NULL : (attr = (g_object_unref (attr), NULL)));
			}
		}
	}
	gtkaml_class_definition_set_construct_method (class_definition, new_method);
	(constructors == NULL ? NULL : (constructors = (gee_collection_object_unref (constructors), NULL)));
	(determined_constructor == NULL ? NULL : (determined_constructor = (vala_code_node_unref (determined_constructor), NULL)));
	(new_method == NULL ? NULL : (new_method = (g_object_unref (new_method), NULL)));
	(to_remove == NULL ? NULL : (to_remove = (gee_collection_object_unref (to_remove), NULL)));
	(method_matcher == NULL ? NULL : (method_matcher = (g_object_unref (method_matcher), NULL)));
}


static void gtkaml_implicits_resolver_lookup_container_add_methods_for_class (GtkamlImplicitsResolver* self, const char* ns, ValaClass* container_class_implicits_entry, const char* ns2, ValaObjectTypeSymbol* container_class_holding_methods, GeeList* methods) {
	GeeList* base_types;
	GeeList* add_methods;
	g_return_if_fail (self != NULL);
	g_return_if_fail (ns != NULL);
	g_return_if_fail (container_class_implicits_entry != NULL);
	g_return_if_fail (methods != NULL);
	if (ns2 == NULL) {
		return;
	}
	base_types = NULL;
	if (VALA_IS_CLASS (container_class_holding_methods)) {
		GeeList* _tmp1;
		ValaObjectTypeSymbol* _tmp0;
		_tmp1 = NULL;
		_tmp0 = NULL;
		base_types = (_tmp1 = vala_class_get_base_types (((_tmp0 = container_class_holding_methods, (VALA_IS_CLASS (_tmp0) ? ((ValaClass*) (_tmp0)) : NULL)))), (base_types == NULL ? NULL : (base_types = (gee_collection_object_unref (base_types), NULL))), _tmp1);
	} else {
		if (VALA_IS_INTERFACE (container_class_holding_methods)) {
			GeeList* _tmp3;
			ValaObjectTypeSymbol* _tmp2;
			_tmp3 = NULL;
			_tmp2 = NULL;
			base_types = (_tmp3 = vala_interface_get_prerequisites (((_tmp2 = container_class_holding_methods, (VALA_IS_INTERFACE (_tmp2) ? ((ValaInterface*) (_tmp2)) : NULL)))), (base_types == NULL ? NULL : (base_types = (gee_collection_object_unref (base_types), NULL))), _tmp3);
		}
	}
	/*recurse over base classes - ugly ugly ugly!*/
	{
		GeeList* dt_collection;
		int dt_it;
		dt_collection = base_types;
		for (dt_it = 0; dt_it < gee_collection_get_size (GEE_COLLECTION (dt_collection)); dt_it = dt_it + 1) {
			ValaDataType* dt;
			dt = ((ValaDataType*) (gee_list_get (GEE_LIST (dt_collection), dt_it)));
			{
				if (VALA_IS_UNRESOLVED_TYPE (dt)) {
					ValaDataType* _tmp4;
					char* utns;
					ValaDataType* _tmp5;
					ValaObjectTypeSymbol* c;
					_tmp4 = NULL;
					utns = gtkaml_implicits_resolver_get_unresolved_type_ns (self, (_tmp4 = dt, (VALA_IS_UNRESOLVED_TYPE (_tmp4) ? ((ValaUnresolvedType*) (_tmp4)) : NULL)));
					if (utns == NULL) {
						utns = (g_free (utns), NULL);
						(dt == NULL ? NULL : (dt = (vala_code_node_unref (dt), NULL)));
						continue;
					}
					_tmp5 = NULL;
					c = gtkaml_implicits_resolver_lookup_class (self, utns, vala_symbol_get_name (((ValaSymbol*) (vala_unresolved_type_get_unresolved_symbol (((_tmp5 = dt, (VALA_IS_UNRESOLVED_TYPE (_tmp5) ? ((ValaUnresolvedType*) (_tmp5)) : NULL))))))));
					if (c != NULL) {
						gtkaml_implicits_resolver_lookup_container_add_methods_for_class (self, ns, container_class_implicits_entry, utns, c, methods);
					}
					utns = (g_free (utns), NULL);
					(c == NULL ? NULL : (c = (vala_code_node_unref (c), NULL)));
				}
				(dt == NULL ? NULL : (dt = (vala_code_node_unref (dt), NULL)));
			}
		}
	}
	add_methods = gtkaml_implicits_store_get_adds (self->priv->_implicits_store, ns, vala_symbol_get_name (((ValaSymbol*) (container_class_implicits_entry))));
	if (gee_collection_get_size (((GeeCollection*) (add_methods))) != 0) {
		{
			GeeList* add_method_collection;
			int add_method_it;
			add_method_collection = add_methods;
			for (add_method_it = 0; add_method_it < gee_collection_get_size (GEE_COLLECTION (add_method_collection)); add_method_it = add_method_it + 1) {
				char* add_method;
				add_method = ((char*) (gee_list_get (GEE_LIST (add_method_collection), add_method_it)));
				{
					{
						GeeList* method_collection;
						int method_it;
						method_collection = vala_object_type_symbol_get_methods (container_class_holding_methods);
						for (method_it = 0; method_it < gee_collection_get_size (GEE_COLLECTION (method_collection)); method_it = method_it + 1) {
							ValaMethod* method;
							method = ((ValaMethod*) (gee_list_get (GEE_LIST (method_collection), method_it)));
							{
								if (_vala_strcmp0 (vala_symbol_get_name (((ValaSymbol*) (method))), add_method) == 0) {
									gee_collection_add (((GeeCollection*) (methods)), method);
									/*stderr.printf ("Found direct add method '%s.%s' for %s, we now have %d\n", container_class_holding_methods.name, method.name, container_class_implicits_entry.name, methods.size);*/
									(method == NULL ? NULL : (method = (vala_code_node_unref (method), NULL)));
									break;
								}
								(method == NULL ? NULL : (method = (vala_code_node_unref (method), NULL)));
							}
						}
						(method_collection == NULL ? NULL : (method_collection = (gee_collection_object_unref (method_collection), NULL)));
					}
					add_method = (g_free (add_method), NULL);
				}
			}
		}
	}
	(base_types == NULL ? NULL : (base_types = (gee_collection_object_unref (base_types), NULL)));
	(add_methods == NULL ? NULL : (add_methods = (gee_collection_object_unref (add_methods), NULL)));
}


void gtkaml_implicits_resolver_lookup_container_add_methods (GtkamlImplicitsResolver* self, const char* ns, ValaClass* container_class, GeeList* methods) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (methods != NULL);
	/*FIXME workaround to stop recursion at TypeInstance and Object*/
	if (NULL == ns) {
		return;
	}
	/*first recurse over class hierarchy*/
	gtkaml_implicits_resolver_lookup_container_add_methods_for_class (self, ns, container_class, ns, ((ValaObjectTypeSymbol*) (container_class)), methods);
	/*then recurse over implicits definitions*/
	{
		GeeList* dt_collection;
		int dt_it;
		dt_collection = vala_class_get_base_types (container_class);
		for (dt_it = 0; dt_it < gee_collection_get_size (GEE_COLLECTION (dt_collection)); dt_it = dt_it + 1) {
			ValaDataType* dt;
			dt = ((ValaDataType*) (gee_list_get (GEE_LIST (dt_collection), dt_it)));
			{
				if (VALA_IS_UNRESOLVED_TYPE (dt)) {
					ValaDataType* _tmp0;
					char* utns;
					ValaDataType* _tmp1;
					ValaObjectTypeSymbol* _tmp2;
					ValaClass* c;
					_tmp0 = NULL;
					utns = gtkaml_implicits_resolver_get_unresolved_type_ns (self, (_tmp0 = dt, (VALA_IS_UNRESOLVED_TYPE (_tmp0) ? ((ValaUnresolvedType*) (_tmp0)) : NULL)));
					if (utns == NULL) {
						utns = (g_free (utns), NULL);
						(dt == NULL ? NULL : (dt = (vala_code_node_unref (dt), NULL)));
						continue;
					}
					_tmp1 = NULL;
					_tmp2 = NULL;
					c = (_tmp2 = gtkaml_implicits_resolver_lookup_class (self, utns, vala_symbol_get_name (((ValaSymbol*) (vala_unresolved_type_get_unresolved_symbol (((_tmp1 = dt, (VALA_IS_UNRESOLVED_TYPE (_tmp1) ? ((ValaUnresolvedType*) (_tmp1)) : NULL)))))))), (VALA_IS_CLASS (_tmp2) ? ((ValaClass*) (_tmp2)) : NULL));
					if (c != NULL) {
						/*over inherited implicits definitions*/
						gtkaml_implicits_resolver_lookup_container_add_methods (self, utns, c, methods);
						utns = (g_free (utns), NULL);
						(c == NULL ? NULL : (c = (vala_code_node_unref (c), NULL)));
						(dt == NULL ? NULL : (dt = (vala_code_node_unref (dt), NULL)));
						break;
					}
					utns = (g_free (utns), NULL);
					(c == NULL ? NULL : (c = (vala_code_node_unref (c), NULL)));
				}
				(dt == NULL ? NULL : (dt = (vala_code_node_unref (dt), NULL)));
			}
		}
		(dt_collection == NULL ? NULL : (dt_collection = (gee_collection_object_unref (dt_collection), NULL)));
	}
}


static char* gtkaml_implicits_resolver_get_unresolved_type_ns (GtkamlImplicitsResolver* self, ValaUnresolvedType* dt) {
	const char* _tmp1;
	g_return_val_if_fail (self != NULL, NULL);
	if (vala_unresolved_symbol_get_inner (vala_unresolved_type_get_unresolved_symbol (dt)) == NULL) {
		return NULL;
	}
	_tmp1 = NULL;
	return (_tmp1 = vala_symbol_get_name (((ValaSymbol*) (vala_unresolved_symbol_get_inner (vala_unresolved_type_get_unresolved_symbol (dt))))), (_tmp1 == NULL ? NULL : g_strdup (_tmp1)));
}


static void gtkaml_implicits_resolver_determine_attribute_types (GtkamlImplicitsResolver* self, GtkamlClassDefinition* class_definition) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (class_definition != NULL);
	{
		GeeList* attr_collection;
		int attr_it;
		attr_collection = gtkaml_class_definition_get_attrs (class_definition);
		for (attr_it = 0; attr_it < gee_collection_get_size (GEE_COLLECTION (attr_collection)); attr_it = attr_it + 1) {
			GtkamlAttribute* attr;
			attr = ((GtkamlAttribute*) (gee_list_get (GEE_LIST (attr_collection), attr_it)));
			{
				ValaMember* _tmp0;
				_tmp0 = NULL;
				gtkaml_attribute_set_target_type (attr, ((ValaSymbol*) ((_tmp0 = gtkaml_implicits_resolver_member_lookup_inherited (self, gtkaml_class_definition_get_base_type (class_definition), gtkaml_attribute_get_name (attr))))));
				(_tmp0 == NULL ? NULL : (_tmp0 = (vala_code_node_unref (_tmp0), NULL)));
				if (gtkaml_attribute_get_target_type (attr) == NULL) {
					char* _tmp1;
					_tmp1 = NULL;
					vala_report_error (gtkaml_class_definition_get_source_reference (class_definition), (_tmp1 = g_strdup_printf ("Cannot find member %s of class %s\n", gtkaml_attribute_get_name (attr), gtkaml_class_definition_get_base_full_name (class_definition))));
					_tmp1 = (g_free (_tmp1), NULL);
				}
				(attr == NULL ? NULL : (attr = (g_object_unref (attr), NULL)));
			}
		}
	}
}


static ValaMember* gtkaml_implicits_resolver_member_lookup_inherited (GtkamlImplicitsResolver* self, ValaClass* clazz, const char* member) {
	ValaSymbol* _tmp0;
	ValaMember* result;
	ValaMember* _tmp13;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (clazz != NULL, NULL);
	g_return_val_if_fail (member != NULL, NULL);
	_tmp0 = NULL;
	result = (_tmp0 = vala_scope_lookup (vala_symbol_get_scope (((ValaSymbol*) (clazz))), member), (VALA_IS_MEMBER (_tmp0) ? ((ValaMember*) (_tmp0)) : NULL));
	if (result != NULL) {
		return result;
	}
	{
		GeeList* dt_collection;
		int dt_it;
		dt_collection = vala_class_get_base_types (clazz);
		for (dt_it = 0; dt_it < gee_collection_get_size (GEE_COLLECTION (dt_collection)); dt_it = dt_it + 1) {
			ValaDataType* dt;
			dt = ((ValaDataType*) (gee_list_get (GEE_LIST (dt_collection), dt_it)));
			{
				if (VALA_IS_UNRESOLVED_TYPE (dt)) {
					const char* _tmp3;
					ValaDataType* _tmp2;
					char* name;
					char* ns;
					ValaDataType* _tmp4;
					ValaObjectTypeSymbol* _tmp9;
					ValaClass* clazz;
					ValaMember* _tmp11;
					ValaMember* _tmp10;
					_tmp3 = NULL;
					_tmp2 = NULL;
					name = (_tmp3 = vala_symbol_get_name (((ValaSymbol*) (vala_unresolved_type_get_unresolved_symbol (((_tmp2 = dt, (VALA_IS_UNRESOLVED_TYPE (_tmp2) ? ((ValaUnresolvedType*) (_tmp2)) : NULL))))))), (_tmp3 == NULL ? NULL : g_strdup (_tmp3)));
					ns = NULL;
					_tmp4 = NULL;
					if (vala_unresolved_symbol_get_inner (vala_unresolved_type_get_unresolved_symbol (((_tmp4 = dt, (VALA_IS_UNRESOLVED_TYPE (_tmp4) ? ((ValaUnresolvedType*) (_tmp4)) : NULL))))) != NULL) {
						char* _tmp7;
						const char* _tmp6;
						ValaDataType* _tmp5;
						_tmp7 = NULL;
						_tmp6 = NULL;
						_tmp5 = NULL;
						ns = (_tmp7 = (_tmp6 = vala_symbol_get_name (((ValaSymbol*) (vala_unresolved_symbol_get_inner (vala_unresolved_type_get_unresolved_symbol (((_tmp5 = dt, (VALA_IS_UNRESOLVED_TYPE (_tmp5) ? ((ValaUnresolvedType*) (_tmp5)) : NULL)))))))), (_tmp6 == NULL ? NULL : g_strdup (_tmp6))), (ns = (g_free (ns), NULL)), _tmp7);
					} else {
						char* _tmp8;
						_tmp8 = NULL;
						ns = (_tmp8 = NULL, (ns = (g_free (ns), NULL)), _tmp8);
					}
					_tmp9 = NULL;
					clazz = (_tmp9 = gtkaml_implicits_resolver_lookup_class (self, ns, name), (VALA_IS_CLASS (_tmp9) ? ((ValaClass*) (_tmp9)) : NULL));
					_tmp11 = NULL;
					_tmp10 = NULL;
					if (clazz != NULL && (NULL != (result = (_tmp11 = (_tmp10 = gtkaml_implicits_resolver_member_lookup_inherited (self, clazz, member), (VALA_IS_MEMBER (_tmp10) ? ((ValaMember*) (_tmp10)) : NULL)), (result == NULL ? NULL : (result = (vala_code_node_unref (result), NULL))), _tmp11)))) {
						ValaMember* _tmp12;
						_tmp12 = NULL;
						return (_tmp12 = result, (name = (g_free (name), NULL)), (ns = (g_free (ns), NULL)), (clazz == NULL ? NULL : (clazz = (vala_code_node_unref (clazz), NULL))), (dt == NULL ? NULL : (dt = (vala_code_node_unref (dt), NULL))), (dt_collection == NULL ? NULL : (dt_collection = (gee_collection_object_unref (dt_collection), NULL))), _tmp12);
					}
					name = (g_free (name), NULL);
					ns = (g_free (ns), NULL);
					(clazz == NULL ? NULL : (clazz = (vala_code_node_unref (clazz), NULL)));
				}
				(dt == NULL ? NULL : (dt = (vala_code_node_unref (dt), NULL)));
			}
		}
		(dt_collection == NULL ? NULL : (dt_collection = (gee_collection_object_unref (dt_collection), NULL)));
	}
	_tmp13 = NULL;
	return (_tmp13 = NULL, (result == NULL ? NULL : (result = (vala_code_node_unref (result), NULL))), _tmp13);
}


static ValaObjectTypeSymbol* gtkaml_implicits_resolver_lookup_class (GtkamlImplicitsResolver* self, const char* xmlNamespace, const char* name) {
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (xmlNamespace != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	{
		GeeList* ns_collection;
		int ns_it;
		ns_collection = vala_namespace_get_namespaces (vala_code_context_get_root (self->priv->_context));
		for (ns_it = 0; ns_it < gee_collection_get_size (GEE_COLLECTION (ns_collection)); ns_it = ns_it + 1) {
			ValaNamespace* ns;
			ns = ((ValaNamespace*) (gee_list_get (GEE_LIST (ns_collection), ns_it)));
			{
				if ((vala_symbol_get_name (((ValaSymbol*) (ns))) == NULL && xmlNamespace == NULL) || _vala_strcmp0 (vala_symbol_get_name (((ValaSymbol*) (ns))), xmlNamespace) == 0) {
					ValaSymbol* s;
					s = vala_scope_lookup (vala_symbol_get_scope (((ValaSymbol*) (ns))), name);
					if (VALA_IS_OBJECT_TYPE_SYMBOL (s)) {
						ValaObjectTypeSymbol* _tmp1;
						ValaSymbol* _tmp0;
						ValaObjectTypeSymbol* _tmp2;
						_tmp1 = NULL;
						_tmp0 = NULL;
						_tmp2 = NULL;
						return (_tmp2 = (_tmp1 = (_tmp0 = s, (VALA_IS_OBJECT_TYPE_SYMBOL (_tmp0) ? ((ValaObjectTypeSymbol*) (_tmp0)) : NULL)), (_tmp1 == NULL ? NULL : vala_code_node_ref (_tmp1))), (s == NULL ? NULL : (s = (vala_code_node_unref (s), NULL))), (ns == NULL ? NULL : (ns = (vala_code_node_unref (ns), NULL))), (ns_collection == NULL ? NULL : (ns_collection = (gee_collection_object_unref (ns_collection), NULL))), _tmp2);
					}
					(s == NULL ? NULL : (s = (vala_code_node_unref (s), NULL)));
				}
				(ns == NULL ? NULL : (ns = (vala_code_node_unref (ns), NULL)));
			}
		}
		(ns_collection == NULL ? NULL : (ns_collection = (gee_collection_object_unref (ns_collection), NULL)));
	}
	return NULL;
}


static GeeList* gtkaml_implicits_resolver_lookup_constructors (GtkamlImplicitsResolver* self, ValaClass* clazz) {
	GeeArrayList* constructors;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (clazz != NULL, NULL);
	constructors = gee_array_list_new (VALA_TYPE_METHOD, ((GBoxedCopyFunc) (vala_code_node_ref)), vala_code_node_unref, g_direct_equal);
	{
		GeeList* m_collection;
		int m_it;
		m_collection = vala_object_type_symbol_get_methods (((ValaObjectTypeSymbol*) (clazz)));
		for (m_it = 0; m_it < gee_collection_get_size (GEE_COLLECTION (m_collection)); m_it = m_it + 1) {
			ValaMethod* m;
			m = ((ValaMethod*) (gee_list_get (GEE_LIST (m_collection), m_it)));
			{
				if (VALA_IS_CREATION_METHOD (m)) {
					gee_collection_add (((GeeCollection*) (constructors)), m);
				}
				(m == NULL ? NULL : (m = (vala_code_node_unref (m), NULL)));
			}
		}
		(m_collection == NULL ? NULL : (m_collection = (gee_collection_object_unref (m_collection), NULL)));
	}
	return ((GeeList*) (constructors));
}


GtkamlImplicitsStore* gtkaml_implicits_resolver_get_implicits_store (GtkamlImplicitsResolver* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_implicits_store;
}


static void gtkaml_implicits_resolver_set_implicits_store (GtkamlImplicitsResolver* self, GtkamlImplicitsStore* value) {
	GtkamlImplicitsStore* _tmp2;
	GtkamlImplicitsStore* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_implicits_store = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : g_object_ref (_tmp1))), (self->priv->_implicits_store == NULL ? NULL : (self->priv->_implicits_store = (g_object_unref (self->priv->_implicits_store), NULL))), _tmp2);
	g_object_notify (((GObject *) (self)), "implicits-store");
}


ValaCodeContext* gtkaml_implicits_resolver_get_context (GtkamlImplicitsResolver* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_context;
}


static void gtkaml_implicits_resolver_set_context (GtkamlImplicitsResolver* self, ValaCodeContext* value) {
	ValaCodeContext* _tmp2;
	ValaCodeContext* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_context = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : vala_code_context_ref (_tmp1))), (self->priv->_context == NULL ? NULL : (self->priv->_context = (vala_code_context_unref (self->priv->_context), NULL))), _tmp2);
	g_object_notify (((GObject *) (self)), "context");
}


static void gtkaml_implicits_resolver_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GtkamlImplicitsResolver * self;
	self = GTKAML_IMPLICITS_RESOLVER (object);
	switch (property_id) {
		case GTKAML_IMPLICITS_RESOLVER_IMPLICITS_STORE:
		g_value_set_object (value, gtkaml_implicits_resolver_get_implicits_store (self));
		break;
		case GTKAML_IMPLICITS_RESOLVER_CONTEXT:
		vala_value_set_code_context (value, gtkaml_implicits_resolver_get_context (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void gtkaml_implicits_resolver_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GtkamlImplicitsResolver * self;
	self = GTKAML_IMPLICITS_RESOLVER (object);
	switch (property_id) {
		case GTKAML_IMPLICITS_RESOLVER_IMPLICITS_STORE:
		gtkaml_implicits_resolver_set_implicits_store (self, g_value_get_object (value));
		break;
		case GTKAML_IMPLICITS_RESOLVER_CONTEXT:
		gtkaml_implicits_resolver_set_context (self, vala_value_get_code_context (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void gtkaml_implicits_resolver_class_init (GtkamlImplicitsResolverClass * klass) {
	gtkaml_implicits_resolver_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GtkamlImplicitsResolverPrivate));
	G_OBJECT_CLASS (klass)->get_property = gtkaml_implicits_resolver_get_property;
	G_OBJECT_CLASS (klass)->set_property = gtkaml_implicits_resolver_set_property;
	G_OBJECT_CLASS (klass)->finalize = gtkaml_implicits_resolver_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GTKAML_IMPLICITS_RESOLVER_IMPLICITS_STORE, g_param_spec_object ("implicits-store", "implicits-store", "implicits-store", GTKAML_TYPE_IMPLICITS_STORE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GTKAML_IMPLICITS_RESOLVER_CONTEXT, vala_param_spec_code_context ("context", "context", "context", VALA_TYPE_CODE_CONTEXT, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void gtkaml_implicits_resolver_instance_init (GtkamlImplicitsResolver * self) {
	self->priv = GTKAML_IMPLICITS_RESOLVER_GET_PRIVATE (self);
}


static void gtkaml_implicits_resolver_finalize (GObject* obj) {
	GtkamlImplicitsResolver * self;
	self = GTKAML_IMPLICITS_RESOLVER (obj);
	(self->priv->_implicits_store == NULL ? NULL : (self->priv->_implicits_store = (g_object_unref (self->priv->_implicits_store), NULL)));
	(self->priv->_context == NULL ? NULL : (self->priv->_context = (vala_code_context_unref (self->priv->_context), NULL)));
	G_OBJECT_CLASS (gtkaml_implicits_resolver_parent_class)->finalize (obj);
}


GType gtkaml_implicits_resolver_get_type (void) {
	static GType gtkaml_implicits_resolver_type_id = 0;
	if (gtkaml_implicits_resolver_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (GtkamlImplicitsResolverClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gtkaml_implicits_resolver_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GtkamlImplicitsResolver), 0, (GInstanceInitFunc) gtkaml_implicits_resolver_instance_init, NULL };
		gtkaml_implicits_resolver_type_id = g_type_register_static (G_TYPE_OBJECT, "GtkamlImplicitsResolver", &g_define_type_info, 0);
	}
	return gtkaml_implicits_resolver_type_id;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return (str1 != str2);
	}
	return strcmp (str1, str2);
}




