/* GtkamlStateStack.vala
 * 
 * Copyright (C) 2008 Vlad Grecescu
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with main.c; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor Boston, MA 02110-1301,  USA
 *
 * Author:
 *        Vlad Grecescu (b100dian@gmail.com)
 */

#ifndef __GTKAMLSTATESTACK_H__
#define __GTKAMLSTATESTACK_H__

#include <glib.h>
#include <glib-object.h>
#include "GtkamlState.h"

G_BEGIN_DECLS


#define GTKAML_TYPE_STATE_STACK (gtkaml_state_stack_get_type ())
#define GTKAML_STATE_STACK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTKAML_TYPE_STATE_STACK, GtkamlStateStack))
#define GTKAML_STATE_STACK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GTKAML_TYPE_STATE_STACK, GtkamlStateStackClass))
#define GTKAML_IS_STATE_STACK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTKAML_TYPE_STATE_STACK))
#define GTKAML_IS_STATE_STACK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTKAML_TYPE_STATE_STACK))
#define GTKAML_STATE_STACK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GTKAML_TYPE_STATE_STACK, GtkamlStateStackClass))

typedef struct _GtkamlStateStack GtkamlStateStack;
typedef struct _GtkamlStateStackClass GtkamlStateStackClass;
typedef struct _GtkamlStateStackPrivate GtkamlStateStackPrivate;

/** 
 * Simple, specialized, stack implementation using a Gee.List
 */
struct _GtkamlStateStack {
	GObject parent_instance;
	GtkamlStateStackPrivate * priv;
};

struct _GtkamlStateStackClass {
	GObjectClass parent_class;
};


GtkamlStateStack* gtkaml_state_stack_new (void);
void gtkaml_state_stack_push (GtkamlStateStack* self, GtkamlState* element);
GtkamlState* gtkaml_state_stack_peek (GtkamlStateStack* self, gint backtrack);
GtkamlState* gtkaml_state_stack_pop (GtkamlStateStack* self);
GType gtkaml_state_stack_get_type (void);


G_END_DECLS

#endif
