/* GtkamlMethodMatcher.vala
 * 
 * Copyright (C) 2008 Vlad Grecescu
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with main.c; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor Boston, MA 02110-1301,  USA
 *
 * Author:
 *        Vlad Grecescu (b100dian@gmail.com)
 */

#include "GtkamlMethodMatcher.h"
#include <gee/arraylist.h>
#include <gee/list.h>
#include <gee/collection.h>
#include <vala/valareport.h>
#include <vala/valasourcereference.h>
#include <vala/valasymbol.h>
#include <vala/valaformalparameter.h>
#include "GtkamlAttribute.h"
#include "GtkamlSimpleAttribute.h"




struct _GtkamlMethodMatcherPrivate {
	GtkamlClassDefinition* _class_owning_method;
	char* _wording;
	GtkamlComplexAttribute* _first_parameter;
	GtkamlImplicitsStore* _implicits_store;
	GtkamlClassDefinition* class_owning_parameters;
	GeeList* methods;
	gint min_params;
	GeeList* min_param_names;
	gint max_matches;
	ValaMethod* max_matches_method;
	gint max_matches_defaulted;
	GeeList* max_matches_method_defaulted_parameters;
	gint count_with_max_match;
};

#define GTKAML_METHOD_MATCHER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GTKAML_TYPE_METHOD_MATCHER, GtkamlMethodMatcherPrivate))
enum  {
	GTKAML_METHOD_MATCHER_DUMMY_PROPERTY,
	GTKAML_METHOD_MATCHER_CLASS_OWNING_METHOD,
	GTKAML_METHOD_MATCHER_WORDING,
	GTKAML_METHOD_MATCHER_FIRST_PARAMETER,
	GTKAML_METHOD_MATCHER_IMPLICITS_STORE
};
static void gtkaml_method_matcher_set_class_owning_method (GtkamlMethodMatcher* self, GtkamlClassDefinition* value);
static void gtkaml_method_matcher_set_wording (GtkamlMethodMatcher* self, const char* value);
static void gtkaml_method_matcher_set_first_parameter (GtkamlMethodMatcher* self, GtkamlComplexAttribute* value);
static void gtkaml_method_matcher_set_implicits_store (GtkamlMethodMatcher* self, GtkamlImplicitsStore* value);
static GObject * gtkaml_method_matcher_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static gpointer gtkaml_method_matcher_parent_class = NULL;
static void gtkaml_method_matcher_dispose (GObject * obj);
static int _vala_strcmp0 (const char * str1, const char * str2);



/**
 * @first_parameter is used to discern between add methods (first_parameter=child widget) and creation methods (first_parameter=null)
 * @wording contains a display name for the type of method
 */
GtkamlMethodMatcher* gtkaml_method_matcher_new (GtkamlImplicitsStore* implicits_store, GtkamlClassDefinition* class_owning_method, const char* wording, GtkamlComplexAttribute* first_parameter) {
	GParameter * __params;
	GParameter * __params_it;
	GtkamlMethodMatcher * self;
	g_return_val_if_fail (GTKAML_IS_IMPLICITS_STORE (implicits_store), NULL);
	g_return_val_if_fail (GTKAML_IS_CLASS_DEFINITION (class_owning_method), NULL);
	g_return_val_if_fail (wording != NULL, NULL);
	g_return_val_if_fail (first_parameter == NULL || GTKAML_IS_COMPLEX_ATTRIBUTE (first_parameter), NULL);
	__params = g_new0 (GParameter, 4);
	__params_it = __params;
	__params_it->name = "implicits-store";
	g_value_init (&__params_it->value, GTKAML_TYPE_IMPLICITS_STORE);
	g_value_set_object (&__params_it->value, implicits_store);
	__params_it++;
	__params_it->name = "class-owning-method";
	g_value_init (&__params_it->value, GTKAML_TYPE_CLASS_DEFINITION);
	g_value_set_object (&__params_it->value, class_owning_method);
	__params_it++;
	__params_it->name = "wording";
	g_value_init (&__params_it->value, G_TYPE_STRING);
	g_value_set_string (&__params_it->value, wording);
	__params_it++;
	__params_it->name = "first-parameter";
	g_value_init (&__params_it->value, GTKAML_TYPE_COMPLEX_ATTRIBUTE);
	g_value_set_object (&__params_it->value, first_parameter);
	__params_it++;
	self = g_object_newv (GTKAML_TYPE_METHOD_MATCHER, __params_it - __params, __params);
	while (__params_it > __params) {
		--__params_it;
		g_value_unset (&__params_it->value);
	}
	g_free (__params);
	return self;
}


void gtkaml_method_matcher_add_method (GtkamlMethodMatcher* self, ValaMethod* method) {
	g_return_if_fail (GTKAML_IS_METHOD_MATCHER (self));
	g_return_if_fail (VALA_IS_METHOD (method));
	gee_collection_add (GEE_COLLECTION (self->priv->methods), method);
}


ValaMethod* gtkaml_method_matcher_determine_matching_method (GtkamlMethodMatcher* self) {
	GeeList* defaulted_parameters;
	ValaMethod* _tmp20;
	ValaMethod* _tmp21;
	g_return_val_if_fail (GTKAML_IS_METHOD_MATCHER (self), NULL);
	defaulted_parameters = NULL;
	/*stderr.printf ("===%d candidates\n", methods.size);*/
	{
		GeeList* method_collection;
		int method_it;
		method_collection = self->priv->methods;
		for (method_it = 0; method_it < gee_collection_get_size (GEE_COLLECTION (method_collection)); method_it = method_it + 1) {
			ValaMethod* method;
			method = ((ValaMethod*) (gee_list_get (GEE_LIST (method_collection), method_it)));
			{
				GeeList* parameters;
				gint current_matches;
				gint current_matches_defaulted;
				GeeList* current_defaulted_parameters;
				/*stderr.printf ("CANDIDATE %s\n", method.name);*/
				parameters = gtkaml_implicits_store_determine_parameter_names_and_default_values (self->priv->_implicits_store, self->priv->_class_owning_method, method);
				current_matches = 0;
				current_matches_defaulted = 0;
				current_defaulted_parameters = GEE_LIST (gee_array_list_new (GTKAML_TYPE_IMPLICITS_PARAMETER, ((GBoxedCopyFunc) (g_object_ref)), g_object_unref, g_direct_equal));
				{
					GeeList* parameter_collection;
					int parameter_it;
					parameter_collection = parameters;
					for (parameter_it = 0; parameter_it < gee_collection_get_size (GEE_COLLECTION (parameter_collection)); parameter_it = parameter_it + 1) {
						GtkamlImplicitsParameter* parameter;
						parameter = ((GtkamlImplicitsParameter*) (gee_list_get (GEE_LIST (parameter_collection), parameter_it)));
						{
							gint flag_current_matches_modified;
							/*stderr.printf ("searching for %s =>", parameter.name); */
							flag_current_matches_modified = current_matches;
							{
								GeeList* attr_collection;
								int attr_it;
								attr_collection = gtkaml_class_definition_get_attrs (self->priv->class_owning_parameters);
								for (attr_it = 0; attr_it < gee_collection_get_size (GEE_COLLECTION (attr_collection)); attr_it = attr_it + 1) {
									GtkamlAttribute* attr;
									attr = ((GtkamlAttribute*) (gee_list_get (GEE_LIST (attr_collection), attr_it)));
									{
										if (_vala_strcmp0 (parameter->name, gtkaml_attribute_get_name (attr)) == 0) {
											current_matches++;
											/*stderr.printf (" .. explicit\n");*/
											(attr == NULL ? NULL : (attr = (g_object_unref (attr), NULL)));
											break;
										}
										(attr == NULL ? NULL : (attr = (g_object_unref (attr), NULL)));
									}
								}
							}
							if (flag_current_matches_modified == current_matches) {
								if (parameter->default_value != NULL) {
									current_matches_defaulted++;
									gee_collection_add (GEE_COLLECTION (current_defaulted_parameters), parameter);
								} else {
								}
							}
							(parameter == NULL ? NULL : (parameter = (g_object_unref (parameter), NULL)));
						}
					}
				}
				/*stderr.printf (" .. default %s\n", parameter.name);
				stderr.printf (" .. not found\n");*/
				if (self->priv->_first_parameter != NULL) {
					/*child widget*/
					current_matches++;
				}
				/*full match?*/
				if (current_matches + current_matches_defaulted == gee_collection_get_size (GEE_COLLECTION (parameters))) {
					if (current_matches > self->priv->max_matches) {
						ValaMethod* _tmp1;
						ValaMethod* _tmp0;
						GeeList* _tmp3;
						GeeList* _tmp2;
						/*stderr.printf ("local maximum is %s with %d matches and %d defaulted\n", method.name, current_matches, current_matches_defaulted);*/
						self->priv->max_matches = current_matches;
						self->priv->max_matches_defaulted = current_matches_defaulted;
						_tmp1 = NULL;
						_tmp0 = NULL;
						self->priv->max_matches_method = (_tmp1 = (_tmp0 = method, (_tmp0 == NULL ? NULL : g_object_ref (_tmp0))), (self->priv->max_matches_method == NULL ? NULL : (self->priv->max_matches_method = (g_object_unref (self->priv->max_matches_method), NULL))), _tmp1);
						_tmp3 = NULL;
						_tmp2 = NULL;
						self->priv->max_matches_method_defaulted_parameters = (_tmp3 = (_tmp2 = current_defaulted_parameters, (_tmp2 == NULL ? NULL : g_object_ref (_tmp2))), (self->priv->max_matches_method_defaulted_parameters == NULL ? NULL : (self->priv->max_matches_method_defaulted_parameters = (g_object_unref (self->priv->max_matches_method_defaulted_parameters), NULL))), _tmp3);
						self->priv->count_with_max_match = 1;
					} else {
						if (current_matches == self->priv->max_matches) {
							if (self->priv->max_matches_defaulted > current_matches_defaulted) {
								ValaMethod* _tmp5;
								ValaMethod* _tmp4;
								GeeList* _tmp7;
								GeeList* _tmp6;
								/*stderr.printf ("found method with less defaulted parameters\n");*/
								self->priv->max_matches = current_matches;
								self->priv->max_matches_defaulted = current_matches_defaulted;
								_tmp5 = NULL;
								_tmp4 = NULL;
								self->priv->max_matches_method = (_tmp5 = (_tmp4 = method, (_tmp4 == NULL ? NULL : g_object_ref (_tmp4))), (self->priv->max_matches_method == NULL ? NULL : (self->priv->max_matches_method = (g_object_unref (self->priv->max_matches_method), NULL))), _tmp5);
								_tmp7 = NULL;
								_tmp6 = NULL;
								self->priv->max_matches_method_defaulted_parameters = (_tmp7 = (_tmp6 = current_defaulted_parameters, (_tmp6 == NULL ? NULL : g_object_ref (_tmp6))), (self->priv->max_matches_method_defaulted_parameters == NULL ? NULL : (self->priv->max_matches_method_defaulted_parameters = (g_object_unref (self->priv->max_matches_method_defaulted_parameters), NULL))), _tmp7);
								self->priv->count_with_max_match = 1;
							} else {
								if (self->priv->max_matches_defaulted > current_matches_defaulted) {
									self->priv->count_with_max_match++;
								} else {
								}
							}
						}
					}
				} else {
				}
				/*stderr.printf ("found method with more defaulted parameters, discarding\n");
				stderr.printf ("discarded because %d != %d\n", current_matches, parameters.size);*/
				if (gee_collection_get_size (GEE_COLLECTION (parameters)) < self->priv->min_params) {
					GeeList* _tmp9;
					GeeList* _tmp8;
					self->priv->min_params = gee_collection_get_size (GEE_COLLECTION (parameters));
					_tmp9 = NULL;
					_tmp8 = NULL;
					self->priv->min_param_names = (_tmp9 = (_tmp8 = parameters, (_tmp8 == NULL ? NULL : g_object_ref (_tmp8))), (self->priv->min_param_names == NULL ? NULL : (self->priv->min_param_names = (g_object_unref (self->priv->min_param_names), NULL))), _tmp9);
				}
				(method == NULL ? NULL : (method = (g_object_unref (method), NULL)));
				(parameters == NULL ? NULL : (parameters = (g_object_unref (parameters), NULL)));
				(current_defaulted_parameters == NULL ? NULL : (current_defaulted_parameters = (g_object_unref (current_defaulted_parameters), NULL)));
			}
		}
	}
	if (self->priv->max_matches_method == NULL) {
		ValaMethod* _tmp17;
		if (self->priv->min_param_names == NULL) {
			char* _tmp10;
			_tmp10 = NULL;
			vala_report_error (gtkaml_class_definition_get_source_reference (self->priv->_class_owning_method), (_tmp10 = g_strdup_printf ("The class %s doesn't have %ss\n", gtkaml_class_definition_get_base_full_name (self->priv->_class_owning_method), self->priv->_wording)));
			_tmp10 = (g_free (_tmp10), NULL);
		} else {
			char* message;
			gint i;
			char* _tmp16;
			message = g_strdup ("");
			i = 0;
			if (self->priv->_first_parameter != NULL) {
				i = 1;
			}
			for (; i < gee_collection_get_size (GEE_COLLECTION (self->priv->min_param_names)) - 1; i++) {
				char* _tmp13;
				char* _tmp12;
				GtkamlImplicitsParameter* _tmp11;
				_tmp13 = NULL;
				_tmp12 = NULL;
				_tmp11 = NULL;
				message = (_tmp13 = g_strconcat (message, (_tmp12 = (g_strconcat ((_tmp11 = ((GtkamlImplicitsParameter*) (gee_list_get (self->priv->min_param_names, i))))->name, ", ", NULL))), NULL), (message = (g_free (message), NULL)), _tmp13);
				_tmp12 = (g_free (_tmp12), NULL);
				(_tmp11 == NULL ? NULL : (_tmp11 = (g_object_unref (_tmp11), NULL)));
			}
			if (i < gee_collection_get_size (GEE_COLLECTION (self->priv->min_param_names))) {
				char* _tmp15;
				GtkamlImplicitsParameter* _tmp14;
				_tmp15 = NULL;
				_tmp14 = NULL;
				message = (_tmp15 = g_strconcat (message, ((_tmp14 = ((GtkamlImplicitsParameter*) (gee_list_get (self->priv->min_param_names, i))))->name), NULL), (message = (g_free (message), NULL)), _tmp15);
				(_tmp14 == NULL ? NULL : (_tmp14 = (g_object_unref (_tmp14), NULL)));
			}
			_tmp16 = NULL;
			vala_report_error (gtkaml_class_definition_get_source_reference (self->priv->class_owning_parameters), (_tmp16 = g_strdup_printf ("NO matching %s found for %s: specify at least: %s\n", self->priv->_wording, gtkaml_class_definition_get_base_full_name (self->priv->_class_owning_method), message)));
			_tmp16 = (g_free (_tmp16), NULL);
			message = (g_free (message), NULL);
		}
		_tmp17 = NULL;
		return (_tmp17 = NULL, (defaulted_parameters == NULL ? NULL : (defaulted_parameters = (g_object_unref (defaulted_parameters), NULL))), _tmp17);
	}
	if (self->priv->count_with_max_match > 1) {
	}
	/*Report.warning (class_owning_method.source_reference, "More than one %s matches your definition of %s(%s)\n".printf (wording, class_owning_method.identifier, class_owning_method.base_full_name));*/
	{
		GeeList* parameter_collection;
		int parameter_it;
		parameter_collection = self->priv->max_matches_method_defaulted_parameters;
		for (parameter_it = 0; parameter_it < gee_collection_get_size (GEE_COLLECTION (parameter_collection)); parameter_it = parameter_it + 1) {
			GtkamlImplicitsParameter* parameter;
			parameter = ((GtkamlImplicitsParameter*) (gee_list_get (GEE_LIST (parameter_collection), parameter_it)));
			{
				/*stderr.printf ("found default value for %s.%s.%s being <%s>\n", class_owning_method.base_full_name, max_matches_method.name, parameter.name, parameter.default_value);*/
				if (self->priv->_first_parameter != NULL) {
					GtkamlSimpleAttribute* _tmp18;
					_tmp18 = NULL;
					gtkaml_class_definition_add_attribute (gtkaml_complex_attribute_get_complex_type (self->priv->_first_parameter), GTKAML_ATTRIBUTE ((_tmp18 = gtkaml_simple_attribute_new (parameter->name, parameter->default_value))));
					(_tmp18 == NULL ? NULL : (_tmp18 = (g_object_unref (_tmp18), NULL)));
				} else {
					GtkamlSimpleAttribute* _tmp19;
					_tmp19 = NULL;
					gtkaml_class_definition_add_attribute (self->priv->_class_owning_method, GTKAML_ATTRIBUTE ((_tmp19 = gtkaml_simple_attribute_new (parameter->name, parameter->default_value))));
					(_tmp19 == NULL ? NULL : (_tmp19 = (g_object_unref (_tmp19), NULL)));
				}
				(parameter == NULL ? NULL : (parameter = (g_object_unref (parameter), NULL)));
			}
		}
	}
	/*stderr.printf ("selected '%s'\n", max_matches_method.name);*/
	_tmp20 = NULL;
	_tmp21 = NULL;
	return (_tmp21 = (_tmp20 = self->priv->max_matches_method, (_tmp20 == NULL ? NULL : g_object_ref (_tmp20))), (defaulted_parameters == NULL ? NULL : (defaulted_parameters = (g_object_unref (defaulted_parameters), NULL))), _tmp21);
}


void gtkaml_method_matcher_set_method_parameters (GtkamlMethodMatcher* self, GtkamlMethod* new_method, ValaMethod* determined_method) {
	GeeList* to_remove;
	GeeList* parameters;
	gint i;
	GeeCollection* method_parameters;
	g_return_if_fail (GTKAML_IS_METHOD_MATCHER (self));
	g_return_if_fail (GTKAML_IS_METHOD (new_method));
	g_return_if_fail (VALA_IS_METHOD (determined_method));
	to_remove = GEE_LIST (gee_array_list_new (GTKAML_TYPE_ATTRIBUTE, ((GBoxedCopyFunc) (g_object_ref)), g_object_unref, g_direct_equal));
	gtkaml_method_set_name (new_method, vala_symbol_get_name (VALA_SYMBOL (determined_method)));
	if (self->priv->_first_parameter != NULL) {
		gee_collection_add (GEE_COLLECTION (gtkaml_method_get_parameter_attributes (new_method)), GTKAML_ATTRIBUTE (self->priv->_first_parameter));
	}
	/*move the attributes from class definition to add method*/
	parameters = gtkaml_implicits_store_determine_parameter_names_and_default_values (self->priv->_implicits_store, self->priv->_class_owning_method, determined_method);
	{
		GeeList* parameter_collection;
		int parameter_it;
		parameter_collection = parameters;
		for (parameter_it = 0; parameter_it < gee_collection_get_size (GEE_COLLECTION (parameter_collection)); parameter_it = parameter_it + 1) {
			GtkamlImplicitsParameter* parameter;
			parameter = ((GtkamlImplicitsParameter*) (gee_list_get (GEE_LIST (parameter_collection), parameter_it)));
			{
				{
					GeeList* attr_collection;
					int attr_it;
					attr_collection = gtkaml_class_definition_get_attrs (self->priv->class_owning_parameters);
					for (attr_it = 0; attr_it < gee_collection_get_size (GEE_COLLECTION (attr_collection)); attr_it = attr_it + 1) {
						GtkamlAttribute* attr;
						attr = ((GtkamlAttribute*) (gee_list_get (GEE_LIST (attr_collection), attr_it)));
						{
							if (_vala_strcmp0 (parameter->name, gtkaml_attribute_get_name (attr)) == 0) {
								gee_collection_add (GEE_COLLECTION (gtkaml_method_get_parameter_attributes (new_method)), attr);
								gee_collection_add (GEE_COLLECTION (to_remove), attr);
								(attr == NULL ? NULL : (attr = (g_object_unref (attr), NULL)));
								break;
							}
							(attr == NULL ? NULL : (attr = (g_object_unref (attr), NULL)));
						}
					}
				}
				(parameter == NULL ? NULL : (parameter = (g_object_unref (parameter), NULL)));
			}
		}
	}
	i = 0;
	if (gee_collection_get_size (GEE_COLLECTION (parameters)) != gee_collection_get_size (GEE_COLLECTION (gtkaml_method_get_parameter_attributes (new_method)))) {
		char* message;
		char* _tmp5;
		/*stderr.printf ("failed because %d != %d", parameters.size, new_method.parameter_attributes.size + i);*/
		i = 0;
		if (self->priv->_first_parameter != NULL) {
			i = 1;
		}
		/*skip child*/
		message = g_strdup ("");
		for (; i < gee_collection_get_size (GEE_COLLECTION (parameters)) - 1; i++) {
			char* _tmp2;
			char* _tmp1;
			GtkamlImplicitsParameter* _tmp0;
			_tmp2 = NULL;
			_tmp1 = NULL;
			_tmp0 = NULL;
			message = (_tmp2 = g_strconcat (message, (_tmp1 = (g_strconcat ((_tmp0 = ((GtkamlImplicitsParameter*) (gee_list_get (parameters, i))))->name, ", ", NULL))), NULL), (message = (g_free (message), NULL)), _tmp2);
			_tmp1 = (g_free (_tmp1), NULL);
			(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
		}
		if (i < gee_collection_get_size (GEE_COLLECTION (parameters))) {
			char* _tmp4;
			GtkamlImplicitsParameter* _tmp3;
			_tmp4 = NULL;
			_tmp3 = NULL;
			message = (_tmp4 = g_strconcat (message, ((_tmp3 = ((GtkamlImplicitsParameter*) (gee_list_get (parameters, i))))->name), NULL), (message = (g_free (message), NULL)), _tmp4);
			(_tmp3 == NULL ? NULL : (_tmp3 = (g_object_unref (_tmp3), NULL)));
		}
		_tmp5 = NULL;
		vala_report_error (gtkaml_class_definition_get_source_reference (self->priv->class_owning_parameters), (_tmp5 = g_strdup_printf ("No matching %s found for %s: specify at least: %s\n", self->priv->_wording, gtkaml_class_definition_get_base_full_name (self->priv->class_owning_parameters), message)));
		_tmp5 = (g_free (_tmp5), NULL);
		message = (g_free (message), NULL);
		(to_remove == NULL ? NULL : (to_remove = (g_object_unref (to_remove), NULL)));
		(parameters == NULL ? NULL : (parameters = (g_object_unref (parameters), NULL)));
		return;
	}
	/*determine attr.target_types directly from method signature*/
	method_parameters = GEE_COLLECTION (vala_method_get_parameters (determined_method));
	i = 0;
	{
		GeeCollection* formal_parameter_collection;
		GeeIterator* formal_parameter_it;
		formal_parameter_collection = method_parameters;
		formal_parameter_it = gee_iterable_iterator (GEE_ITERABLE (formal_parameter_collection));
		while (gee_iterator_next (formal_parameter_it)) {
			ValaFormalParameter* formal_parameter;
			formal_parameter = ((ValaFormalParameter*) (gee_iterator_get (formal_parameter_it)));
			{
				if (!vala_formal_parameter_get_ellipsis (formal_parameter)) {
					GtkamlAttribute* attr;
					attr = ((GtkamlAttribute*) (gee_list_get (gtkaml_method_get_parameter_attributes (new_method), i)));
					gtkaml_attribute_set_target_type (attr, VALA_SYMBOL (formal_parameter));
					i++;
					(attr == NULL ? NULL : (attr = (g_object_unref (attr), NULL)));
				}
				(formal_parameter == NULL ? NULL : (formal_parameter = (g_object_unref (formal_parameter), NULL)));
			}
		}
		(formal_parameter_it == NULL ? NULL : (formal_parameter_it = (g_object_unref (formal_parameter_it), NULL)));
	}
	{
		GeeList* attr_collection;
		int attr_it;
		attr_collection = to_remove;
		for (attr_it = 0; attr_it < gee_collection_get_size (GEE_COLLECTION (attr_collection)); attr_it = attr_it + 1) {
			GtkamlAttribute* attr;
			attr = ((GtkamlAttribute*) (gee_list_get (GEE_LIST (attr_collection), attr_it)));
			{
				gee_collection_remove (GEE_COLLECTION (gtkaml_class_definition_get_attrs (self->priv->class_owning_parameters)), attr);
				(attr == NULL ? NULL : (attr = (g_object_unref (attr), NULL)));
			}
		}
	}
	(to_remove == NULL ? NULL : (to_remove = (g_object_unref (to_remove), NULL)));
	(parameters == NULL ? NULL : (parameters = (g_object_unref (parameters), NULL)));
	(method_parameters == NULL ? NULL : (method_parameters = (g_object_unref (method_parameters), NULL)));
}


GtkamlClassDefinition* gtkaml_method_matcher_get_class_owning_method (GtkamlMethodMatcher* self) {
	g_return_val_if_fail (GTKAML_IS_METHOD_MATCHER (self), NULL);
	return self->priv->_class_owning_method;
}


static void gtkaml_method_matcher_set_class_owning_method (GtkamlMethodMatcher* self, GtkamlClassDefinition* value) {
	GtkamlClassDefinition* _tmp2;
	GtkamlClassDefinition* _tmp1;
	g_return_if_fail (GTKAML_IS_METHOD_MATCHER (self));
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_class_owning_method = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : g_object_ref (_tmp1))), (self->priv->_class_owning_method == NULL ? NULL : (self->priv->_class_owning_method = (g_object_unref (self->priv->_class_owning_method), NULL))), _tmp2);
}


const char* gtkaml_method_matcher_get_wording (GtkamlMethodMatcher* self) {
	g_return_val_if_fail (GTKAML_IS_METHOD_MATCHER (self), NULL);
	return self->priv->_wording;
}


static void gtkaml_method_matcher_set_wording (GtkamlMethodMatcher* self, const char* value) {
	char* _tmp2;
	const char* _tmp1;
	g_return_if_fail (GTKAML_IS_METHOD_MATCHER (self));
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_wording = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : g_strdup (_tmp1))), (self->priv->_wording = (g_free (self->priv->_wording), NULL)), _tmp2);
}


GtkamlComplexAttribute* gtkaml_method_matcher_get_first_parameter (GtkamlMethodMatcher* self) {
	g_return_val_if_fail (GTKAML_IS_METHOD_MATCHER (self), NULL);
	return self->priv->_first_parameter;
}


static void gtkaml_method_matcher_set_first_parameter (GtkamlMethodMatcher* self, GtkamlComplexAttribute* value) {
	GtkamlComplexAttribute* _tmp2;
	GtkamlComplexAttribute* _tmp1;
	g_return_if_fail (GTKAML_IS_METHOD_MATCHER (self));
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_first_parameter = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : g_object_ref (_tmp1))), (self->priv->_first_parameter == NULL ? NULL : (self->priv->_first_parameter = (g_object_unref (self->priv->_first_parameter), NULL))), _tmp2);
}


GtkamlImplicitsStore* gtkaml_method_matcher_get_implicits_store (GtkamlMethodMatcher* self) {
	g_return_val_if_fail (GTKAML_IS_METHOD_MATCHER (self), NULL);
	return self->priv->_implicits_store;
}


static void gtkaml_method_matcher_set_implicits_store (GtkamlMethodMatcher* self, GtkamlImplicitsStore* value) {
	GtkamlImplicitsStore* _tmp2;
	GtkamlImplicitsStore* _tmp1;
	g_return_if_fail (GTKAML_IS_METHOD_MATCHER (self));
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_implicits_store = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : g_object_ref (_tmp1))), (self->priv->_implicits_store == NULL ? NULL : (self->priv->_implicits_store = (g_object_unref (self->priv->_implicits_store), NULL))), _tmp2);
}


static GObject * gtkaml_method_matcher_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GtkamlMethodMatcherClass * klass;
	GObjectClass * parent_class;
	GtkamlMethodMatcher * self;
	klass = GTKAML_METHOD_MATCHER_CLASS (g_type_class_peek (GTKAML_TYPE_METHOD_MATCHER));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = GTKAML_METHOD_MATCHER (obj);
	{
		if (self->priv->_first_parameter == NULL) {
			GtkamlClassDefinition* _tmp1;
			GtkamlClassDefinition* _tmp0;
			_tmp1 = NULL;
			_tmp0 = NULL;
			self->priv->class_owning_parameters = (_tmp1 = (_tmp0 = self->priv->_class_owning_method, (_tmp0 == NULL ? NULL : g_object_ref (_tmp0))), (self->priv->class_owning_parameters == NULL ? NULL : (self->priv->class_owning_parameters = (g_object_unref (self->priv->class_owning_parameters), NULL))), _tmp1);
		} else {
			GtkamlClassDefinition* _tmp3;
			GtkamlClassDefinition* _tmp2;
			_tmp3 = NULL;
			_tmp2 = NULL;
			self->priv->class_owning_parameters = (_tmp3 = (_tmp2 = gtkaml_complex_attribute_get_complex_type (self->priv->_first_parameter), (_tmp2 == NULL ? NULL : g_object_ref (_tmp2))), (self->priv->class_owning_parameters == NULL ? NULL : (self->priv->class_owning_parameters = (g_object_unref (self->priv->class_owning_parameters), NULL))), _tmp3);
		}
	}
	return obj;
}


static void gtkaml_method_matcher_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GtkamlMethodMatcher * self;
	self = GTKAML_METHOD_MATCHER (object);
	switch (property_id) {
		case GTKAML_METHOD_MATCHER_CLASS_OWNING_METHOD:
		g_value_set_object (value, gtkaml_method_matcher_get_class_owning_method (self));
		break;
		case GTKAML_METHOD_MATCHER_WORDING:
		g_value_set_string (value, gtkaml_method_matcher_get_wording (self));
		break;
		case GTKAML_METHOD_MATCHER_FIRST_PARAMETER:
		g_value_set_object (value, gtkaml_method_matcher_get_first_parameter (self));
		break;
		case GTKAML_METHOD_MATCHER_IMPLICITS_STORE:
		g_value_set_object (value, gtkaml_method_matcher_get_implicits_store (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void gtkaml_method_matcher_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GtkamlMethodMatcher * self;
	self = GTKAML_METHOD_MATCHER (object);
	switch (property_id) {
		case GTKAML_METHOD_MATCHER_CLASS_OWNING_METHOD:
		gtkaml_method_matcher_set_class_owning_method (self, g_value_get_object (value));
		break;
		case GTKAML_METHOD_MATCHER_WORDING:
		gtkaml_method_matcher_set_wording (self, g_value_get_string (value));
		break;
		case GTKAML_METHOD_MATCHER_FIRST_PARAMETER:
		gtkaml_method_matcher_set_first_parameter (self, g_value_get_object (value));
		break;
		case GTKAML_METHOD_MATCHER_IMPLICITS_STORE:
		gtkaml_method_matcher_set_implicits_store (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void gtkaml_method_matcher_class_init (GtkamlMethodMatcherClass * klass) {
	gtkaml_method_matcher_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GtkamlMethodMatcherPrivate));
	G_OBJECT_CLASS (klass)->get_property = gtkaml_method_matcher_get_property;
	G_OBJECT_CLASS (klass)->set_property = gtkaml_method_matcher_set_property;
	G_OBJECT_CLASS (klass)->constructor = gtkaml_method_matcher_constructor;
	G_OBJECT_CLASS (klass)->dispose = gtkaml_method_matcher_dispose;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GTKAML_METHOD_MATCHER_CLASS_OWNING_METHOD, g_param_spec_object ("class-owning-method", "class-owning-method", "class-owning-method", GTKAML_TYPE_CLASS_DEFINITION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GTKAML_METHOD_MATCHER_WORDING, g_param_spec_string ("wording", "wording", "wording", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GTKAML_METHOD_MATCHER_FIRST_PARAMETER, g_param_spec_object ("first-parameter", "first-parameter", "first-parameter", GTKAML_TYPE_COMPLEX_ATTRIBUTE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GTKAML_METHOD_MATCHER_IMPLICITS_STORE, g_param_spec_object ("implicits-store", "implicits-store", "implicits-store", GTKAML_TYPE_IMPLICITS_STORE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}


static void gtkaml_method_matcher_instance_init (GtkamlMethodMatcher * self) {
	self->priv = GTKAML_METHOD_MATCHER_GET_PRIVATE (self);
	self->priv->methods = GEE_LIST (gee_array_list_new (VALA_TYPE_METHOD, ((GBoxedCopyFunc) (g_object_ref)), g_object_unref, g_direct_equal));
	self->priv->min_params = 999;
	self->priv->min_param_names = NULL;
	self->priv->max_matches = -1;
	self->priv->max_matches_method = NULL;
	self->priv->max_matches_defaulted = 0;
	self->priv->max_matches_method_defaulted_parameters = NULL;
	self->priv->count_with_max_match = 0;
}


static void gtkaml_method_matcher_dispose (GObject * obj) {
	GtkamlMethodMatcher * self;
	self = GTKAML_METHOD_MATCHER (obj);
	(self->priv->_class_owning_method == NULL ? NULL : (self->priv->_class_owning_method = (g_object_unref (self->priv->_class_owning_method), NULL)));
	self->priv->_wording = (g_free (self->priv->_wording), NULL);
	(self->priv->_first_parameter == NULL ? NULL : (self->priv->_first_parameter = (g_object_unref (self->priv->_first_parameter), NULL)));
	(self->priv->_implicits_store == NULL ? NULL : (self->priv->_implicits_store = (g_object_unref (self->priv->_implicits_store), NULL)));
	(self->priv->class_owning_parameters == NULL ? NULL : (self->priv->class_owning_parameters = (g_object_unref (self->priv->class_owning_parameters), NULL)));
	(self->priv->methods == NULL ? NULL : (self->priv->methods = (g_object_unref (self->priv->methods), NULL)));
	(self->priv->min_param_names == NULL ? NULL : (self->priv->min_param_names = (g_object_unref (self->priv->min_param_names), NULL)));
	(self->priv->max_matches_method == NULL ? NULL : (self->priv->max_matches_method = (g_object_unref (self->priv->max_matches_method), NULL)));
	(self->priv->max_matches_method_defaulted_parameters == NULL ? NULL : (self->priv->max_matches_method_defaulted_parameters = (g_object_unref (self->priv->max_matches_method_defaulted_parameters), NULL)));
	G_OBJECT_CLASS (gtkaml_method_matcher_parent_class)->dispose (obj);
}


GType gtkaml_method_matcher_get_type (void) {
	static GType gtkaml_method_matcher_type_id = 0;
	if (G_UNLIKELY (gtkaml_method_matcher_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (GtkamlMethodMatcherClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gtkaml_method_matcher_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GtkamlMethodMatcher), 0, (GInstanceInitFunc) gtkaml_method_matcher_instance_init };
		gtkaml_method_matcher_type_id = g_type_register_static (G_TYPE_OBJECT, "GtkamlMethodMatcher", &g_define_type_info, 0);
	}
	return gtkaml_method_matcher_type_id;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return (str1 != str2);
	}
	return strcmp (str1, str2);
}




