/* GtkamlImplicitsStore.vala
 * 
 * Copyright (C) 2008 Vlad Grecescu
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with main.c; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor Boston, MA 02110-1301,  USA
 *
 * Author:
 *        Vlad Grecescu (b100dian@gmail.com)
 */

#ifndef __GTKAMLIMPLICITSSTORE_H__
#define __GTKAMLIMPLICITSSTORE_H__

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee/readonlylist.h>
#include <gee/list.h>
#include <vala/valamethod.h>
#include "GtkamlClassDefinition.h"

G_BEGIN_DECLS


#define GTKAML_TYPE_IMPLICITS_PARAMETER (gtkaml_implicits_parameter_get_type ())
#define GTKAML_IMPLICITS_PARAMETER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTKAML_TYPE_IMPLICITS_PARAMETER, GtkamlImplicitsParameter))
#define GTKAML_IMPLICITS_PARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GTKAML_TYPE_IMPLICITS_PARAMETER, GtkamlImplicitsParameterClass))
#define GTKAML_IS_IMPLICITS_PARAMETER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTKAML_TYPE_IMPLICITS_PARAMETER))
#define GTKAML_IS_IMPLICITS_PARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTKAML_TYPE_IMPLICITS_PARAMETER))
#define GTKAML_IMPLICITS_PARAMETER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GTKAML_TYPE_IMPLICITS_PARAMETER, GtkamlImplicitsParameterClass))

typedef struct _GtkamlImplicitsParameter GtkamlImplicitsParameter;
typedef struct _GtkamlImplicitsParameterClass GtkamlImplicitsParameterClass;
typedef struct _GtkamlImplicitsParameterPrivate GtkamlImplicitsParameterPrivate;

#define GTKAML_TYPE_IMPLICITS_STORE (gtkaml_implicits_store_get_type ())
#define GTKAML_IMPLICITS_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTKAML_TYPE_IMPLICITS_STORE, GtkamlImplicitsStore))
#define GTKAML_IMPLICITS_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GTKAML_TYPE_IMPLICITS_STORE, GtkamlImplicitsStoreClass))
#define GTKAML_IS_IMPLICITS_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTKAML_TYPE_IMPLICITS_STORE))
#define GTKAML_IS_IMPLICITS_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTKAML_TYPE_IMPLICITS_STORE))
#define GTKAML_IMPLICITS_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GTKAML_TYPE_IMPLICITS_STORE, GtkamlImplicitsStoreClass))

typedef struct _GtkamlImplicitsStore GtkamlImplicitsStore;
typedef struct _GtkamlImplicitsStoreClass GtkamlImplicitsStoreClass;
typedef struct _GtkamlImplicitsStorePrivate GtkamlImplicitsStorePrivate;

/** a method parameter as it came from an .implicits file, with its default value */
struct _GtkamlImplicitsParameter {
	GObject parent_instance;
	GtkamlImplicitsParameterPrivate * priv;
	char* name;
	char* default_value;
};

struct _GtkamlImplicitsParameterClass {
	GObjectClass parent_class;
};

/** 
 * collects $(ns).implicits key files and provides key information from all of them
 */
struct _GtkamlImplicitsStore {
	GObject parent_instance;
	GtkamlImplicitsStorePrivate * priv;
};

struct _GtkamlImplicitsStoreClass {
	GObjectClass parent_class;
};


GtkamlImplicitsParameter* gtkaml_implicits_parameter_new (void);
GType gtkaml_implicits_parameter_get_type (void);
GeeReadOnlyList* gtkaml_implicits_store_get_implicits_dirs (GtkamlImplicitsStore* self);
void gtkaml_implicits_store_add_implicits_dir (GtkamlImplicitsStore* self, const char* directory);
GeeList* gtkaml_implicits_store_get_adds (GtkamlImplicitsStore* self, const char* ns, const char* class_name);
GeeList* gtkaml_implicits_store_get_method_parameters (GtkamlImplicitsStore* self, const char* ns, const char* class_name, const char* method_name);
GeeList* gtkaml_implicits_store_determine_parameter_names_and_default_values (GtkamlImplicitsStore* self, GtkamlClassDefinition* class_definition, ValaMethod* method);
GtkamlImplicitsStore* gtkaml_implicits_store_new (void);
GType gtkaml_implicits_store_get_type (void);


G_END_DECLS

#endif
