/* GtkamlImplicitsResolver.vala
 * 
 * Copyright (C) 2008 Vlad Grecescu
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with main.c; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor Boston, MA 02110-1301,  USA
 *
 * Author:
 *        Vlad Grecescu (b100dian@gmail.com)
 */

#ifndef __GTKAMLIMPLICITSRESOLVER_H__
#define __GTKAMLIMPLICITSRESOLVER_H__

#include <glib.h>
#include <glib-object.h>
#include <vala/valacodecontext.h>
#include <stdlib.h>
#include <string.h>
#include <vala/valaclass.h>
#include <gee/list.h>
#include "GtkamlImplicitsStore.h"
#include "GtkamlClassDefinition.h"

G_BEGIN_DECLS


#define GTKAML_TYPE_IMPLICITS_RESOLVER (gtkaml_implicits_resolver_get_type ())
#define GTKAML_IMPLICITS_RESOLVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTKAML_TYPE_IMPLICITS_RESOLVER, GtkamlImplicitsResolver))
#define GTKAML_IMPLICITS_RESOLVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GTKAML_TYPE_IMPLICITS_RESOLVER, GtkamlImplicitsResolverClass))
#define GTKAML_IS_IMPLICITS_RESOLVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTKAML_TYPE_IMPLICITS_RESOLVER))
#define GTKAML_IS_IMPLICITS_RESOLVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTKAML_TYPE_IMPLICITS_RESOLVER))
#define GTKAML_IMPLICITS_RESOLVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GTKAML_TYPE_IMPLICITS_RESOLVER, GtkamlImplicitsResolverClass))

typedef struct _GtkamlImplicitsResolver GtkamlImplicitsResolver;
typedef struct _GtkamlImplicitsResolverClass GtkamlImplicitsResolverClass;
typedef struct _GtkamlImplicitsResolverPrivate GtkamlImplicitsResolverPrivate;

/** 
 * determines which constructors to use or which container add functions to use;
 * moves attributes from their ClassDefinition to the add or construct methods
 */
struct _GtkamlImplicitsResolver {
	GObject parent_instance;
	GtkamlImplicitsResolverPrivate * priv;
};

struct _GtkamlImplicitsResolverClass {
	GObjectClass parent_class;
};


GtkamlImplicitsResolver* gtkaml_implicits_resolver_new (ValaCodeContext* context, GtkamlImplicitsStore* implicits_store);
void gtkaml_implicits_resolver_resolve (GtkamlImplicitsResolver* self, GtkamlClassDefinition* class_definition);
void gtkaml_implicits_resolver_resolve_complex_attributes (GtkamlImplicitsResolver* self, GtkamlClassDefinition* class_definition);
void gtkaml_implicits_resolver_lookup_container_add_methods (GtkamlImplicitsResolver* self, const char* ns, ValaClass* container_class, GeeList* methods);
GtkamlImplicitsStore* gtkaml_implicits_resolver_get_implicits_store (GtkamlImplicitsResolver* self);
GType gtkaml_implicits_resolver_get_type (void);


G_END_DECLS

#endif
