/* GtkamlSimpleAttribute.vala
 * 
 * Copyright (C) 2008 Vlad Grecescu
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with main.c; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor Boston, MA 02110-1301,  USA
 *
 * Author:
 *        Vlad Grecescu (b100dian@gmail.com)
 */

#ifndef __GTKAMLSIMPLEATTRIBUTE_H__
#define __GTKAMLSIMPLEATTRIBUTE_H__

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include "GtkamlAttribute.h"

G_BEGIN_DECLS


#define GTKAML_TYPE_SIMPLE_ATTRIBUTE (gtkaml_simple_attribute_get_type ())
#define GTKAML_SIMPLE_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTKAML_TYPE_SIMPLE_ATTRIBUTE, GtkamlSimpleAttribute))
#define GTKAML_SIMPLE_ATTRIBUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GTKAML_TYPE_SIMPLE_ATTRIBUTE, GtkamlSimpleAttributeClass))
#define GTKAML_IS_SIMPLE_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTKAML_TYPE_SIMPLE_ATTRIBUTE))
#define GTKAML_IS_SIMPLE_ATTRIBUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTKAML_TYPE_SIMPLE_ATTRIBUTE))
#define GTKAML_SIMPLE_ATTRIBUTE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GTKAML_TYPE_SIMPLE_ATTRIBUTE, GtkamlSimpleAttributeClass))

typedef struct _GtkamlSimpleAttribute GtkamlSimpleAttribute;
typedef struct _GtkamlSimpleAttributeClass GtkamlSimpleAttributeClass;
typedef struct _GtkamlSimpleAttributePrivate GtkamlSimpleAttributePrivate;

struct _GtkamlSimpleAttribute {
	GtkamlAttribute parent_instance;
	GtkamlSimpleAttributePrivate * priv;
};

struct _GtkamlSimpleAttributeClass {
	GtkamlAttributeClass parent_class;
};


GtkamlSimpleAttribute* gtkaml_simple_attribute_new (const char* name, const char* value);
char* gtkaml_simple_attribute_get_value (GtkamlSimpleAttribute* self);
void gtkaml_simple_attribute_set_value (GtkamlSimpleAttribute* self, const char* value);
GType gtkaml_simple_attribute_get_type (void);


G_END_DECLS

#endif
