/* GtkamlReferenceClassDefinition.vala
 * 
 * Copyright (C) 2008 Vlad Grecescu
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with main.c; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor Boston, MA 02110-1301,  USA
 *
 * Author:
 *        Vlad Grecescu (b100dian@gmail.com)
 */

#include "GtkamlReferenceClassDefinition.h"
#include <gee/arraylist.h>
#include "GtkamlAttribute.h"




struct _GtkamlReferenceClassDefinitionPrivate {
	gint _dummy;
};

#define GTKAML_REFERENCE_CLASS_DEFINITION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GTKAML_TYPE_REFERENCE_CLASS_DEFINITION, GtkamlReferenceClassDefinitionPrivate))
enum  {
	GTKAML_REFERENCE_CLASS_DEFINITION_DUMMY_PROPERTY
};
static gint gtkaml_reference_class_definition_get_dummy (GtkamlReferenceClassDefinition* self);
static void gtkaml_reference_class_definition_set_dummy (GtkamlReferenceClassDefinition* self, gint value);
static gpointer gtkaml_reference_class_definition_parent_class = NULL;
static void gtkaml_reference_class_definition_dispose (GObject * obj);



GtkamlReferenceClassDefinition* gtkaml_reference_class_definition_new (ValaSourceReference* source_reference, const char* reference, const char* base_ns, ValaClass* base_type, GtkamlClassDefinition* parent_container) {
	GtkamlReferenceClassDefinition * self;
	GeeArrayList* _tmp0;
	GeeArrayList* _tmp1;
	g_return_val_if_fail (VALA_IS_SOURCE_REFERENCE (source_reference), NULL);
	g_return_val_if_fail (reference != NULL, NULL);
	g_return_val_if_fail (base_ns != NULL, NULL);
	g_return_val_if_fail (VALA_IS_CLASS (base_type), NULL);
	g_return_val_if_fail (parent_container == NULL || GTKAML_IS_CLASS_DEFINITION (parent_container), NULL);
	self = g_object_newv (GTKAML_TYPE_REFERENCE_CLASS_DEFINITION, 0, NULL);
	gtkaml_reference_class_definition_set_dummy (self, 0);
	gtkaml_class_definition_set_source_reference (GTKAML_CLASS_DEFINITION (self), source_reference);
	gtkaml_class_definition_set_base_ns (GTKAML_CLASS_DEFINITION (self), base_ns);
	gtkaml_class_definition_set_identifier (GTKAML_CLASS_DEFINITION (self), reference);
	gtkaml_class_definition_set_base_type (GTKAML_CLASS_DEFINITION (self), base_type);
	gtkaml_class_definition_set_definition_scope (GTKAML_CLASS_DEFINITION (self), 0);
	gtkaml_class_definition_set_parent_container (GTKAML_CLASS_DEFINITION (self), parent_container);
	_tmp0 = NULL;
	gtkaml_class_definition_set_attrs (GTKAML_CLASS_DEFINITION (self), GEE_LIST ((_tmp0 = gee_array_list_new (GTKAML_TYPE_ATTRIBUTE, ((GBoxedCopyFunc) g_object_ref), g_object_unref, g_direct_equal))));
	(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
	gtkaml_class_definition_set_construct_method (GTKAML_CLASS_DEFINITION (self), NULL);
	_tmp1 = NULL;
	gtkaml_class_definition_set_children (GTKAML_CLASS_DEFINITION (self), GEE_LIST ((_tmp1 = gee_array_list_new (GTKAML_TYPE_CLASS_DEFINITION, ((GBoxedCopyFunc) g_object_ref), g_object_unref, g_direct_equal))));
	(_tmp1 == NULL ? NULL : (_tmp1 = (g_object_unref (_tmp1), NULL)));
	gtkaml_class_definition_set_construct_code (GTKAML_CLASS_DEFINITION (self), NULL);
	gtkaml_class_definition_set_preconstruct_code (GTKAML_CLASS_DEFINITION (self), NULL);
	return self;
}


static gint gtkaml_reference_class_definition_get_dummy (GtkamlReferenceClassDefinition* self) {
	g_return_val_if_fail (GTKAML_IS_REFERENCE_CLASS_DEFINITION (self), 0);
	return self->priv->_dummy;
}


static void gtkaml_reference_class_definition_set_dummy (GtkamlReferenceClassDefinition* self, gint value) {
	g_return_if_fail (GTKAML_IS_REFERENCE_CLASS_DEFINITION (self));
	self->priv->_dummy = value;
}


static void gtkaml_reference_class_definition_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GtkamlReferenceClassDefinition * self;
	self = GTKAML_REFERENCE_CLASS_DEFINITION (object);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void gtkaml_reference_class_definition_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GtkamlReferenceClassDefinition * self;
	self = GTKAML_REFERENCE_CLASS_DEFINITION (object);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void gtkaml_reference_class_definition_class_init (GtkamlReferenceClassDefinitionClass * klass) {
	gtkaml_reference_class_definition_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GtkamlReferenceClassDefinitionPrivate));
	G_OBJECT_CLASS (klass)->get_property = gtkaml_reference_class_definition_get_property;
	G_OBJECT_CLASS (klass)->set_property = gtkaml_reference_class_definition_set_property;
	G_OBJECT_CLASS (klass)->dispose = gtkaml_reference_class_definition_dispose;
}


static void gtkaml_reference_class_definition_init (GtkamlReferenceClassDefinition * self) {
	self->priv = GTKAML_REFERENCE_CLASS_DEFINITION_GET_PRIVATE (self);
}


static void gtkaml_reference_class_definition_dispose (GObject * obj) {
	GtkamlReferenceClassDefinition * self;
	self = GTKAML_REFERENCE_CLASS_DEFINITION (obj);
	G_OBJECT_CLASS (gtkaml_reference_class_definition_parent_class)->dispose (obj);
}


GType gtkaml_reference_class_definition_get_type (void) {
	static GType gtkaml_reference_class_definition_type_id = 0;
	if (G_UNLIKELY (gtkaml_reference_class_definition_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (GtkamlReferenceClassDefinitionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gtkaml_reference_class_definition_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GtkamlReferenceClassDefinition), 0, (GInstanceInitFunc) gtkaml_reference_class_definition_init };
		gtkaml_reference_class_definition_type_id = g_type_register_static (GTKAML_TYPE_CLASS_DEFINITION, "GtkamlReferenceClassDefinition", &g_define_type_info, 0);
	}
	return gtkaml_reference_class_definition_type_id;
}




