/* GtkamlMethodMatcher.vala
 * 
 * Copyright (C) 2008 Vlad Grecescu
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with main.c; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor Boston, MA 02110-1301,  USA
 *
 * Author:
 *        Vlad Grecescu (b100dian@gmail.com)
 */

#ifndef __GTKAMLMETHODMATCHER_H__
#define __GTKAMLMETHODMATCHER_H__

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <vala/valamethod.h>
#include "GtkamlImplicitsStore.h"
#include "GtkamlClassDefinition.h"
#include "GtkamlComplexAttribute.h"
#include "GtkamlMethod.h"

G_BEGIN_DECLS


#define GTKAML_TYPE_METHOD_MATCHER (gtkaml_method_matcher_get_type ())
#define GTKAML_METHOD_MATCHER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTKAML_TYPE_METHOD_MATCHER, GtkamlMethodMatcher))
#define GTKAML_METHOD_MATCHER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GTKAML_TYPE_METHOD_MATCHER, GtkamlMethodMatcherClass))
#define GTKAML_IS_METHOD_MATCHER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTKAML_TYPE_METHOD_MATCHER))
#define GTKAML_IS_METHOD_MATCHER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTKAML_TYPE_METHOD_MATCHER))
#define GTKAML_METHOD_MATCHER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GTKAML_TYPE_METHOD_MATCHER, GtkamlMethodMatcherClass))

typedef struct _GtkamlMethodMatcher GtkamlMethodMatcher;
typedef struct _GtkamlMethodMatcherClass GtkamlMethodMatcherClass;
typedef struct _GtkamlMethodMatcherPrivate GtkamlMethodMatcherPrivate;

struct _GtkamlMethodMatcher {
	GObject parent_instance;
	GtkamlMethodMatcherPrivate * priv;
};

struct _GtkamlMethodMatcherClass {
	GObjectClass parent_class;
};


GtkamlMethodMatcher* gtkaml_method_matcher_new (GtkamlImplicitsStore* implicits_store, GtkamlClassDefinition* class_owning_method, const char* wording, GtkamlComplexAttribute* first_parameter);
void gtkaml_method_matcher_add_method (GtkamlMethodMatcher* self, ValaMethod* method);
ValaMethod* gtkaml_method_matcher_determine_matching_method (GtkamlMethodMatcher* self);
void gtkaml_method_matcher_set_method_parameters (GtkamlMethodMatcher* self, GtkamlMethod* new_method, ValaMethod* determined_method);
GtkamlClassDefinition* gtkaml_method_matcher_get_class_owning_method (GtkamlMethodMatcher* self);
char* gtkaml_method_matcher_get_wording (GtkamlMethodMatcher* self);
GtkamlComplexAttribute* gtkaml_method_matcher_get_first_parameter (GtkamlMethodMatcher* self);
GtkamlImplicitsStore* gtkaml_method_matcher_get_implicits_store (GtkamlMethodMatcher* self);
GType gtkaml_method_matcher_get_type (void);


G_END_DECLS

#endif
