/* GtkamlMethod.vala
 * 
 * Copyright (C) 2008 Vlad Grecescu
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with main.c; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor Boston, MA 02110-1301,  USA
 *
 * Author:
 *        Vlad Grecescu (b100dian@gmail.com)
 */

#include "GtkamlMethod.h"
#include <gee/arraylist.h>
#include "GtkamlAttribute.h"




struct _GtkamlMethodPrivate {
	char* _name;
	GeeList* _parameter_attributes;
};

#define GTKAML_METHOD_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GTKAML_TYPE_METHOD, GtkamlMethodPrivate))
enum  {
	GTKAML_METHOD_DUMMY_PROPERTY,
	GTKAML_METHOD_NAME,
	GTKAML_METHOD_PARAMETER_ATTRIBUTES
};
static GObject * gtkaml_method_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static gpointer gtkaml_method_parent_class = NULL;
static void gtkaml_method_dispose (GObject * obj);
enum  {
	GTKAML_ADD_METHOD_DUMMY_PROPERTY
};
static gpointer gtkaml_add_method_parent_class = NULL;
enum  {
	GTKAML_CONSTRUCT_METHOD_DUMMY_PROPERTY
};
static gpointer gtkaml_construct_method_parent_class = NULL;



/**
 * a constructor or an add method
 */
GtkamlMethod* gtkaml_method_new (void) {
	GtkamlMethod * self;
	self = g_object_newv (GTKAML_TYPE_METHOD, 0, NULL);
	return self;
}


char* gtkaml_method_get_name (GtkamlMethod* self) {
	g_return_val_if_fail (GTKAML_IS_METHOD (self), NULL);
	return self->priv->_name;
}


void gtkaml_method_set_name (GtkamlMethod* self, const char* value) {
	char* _tmp2;
	const char* _tmp1;
	g_return_if_fail (GTKAML_IS_METHOD (self));
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_name = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : g_strdup (_tmp1))), (self->priv->_name = (g_free (self->priv->_name), NULL)), _tmp2);
}


GeeList* gtkaml_method_get_parameter_attributes (GtkamlMethod* self) {
	g_return_val_if_fail (GTKAML_IS_METHOD (self), NULL);
	return self->priv->_parameter_attributes;
}


void gtkaml_method_set_parameter_attributes (GtkamlMethod* self, GeeList* value) {
	GeeList* _tmp2;
	GeeList* _tmp1;
	g_return_if_fail (GTKAML_IS_METHOD (self));
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_parameter_attributes = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : g_object_ref (_tmp1))), (self->priv->_parameter_attributes == NULL ? NULL : (self->priv->_parameter_attributes = (g_object_unref (self->priv->_parameter_attributes), NULL))), _tmp2);
}


static GObject * gtkaml_method_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GtkamlMethodClass * klass;
	GObjectClass * parent_class;
	GtkamlMethod * self;
	klass = GTKAML_METHOD_CLASS (g_type_class_peek (GTKAML_TYPE_METHOD));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = GTKAML_METHOD (obj);
	{
		GeeArrayList* _tmp0;
		_tmp0 = NULL;
		gtkaml_method_set_parameter_attributes (self, GEE_LIST ((_tmp0 = gee_array_list_new (GTKAML_TYPE_ATTRIBUTE, ((GBoxedCopyFunc) g_object_ref), g_object_unref, g_direct_equal))));
		(_tmp0 == NULL ? NULL : (_tmp0 = (g_object_unref (_tmp0), NULL)));
	}
	return obj;
}


static void gtkaml_method_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GtkamlMethod * self;
	self = GTKAML_METHOD (object);
	switch (property_id) {
		case GTKAML_METHOD_NAME:
		g_value_set_string (value, gtkaml_method_get_name (self));
		break;
		case GTKAML_METHOD_PARAMETER_ATTRIBUTES:
		g_value_set_object (value, gtkaml_method_get_parameter_attributes (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void gtkaml_method_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GtkamlMethod * self;
	self = GTKAML_METHOD (object);
	switch (property_id) {
		case GTKAML_METHOD_NAME:
		gtkaml_method_set_name (self, g_value_get_string (value));
		break;
		case GTKAML_METHOD_PARAMETER_ATTRIBUTES:
		gtkaml_method_set_parameter_attributes (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void gtkaml_method_class_init (GtkamlMethodClass * klass) {
	gtkaml_method_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GtkamlMethodPrivate));
	G_OBJECT_CLASS (klass)->get_property = gtkaml_method_get_property;
	G_OBJECT_CLASS (klass)->set_property = gtkaml_method_set_property;
	G_OBJECT_CLASS (klass)->constructor = gtkaml_method_constructor;
	G_OBJECT_CLASS (klass)->dispose = gtkaml_method_dispose;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GTKAML_METHOD_NAME, g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GTKAML_METHOD_PARAMETER_ATTRIBUTES, g_param_spec_object ("parameter-attributes", "parameter-attributes", "parameter-attributes", GEE_TYPE_LIST, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void gtkaml_method_init (GtkamlMethod * self) {
	self->priv = GTKAML_METHOD_GET_PRIVATE (self);
}


static void gtkaml_method_dispose (GObject * obj) {
	GtkamlMethod * self;
	self = GTKAML_METHOD (obj);
	self->priv->_name = (g_free (self->priv->_name), NULL);
	(self->priv->_parameter_attributes == NULL ? NULL : (self->priv->_parameter_attributes = (g_object_unref (self->priv->_parameter_attributes), NULL)));
	G_OBJECT_CLASS (gtkaml_method_parent_class)->dispose (obj);
}


GType gtkaml_method_get_type (void) {
	static GType gtkaml_method_type_id = 0;
	if (G_UNLIKELY (gtkaml_method_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (GtkamlMethodClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gtkaml_method_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GtkamlMethod), 0, (GInstanceInitFunc) gtkaml_method_init };
		gtkaml_method_type_id = g_type_register_static (G_TYPE_OBJECT, "GtkamlMethod", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	}
	return gtkaml_method_type_id;
}


/** useless specialization */
GtkamlAddMethod* gtkaml_add_method_new (void) {
	GtkamlAddMethod * self;
	self = g_object_newv (GTKAML_TYPE_ADD_METHOD, 0, NULL);
	return self;
}


static void gtkaml_add_method_class_init (GtkamlAddMethodClass * klass) {
	gtkaml_add_method_parent_class = g_type_class_peek_parent (klass);
}


static void gtkaml_add_method_init (GtkamlAddMethod * self) {
}


GType gtkaml_add_method_get_type (void) {
	static GType gtkaml_add_method_type_id = 0;
	if (G_UNLIKELY (gtkaml_add_method_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (GtkamlAddMethodClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gtkaml_add_method_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GtkamlAddMethod), 0, (GInstanceInitFunc) gtkaml_add_method_init };
		gtkaml_add_method_type_id = g_type_register_static (GTKAML_TYPE_METHOD, "GtkamlAddMethod", &g_define_type_info, 0);
	}
	return gtkaml_add_method_type_id;
}


/** useless specialization */
GtkamlConstructMethod* gtkaml_construct_method_new (void) {
	GtkamlConstructMethod * self;
	self = g_object_newv (GTKAML_TYPE_CONSTRUCT_METHOD, 0, NULL);
	return self;
}


static void gtkaml_construct_method_class_init (GtkamlConstructMethodClass * klass) {
	gtkaml_construct_method_parent_class = g_type_class_peek_parent (klass);
}


static void gtkaml_construct_method_init (GtkamlConstructMethod * self) {
}


GType gtkaml_construct_method_get_type (void) {
	static GType gtkaml_construct_method_type_id = 0;
	if (G_UNLIKELY (gtkaml_construct_method_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (GtkamlConstructMethodClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gtkaml_construct_method_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GtkamlConstructMethod), 0, (GInstanceInitFunc) gtkaml_construct_method_init };
		gtkaml_construct_method_type_id = g_type_register_static (GTKAML_TYPE_METHOD, "GtkamlConstructMethod", &g_define_type_info, 0);
	}
	return gtkaml_construct_method_type_id;
}




