/* GtkamlAttribute.vala
 *
 * Copyright (C) 2008 Vlad Grecescu
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with main.c; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor Boston, MA 02110-1301,  USA
 *
 * Author:
 *        Vlad Grecescu (b100dian@gmail.com)
 */

#ifndef __GTKAMLATTRIBUTE_H__
#define __GTKAMLATTRIBUTE_H__

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <vala/valasymbol.h>

G_BEGIN_DECLS


#define GTKAML_TYPE_ATTRIBUTE (gtkaml_attribute_get_type ())
#define GTKAML_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTKAML_TYPE_ATTRIBUTE, GtkamlAttribute))
#define GTKAML_ATTRIBUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GTKAML_TYPE_ATTRIBUTE, GtkamlAttributeClass))
#define GTKAML_IS_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTKAML_TYPE_ATTRIBUTE))
#define GTKAML_IS_ATTRIBUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTKAML_TYPE_ATTRIBUTE))
#define GTKAML_ATTRIBUTE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GTKAML_TYPE_ATTRIBUTE, GtkamlAttributeClass))

typedef struct _GtkamlAttribute GtkamlAttribute;
typedef struct _GtkamlAttributeClass GtkamlAttributeClass;
typedef struct _GtkamlAttributePrivate GtkamlAttributePrivate;

/**
 * A generic xml attribute with a name and a reflected Vala type
 */
struct _GtkamlAttribute {
	GObject parent_instance;
	GtkamlAttributePrivate * priv;
};

struct _GtkamlAttributeClass {
	GObjectClass parent_class;
};


GtkamlAttribute* gtkaml_attribute_new (void);
char* gtkaml_attribute_get_name (GtkamlAttribute* self);
void gtkaml_attribute_set_name (GtkamlAttribute* self, const char* value);
ValaSymbol* gtkaml_attribute_get_target_type (GtkamlAttribute* self);
void gtkaml_attribute_set_target_type (GtkamlAttribute* self, ValaSymbol* value);
GType gtkaml_attribute_get_type (void);


G_END_DECLS

#endif
