/*
 * Copyright (c) 2001-2003, Richard Eckart
 *
 * THIS FILE IS AUTOGENERATED! DO NOT EDIT!
 * This file is generated from gnet_props.ag using autogen.
 * Autogen is available at http://autogen.sourceforge.net/.
 *
 *----------------------------------------------------------------------
 * This file is part of gtk-gnutella.
 *
 *  gtk-gnutella is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  gtk-gnutella is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with gtk-gnutella; if not, write to the Free Software
 *  Foundation, Inc.:
 *      59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *----------------------------------------------------------------------
 */

#include "lib/prop.h"
#include "lib/eval.h"
#include "gnet_property.h"

/*
 * Includes specified by "uses"-statement in .ag file
 */
#include "core/sockets.h"
#include "core/bsched.h"
#include "if/core/nodes.h"

#include "lib/override.h"		/* Must be the last header included */


gboolean reading_hostfile     = FALSE;
gboolean reading_hostfile_def = FALSE;
gboolean reading_ultrafile     = FALSE;
gboolean reading_ultrafile_def = FALSE;
gboolean ancient_version     = FALSE;
gboolean ancient_version_def = FALSE;
gchar   *new_version_str     = NULL;
gchar   *new_version_str_def = NULL;
guint32  up_connections     = 32;
guint32  up_connections_def = 32;
guint32  normal_connections     = 0;
guint32  normal_connections_def = 0;
guint32  max_connections     = 40;
guint32  max_connections_def = 40;
guint32  node_leaf_count     = 0;
guint32  node_leaf_count_def = 0;
guint32  node_normal_count     = 0;
guint32  node_normal_count_def = 0;
guint32  node_ultra_count     = 0;
guint32  node_ultra_count_def = 0;
guint32  max_downloads     = 100;
guint32  max_downloads_def = 100;
guint32  max_host_downloads     = 1;
guint32  max_host_downloads_def = 1;
guint32  max_uploads     = 4;
guint32  max_uploads_def = 4;
guint32  max_uploads_ip     = 1;
guint32  max_uploads_ip_def = 1;
guint32  local_ip     = 0x00000000;
guint32  local_ip_def = 0x00000000;
guint32  current_ip_stamp     = 0;
guint32  current_ip_stamp_def = 0;
guint32  average_ip_uptime     = 0;
guint32  average_ip_uptime_def = 0;
guint32  start_stamp     = 0;
guint32  start_stamp_def = 0;
guint32  average_servent_uptime     = 0;
guint32  average_servent_uptime_def = 0;
guint32  listen_port     = 1;
guint32  listen_port_def = 1;
guint32  forced_local_ip     = 0x00000000;
guint32  forced_local_ip_def = 0x00000000;
guint32  connection_speed     = 0;
guint32  connection_speed_def = 0;
gboolean compute_connection_speed     = TRUE;
gboolean compute_connection_speed_def = TRUE;
guint32  search_max_items     = 50;
guint32  search_max_items_def = 50;
guint32  ul_usage_min_percentage     = 70;
guint32  ul_usage_min_percentage_def = 70;
guint32  download_connecting_timeout     = 60;
guint32  download_connecting_timeout_def = 60;
guint32  download_push_sent_timeout     = 60;
guint32  download_push_sent_timeout_def = 60;
guint32  download_connected_timeout     = 60;
guint32  download_connected_timeout_def = 60;
guint32  download_retry_timeout_min     = 20;
guint32  download_retry_timeout_min_def = 20;
guint32  download_retry_timeout_max     = 300;
guint32  download_retry_timeout_max_def = 300;
guint32  download_max_retries     = 50;
guint32  download_max_retries_def = 50;
guint32  download_retry_timeout_delay     = 1200;
guint32  download_retry_timeout_delay_def = 1200;
guint32  download_retry_busy_delay     = 60;
guint32  download_retry_busy_delay_def = 60;
guint32  download_retry_refused_delay     = 1800;
guint32  download_retry_refused_delay_def = 1800;
guint32  download_retry_stopped_delay     = 15;
guint32  download_retry_stopped_delay_def = 15;
guint32  download_overlap_range     = 512;
guint32  download_overlap_range_def = 512;
guint32  upload_connecting_timeout     = 60;
guint32  upload_connecting_timeout_def = 60;
guint32  upload_connected_timeout     = 180;
guint32  upload_connected_timeout_def = 180;
guint32  search_reissue_timeout     = 3600;
guint32  search_reissue_timeout_def = 3600;
guint32  ban_ratio_fds     = 25;
guint32  ban_ratio_fds_def = 25;
guint32  ban_max_fds     = 100;
guint32  ban_max_fds_def = 100;
guint32  banned_count     = 0;
guint32  banned_count_def = 0;
guint32  max_banned_fd     = 100;
guint32  max_banned_fd_def = 100;
guint32  incoming_connecting_timeout     = 30;
guint32  incoming_connecting_timeout_def = 30;
guint32  node_connecting_timeout     = 30;
guint32  node_connecting_timeout_def = 30;
guint32  node_connected_timeout     = 180;
guint32  node_connected_timeout_def = 180;
guint32  node_sendqueue_size     = 98304;
guint32  node_sendqueue_size_def = 98304;
guint32  node_tx_flowc_timeout     = 180;
guint32  node_tx_flowc_timeout_def = 180;
guint32  node_rx_flowc_ratio     = 70;
guint32  node_rx_flowc_ratio_def = 70;
guint32  max_ttl     = 4;
guint32  max_ttl_def = 4;
guint32  my_ttl     = 4;
guint32  my_ttl_def = 4;
guint32  hard_ttl_limit     = 15;
guint32  hard_ttl_limit_def = 15;
guint32  dbg     = 0;
guint32  dbg_def = 0;
guint32  lib_debug     = 0;
guint32  lib_debug_def = 0;
guint32  bitzi_debug     = 0;
guint32  bitzi_debug_def = 0;
guint32  gwc_debug     = 0;
guint32  gwc_debug_def = 0;
guint32  url_debug     = 0;
guint32  url_debug_def = 0;
guint32  dh_debug     = 0;
guint32  dh_debug_def = 0;
guint32  dq_debug     = 0;
guint32  dq_debug_def = 0;
guint32  vmsg_debug     = 0;
guint32  vmsg_debug_def = 0;
guint32  query_debug     = 0;
guint32  query_debug_def = 0;
guint32  search_debug     = 0;
guint32  search_debug_def = 0;
guint32  udp_debug     = 0;
guint32  udp_debug_def = 0;
guint32  qrp_debug     = 0;
guint32  qrp_debug_def = 0;
guint32  routing_debug     = 0;
guint32  routing_debug_def = 0;
guint32  ggep_debug     = 0;
guint32  ggep_debug_def = 0;
guint32  pcache_debug     = 0;
guint32  pcache_debug_def = 0;
guint32  hsep_debug     = 0;
guint32  hsep_debug_def = 0;
guint32  track_props     = 0;
guint32  track_props_def = 0;
gboolean stop_host_get     = FALSE;
gboolean stop_host_get_def = FALSE;
gboolean bws_in_enabled     = FALSE;
gboolean bws_in_enabled_def = FALSE;
gboolean bws_out_enabled     = FALSE;
gboolean bws_out_enabled_def = FALSE;
gboolean bws_gin_enabled     = FALSE;
gboolean bws_gin_enabled_def = FALSE;
gboolean bws_glin_enabled     = FALSE;
gboolean bws_glin_enabled_def = FALSE;
gboolean bws_gout_enabled     = FALSE;
gboolean bws_gout_enabled_def = FALSE;
gboolean bws_glout_enabled     = FALSE;
gboolean bws_glout_enabled_def = FALSE;
gboolean bw_ul_usage_enabled     = FALSE;
gboolean bw_ul_usage_enabled_def = FALSE;
gboolean bw_allow_stealing     = TRUE;
gboolean bw_allow_stealing_def = TRUE;
gboolean clear_complete_downloads     = FALSE;
gboolean clear_complete_downloads_def = FALSE;
gboolean clear_failed_downloads     = FALSE;
gboolean clear_failed_downloads_def = FALSE;
gboolean clear_unavailable_downloads     = TRUE;
gboolean clear_unavailable_downloads_def = TRUE;
gboolean search_remove_downloaded     = FALSE;
gboolean search_remove_downloaded_def = FALSE;
gboolean force_local_ip     = FALSE;
gboolean force_local_ip_def = FALSE;
gboolean use_netmasks     = FALSE;
gboolean use_netmasks_def = FALSE;
gboolean allow_private_network_connection     = FALSE;
gboolean allow_private_network_connection_def = FALSE;
gboolean use_ip_tos     = FALSE;
gboolean use_ip_tos_def = FALSE;
gboolean download_delete_aborted     = TRUE;
gboolean download_delete_aborted_def = TRUE;
gboolean proxy_auth     = FALSE;
gboolean proxy_auth_def = FALSE;
gchar   *socks_user     = "username";
gchar   *socks_user_def = "username";
gchar   *socks_pass     = "password";
gchar   *socks_pass_def = "password";
guint32  proxy_ip     = 0x00000000;
guint32  proxy_ip_def = 0x00000000;
gchar   *proxy_hostname     = "";
gchar   *proxy_hostname_def = "";
guint32  proxy_port     = 0x0000;
guint32  proxy_port_def = 0x0000;
guint32  proxy_protocol     = PROXY_NONE;
guint32  proxy_protocol_def = PROXY_NONE;
prop_def_choice_t proxy_protocol_choices[] = { 
    {N_("No proxy"), PROXY_NONE},
    {N_("HTTP"), PROXY_HTTP},
    {N_("SOCKS v4"), PROXY_SOCKSV4},
    {N_("SOCKS v5"), PROXY_SOCKSV5},
    {NULL, 0}
};
guint32  hosts_in_catcher     = 0;
guint32  hosts_in_catcher_def = 0;
guint32  hosts_in_ultra_catcher     = 0;
guint32  hosts_in_ultra_catcher_def = 0;
guint32  hosts_in_bad_catcher     = 0;
guint32  hosts_in_bad_catcher_def = 0;
guint32  max_hosts_cached     = 10000;
guint32  max_hosts_cached_def = 10000;
guint32  max_ultra_hosts_cached     = 10000;
guint32  max_ultra_hosts_cached_def = 10000;
guint32  max_bad_hosts_cached     = 8000;
guint32  max_bad_hosts_cached_def = 8000;
guint32  max_high_ttl_msg     = 10;
guint32  max_high_ttl_msg_def = 10;
guint32  max_high_ttl_radius     = 2;
guint32  max_high_ttl_radius_def = 2;
guint32  bw_http_in     = 8192;
guint32  bw_http_in_def = 8192;
guint32  bw_http_out     = 8192;
guint32  bw_http_out_def = 8192;
guint32  bw_gnet_in     = 8192;
guint32  bw_gnet_in_def = 8192;
guint32  bw_gnet_out     = 8192;
guint32  bw_gnet_out_def = 8192;
guint32  bw_gnet_lin     = 3072;
guint32  bw_gnet_lin_def = 3072;
guint32  bw_gnet_lout     = 2048;
guint32  bw_gnet_lout_def = 2048;
guint32  search_queries_forward_size     = 256;
guint32  search_queries_forward_size_def = 256;
guint32  search_queries_kick_size     = 1024;
guint32  search_queries_kick_size_def = 1024;
guint32  search_answers_forward_size     = 16384;
guint32  search_answers_forward_size_def = 16384;
guint32  search_answers_kick_size     = 65536;
guint32  search_answers_kick_size_def = 65536;
guint32  other_messages_kick_size     = 40960;
guint32  other_messages_kick_size_def = 40960;
guint32  hops_random_factor     = 0;
guint32  hops_random_factor_def = 0;
gboolean send_pushes     = TRUE;
gboolean send_pushes_def = TRUE;
guint32  min_dup_msg     = 5;
guint32  min_dup_msg_def = 5;
guint32  min_dup_ratio     = 150;
guint32  min_dup_ratio_def = 150;
gchar   *scan_extensions     = "aac;asf;avi;bin;bz2;cue;deb;divx;doc;flac;flc;fli;gif;gz;ifo;iso;it;jpeg;jpg;m4a;mjpg;mka;mkv;mod;mov;mp1;mp2;mp3;mp4;mpa;mpeg;mpega;mpg;mpv;nes;ogg;ogm;qt;pdf;png;ps;ram;rar;rm;rom;rpm;s3m;shn;smc;smd;stm;tar;tgz;torrent;txt;vob;voc;vqf;wav;wma;wmv;xm;xvid;zip";
gchar   *scan_extensions_def = "aac;asf;avi;bin;bz2;cue;deb;divx;doc;flac;flc;fli;gif;gz;ifo;iso;it;jpeg;jpg;m4a;mjpg;mka;mkv;mod;mov;mp1;mp2;mp3;mp4;mpa;mpeg;mpega;mpg;mpv;nes;ogg;ogm;qt;pdf;png;ps;ram;rar;rm;rom;rpm;s3m;shn;smc;smd;stm;tar;tgz;torrent;txt;vob;voc;vqf;wav;wma;wmv;xm;xvid;zip";
gboolean scan_ignore_symlink_dirs     = FALSE;
gboolean scan_ignore_symlink_dirs_def = FALSE;
gboolean scan_ignore_symlink_regfiles     = FALSE;
gboolean scan_ignore_symlink_regfiles_def = FALSE;
gchar   *save_file_path     = "~/gtk-gnutella-downloads/incomplete";
gchar   *save_file_path_def = "~/gtk-gnutella-downloads/incomplete";
gchar   *move_file_path     = "~/gtk-gnutella-downloads/complete";
gchar   *move_file_path_def = "~/gtk-gnutella-downloads/complete";
gchar   *bad_file_path     = "~/gtk-gnutella-downloads/corrupt";
gchar   *bad_file_path_def = "~/gtk-gnutella-downloads/corrupt";
gchar   *shared_dirs_paths     = "";
gchar   *shared_dirs_paths_def = "";
gchar   *local_netmasks_string     = "";
gchar   *local_netmasks_string_def = "";
guint32  total_downloads     = 0;
guint32  total_downloads_def = 0;
guint32  ul_running     = 0;
guint32  ul_running_def = 0;
guint32  ul_registered     = 0;
guint32  ul_registered_def = 0;
guint32  total_uploads     = 0;
guint32  total_uploads_def = 0;
gchar   servent_guid[16];
gboolean use_swarming     = TRUE;
gboolean use_swarming_def = TRUE;
gboolean use_aggressive_swarming     = TRUE;
gboolean use_aggressive_swarming_def = TRUE;
guint32  dl_minchunksize     = 512*1024;
guint32  dl_minchunksize_def = 512*1024;
guint32  dl_maxchunksize     = 10*1024*1024;
guint32  dl_maxchunksize_def = 10*1024*1024;
gboolean auto_download_identical     = TRUE;
gboolean auto_download_identical_def = TRUE;
gboolean auto_feed_download_mesh     = TRUE;
gboolean auto_feed_download_mesh_def = TRUE;
gboolean strict_sha1_matching     = TRUE;
gboolean strict_sha1_matching_def = TRUE;
gboolean use_fuzzy_matching     = FALSE;
gboolean use_fuzzy_matching_def = FALSE;
guint32  fuzzy_threshold     = 70;
guint32  fuzzy_threshold_def = 70;
gboolean is_firewalled     = TRUE;
gboolean is_firewalled_def = TRUE;
gboolean is_inet_connected     = TRUE;
gboolean is_inet_connected_def = TRUE;
gboolean is_udp_firewalled     = TRUE;
gboolean is_udp_firewalled_def = TRUE;
gboolean recv_solicited_udp     = FALSE;
gboolean recv_solicited_udp_def = FALSE;
gboolean gnet_compact_query     = TRUE;
gboolean gnet_compact_query_def = TRUE;
gboolean download_optimistic_start     = FALSE;
gboolean download_optimistic_start_def = FALSE;
gboolean library_rebuilding     = FALSE;
gboolean library_rebuilding_def = FALSE;
gboolean sha1_rebuilding     = FALSE;
gboolean sha1_rebuilding_def = FALSE;
gboolean sha1_verifying     = FALSE;
gboolean sha1_verifying_def = FALSE;
gboolean file_moving     = FALSE;
gboolean file_moving_def = FALSE;
gboolean prefer_compressed_gnet     = TRUE;
gboolean prefer_compressed_gnet_def = TRUE;
gboolean online_mode     = TRUE;
gboolean online_mode_def = TRUE;
gboolean download_require_urn     = FALSE;
gboolean download_require_urn_def = FALSE;
gboolean download_require_server_name     = TRUE;
gboolean download_require_server_name_def = TRUE;
guint32  max_ultrapeers     = 3;
guint32  max_ultrapeers_def = 3;
guint32  quick_connect_pool_size     = 40;
guint32  quick_connect_pool_size_def = 40;
guint32  max_leaves     = 100;
guint32  max_leaves_def = 100;
guint32  search_handle_ignored_files     = 0;
guint32  search_handle_ignored_files_def = 0;
prop_def_choice_t search_handle_ignored_files_choices[] = { 
    {N_("displayed normally"), 0},
    {N_("displayed marked"), 1},
    {N_("not displayed"), 2},
    {NULL, 0}
};
guint32  configured_peermode     = NODE_P_AUTO;
guint32  configured_peermode_def = NODE_P_AUTO;
prop_def_choice_t configured_peermode_choices[] = { 
    {N_("auto (recommended)"), NODE_P_AUTO},
    {N_("ultra node"), NODE_P_ULTRA},
    {N_("leaf node"), NODE_P_LEAF},
    {NULL, 0}
};
guint32  current_peermode     = 0;
guint32  current_peermode_def = 0;
prop_def_choice_t current_peermode_choices[] = { 
    {N_("ultra node"), 2},
    {N_("normal node"), 1},
    {N_("leaf node"), 0},
    {NULL, 0}
};
guint32  sys_nofile     = 1024;
guint32  sys_nofile_def = 1024;
guint32  sys_physmem     = 65536;
guint32  sys_physmem_def = 65536;
guint32  dl_queue_count     = 0;
guint32  dl_queue_count_def = 0;
guint32  dl_running_count     = 0;
guint32  dl_running_count_def = 0;
guint32  dl_active_count     = 0;
guint32  dl_active_count_def = 0;
guint32  dl_aqueued_count     = 0;
guint32  dl_aqueued_count_def = 0;
guint32  dl_pqueued_count     = 0;
guint32  dl_pqueued_count_def = 0;
guint32  fi_all_count     = 0;
guint32  fi_all_count_def = 0;
guint32  fi_with_source_count     = 0;
guint32  fi_with_source_count_def = 0;
guint32  dl_qalive_count     = 0;
guint32  dl_qalive_count_def = 0;
guint64  dl_byte_count     = 0;
guint64  dl_byte_count_def = 0;
guint64  ul_byte_count     = 0;
guint64  ul_byte_count_def = 0;
gboolean pfsp_server     = TRUE;
gboolean pfsp_server_def = TRUE;
guint32  pfsp_first_chunk     = 524288;
guint32  pfsp_first_chunk_def = 524288;
gboolean fuzzy_filter_dmesh     = FALSE;
gboolean fuzzy_filter_dmesh_def = FALSE;
guint32  crawler_visit_count     = 0;
guint32  crawler_visit_count_def = 0;
guint32  udp_crawler_visit_count     = 0;
guint32  udp_crawler_visit_count_def = 0;
gboolean host_runs_ntp     = FALSE;
gboolean host_runs_ntp_def = FALSE;
gboolean ntp_detected     = FALSE;
gboolean ntp_detected_def = FALSE;
guint32  clock_skew     = 0;
guint32  clock_skew_def = 0;
gboolean node_monitor_unstable_ip     = TRUE;
gboolean node_monitor_unstable_ip_def = TRUE;
gboolean node_monitor_unstable_servents     = FALSE;
gboolean node_monitor_unstable_servents_def = FALSE;
gboolean dl_remove_file_on_mismatch     = FALSE;
gboolean dl_remove_file_on_mismatch_def = FALSE;
guint32  dl_mismatch_backout     = 50000;
guint32  dl_mismatch_backout_def = 50000;
gchar   *server_hostname     = "";
gchar   *server_hostname_def = "";
gboolean give_server_hostname     = FALSE;
gboolean give_server_hostname_def = FALSE;
guint32  reserve_gtkg_nodes     = 20;
guint32  reserve_gtkg_nodes_def = 20;
guint32  unique_nodes     = 60;
guint32  unique_nodes_def = 60;
guint32  download_rx_size     = 64;
guint32  download_rx_size_def = 64;
guint32  node_rx_size     = 16;
guint32  node_rx_size_def = 16;
guint32  dl_http_latency     = 0;
guint32  dl_http_latency_def = 0;
guint32  node_last_ultra_check     = 0;
guint32  node_last_ultra_check_def = 0;
guint32  node_last_ultra_leaf_switch     = 0;
guint32  node_last_ultra_leaf_switch_def = 0;
gboolean up_req_avg_servent_uptime     = FALSE;
gboolean up_req_avg_servent_uptime_def = FALSE;
gboolean up_req_avg_ip_uptime     = FALSE;
gboolean up_req_avg_ip_uptime_def = FALSE;
gboolean up_req_node_uptime     = FALSE;
gboolean up_req_node_uptime_def = FALSE;
gboolean up_req_not_firewalled     = FALSE;
gboolean up_req_not_firewalled_def = FALSE;
gboolean up_req_enough_conn     = FALSE;
gboolean up_req_enough_conn_def = FALSE;
gboolean up_req_enough_fd     = FALSE;
gboolean up_req_enough_fd_def = FALSE;
gboolean up_req_enough_mem     = FALSE;
gboolean up_req_enough_mem_def = FALSE;
gboolean up_req_enough_bw     = FALSE;
gboolean up_req_enough_bw_def = FALSE;
guint32  search_queue_size     = 256;
guint32  search_queue_size_def = 256;
guint32  search_queue_spacing     = 10;
guint32  search_queue_spacing_def = 10;
gboolean enable_shell     = FALSE;
gboolean enable_shell_def = FALSE;
guint32  entry_removal_timeout     = 5;
guint32  entry_removal_timeout_def = 5;
gboolean node_watch_similar_queries     = TRUE;
gboolean node_watch_similar_queries_def = TRUE;
guint32  node_queries_half_life     = 5;
guint32  node_queries_half_life_def = 5;
guint32  node_requery_threshold     = 1700;
guint32  node_requery_threshold_def = 1700;
guint32  library_rescan_timestamp     = 0;
guint32  library_rescan_timestamp_def = 0;
guint32  library_rescan_time     = 0;
guint32  library_rescan_time_def = 0;
guint32  qrp_indexing_timestamp     = 0;
guint32  qrp_indexing_timestamp_def = 0;
guint32  qrp_indexing_time     = 0;
guint32  qrp_indexing_time_def = 0;
guint32  qrp_timestamp     = 0;
guint32  qrp_timestamp_def = 0;
guint32  qrp_computation_time     = 0;
guint32  qrp_computation_time_def = 0;
guint32  qrp_patch_timestamp     = 0;
guint32  qrp_patch_timestamp_def = 0;
guint32  qrp_patch_computation_time     = 0;
guint32  qrp_patch_computation_time_def = 0;
guint32  qrp_generation     = 0;
guint32  qrp_generation_def = 0;
guint32  qrp_slots     = 0;
guint32  qrp_slots_def = 0;
guint32  qrp_slots_filled     = 0;
guint32  qrp_slots_filled_def = 0;
guint32  qrp_fill_ratio     = 0;
guint32  qrp_fill_ratio_def = 0;
guint32  qrp_conflict_ratio     = 0;
guint32  qrp_conflict_ratio_def = 0;
guint32  qrp_hashed_keywords     = 0;
guint32  qrp_hashed_keywords_def = 0;
guint32  qrp_patch_raw_length     = 0;
guint32  qrp_patch_raw_length_def = 0;
guint32  qrp_patch_length     = 0;
guint32  qrp_patch_length_def = 0;
guint32  qrp_patch_comp_ratio     = 0;
guint32  qrp_patch_comp_ratio_def = 0;
gchar   *ancient_version_force     = "";
gchar   *ancient_version_force_def = "";
guint32  ancient_version_left_days     = 365;
guint32  ancient_version_left_days_def = 365;
gboolean file_descriptor_shortage     = FALSE;
gboolean file_descriptor_shortage_def = FALSE;
gboolean file_descriptor_runout     = FALSE;
gboolean file_descriptor_runout_def = FALSE;
gboolean enable_g2_support     = FALSE;
gboolean enable_g2_support_def = FALSE;
gboolean convert_spaces     = FALSE;
gboolean convert_spaces_def = FALSE;
gboolean convert_evil_chars     = TRUE;
gboolean convert_evil_chars_def = TRUE;
gboolean convert_old_filenames     = FALSE;
gboolean convert_old_filenames_def = FALSE;
gboolean tls_enforce     = FALSE;
gboolean tls_enforce_def = FALSE;
gboolean gnet_deflate_enabled     = TRUE;
gboolean gnet_deflate_enabled_def = TRUE;
gboolean enable_udp     = TRUE;
gboolean enable_udp_def = TRUE;
gboolean process_oob_queries     = TRUE;
gboolean process_oob_queries_def = TRUE;
gboolean send_oob_queries     = TRUE;
gboolean send_oob_queries_def = TRUE;
gboolean proxy_oob_queries     = TRUE;
gboolean proxy_oob_queries_def = TRUE;
gboolean uploads_stalling     = FALSE;
gboolean uploads_stalling_def = FALSE;
gboolean allow_auto_requeries     = TRUE;
gboolean allow_auto_requeries_def = TRUE;
gboolean use_global_hostiles_txt     = TRUE;
gboolean use_global_hostiles_txt_def = TRUE;
gboolean use_so_linger     = FALSE;
gboolean use_so_linger_def = FALSE;

static prop_set_t *gnet_property = NULL;

prop_set_t *
gnet_prop_init(void) {
    guint32 n;

    gnet_property = g_new(prop_set_t, 1);
    gnet_property->name   = "gnet_property";
    gnet_property->desc   = "";
    gnet_property->size   = GNET_PROPERTY_NUM;
    gnet_property->offset = (NO_PROP+1);
    gnet_property->mtime  = 0;
    gnet_property->props  = g_new(prop_def_t, GNET_PROPERTY_NUM);
    gnet_property->get_stub = gnet_prop_get_stub;
    gnet_property->dirty = FALSE;
    gnet_property->byName = NULL;


    /*
     * PROP_READING_HOSTFILE:
     *
     * General data:
     */
    gnet_property->props[0].name = "reading_hostfile";
    gnet_property->props[0].desc = _("Indicates whether the hostcache file is being read.");
    gnet_property->props[0].ev_changed = event_new("reading_hostfile_changed");
    gnet_property->props[0].save = FALSE;
    gnet_property->props[0].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[0].type               = PROP_TYPE_BOOLEAN;
    gnet_property->props[0].data.boolean.def   = &reading_hostfile_def;
    gnet_property->props[0].data.boolean.value = &reading_hostfile;


    /*
     * PROP_READING_ULTRAFILE:
     *
     * General data:
     */
    gnet_property->props[1].name = "reading_ultrafile";
    gnet_property->props[1].desc = _("Indicates whether the ultracache file is being read.");
    gnet_property->props[1].ev_changed = event_new("reading_ultrafile_changed");
    gnet_property->props[1].save = FALSE;
    gnet_property->props[1].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[1].type               = PROP_TYPE_BOOLEAN;
    gnet_property->props[1].data.boolean.def   = &reading_ultrafile_def;
    gnet_property->props[1].data.boolean.value = &reading_ultrafile;


    /*
     * PROP_ANCIENT_VERSION:
     *
     * General data:
     */
    gnet_property->props[2].name = "ancient_version";
    gnet_property->props[2].desc = _("Indicates that gtk-gnutella finds the version you run very VERY old.  You should upgrade as soon as possible to avoid suffering from non-optimal Gnutella support that may not only damage your abilities to search and download but also harm the network since you're not supporting the newest features.");
    gnet_property->props[2].ev_changed = event_new("ancient_version_changed");
    gnet_property->props[2].save = FALSE;
    gnet_property->props[2].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[2].type               = PROP_TYPE_BOOLEAN;
    gnet_property->props[2].data.boolean.def   = &ancient_version_def;
    gnet_property->props[2].data.boolean.value = &ancient_version;


    /*
     * PROP_NEW_VERSION_STR:
     *
     * General data:
     */
    gnet_property->props[3].name = "new_version_str";
    gnet_property->props[3].desc = _("Gtk-Gnutella found a newer version on the Gnet and gives information about it here.");
    gnet_property->props[3].ev_changed = event_new("new_version_str_changed");
    gnet_property->props[3].save = FALSE;
    gnet_property->props[3].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[3].type               = PROP_TYPE_STRING;
    gnet_property->props[3].data.string.def    = &new_version_str_def;
    gnet_property->props[3].data.string.value  = &new_version_str;
    if (gnet_property->props[3].data.string.def) {
        *gnet_property->props[3].data.string.value =
            g_strdup(eval_subst(*gnet_property->props[3].data.string.def));
    }


    /*
     * PROP_UP_CONNECTIONS:
     *
     * General data:
     */
    gnet_property->props[4].name = "up_connections";
    gnet_property->props[4].desc = _("Try to keep at least this number of connections to other servents of the same kind as we are (normal or ultra nodes). This should be smaller than the maximum amount of connections to allow incoming connections.  Keep in mind that the default TTL on Gnutella is 4, so this needs to be more than 30 to provide decent range for searches.");
    gnet_property->props[4].ev_changed = event_new("up_connections_changed");
    gnet_property->props[4].save = TRUE;
    gnet_property->props[4].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[4].type               = PROP_TYPE_GUINT32;
    gnet_property->props[4].data.guint32.def   = &up_connections_def;
    gnet_property->props[4].data.guint32.value = &up_connections;
    gnet_property->props[4].data.guint32.choices = NULL;
    gnet_property->props[4].data.guint32.max   = 100;
    gnet_property->props[4].data.guint32.min   = 0;


    /*
     * PROP_NORMAL_CONNECTIONS:
     *
     * General data:
     */
    gnet_property->props[5].name = "normal_connections";
    gnet_property->props[5].desc = _("When in ultrapeer mode, try to keep at least this number of connections to normal servents.  This should be smaller than the maximum amount of connections to allow incoming connections.");
    gnet_property->props[5].ev_changed = event_new("normal_connections_changed");
    gnet_property->props[5].save = TRUE;
    gnet_property->props[5].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[5].type               = PROP_TYPE_GUINT32;
    gnet_property->props[5].data.guint32.def   = &normal_connections_def;
    gnet_property->props[5].data.guint32.value = &normal_connections;
    gnet_property->props[5].data.guint32.choices = NULL;
    gnet_property->props[5].data.guint32.max   = 1;
    gnet_property->props[5].data.guint32.min   = 0;


    /*
     * PROP_MAX_CONNECTIONS:
     *
     * General data:
     */
    gnet_property->props[6].name = "max_connections";
    gnet_property->props[6].desc = _("Don't allow more than this number of connections to other servents.  As a rule of thumb you should reserve 256 b/s bandwidth per connection. Never use up all your bandwidth, leave a little space for TCP/IP overhead. It's not advisable that you set this to a value smaller than 30.");
    gnet_property->props[6].ev_changed = event_new("max_connections_changed");
    gnet_property->props[6].save = TRUE;
    gnet_property->props[6].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[6].type               = PROP_TYPE_GUINT32;
    gnet_property->props[6].data.guint32.def   = &max_connections_def;
    gnet_property->props[6].data.guint32.value = &max_connections;
    gnet_property->props[6].data.guint32.choices = NULL;
    gnet_property->props[6].data.guint32.max   = 100;
    gnet_property->props[6].data.guint32.min   = 20;


    /*
     * PROP_NODE_LEAF_COUNT:
     *
     * General data:
     */
    gnet_property->props[7].name = "node_leaf_count";
    gnet_property->props[7].desc = _("Number of leaf nodes currently connected.");
    gnet_property->props[7].ev_changed = event_new("node_leaf_count_changed");
    gnet_property->props[7].save = FALSE;
    gnet_property->props[7].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[7].type               = PROP_TYPE_GUINT32;
    gnet_property->props[7].data.guint32.def   = &node_leaf_count_def;
    gnet_property->props[7].data.guint32.value = &node_leaf_count;
    gnet_property->props[7].data.guint32.choices = NULL;
    gnet_property->props[7].data.guint32.max   = 0xFFFFFFFF;
    gnet_property->props[7].data.guint32.min   = 0x00000000;


    /*
     * PROP_NODE_NORMAL_COUNT:
     *
     * General data:
     */
    gnet_property->props[8].name = "node_normal_count";
    gnet_property->props[8].desc = _("Number of normal nodes currently connected.");
    gnet_property->props[8].ev_changed = event_new("node_normal_count_changed");
    gnet_property->props[8].save = FALSE;
    gnet_property->props[8].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[8].type               = PROP_TYPE_GUINT32;
    gnet_property->props[8].data.guint32.def   = &node_normal_count_def;
    gnet_property->props[8].data.guint32.value = &node_normal_count;
    gnet_property->props[8].data.guint32.choices = NULL;
    gnet_property->props[8].data.guint32.max   = 0xFFFFFFFF;
    gnet_property->props[8].data.guint32.min   = 0x00000000;


    /*
     * PROP_NODE_ULTRA_COUNT:
     *
     * General data:
     */
    gnet_property->props[9].name = "node_ultra_count";
    gnet_property->props[9].desc = _("Number of ultra nodes currently connected.");
    gnet_property->props[9].ev_changed = event_new("node_ultra_count_changed");
    gnet_property->props[9].save = FALSE;
    gnet_property->props[9].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[9].type               = PROP_TYPE_GUINT32;
    gnet_property->props[9].data.guint32.def   = &node_ultra_count_def;
    gnet_property->props[9].data.guint32.value = &node_ultra_count;
    gnet_property->props[9].data.guint32.choices = NULL;
    gnet_property->props[9].data.guint32.max   = 0xFFFFFFFF;
    gnet_property->props[9].data.guint32.min   = 0x00000000;


    /*
     * PROP_MAX_DOWNLOADS:
     *
     * General data:
     */
    gnet_property->props[10].name = "max_simultaneous_downloads";
    gnet_property->props[10].desc = _("Don't start more than this number of parallel downloads.  Others will remain in the queue waiting for a download slot.");
    gnet_property->props[10].ev_changed = event_new("max_downloads_changed");
    gnet_property->props[10].save = TRUE;
    gnet_property->props[10].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[10].type               = PROP_TYPE_GUINT32;
    gnet_property->props[10].data.guint32.def   = &max_downloads_def;
    gnet_property->props[10].data.guint32.value = &max_downloads;
    gnet_property->props[10].data.guint32.choices = NULL;
    gnet_property->props[10].data.guint32.max   = 5000;
    gnet_property->props[10].data.guint32.min   = 0;


    /*
     * PROP_MAX_HOST_DOWNLOADS:
     *
     * General data:
     */
    gnet_property->props[11].name = "max_simultaneous_host_downloads";
    gnet_property->props[11].desc = _("Don't make more connections than given here to a single host to download a file.  Be nice to others, and leave it at the default value (1).");
    gnet_property->props[11].ev_changed = event_new("max_host_downloads_changed");
    gnet_property->props[11].save = TRUE;
    gnet_property->props[11].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[11].type               = PROP_TYPE_GUINT32;
    gnet_property->props[11].data.guint32.def   = &max_host_downloads_def;
    gnet_property->props[11].data.guint32.value = &max_host_downloads;
    gnet_property->props[11].data.guint32.choices = NULL;
    gnet_property->props[11].data.guint32.max   = 10;
    gnet_property->props[11].data.guint32.min   = 1;


    /*
     * PROP_MAX_UPLOADS:
     *
     * General data:
     */
    gnet_property->props[12].name = "max_simultaneous_uploads";
    gnet_property->props[12].desc = _("Don't allow more than this number of uploads in total. This also defines the amount of PARQ queues that will be used. You should at least set it to 2.");
    gnet_property->props[12].ev_changed = event_new("max_uploads_changed");
    gnet_property->props[12].save = TRUE;
    gnet_property->props[12].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[12].type               = PROP_TYPE_GUINT32;
    gnet_property->props[12].data.guint32.def   = &max_uploads_def;
    gnet_property->props[12].data.guint32.value = &max_uploads;
    gnet_property->props[12].data.guint32.choices = NULL;
    gnet_property->props[12].data.guint32.max   = 100;
    gnet_property->props[12].data.guint32.min   = 0;


    /*
     * PROP_MAX_UPLOADS_IP:
     *
     * General data:
     */
    gnet_property->props[13].name = "max_uploads_ip";
    gnet_property->props[13].desc = _("Don't upload more than this number of files in parallel to a single host.");
    gnet_property->props[13].ev_changed = event_new("max_uploads_ip_changed");
    gnet_property->props[13].save = TRUE;
    gnet_property->props[13].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[13].type               = PROP_TYPE_GUINT32;
    gnet_property->props[13].data.guint32.def   = &max_uploads_ip_def;
    gnet_property->props[13].data.guint32.value = &max_uploads_ip;
    gnet_property->props[13].data.guint32.choices = NULL;
    gnet_property->props[13].data.guint32.max   = 100;
    gnet_property->props[13].data.guint32.min   = 1;


    /*
     * PROP_LOCAL_IP:
     *
     * General data:
     */
    gnet_property->props[14].name = "local_ip";
    gnet_property->props[14].desc = _("Local IP address last determined.");
    gnet_property->props[14].ev_changed = event_new("local_ip_changed");
    gnet_property->props[14].save = TRUE;
    gnet_property->props[14].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[14].type               = PROP_TYPE_IP;
    gnet_property->props[14].data.guint32.def   = &local_ip_def;
    gnet_property->props[14].data.guint32.value = &local_ip;
    gnet_property->props[14].data.guint32.choices = NULL;
    gnet_property->props[14].data.guint32.max   = 0xFFFFFFFF;
    gnet_property->props[14].data.guint32.min   = 0x00000000;


    /*
     * PROP_CURRENT_IP_STAMP:
     *
     * General data:
     */
    gnet_property->props[15].name = "current_ip_stamp";
    gnet_property->props[15].desc = _("When the current IP address was determined.");
    gnet_property->props[15].ev_changed = event_new("current_ip_stamp_changed");
    gnet_property->props[15].save = TRUE;
    gnet_property->props[15].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[15].type               = PROP_TYPE_GUINT32;
    gnet_property->props[15].data.guint32.def   = &current_ip_stamp_def;
    gnet_property->props[15].data.guint32.value = &current_ip_stamp;
    gnet_property->props[15].data.guint32.choices = NULL;
    gnet_property->props[15].data.guint32.max   = 0xFFFFFFFF;
    gnet_property->props[15].data.guint32.min   = 0x00000000;


    /*
     * PROP_AVERAGE_IP_UPTIME:
     *
     * General data:
     */
    gnet_property->props[16].name = "average_ip_uptime";
    gnet_property->props[16].desc = _("Average uptime with the same IP address.");
    gnet_property->props[16].ev_changed = event_new("average_ip_uptime_changed");
    gnet_property->props[16].save = TRUE;
    gnet_property->props[16].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[16].type               = PROP_TYPE_GUINT32;
    gnet_property->props[16].data.guint32.def   = &average_ip_uptime_def;
    gnet_property->props[16].data.guint32.value = &average_ip_uptime;
    gnet_property->props[16].data.guint32.choices = NULL;
    gnet_property->props[16].data.guint32.max   = 0xFFFFFFFF;
    gnet_property->props[16].data.guint32.min   = 0x00000000;


    /*
     * PROP_START_STAMP:
     *
     * General data:
     */
    gnet_property->props[17].name = "start_stamp";
    gnet_property->props[17].desc = _("Timestamp at which servent was started.");
    gnet_property->props[17].ev_changed = event_new("start_stamp_changed");
    gnet_property->props[17].save = FALSE;
    gnet_property->props[17].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[17].type               = PROP_TYPE_GUINT32;
    gnet_property->props[17].data.guint32.def   = &start_stamp_def;
    gnet_property->props[17].data.guint32.value = &start_stamp;
    gnet_property->props[17].data.guint32.choices = NULL;
    gnet_property->props[17].data.guint32.max   = 0xFFFFFFFF;
    gnet_property->props[17].data.guint32.min   = 0x00000000;


    /*
     * PROP_AVERAGE_SERVENT_UPTIME:
     *
     * General data:
     */
    gnet_property->props[18].name = "average_servent_uptime";
    gnet_property->props[18].desc = _("Average servent uptime.");
    gnet_property->props[18].ev_changed = event_new("average_servent_uptime_changed");
    gnet_property->props[18].save = TRUE;
    gnet_property->props[18].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[18].type               = PROP_TYPE_GUINT32;
    gnet_property->props[18].data.guint32.def   = &average_servent_uptime_def;
    gnet_property->props[18].data.guint32.value = &average_servent_uptime;
    gnet_property->props[18].data.guint32.choices = NULL;
    gnet_property->props[18].data.guint32.max   = 0xFFFFFFFF;
    gnet_property->props[18].data.guint32.min   = 0x00000000;


    /*
     * PROP_LISTEN_PORT:
     *
     * General data:
     */
    gnet_property->props[19].name = "listen_port";
    gnet_property->props[19].desc = _("Local TCP port gtk-gnutella is listening on. Your ISP may block or choke traffic on TCP port 6346 so it would be a good idea to change it to something in the range of 1024-65535.  Don't forget to update your firewall port forwarding / opening, as necessary.  Note that by default, the TCP port 6346 is not used to guard against undue censorship.");
    gnet_property->props[19].ev_changed = event_new("listen_port_changed");
    gnet_property->props[19].save = TRUE;
    gnet_property->props[19].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[19].type               = PROP_TYPE_GUINT32;
    gnet_property->props[19].data.guint32.def   = &listen_port_def;
    gnet_property->props[19].data.guint32.value = &listen_port;
    gnet_property->props[19].data.guint32.choices = NULL;
    gnet_property->props[19].data.guint32.max   = 0xFFFF;
    gnet_property->props[19].data.guint32.min   = 0x0000;


    /*
     * PROP_FORCED_LOCAL_IP:
     *
     * General data:
     */
    gnet_property->props[20].name = "forced_local_ip";
    gnet_property->props[20].desc = _("Use this IP address as source address if 'force local ip' is activated.");
    gnet_property->props[20].ev_changed = event_new("forced_local_ip_changed");
    gnet_property->props[20].save = TRUE;
    gnet_property->props[20].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[20].type               = PROP_TYPE_IP;
    gnet_property->props[20].data.guint32.def   = &forced_local_ip_def;
    gnet_property->props[20].data.guint32.value = &forced_local_ip;
    gnet_property->props[20].data.guint32.choices = NULL;
    gnet_property->props[20].data.guint32.max   = 0xFFFFFFFF;
    gnet_property->props[20].data.guint32.min   = 0x00000000;


    /*
     * PROP_CONNECTION_SPEED:
     *
     * General data:
     */
    gnet_property->props[21].name = "connection_speed";
    gnet_property->props[21].desc = _("The connection bandwidth reported to other hosts. This is the speed at which you can upload things to others.");
    gnet_property->props[21].ev_changed = event_new("connection_speed_changed");
    gnet_property->props[21].save = TRUE;
    gnet_property->props[21].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[21].type               = PROP_TYPE_GUINT32;
    gnet_property->props[21].data.guint32.def   = &connection_speed_def;
    gnet_property->props[21].data.guint32.value = &connection_speed;
    gnet_property->props[21].data.guint32.choices = NULL;
    gnet_property->props[21].data.guint32.max   = 2000;
    gnet_property->props[21].data.guint32.min   = 0;


    /*
     * PROP_COMPUTE_CONNECTION_SPEED:
     *
     * General data:
     */
    gnet_property->props[22].name = "compute_connection_speed";
    gnet_property->props[22].desc = _("Whether the connection bandwidth reported to other hosts should be computed based on the current average upload speed. The reported speed is the available speed for a new upload, not the theoretical maximum configured: it is the average bandwidth (or the max configured bandwidth if no traffic yet) divided by the number of upload slots. When it is ON (recommended setting), the hardwired connection speed is not used.");
    gnet_property->props[22].ev_changed = event_new("compute_connection_speed_changed");
    gnet_property->props[22].save = TRUE;
    gnet_property->props[22].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[22].type               = PROP_TYPE_BOOLEAN;
    gnet_property->props[22].data.boolean.def   = &compute_connection_speed_def;
    gnet_property->props[22].data.boolean.value = &compute_connection_speed;


    /*
     * PROP_QUERY_RESPONSE_MAX_ITEMS:
     *
     * General data:
     */
    gnet_property->props[23].name = "limit_search_results";
    gnet_property->props[23].desc = _("Return at most this number of results to a query, using as many query hit packets as necessary.  To avoid network flooding, keep this to a reasonable value.");
    gnet_property->props[23].ev_changed = event_new("query_response_max_items_changed");
    gnet_property->props[23].save = TRUE;
    gnet_property->props[23].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[23].type               = PROP_TYPE_GUINT32;
    gnet_property->props[23].data.guint32.def   = &search_max_items_def;
    gnet_property->props[23].data.guint32.value = &search_max_items;
    gnet_property->props[23].data.guint32.choices = NULL;
    gnet_property->props[23].data.guint32.max   = 500;
    gnet_property->props[23].data.guint32.min   = 1;


    /*
     * PROP_UL_USAGE_MIN_PERCENTAGE:
     *
     * General data:
     */
    gnet_property->props[24].name = "upload_bandwith_min_percentage";
    gnet_property->props[24].desc = _("Unless this percentage or more of the upload bandwidth is used, allow additional upload slots.");
    gnet_property->props[24].ev_changed = event_new("ul_usage_min_percentage_changed");
    gnet_property->props[24].save = TRUE;
    gnet_property->props[24].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[24].type               = PROP_TYPE_GUINT32;
    gnet_property->props[24].data.guint32.def   = &ul_usage_min_percentage_def;
    gnet_property->props[24].data.guint32.value = &ul_usage_min_percentage;
    gnet_property->props[24].data.guint32.choices = NULL;
    gnet_property->props[24].data.guint32.max   = 100;
    gnet_property->props[24].data.guint32.min   = 0;


    /*
     * PROP_DOWNLOAD_CONNECTING_TIMEOUT:
     *
     * General data:
     */
    gnet_property->props[25].name = "download_connecting_timeout";
    gnet_property->props[25].desc = _("Number of seconds before a download connect attempt times out.");
    gnet_property->props[25].ev_changed = event_new("download_connecting_timeout_changed");
    gnet_property->props[25].save = TRUE;
    gnet_property->props[25].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[25].type               = PROP_TYPE_GUINT32;
    gnet_property->props[25].data.guint32.def   = &download_connecting_timeout_def;
    gnet_property->props[25].data.guint32.value = &download_connecting_timeout;
    gnet_property->props[25].data.guint32.choices = NULL;
    gnet_property->props[25].data.guint32.max   = 100000;
    gnet_property->props[25].data.guint32.min   = 10;


    /*
     * PROP_DOWNLOAD_PUSH_SENT_TIMEOUT:
     *
     * General data:
     */
    gnet_property->props[26].name = "download_push_sent_timeout";
    gnet_property->props[26].desc = _("Number of seconds before a push request times out.");
    gnet_property->props[26].ev_changed = event_new("download_push_sent_timeout_changed");
    gnet_property->props[26].save = TRUE;
    gnet_property->props[26].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[26].type               = PROP_TYPE_GUINT32;
    gnet_property->props[26].data.guint32.def   = &download_push_sent_timeout_def;
    gnet_property->props[26].data.guint32.value = &download_push_sent_timeout;
    gnet_property->props[26].data.guint32.choices = NULL;
    gnet_property->props[26].data.guint32.max   = 100000;
    gnet_property->props[26].data.guint32.min   = 30;


    /*
     * PROP_DOWNLOAD_CONNECTED_TIMEOUT:
     *
     * General data:
     */
    gnet_property->props[27].name = "download_connected_timeout";
    gnet_property->props[27].desc = _("Number of seconds before a download times out if no data is received.");
    gnet_property->props[27].ev_changed = event_new("download_connected_timeout_changed");
    gnet_property->props[27].save = TRUE;
    gnet_property->props[27].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[27].type               = PROP_TYPE_GUINT32;
    gnet_property->props[27].data.guint32.def   = &download_connected_timeout_def;
    gnet_property->props[27].data.guint32.value = &download_connected_timeout;
    gnet_property->props[27].data.guint32.choices = NULL;
    gnet_property->props[27].data.guint32.max   = 100000;
    gnet_property->props[27].data.guint32.min   = 20;


    /*
     * PROP_DOWNLOAD_RETRY_TIMEOUT_MIN:
     *
     * General data:
     */
    gnet_property->props[28].name = "download_retry_timeout_min";
    gnet_property->props[28].desc = _("Minimum number of seconds to wait on auto-retry timeouts.");
    gnet_property->props[28].ev_changed = event_new("download_retry_timeout_min_changed");
    gnet_property->props[28].save = TRUE;
    gnet_property->props[28].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[28].type               = PROP_TYPE_GUINT32;
    gnet_property->props[28].data.guint32.def   = &download_retry_timeout_min_def;
    gnet_property->props[28].data.guint32.value = &download_retry_timeout_min;
    gnet_property->props[28].data.guint32.choices = NULL;
    gnet_property->props[28].data.guint32.max   = 100000;
    gnet_property->props[28].data.guint32.min   = 5;


    /*
     * PROP_DOWNLOAD_RETRY_TIMEOUT_MAX:
     *
     * General data:
     */
    gnet_property->props[29].name = "download_retry_timeout_max";
    gnet_property->props[29].desc = _("Maximum number of seconds to wait on auto-retry timeouts.");
    gnet_property->props[29].ev_changed = event_new("download_retry_timeout_max_changed");
    gnet_property->props[29].save = TRUE;
    gnet_property->props[29].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[29].type               = PROP_TYPE_GUINT32;
    gnet_property->props[29].data.guint32.def   = &download_retry_timeout_max_def;
    gnet_property->props[29].data.guint32.value = &download_retry_timeout_max;
    gnet_property->props[29].data.guint32.choices = NULL;
    gnet_property->props[29].data.guint32.max   = 100000;
    gnet_property->props[29].data.guint32.min   = 5;


    /*
     * PROP_DOWNLOAD_MAX_RETRIES:
     *
     * General data:
     */
    gnet_property->props[30].name = "download_max_retries";
    gnet_property->props[30].desc = _("Maximum number of attempts to download a file not counting HTTP busy indications.");
    gnet_property->props[30].ev_changed = event_new("download_max_retries_changed");
    gnet_property->props[30].save = TRUE;
    gnet_property->props[30].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[30].type               = PROP_TYPE_GUINT32;
    gnet_property->props[30].data.guint32.def   = &download_max_retries_def;
    gnet_property->props[30].data.guint32.value = &download_max_retries;
    gnet_property->props[30].data.guint32.choices = NULL;
    gnet_property->props[30].data.guint32.max   = 100000;
    gnet_property->props[30].data.guint32.min   = 1;


    /*
     * PROP_DOWNLOAD_RETRY_TIMEOUT_DELAY:
     *
     * General data:
     */
    gnet_property->props[31].name = "download_retry_timeout_delay";
    gnet_property->props[31].desc = _("Delay in seconds before retrying after a connection timed out.");
    gnet_property->props[31].ev_changed = event_new("download_retry_timeout_delay_changed");
    gnet_property->props[31].save = TRUE;
    gnet_property->props[31].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[31].type               = PROP_TYPE_GUINT32;
    gnet_property->props[31].data.guint32.def   = &download_retry_timeout_delay_def;
    gnet_property->props[31].data.guint32.value = &download_retry_timeout_delay;
    gnet_property->props[31].data.guint32.choices = NULL;
    gnet_property->props[31].data.guint32.max   = 100000;
    gnet_property->props[31].data.guint32.min   = 15;


    /*
     * PROP_DOWNLOAD_RETRY_BUSY_DELAY:
     *
     * General data:
     */
    gnet_property->props[32].name = "download_retry_busy_delay";
    gnet_property->props[32].desc = _("Delay in seconds before retrying after getting a 'busy' response from a host.");
    gnet_property->props[32].ev_changed = event_new("download_retry_busy_delay_changed");
    gnet_property->props[32].save = TRUE;
    gnet_property->props[32].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[32].type               = PROP_TYPE_GUINT32;
    gnet_property->props[32].data.guint32.def   = &download_retry_busy_delay_def;
    gnet_property->props[32].data.guint32.value = &download_retry_busy_delay;
    gnet_property->props[32].data.guint32.choices = NULL;
    gnet_property->props[32].data.guint32.max   = 100000;
    gnet_property->props[32].data.guint32.min   = 15;


    /*
     * PROP_DOWNLOAD_RETRY_REFUSED_DELAY:
     *
     * General data:
     */
    gnet_property->props[33].name = "download_retry_refused_delay";
    gnet_property->props[33].desc = _("Delay in seconds before retrying after getting a 'connection refused' response from a host.");
    gnet_property->props[33].ev_changed = event_new("download_retry_refused_delay_changed");
    gnet_property->props[33].save = TRUE;
    gnet_property->props[33].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[33].type               = PROP_TYPE_GUINT32;
    gnet_property->props[33].data.guint32.def   = &download_retry_refused_delay_def;
    gnet_property->props[33].data.guint32.value = &download_retry_refused_delay;
    gnet_property->props[33].data.guint32.choices = NULL;
    gnet_property->props[33].data.guint32.max   = 100000;
    gnet_property->props[33].data.guint32.min   = 15;


    /*
     * PROP_DOWNLOAD_RETRY_STOPPED_DELAY:
     *
     * General data:
     */
    gnet_property->props[34].name = "download_retry_stopped";
    gnet_property->props[34].desc = _("Delay in seconds before retrying after a retry stopped (timed out, connection reset by peer, etc...).");
    gnet_property->props[34].ev_changed = event_new("download_retry_stopped_delay_changed");
    gnet_property->props[34].save = TRUE;
    gnet_property->props[34].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[34].type               = PROP_TYPE_GUINT32;
    gnet_property->props[34].data.guint32.def   = &download_retry_stopped_delay_def;
    gnet_property->props[34].data.guint32.value = &download_retry_stopped_delay;
    gnet_property->props[34].data.guint32.choices = NULL;
    gnet_property->props[34].data.guint32.max   = 100000;
    gnet_property->props[34].data.guint32.min   = 15;


    /*
     * PROP_DOWNLOAD_OVERLAP_RANGE:
     *
     * General data:
     */
    gnet_property->props[35].name = "download_overlap_range";
    gnet_property->props[35].desc = _("Amount of bytes to overlap when resuming a download. It should be at least 64 bytes for safe resuming, otherwise gtk-gnutella will not accept to resume a file for which we had no SHA1 known, after a server gives one back.");
    gnet_property->props[35].ev_changed = event_new("download_overlap_range_changed");
    gnet_property->props[35].save = TRUE;
    gnet_property->props[35].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[35].type               = PROP_TYPE_GUINT32;
    gnet_property->props[35].data.guint32.def   = &download_overlap_range_def;
    gnet_property->props[35].data.guint32.value = &download_overlap_range;
    gnet_property->props[35].data.guint32.choices = NULL;
    gnet_property->props[35].data.guint32.max   = SOCK_BUFSZ;
    gnet_property->props[35].data.guint32.min   = 0;


    /*
     * PROP_UPLOAD_CONNECTING_TIMEOUT:
     *
     * General data:
     */
    gnet_property->props[36].name = "upload_connecting_timeout";
    gnet_property->props[36].desc = _("Number of seconds before an upload times out if no connection can be established during a push.  It is also the maximum amount of time we wait to get the whole HTTP request.");
    gnet_property->props[36].ev_changed = event_new("upload_connecting_timeout_changed");
    gnet_property->props[36].save = TRUE;
    gnet_property->props[36].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[36].type               = PROP_TYPE_GUINT32;
    gnet_property->props[36].data.guint32.def   = &upload_connecting_timeout_def;
    gnet_property->props[36].data.guint32.value = &upload_connecting_timeout;
    gnet_property->props[36].data.guint32.choices = NULL;
    gnet_property->props[36].data.guint32.max   = 100000;
    gnet_property->props[36].data.guint32.min   = 10;


    /*
     * PROP_UPLOAD_CONNECTED_TIMEOUT:
     *
     * General data:
     */
    gnet_property->props[37].name = "upload_connected_timeout";
    gnet_property->props[37].desc = _("Number of seconds after which an upload times out if no data is transmitted.");
    gnet_property->props[37].ev_changed = event_new("upload_connected_timeout_changed");
    gnet_property->props[37].save = TRUE;
    gnet_property->props[37].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[37].type               = PROP_TYPE_GUINT32;
    gnet_property->props[37].data.guint32.def   = &upload_connected_timeout_def;
    gnet_property->props[37].data.guint32.value = &upload_connected_timeout;
    gnet_property->props[37].data.guint32.choices = NULL;
    gnet_property->props[37].data.guint32.max   = 100000;
    gnet_property->props[37].data.guint32.min   = 20;


    /*
     * PROP_SEARCH_REISSUE_TIMEOUT:
     *
     * General data:
     */
    gnet_property->props[38].name = "search_reissue_timeout";
    gnet_property->props[38].desc = _("Amount of seconds to wait before a search is issued again to see if new results are available.  Be very careful with this parameter, and do not set it too low or you will damage the Gnutella network.  A delay of half an hour is fine.");
    gnet_property->props[38].ev_changed = event_new("search_reissue_timeout_changed");
    gnet_property->props[38].save = TRUE;
    gnet_property->props[38].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[38].type               = PROP_TYPE_GUINT32;
    gnet_property->props[38].data.guint32.def   = &search_reissue_timeout_def;
    gnet_property->props[38].data.guint32.value = &search_reissue_timeout;
    gnet_property->props[38].data.guint32.choices = NULL;
    gnet_property->props[38].data.guint32.max   = 9999;
    gnet_property->props[38].data.guint32.min   = 0;


    /*
     * PROP_BAN_RATIO_FDS:
     *
     * General data:
     */
    gnet_property->props[39].name = "ban_ratio_fds";
    gnet_property->props[39].desc = _("Maximum ratio of file descriptors reserved for banning. For instance, if your OS gives you 350 file descriptors, a ratio of 10 will reserve at most 35 file descriptors.  You should ensure you have around 100 file descriptors for efficient banning.");
    gnet_property->props[39].ev_changed = event_new("ban_ratio_fds_changed");
    gnet_property->props[39].save = TRUE;
    gnet_property->props[39].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[39].type               = PROP_TYPE_GUINT32;
    gnet_property->props[39].data.guint32.def   = &ban_ratio_fds_def;
    gnet_property->props[39].data.guint32.value = &ban_ratio_fds;
    gnet_property->props[39].data.guint32.choices = NULL;
    gnet_property->props[39].data.guint32.max   = 100;
    gnet_property->props[39].data.guint32.min   = 0;


    /*
     * PROP_BAN_MAX_FDS:
     *
     * General data:
     */
    gnet_property->props[40].name = "ban_max_fds";
    gnet_property->props[40].desc = _("Maximum number of file descriptors reserved for banning.");
    gnet_property->props[40].ev_changed = event_new("ban_max_fds_changed");
    gnet_property->props[40].save = TRUE;
    gnet_property->props[40].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[40].type               = PROP_TYPE_GUINT32;
    gnet_property->props[40].data.guint32.def   = &ban_max_fds_def;
    gnet_property->props[40].data.guint32.value = &ban_max_fds;
    gnet_property->props[40].data.guint32.choices = NULL;
    gnet_property->props[40].data.guint32.max   = 10000;
    gnet_property->props[40].data.guint32.min   = 0;


    /*
     * PROP_BANNED_COUNT:
     *
     * General data:
     */
    gnet_property->props[41].name = "banned_count";
    gnet_property->props[41].desc = _("Amount of file descriptors currently used for banning, i.e. which are currently kept open for delayed close.");
    gnet_property->props[41].ev_changed = event_new("banned_count_changed");
    gnet_property->props[41].save = FALSE;
    gnet_property->props[41].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[41].type               = PROP_TYPE_GUINT32;
    gnet_property->props[41].data.guint32.def   = &banned_count_def;
    gnet_property->props[41].data.guint32.value = &banned_count;
    gnet_property->props[41].data.guint32.choices = NULL;
    gnet_property->props[41].data.guint32.max   = 0xFFFFFFFF;
    gnet_property->props[41].data.guint32.min   = 0x00000000;


    /*
     * PROP_MAX_BANNED_FD:
     *
     * General data:
     */
    gnet_property->props[42].name = "max_banned_fd";
    gnet_property->props[42].desc = _("Number of file descriptors we'll actually be using for banning.");
    gnet_property->props[42].ev_changed = event_new("max_banned_fd_changed");
    gnet_property->props[42].save = FALSE;
    gnet_property->props[42].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[42].type               = PROP_TYPE_GUINT32;
    gnet_property->props[42].data.guint32.def   = &max_banned_fd_def;
    gnet_property->props[42].data.guint32.value = &max_banned_fd;
    gnet_property->props[42].data.guint32.choices = NULL;
    gnet_property->props[42].data.guint32.max   = 0xFFFFFFFF;
    gnet_property->props[42].data.guint32.min   = 0x00000000;


    /*
     * PROP_INCOMING_CONNECTING_TIMEOUT:
     *
     * General data:
     */
    gnet_property->props[43].name = "incoming_connecting_timeout";
    gnet_property->props[43].desc = _("Number of seconds an incoming connection has to start sending out its request.");
    gnet_property->props[43].ev_changed = event_new("incoming_connecting_timeout_changed");
    gnet_property->props[43].save = TRUE;
    gnet_property->props[43].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[43].type               = PROP_TYPE_GUINT32;
    gnet_property->props[43].data.guint32.def   = &incoming_connecting_timeout_def;
    gnet_property->props[43].data.guint32.value = &incoming_connecting_timeout;
    gnet_property->props[43].data.guint32.choices = NULL;
    gnet_property->props[43].data.guint32.max   = 300;
    gnet_property->props[43].data.guint32.min   = 15;


    /*
     * PROP_NODE_CONNECTING_TIMEOUT:
     *
     * General data:
     */
    gnet_property->props[44].name = "node_connecting_timeout";
    gnet_property->props[44].desc = _("Number of seconds before a Gnet connect attempt times out if no connection can be established.");
    gnet_property->props[44].ev_changed = event_new("node_connecting_timeout_changed");
    gnet_property->props[44].save = TRUE;
    gnet_property->props[44].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[44].type               = PROP_TYPE_GUINT32;
    gnet_property->props[44].data.guint32.def   = &node_connecting_timeout_def;
    gnet_property->props[44].data.guint32.value = &node_connecting_timeout;
    gnet_property->props[44].data.guint32.choices = NULL;
    gnet_property->props[44].data.guint32.max   = 100000;
    gnet_property->props[44].data.guint32.min   = 10;


    /*
     * PROP_NODE_CONNECTED_TIMEOUT:
     *
     * General data:
     */
    gnet_property->props[45].name = "node_connected_timeout";
    gnet_property->props[45].desc = _("Number of seconds before a Gnet connection times out if no data is transmitted.");
    gnet_property->props[45].ev_changed = event_new("node_connected_timeout_changed");
    gnet_property->props[45].save = TRUE;
    gnet_property->props[45].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[45].type               = PROP_TYPE_GUINT32;
    gnet_property->props[45].data.guint32.def   = &node_connected_timeout_def;
    gnet_property->props[45].data.guint32.value = &node_connected_timeout;
    gnet_property->props[45].data.guint32.choices = NULL;
    gnet_property->props[45].data.guint32.max   = 100000;
    gnet_property->props[45].data.guint32.min   = 120;


    /*
     * PROP_NODE_SENDQUEUE_SIZE:
     *
     * General data:
     */
    gnet_property->props[46].name = "node_sendqueue_size";
    gnet_property->props[46].desc = _("Maximum size of the sendqueue for the nodes (in bytes). Must be at least 150 percent of the maximum message size.");
    gnet_property->props[46].ev_changed = event_new("node_sendqueue_size_changed");
    gnet_property->props[46].save = TRUE;
    gnet_property->props[46].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[46].type               = PROP_TYPE_GUINT32;
    gnet_property->props[46].data.guint32.def   = &node_sendqueue_size_def;
    gnet_property->props[46].data.guint32.value = &node_sendqueue_size;
    gnet_property->props[46].data.guint32.choices = NULL;
    gnet_property->props[46].data.guint32.max   = 256000;
    gnet_property->props[46].data.guint32.min   = 98305;


    /*
     * PROP_NODE_TX_FLOWC_TIMEOUT:
     *
     * General data:
     */
    gnet_property->props[47].name = "node_tx_flowc_timeout";
    gnet_property->props[47].desc = _("Maximum number of seconds a node can remain in transmit flow control before being kicked out.");
    gnet_property->props[47].ev_changed = event_new("node_tx_flowc_timeout_changed");
    gnet_property->props[47].save = TRUE;
    gnet_property->props[47].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[47].type               = PROP_TYPE_GUINT32;
    gnet_property->props[47].data.guint32.def   = &node_tx_flowc_timeout_def;
    gnet_property->props[47].data.guint32.value = &node_tx_flowc_timeout;
    gnet_property->props[47].data.guint32.choices = NULL;
    gnet_property->props[47].data.guint32.max   = 7200;
    gnet_property->props[47].data.guint32.min   = 90;


    /*
     * PROP_NODE_RX_FLOWC_RATIO:
     *
     * General data:
     */
    gnet_property->props[48].name = "node_rx_flowc_ratio";
    gnet_property->props[48].desc = _("Maximum percentage of time over 5 minutes that our node can remain in flow control remotely before dropping the connection.  This only works with nodes that will send us an hops-flow message when they are flow-controlling us.");
    gnet_property->props[48].ev_changed = event_new("node_rx_flowc_ratio_changed");
    gnet_property->props[48].save = TRUE;
    gnet_property->props[48].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[48].type               = PROP_TYPE_GUINT32;
    gnet_property->props[48].data.guint32.def   = &node_rx_flowc_ratio_def;
    gnet_property->props[48].data.guint32.value = &node_rx_flowc_ratio;
    gnet_property->props[48].data.guint32.choices = NULL;
    gnet_property->props[48].data.guint32.max   = 100;
    gnet_property->props[48].data.guint32.min   = 30;


    /*
     * PROP_MAX_TTL:
     *
     * General data:
     */
    gnet_property->props[49].name = "max_ttl";
    gnet_property->props[49].desc = _("Maximum TTL we allow in messages we broadcast.  If a query comes in with a TTL greater than that, it will be trimmed down to that value.  On Gnutella, the standard is TTL=4, so you cannot set a value lower than that.");
    gnet_property->props[49].ev_changed = event_new("max_ttl_changed");
    gnet_property->props[49].save = TRUE;
    gnet_property->props[49].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[49].type               = PROP_TYPE_GUINT32;
    gnet_property->props[49].data.guint32.def   = &max_ttl_def;
    gnet_property->props[49].data.guint32.value = &max_ttl;
    gnet_property->props[49].data.guint32.choices = NULL;
    gnet_property->props[49].data.guint32.max   = 5;
    gnet_property->props[49].data.guint32.min   = 4;


    /*
     * PROP_MY_TTL:
     *
     * General data:
     */
    gnet_property->props[50].name = "my_ttl";
    gnet_property->props[50].desc = _("The TTL we use in messages we generate.  The default on Gnutella is TTL=4.  If you set it to too large a value, you run the risk of being trimmed down by fellow gtk-gnutella nodes, or kicked out by some other servent.");
    gnet_property->props[50].ev_changed = event_new("my_ttl_changed");
    gnet_property->props[50].save = TRUE;
    gnet_property->props[50].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[50].type               = PROP_TYPE_GUINT32;
    gnet_property->props[50].data.guint32.def   = &my_ttl_def;
    gnet_property->props[50].data.guint32.value = &my_ttl;
    gnet_property->props[50].data.guint32.choices = NULL;
    gnet_property->props[50].data.guint32.max   = 4;
    gnet_property->props[50].data.guint32.min   = 1;


    /*
     * PROP_HARD_TTL_LIMIT:
     *
     * General data:
     */
    gnet_property->props[51].name = "hard_ttl_limit";
    gnet_property->props[51].desc = _("Maximum hard TTL limit (hops + TTL) on messages we relay.  This should be greater than the standard TTL=4, because it is also applied to routed-back messages (query hits) that could be re-routed in case a connection is lost.  Standard broadcasted messages have their TTL limited by the maximum TTL you configure, and that limit should be much lower than the value of this parameter.");
    gnet_property->props[51].ev_changed = event_new("hard_ttl_limit_changed");
    gnet_property->props[51].save = TRUE;
    gnet_property->props[51].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[51].type               = PROP_TYPE_GUINT32;
    gnet_property->props[51].data.guint32.def   = &hard_ttl_limit_def;
    gnet_property->props[51].data.guint32.value = &hard_ttl_limit;
    gnet_property->props[51].data.guint32.choices = NULL;
    gnet_property->props[51].data.guint32.max   = 25;
    gnet_property->props[51].data.guint32.min   = 9;


    /*
     * PROP_DBG:
     *
     * General data:
     */
    gnet_property->props[52].name = "dbg";
    gnet_property->props[52].desc = _("For development use: debug level.");
    gnet_property->props[52].ev_changed = event_new("dbg_changed");
    gnet_property->props[52].save = TRUE;
    gnet_property->props[52].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[52].type               = PROP_TYPE_GUINT32;
    gnet_property->props[52].data.guint32.def   = &dbg_def;
    gnet_property->props[52].data.guint32.value = &dbg;
    gnet_property->props[52].data.guint32.choices = NULL;
    gnet_property->props[52].data.guint32.max   = 20;
    gnet_property->props[52].data.guint32.min   = 0;


    /*
     * PROP_LIB_DEBUG:
     *
     * General data:
     */
    gnet_property->props[53].name = "lib_debug";
    gnet_property->props[53].desc = _("Debug level for code shared between gui and core.");
    gnet_property->props[53].ev_changed = event_new("lib_debug_changed");
    gnet_property->props[53].save = TRUE;
    gnet_property->props[53].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[53].type               = PROP_TYPE_GUINT32;
    gnet_property->props[53].data.guint32.def   = &lib_debug_def;
    gnet_property->props[53].data.guint32.value = &lib_debug;
    gnet_property->props[53].data.guint32.choices = NULL;
    gnet_property->props[53].data.guint32.max   = 0xFFFFFFFF;
    gnet_property->props[53].data.guint32.min   = 0x00000000;


    /*
     * PROP_BITZI_DEBUG:
     *
     * General data:
     */
    gnet_property->props[54].name = "bitzi_debug";
    gnet_property->props[54].desc = _("Verbosity of Bitzi related debug messages.");
    gnet_property->props[54].ev_changed = event_new("bitzi_debug_changed");
    gnet_property->props[54].save = TRUE;
    gnet_property->props[54].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[54].type               = PROP_TYPE_GUINT32;
    gnet_property->props[54].data.guint32.def   = &bitzi_debug_def;
    gnet_property->props[54].data.guint32.value = &bitzi_debug;
    gnet_property->props[54].data.guint32.choices = NULL;
    gnet_property->props[54].data.guint32.max   = 20;
    gnet_property->props[54].data.guint32.min   = 0;


    /*
     * PROP_GWC_DEBUG:
     *
     * General data:
     */
    gnet_property->props[55].name = "gwc_debug";
    gnet_property->props[55].desc = _("Verbosity of GWebCache related debug messages.");
    gnet_property->props[55].ev_changed = event_new("gwc_debug_changed");
    gnet_property->props[55].save = TRUE;
    gnet_property->props[55].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[55].type               = PROP_TYPE_GUINT32;
    gnet_property->props[55].data.guint32.def   = &gwc_debug_def;
    gnet_property->props[55].data.guint32.value = &gwc_debug;
    gnet_property->props[55].data.guint32.choices = NULL;
    gnet_property->props[55].data.guint32.max   = 20;
    gnet_property->props[55].data.guint32.min   = 0;


    /*
     * PROP_URL_DEBUG:
     *
     * General data:
     */
    gnet_property->props[56].name = "url_debug";
    gnet_property->props[56].desc = _("Verbosity of URL handling related debug messages.");
    gnet_property->props[56].ev_changed = event_new("url_debug_changed");
    gnet_property->props[56].save = TRUE;
    gnet_property->props[56].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[56].type               = PROP_TYPE_GUINT32;
    gnet_property->props[56].data.guint32.def   = &url_debug_def;
    gnet_property->props[56].data.guint32.value = &url_debug;
    gnet_property->props[56].data.guint32.choices = NULL;
    gnet_property->props[56].data.guint32.max   = 20;
    gnet_property->props[56].data.guint32.min   = 0;


    /*
     * PROP_DH_DEBUG:
     *
     * General data:
     */
    gnet_property->props[57].name = "dh_debug";
    gnet_property->props[57].desc = _("Debug level for dynamic query hit routing.");
    gnet_property->props[57].ev_changed = event_new("dh_debug_changed");
    gnet_property->props[57].save = TRUE;
    gnet_property->props[57].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[57].type               = PROP_TYPE_GUINT32;
    gnet_property->props[57].data.guint32.def   = &dh_debug_def;
    gnet_property->props[57].data.guint32.value = &dh_debug;
    gnet_property->props[57].data.guint32.choices = NULL;
    gnet_property->props[57].data.guint32.max   = 20;
    gnet_property->props[57].data.guint32.min   = 0;


    /*
     * PROP_DQ_DEBUG:
     *
     * General data:
     */
    gnet_property->props[58].name = "dq_debug";
    gnet_property->props[58].desc = _("Debug level for dynamic queries.");
    gnet_property->props[58].ev_changed = event_new("dq_debug_changed");
    gnet_property->props[58].save = TRUE;
    gnet_property->props[58].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[58].type               = PROP_TYPE_GUINT32;
    gnet_property->props[58].data.guint32.def   = &dq_debug_def;
    gnet_property->props[58].data.guint32.value = &dq_debug;
    gnet_property->props[58].data.guint32.choices = NULL;
    gnet_property->props[58].data.guint32.max   = 20;
    gnet_property->props[58].data.guint32.min   = 0;


    /*
     * PROP_VMSG_DEBUG:
     *
     * General data:
     */
    gnet_property->props[59].name = "vmsg_debug";
    gnet_property->props[59].desc = _("Debug level for vendor messages.");
    gnet_property->props[59].ev_changed = event_new("vmsg_debug_changed");
    gnet_property->props[59].save = TRUE;
    gnet_property->props[59].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[59].type               = PROP_TYPE_GUINT32;
    gnet_property->props[59].data.guint32.def   = &vmsg_debug_def;
    gnet_property->props[59].data.guint32.value = &vmsg_debug;
    gnet_property->props[59].data.guint32.choices = NULL;
    gnet_property->props[59].data.guint32.max   = 20;
    gnet_property->props[59].data.guint32.min   = 0;


    /*
     * PROP_QUERY_DEBUG:
     *
     * General data:
     */
    gnet_property->props[60].name = "query_debug";
    gnet_property->props[60].desc = _("Debug level for queries.");
    gnet_property->props[60].ev_changed = event_new("query_debug_changed");
    gnet_property->props[60].save = TRUE;
    gnet_property->props[60].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[60].type               = PROP_TYPE_GUINT32;
    gnet_property->props[60].data.guint32.def   = &query_debug_def;
    gnet_property->props[60].data.guint32.value = &query_debug;
    gnet_property->props[60].data.guint32.choices = NULL;
    gnet_property->props[60].data.guint32.max   = 20;
    gnet_property->props[60].data.guint32.min   = 0;


    /*
     * PROP_SEARCH_DEBUG:
     *
     * General data:
     */
    gnet_property->props[61].name = "search_debug";
    gnet_property->props[61].desc = _("Debug level for searches and search results management.");
    gnet_property->props[61].ev_changed = event_new("search_debug_changed");
    gnet_property->props[61].save = TRUE;
    gnet_property->props[61].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[61].type               = PROP_TYPE_GUINT32;
    gnet_property->props[61].data.guint32.def   = &search_debug_def;
    gnet_property->props[61].data.guint32.value = &search_debug;
    gnet_property->props[61].data.guint32.choices = NULL;
    gnet_property->props[61].data.guint32.max   = 20;
    gnet_property->props[61].data.guint32.min   = 0;


    /*
     * PROP_UDP_DEBUG:
     *
     * General data:
     */
    gnet_property->props[62].name = "udp_debug";
    gnet_property->props[62].desc = _("Debug level for the UDP traffic layer.");
    gnet_property->props[62].ev_changed = event_new("udp_debug_changed");
    gnet_property->props[62].save = TRUE;
    gnet_property->props[62].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[62].type               = PROP_TYPE_GUINT32;
    gnet_property->props[62].data.guint32.def   = &udp_debug_def;
    gnet_property->props[62].data.guint32.value = &udp_debug;
    gnet_property->props[62].data.guint32.choices = NULL;
    gnet_property->props[62].data.guint32.max   = 20;
    gnet_property->props[62].data.guint32.min   = 0;


    /*
     * PROP_QRP_DEBUG:
     *
     * General data:
     */
    gnet_property->props[63].name = "qrp_debug";
    gnet_property->props[63].desc = _("Debug level for the Query Routing Protocol.");
    gnet_property->props[63].ev_changed = event_new("qrp_debug_changed");
    gnet_property->props[63].save = TRUE;
    gnet_property->props[63].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[63].type               = PROP_TYPE_GUINT32;
    gnet_property->props[63].data.guint32.def   = &qrp_debug_def;
    gnet_property->props[63].data.guint32.value = &qrp_debug;
    gnet_property->props[63].data.guint32.choices = NULL;
    gnet_property->props[63].data.guint32.max   = 20;
    gnet_property->props[63].data.guint32.min   = 0;


    /*
     * PROP_ROUTING_DEBUG:
     *
     * General data:
     */
    gnet_property->props[64].name = "routing_debug";
    gnet_property->props[64].desc = _("Debug level for message routing.");
    gnet_property->props[64].ev_changed = event_new("routing_debug_changed");
    gnet_property->props[64].save = TRUE;
    gnet_property->props[64].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[64].type               = PROP_TYPE_GUINT32;
    gnet_property->props[64].data.guint32.def   = &routing_debug_def;
    gnet_property->props[64].data.guint32.value = &routing_debug;
    gnet_property->props[64].data.guint32.choices = NULL;
    gnet_property->props[64].data.guint32.max   = 20;
    gnet_property->props[64].data.guint32.min   = 0;


    /*
     * PROP_GGEP_DEBUG:
     *
     * General data:
     */
    gnet_property->props[65].name = "ggep_debug";
    gnet_property->props[65].desc = _("Debug level for GGEP.");
    gnet_property->props[65].ev_changed = event_new("ggep_debug_changed");
    gnet_property->props[65].save = TRUE;
    gnet_property->props[65].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[65].type               = PROP_TYPE_GUINT32;
    gnet_property->props[65].data.guint32.def   = &ggep_debug_def;
    gnet_property->props[65].data.guint32.value = &ggep_debug;
    gnet_property->props[65].data.guint32.choices = NULL;
    gnet_property->props[65].data.guint32.max   = 20;
    gnet_property->props[65].data.guint32.min   = 0;


    /*
     * PROP_PCACHE_DEBUG:
     *
     * General data:
     */
    gnet_property->props[66].name = "pcache_debug";
    gnet_property->props[66].desc = _("Debug level for pong caching.");
    gnet_property->props[66].ev_changed = event_new("pcache_debug_changed");
    gnet_property->props[66].save = TRUE;
    gnet_property->props[66].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[66].type               = PROP_TYPE_GUINT32;
    gnet_property->props[66].data.guint32.def   = &pcache_debug_def;
    gnet_property->props[66].data.guint32.value = &pcache_debug;
    gnet_property->props[66].data.guint32.choices = NULL;
    gnet_property->props[66].data.guint32.max   = 20;
    gnet_property->props[66].data.guint32.min   = 0;


    /*
     * PROP_HSEP_DEBUG:
     *
     * General data:
     */
    gnet_property->props[67].name = "hsep_debug";
    gnet_property->props[67].desc = _("Debug level for HSEP.");
    gnet_property->props[67].ev_changed = event_new("hsep_debug_changed");
    gnet_property->props[67].save = TRUE;
    gnet_property->props[67].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[67].type               = PROP_TYPE_GUINT32;
    gnet_property->props[67].data.guint32.def   = &hsep_debug_def;
    gnet_property->props[67].data.guint32.value = &hsep_debug;
    gnet_property->props[67].data.guint32.choices = NULL;
    gnet_property->props[67].data.guint32.max   = 20;
    gnet_property->props[67].data.guint32.min   = 0;


    /*
     * PROP_TRACK_PROPS:
     *
     * General data:
     */
    gnet_property->props[68].name = "track_props";
    gnet_property->props[68].desc = _("For development use: track properties.");
    gnet_property->props[68].ev_changed = event_new("track_props_changed");
    gnet_property->props[68].save = TRUE;
    gnet_property->props[68].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[68].type               = PROP_TYPE_GUINT32;
    gnet_property->props[68].data.guint32.def   = &track_props_def;
    gnet_property->props[68].data.guint32.value = &track_props;
    gnet_property->props[68].data.guint32.choices = NULL;
    gnet_property->props[68].data.guint32.max   = 20;
    gnet_property->props[68].data.guint32.min   = 0;


    /*
     * PROP_STOP_HOST_GET:
     *
     * General data:
     */
    gnet_property->props[69].name = "stop_host_get";
    gnet_property->props[69].desc = _("For development use: don't add new hosts to the hostcatcher.");
    gnet_property->props[69].ev_changed = event_new("stop_host_get_changed");
    gnet_property->props[69].save = TRUE;
    gnet_property->props[69].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[69].type               = PROP_TYPE_BOOLEAN;
    gnet_property->props[69].data.boolean.def   = &stop_host_get_def;
    gnet_property->props[69].data.boolean.value = &stop_host_get;


    /*
     * PROP_BW_HTTP_IN_ENABLED:
     *
     * General data:
     */
    gnet_property->props[70].name = "bandwidth_input_limit";
    gnet_property->props[70].desc = _("Enable bandwidth limitation for incoming HTTP traffic.");
    gnet_property->props[70].ev_changed = event_new("bw_http_in_enabled_changed");
    gnet_property->props[70].save = TRUE;
    gnet_property->props[70].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[70].type               = PROP_TYPE_BOOLEAN;
    gnet_property->props[70].data.boolean.def   = &bws_in_enabled_def;
    gnet_property->props[70].data.boolean.value = &bws_in_enabled;


    /*
     * PROP_BW_HTTP_OUT_ENABLED:
     *
     * General data:
     */
    gnet_property->props[71].name = "bandwidth_output_limit";
    gnet_property->props[71].desc = _("Enable bandwidth limitation for outgoing HTTP traffic.");
    gnet_property->props[71].ev_changed = event_new("bw_http_out_enabled_changed");
    gnet_property->props[71].save = TRUE;
    gnet_property->props[71].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[71].type               = PROP_TYPE_BOOLEAN;
    gnet_property->props[71].data.boolean.def   = &bws_out_enabled_def;
    gnet_property->props[71].data.boolean.value = &bws_out_enabled;


    /*
     * PROP_BW_GNET_IN_ENABLED:
     *
     * General data:
     */
    gnet_property->props[72].name = "bandwidth_ginput_limit";
    gnet_property->props[72].desc = _("Enable bandwidth limitation for incoming Gnet traffic.");
    gnet_property->props[72].ev_changed = event_new("bw_gnet_in_enabled_changed");
    gnet_property->props[72].save = TRUE;
    gnet_property->props[72].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[72].type               = PROP_TYPE_BOOLEAN;
    gnet_property->props[72].data.boolean.def   = &bws_gin_enabled_def;
    gnet_property->props[72].data.boolean.value = &bws_gin_enabled;


    /*
     * PROP_BW_GNET_LEAF_IN_ENABLED:
     *
     * General data:
     */
    gnet_property->props[73].name = "bandwidth_glinput_limit";
    gnet_property->props[73].desc = _("Enable bandwidth limitation for incoming Gnet leaf traffic.");
    gnet_property->props[73].ev_changed = event_new("bw_gnet_leaf_in_enabled_changed");
    gnet_property->props[73].save = TRUE;
    gnet_property->props[73].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[73].type               = PROP_TYPE_BOOLEAN;
    gnet_property->props[73].data.boolean.def   = &bws_glin_enabled_def;
    gnet_property->props[73].data.boolean.value = &bws_glin_enabled;


    /*
     * PROP_BW_GNET_OUT_ENABLED:
     *
     * General data:
     */
    gnet_property->props[74].name = "bandwidth_goutput_limit";
    gnet_property->props[74].desc = _("Enable bandwidth limitation for outgoing Gnet traffic.");
    gnet_property->props[74].ev_changed = event_new("bw_gnet_out_enabled_changed");
    gnet_property->props[74].save = TRUE;
    gnet_property->props[74].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[74].type               = PROP_TYPE_BOOLEAN;
    gnet_property->props[74].data.boolean.def   = &bws_gout_enabled_def;
    gnet_property->props[74].data.boolean.value = &bws_gout_enabled;


    /*
     * PROP_BW_GNET_LEAF_OUT_ENABLED:
     *
     * General data:
     */
    gnet_property->props[75].name = "bandwidth_gloutput_limit";
    gnet_property->props[75].desc = _("Enable bandwidth limitation for outgoing Gnet leaf traffic.");
    gnet_property->props[75].ev_changed = event_new("bw_gnet_leaf_out_enabled_changed");
    gnet_property->props[75].save = TRUE;
    gnet_property->props[75].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[75].type               = PROP_TYPE_BOOLEAN;
    gnet_property->props[75].data.boolean.def   = &bws_glout_enabled_def;
    gnet_property->props[75].data.boolean.value = &bws_glout_enabled;


    /*
     * PROP_BW_UL_USAGE_ENABLED:
     *
     * General data:
     */
    gnet_property->props[76].name = "upload_bandwith_usage_enabled";
    gnet_property->props[76].desc = _("Enable dynamic upload slots allocation.");
    gnet_property->props[76].ev_changed = event_new("bw_ul_usage_enabled_changed");
    gnet_property->props[76].save = TRUE;
    gnet_property->props[76].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[76].type               = PROP_TYPE_BOOLEAN;
    gnet_property->props[76].data.boolean.def   = &bw_ul_usage_enabled_def;
    gnet_property->props[76].data.boolean.value = &bw_ul_usage_enabled;


    /*
     * PROP_BW_ALLOW_STEALING:
     *
     * General data:
     */
    gnet_property->props[77].name = "bw_allow_stealing";
    gnet_property->props[77].desc = _("Allow HTTP and Gnutella to grab whatever bandwidth the other is not using.  If FALSE, unused bandwidth is lost.");
    gnet_property->props[77].ev_changed = event_new("bw_allow_stealing_changed");
    gnet_property->props[77].save = TRUE;
    gnet_property->props[77].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[77].type               = PROP_TYPE_BOOLEAN;
    gnet_property->props[77].data.boolean.def   = &bw_allow_stealing_def;
    gnet_property->props[77].data.boolean.value = &bw_allow_stealing;


    /*
     * PROP_AUTOCLEAR_COMPLETED_DOWNLOADS:
     *
     * General data:
     */
    gnet_property->props[78].name = "auto_clear_completed_downloads";
    gnet_property->props[78].desc = _("Auto clear completed downloads.");
    gnet_property->props[78].ev_changed = event_new("autoclear_completed_downloads_changed");
    gnet_property->props[78].save = TRUE;
    gnet_property->props[78].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[78].type               = PROP_TYPE_BOOLEAN;
    gnet_property->props[78].data.boolean.def   = &clear_complete_downloads_def;
    gnet_property->props[78].data.boolean.value = &clear_complete_downloads;


    /*
     * PROP_AUTOCLEAR_FAILED_DOWNLOADS:
     *
     * General data:
     */
    gnet_property->props[79].name = "auto_clear_failed_downloads";
    gnet_property->props[79].desc = _("Auto clear failed downloads (HTTP error, failure to resume, write error, etc...).");
    gnet_property->props[79].ev_changed = event_new("autoclear_failed_downloads_changed");
    gnet_property->props[79].save = TRUE;
    gnet_property->props[79].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[79].type               = PROP_TYPE_BOOLEAN;
    gnet_property->props[79].data.boolean.def   = &clear_failed_downloads_def;
    gnet_property->props[79].data.boolean.value = &clear_failed_downloads;


    /*
     * PROP_AUTOCLEAR_UNAVAILABLE_DOWNLOADS:
     *
     * General data:
     */
    gnet_property->props[80].name = "auto_clear_unavailable_downloads";
    gnet_property->props[80].desc = _("Auto clear unavailable downloads (connection timeout, push route lost, etc...).");
    gnet_property->props[80].ev_changed = event_new("autoclear_unavailable_downloads_changed");
    gnet_property->props[80].save = TRUE;
    gnet_property->props[80].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[80].type               = PROP_TYPE_BOOLEAN;
    gnet_property->props[80].data.boolean.def   = &clear_unavailable_downloads_def;
    gnet_property->props[80].data.boolean.value = &clear_unavailable_downloads;


    /*
     * PROP_SEARCH_REMOVE_DOWNLOADED:
     *
     * General data:
     */
    gnet_property->props[81].name = "search_remove_downloaded";
    gnet_property->props[81].desc = _("Remove downloaded files from the search result.");
    gnet_property->props[81].ev_changed = event_new("search_remove_downloaded_changed");
    gnet_property->props[81].save = TRUE;
    gnet_property->props[81].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[81].type               = PROP_TYPE_BOOLEAN;
    gnet_property->props[81].data.boolean.def   = &search_remove_downloaded_def;
    gnet_property->props[81].data.boolean.value = &search_remove_downloaded;


    /*
     * PROP_FORCE_LOCAL_IP:
     *
     * General data:
     */
    gnet_property->props[82].name = "force_local_ip";
    gnet_property->props[82].desc = _("Enable to use [forced_local_ip] as local ip.");
    gnet_property->props[82].ev_changed = event_new("force_local_ip_changed");
    gnet_property->props[82].save = TRUE;
    gnet_property->props[82].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[82].type               = PROP_TYPE_BOOLEAN;
    gnet_property->props[82].data.boolean.def   = &force_local_ip_def;
    gnet_property->props[82].data.boolean.value = &force_local_ip;


    /*
     * PROP_USE_NETMASKS:
     *
     * General data:
     */
    gnet_property->props[83].name = "use_netmasks";
    gnet_property->props[83].desc = _("Try to connect to local networks first.");
    gnet_property->props[83].ev_changed = event_new("use_netmasks_changed");
    gnet_property->props[83].save = TRUE;
    gnet_property->props[83].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[83].type               = PROP_TYPE_BOOLEAN;
    gnet_property->props[83].data.boolean.def   = &use_netmasks_def;
    gnet_property->props[83].data.boolean.value = &use_netmasks;


    /*
     * PROP_ALLOW_PRIVATE_NETWORK_CONNECTION:
     *
     * General data:
     */
    gnet_property->props[84].name = "allow_private_network_connection";
    gnet_property->props[84].desc = _("Check this button if you want to use Gtk-Gnutella on your Local Area Network. RFC1918 will be ignored.");
    gnet_property->props[84].ev_changed = event_new("allow_private_network_connection_changed");
    gnet_property->props[84].save = TRUE;
    gnet_property->props[84].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[84].type               = PROP_TYPE_BOOLEAN;
    gnet_property->props[84].data.boolean.def   = &allow_private_network_connection_def;
    gnet_property->props[84].data.boolean.value = &allow_private_network_connection;


    /*
     * PROP_USE_IP_TOS:
     *
     * General data:
     */
    gnet_property->props[85].name = "use_ip_tos";
    gnet_property->props[85].desc = _("Check this button if you want Gtk-Gnutella to use IP TOS to differentiate interactive, normal and bulk data. This is probably a good idea in most cases, and can particularly help with badly misconfigured hosts, LANs, and ISPs.");
    gnet_property->props[85].ev_changed = event_new("use_ip_tos_changed");
    gnet_property->props[85].save = TRUE;
    gnet_property->props[85].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[85].type               = PROP_TYPE_BOOLEAN;
    gnet_property->props[85].data.boolean.def   = &use_ip_tos_def;
    gnet_property->props[85].data.boolean.value = &use_ip_tos;


    /*
     * PROP_DOWNLOAD_DELETE_ABORTED:
     *
     * General data:
     */
    gnet_property->props[86].name = "download_delete_aborted";
    gnet_property->props[86].desc = _("Remove files of aborted downloads from disk.");
    gnet_property->props[86].ev_changed = event_new("download_delete_aborted_changed");
    gnet_property->props[86].save = TRUE;
    gnet_property->props[86].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[86].type               = PROP_TYPE_BOOLEAN;
    gnet_property->props[86].data.boolean.def   = &download_delete_aborted_def;
    gnet_property->props[86].data.boolean.value = &download_delete_aborted;


    /*
     * PROP_PROXY_AUTH:
     *
     * General data:
     */
    gnet_property->props[87].name = "proxy_auth";
    gnet_property->props[87].desc = _("Use username and password to authenticate to proxy.");
    gnet_property->props[87].ev_changed = event_new("proxy_auth_changed");
    gnet_property->props[87].save = TRUE;
    gnet_property->props[87].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[87].type               = PROP_TYPE_BOOLEAN;
    gnet_property->props[87].data.boolean.def   = &proxy_auth_def;
    gnet_property->props[87].data.boolean.value = &proxy_auth;


    /*
     * PROP_SOCKS_USER:
     *
     * General data:
     */
    gnet_property->props[88].name = "socks_user";
    gnet_property->props[88].desc = _("Username for proxy.");
    gnet_property->props[88].ev_changed = event_new("socks_user_changed");
    gnet_property->props[88].save = TRUE;
    gnet_property->props[88].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[88].type               = PROP_TYPE_STRING;
    gnet_property->props[88].data.string.def    = &socks_user_def;
    gnet_property->props[88].data.string.value  = &socks_user;
    if (gnet_property->props[88].data.string.def) {
        *gnet_property->props[88].data.string.value =
            g_strdup(eval_subst(*gnet_property->props[88].data.string.def));
    }


    /*
     * PROP_SOCKS_PASS:
     *
     * General data:
     */
    gnet_property->props[89].name = "socks_pass";
    gnet_property->props[89].desc = _("Password for proxy.");
    gnet_property->props[89].ev_changed = event_new("socks_pass_changed");
    gnet_property->props[89].save = TRUE;
    gnet_property->props[89].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[89].type               = PROP_TYPE_STRING;
    gnet_property->props[89].data.string.def    = &socks_pass_def;
    gnet_property->props[89].data.string.value  = &socks_pass;
    if (gnet_property->props[89].data.string.def) {
        *gnet_property->props[89].data.string.value =
            g_strdup(eval_subst(*gnet_property->props[89].data.string.def));
    }


    /*
     * PROP_PROXY_IP:
     *
     * General data:
     */
    gnet_property->props[90].name = "proxy_ip";
    gnet_property->props[90].desc = _("IP address of the proxy.");
    gnet_property->props[90].ev_changed = event_new("proxy_ip_changed");
    gnet_property->props[90].save = FALSE;
    gnet_property->props[90].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[90].type               = PROP_TYPE_IP;
    gnet_property->props[90].data.guint32.def   = &proxy_ip_def;
    gnet_property->props[90].data.guint32.value = &proxy_ip;
    gnet_property->props[90].data.guint32.choices = NULL;
    gnet_property->props[90].data.guint32.max   = 0xFFFFFFFF;
    gnet_property->props[90].data.guint32.min   = 0x00000000;


    /*
     * PROP_PROXY_HOSTNAME:
     *
     * General data:
     */
    gnet_property->props[91].name = "proxy_hostname";
    gnet_property->props[91].desc = _("Hostname of the proxy.");
    gnet_property->props[91].ev_changed = event_new("proxy_hostname_changed");
    gnet_property->props[91].save = TRUE;
    gnet_property->props[91].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[91].type               = PROP_TYPE_STRING;
    gnet_property->props[91].data.string.def    = &proxy_hostname_def;
    gnet_property->props[91].data.string.value  = &proxy_hostname;
    if (gnet_property->props[91].data.string.def) {
        *gnet_property->props[91].data.string.value =
            g_strdup(eval_subst(*gnet_property->props[91].data.string.def));
    }


    /*
     * PROP_PROXY_PORT:
     *
     * General data:
     */
    gnet_property->props[92].name = "proxy_port";
    gnet_property->props[92].desc = _("TCP Port the proxy is listening on.");
    gnet_property->props[92].ev_changed = event_new("proxy_port_changed");
    gnet_property->props[92].save = TRUE;
    gnet_property->props[92].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[92].type               = PROP_TYPE_GUINT32;
    gnet_property->props[92].data.guint32.def   = &proxy_port_def;
    gnet_property->props[92].data.guint32.value = &proxy_port;
    gnet_property->props[92].data.guint32.choices = NULL;
    gnet_property->props[92].data.guint32.max   = 0xFFFF;
    gnet_property->props[92].data.guint32.min   = 0x0000;


    /*
     * PROP_PROXY_PROTOCOL:
     *
     * General data:
     */
    gnet_property->props[93].name = "proxy_protocol";
    gnet_property->props[93].desc = _("Protocol the proxy uses.");
    gnet_property->props[93].ev_changed = event_new("proxy_protocol_changed");
    gnet_property->props[93].save = TRUE;
    gnet_property->props[93].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[93].type               = PROP_TYPE_MULTICHOICE;
    gnet_property->props[93].data.guint32.def   = &proxy_protocol_def;
    gnet_property->props[93].data.guint32.value = &proxy_protocol;
    gnet_property->props[93].data.guint32.max   = 0xFFFFFFFF;
    gnet_property->props[93].data.guint32.min   = 0x00000000;
    gnet_property->props[93].data.guint32.choices = proxy_protocol_choices;


    /*
     * PROP_HOSTS_IN_CATCHER:
     *
     * General data:
     */
    gnet_property->props[94].name = "hosts_in_catcher";
    gnet_property->props[94].desc = _("Current number of hosts in regular node caches.");
    gnet_property->props[94].ev_changed = event_new("hosts_in_catcher_changed");
    gnet_property->props[94].save = FALSE;
    gnet_property->props[94].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[94].type               = PROP_TYPE_GUINT32;
    gnet_property->props[94].data.guint32.def   = &hosts_in_catcher_def;
    gnet_property->props[94].data.guint32.value = &hosts_in_catcher;
    gnet_property->props[94].data.guint32.choices = NULL;
    gnet_property->props[94].data.guint32.max   = 999999;
    gnet_property->props[94].data.guint32.min   = 0;


    /*
     * PROP_HOSTS_IN_ULTRA_CATCHER:
     *
     * General data:
     */
    gnet_property->props[95].name = "hosts_in_ultra_catcher";
    gnet_property->props[95].desc = _("Current number of hosts in ultra node caches.");
    gnet_property->props[95].ev_changed = event_new("hosts_in_ultra_catcher_changed");
    gnet_property->props[95].save = FALSE;
    gnet_property->props[95].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[95].type               = PROP_TYPE_GUINT32;
    gnet_property->props[95].data.guint32.def   = &hosts_in_ultra_catcher_def;
    gnet_property->props[95].data.guint32.value = &hosts_in_ultra_catcher;
    gnet_property->props[95].data.guint32.choices = NULL;
    gnet_property->props[95].data.guint32.max   = 999999;
    gnet_property->props[95].data.guint32.min   = 0;


    /*
     * PROP_HOSTS_IN_BAD_CATCHER:
     *
     * General data:
     */
    gnet_property->props[96].name = "hosts_in_bad_catcher";
    gnet_property->props[96].desc = _("Current number of hosts in bad node caches.");
    gnet_property->props[96].ev_changed = event_new("hosts_in_bad_catcher_changed");
    gnet_property->props[96].save = FALSE;
    gnet_property->props[96].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[96].type               = PROP_TYPE_GUINT32;
    gnet_property->props[96].data.guint32.def   = &hosts_in_bad_catcher_def;
    gnet_property->props[96].data.guint32.value = &hosts_in_bad_catcher;
    gnet_property->props[96].data.guint32.choices = NULL;
    gnet_property->props[96].data.guint32.max   = 999999;
    gnet_property->props[96].data.guint32.min   = 0;


    /*
     * PROP_MAX_HOSTS_CACHED:
     *
     * General data:
     */
    gnet_property->props[97].name = "max_hosts_cached";
    gnet_property->props[97].desc = _("Maximum number of hosts in the regular node catcher.");
    gnet_property->props[97].ev_changed = event_new("max_hosts_cached_changed");
    gnet_property->props[97].save = TRUE;
    gnet_property->props[97].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[97].type               = PROP_TYPE_GUINT32;
    gnet_property->props[97].data.guint32.def   = &max_hosts_cached_def;
    gnet_property->props[97].data.guint32.value = &max_hosts_cached;
    gnet_property->props[97].data.guint32.choices = NULL;
    gnet_property->props[97].data.guint32.max   = 50000;
    gnet_property->props[97].data.guint32.min   = 100;


    /*
     * PROP_MAX_ULTRA_HOSTS_CACHED:
     *
     * General data:
     */
    gnet_property->props[98].name = "max_ultra_hosts_cached";
    gnet_property->props[98].desc = _("Maximum number of hosts in the ultra node catcher.");
    gnet_property->props[98].ev_changed = event_new("max_ultra_hosts_cached_changed");
    gnet_property->props[98].save = TRUE;
    gnet_property->props[98].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[98].type               = PROP_TYPE_GUINT32;
    gnet_property->props[98].data.guint32.def   = &max_ultra_hosts_cached_def;
    gnet_property->props[98].data.guint32.value = &max_ultra_hosts_cached;
    gnet_property->props[98].data.guint32.choices = NULL;
    gnet_property->props[98].data.guint32.max   = 50000;
    gnet_property->props[98].data.guint32.min   = 100;


    /*
     * PROP_MAX_BAD_HOSTS_CACHED:
     *
     * General data:
     */
    gnet_property->props[99].name = "max_bad_hosts_cached";
    gnet_property->props[99].desc = _("Maximum number of hosts in the BUSY, UNSTABLE and TIMEOUT lists.");
    gnet_property->props[99].ev_changed = event_new("max_bad_hosts_cached_changed");
    gnet_property->props[99].save = TRUE;
    gnet_property->props[99].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[99].type               = PROP_TYPE_GUINT32;
    gnet_property->props[99].data.guint32.def   = &max_bad_hosts_cached_def;
    gnet_property->props[99].data.guint32.value = &max_bad_hosts_cached;
    gnet_property->props[99].data.guint32.choices = NULL;
    gnet_property->props[99].data.guint32.max   = 50000;
    gnet_property->props[99].data.guint32.min   = 100;


    /*
     * PROP_MAX_HIGH_TTL_MSG:
     *
     * General data:
     */
    gnet_property->props[100].name = "max_high_ttl_msg";
    gnet_property->props[100].desc = _("Amount of tolerable messages above hard TTL limit per node. See also MAX_HIGH_TTL_RADIUS");
    gnet_property->props[100].ev_changed = event_new("max_high_ttl_msg_changed");
    gnet_property->props[100].save = TRUE;
    gnet_property->props[100].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[100].type               = PROP_TYPE_GUINT32;
    gnet_property->props[100].data.guint32.def   = &max_high_ttl_msg_def;
    gnet_property->props[100].data.guint32.value = &max_high_ttl_msg;
    gnet_property->props[100].data.guint32.choices = NULL;
    gnet_property->props[100].data.guint32.max   = 10000;
    gnet_property->props[100].data.guint32.min   = 0;


    /*
     * PROP_MAX_HIGH_TTL_RADIUS:
     *
     * General data:
     */
    gnet_property->props[101].name = "max_high_ttl_radius";
    gnet_property->props[101].desc = _("Hop radius for counting high TTL limit messages (# hops lower than...). See also MAX_HIGH_TTL_MSG");
    gnet_property->props[101].ev_changed = event_new("max_high_ttl_radius_changed");
    gnet_property->props[101].save = TRUE;
    gnet_property->props[101].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[101].type               = PROP_TYPE_GUINT32;
    gnet_property->props[101].data.guint32.def   = &max_high_ttl_radius_def;
    gnet_property->props[101].data.guint32.value = &max_high_ttl_radius;
    gnet_property->props[101].data.guint32.choices = NULL;
    gnet_property->props[101].data.guint32.max   = 10;
    gnet_property->props[101].data.guint32.min   = 0;


    /*
     * PROP_BW_HTTP_IN:
     *
     * General data:
     */
    gnet_property->props[102].name = "input_bandwidth";
    gnet_property->props[102].desc = _("Bandwidth limit for incoming HTTP traffic in bytes/sec.");
    gnet_property->props[102].ev_changed = event_new("bw_http_in_changed");
    gnet_property->props[102].save = TRUE;
    gnet_property->props[102].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[102].type               = PROP_TYPE_GUINT32;
    gnet_property->props[102].data.guint32.def   = &bw_http_in_def;
    gnet_property->props[102].data.guint32.value = &bw_http_in;
    gnet_property->props[102].data.guint32.choices = NULL;
    gnet_property->props[102].data.guint32.max   = BS_BW_MAX;
    gnet_property->props[102].data.guint32.min   = 1024;


    /*
     * PROP_BW_HTTP_OUT:
     *
     * General data:
     */
    gnet_property->props[103].name = "output_bandwidth";
    gnet_property->props[103].desc = _("Bandwidth limit for outgoing HTTP traffic in bytes/sec.");
    gnet_property->props[103].ev_changed = event_new("bw_http_out_changed");
    gnet_property->props[103].save = TRUE;
    gnet_property->props[103].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[103].type               = PROP_TYPE_GUINT32;
    gnet_property->props[103].data.guint32.def   = &bw_http_out_def;
    gnet_property->props[103].data.guint32.value = &bw_http_out;
    gnet_property->props[103].data.guint32.choices = NULL;
    gnet_property->props[103].data.guint32.max   = BS_BW_MAX;
    gnet_property->props[103].data.guint32.min   = 1024;


    /*
     * PROP_BW_GNET_IN:
     *
     * General data:
     */
    gnet_property->props[104].name = "input_gnet_bandwidth";
    gnet_property->props[104].desc = _("Bandwidth limit for incoming Gnet traffic in bytes/sec.");
    gnet_property->props[104].ev_changed = event_new("bw_gnet_in_changed");
    gnet_property->props[104].save = TRUE;
    gnet_property->props[104].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[104].type               = PROP_TYPE_GUINT32;
    gnet_property->props[104].data.guint32.def   = &bw_gnet_in_def;
    gnet_property->props[104].data.guint32.value = &bw_gnet_in;
    gnet_property->props[104].data.guint32.choices = NULL;
    gnet_property->props[104].data.guint32.max   = BS_BW_MAX;
    gnet_property->props[104].data.guint32.min   = 1024;


    /*
     * PROP_BW_GNET_OUT:
     *
     * General data:
     */
    gnet_property->props[105].name = "output_gnet_bandwidth";
    gnet_property->props[105].desc = _("Bandwidth limit for outgoing Gnet traffic in bytes/sec.");
    gnet_property->props[105].ev_changed = event_new("bw_gnet_out_changed");
    gnet_property->props[105].save = TRUE;
    gnet_property->props[105].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[105].type               = PROP_TYPE_GUINT32;
    gnet_property->props[105].data.guint32.def   = &bw_gnet_out_def;
    gnet_property->props[105].data.guint32.value = &bw_gnet_out;
    gnet_property->props[105].data.guint32.choices = NULL;
    gnet_property->props[105].data.guint32.max   = BS_BW_MAX;
    gnet_property->props[105].data.guint32.min   = 1024;


    /*
     * PROP_BW_GNET_LIN:
     *
     * General data:
     */
    gnet_property->props[106].name = "input_gnet_leaf_bandwidth";
    gnet_property->props[106].desc = _("Bandwidth limit for incoming Gnet leaf traffic in bytes/sec. When running as an ultra node, this bandwidth is stolen from the regular HTTP traffic if the shaper for leaves is enabled.");
    gnet_property->props[106].ev_changed = event_new("bw_gnet_lin_changed");
    gnet_property->props[106].save = TRUE;
    gnet_property->props[106].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[106].type               = PROP_TYPE_GUINT32;
    gnet_property->props[106].data.guint32.def   = &bw_gnet_lin_def;
    gnet_property->props[106].data.guint32.value = &bw_gnet_lin;
    gnet_property->props[106].data.guint32.choices = NULL;
    gnet_property->props[106].data.guint32.max   = BS_BW_MAX;
    gnet_property->props[106].data.guint32.min   = 1024;


    /*
     * PROP_BW_GNET_LOUT:
     *
     * General data:
     */
    gnet_property->props[107].name = "output_gnet_leaf_bandwidth";
    gnet_property->props[107].desc = _("Bandwidth limit for outgoing Gnet leaf traffic in bytes/sec. When running as an ultra node, this bandwidth is stolen from the regular HTTP traffic, if the shaper for leaves is enabled.");
    gnet_property->props[107].ev_changed = event_new("bw_gnet_lout_changed");
    gnet_property->props[107].save = TRUE;
    gnet_property->props[107].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[107].type               = PROP_TYPE_GUINT32;
    gnet_property->props[107].data.guint32.def   = &bw_gnet_lout_def;
    gnet_property->props[107].data.guint32.value = &bw_gnet_lout;
    gnet_property->props[107].data.guint32.choices = NULL;
    gnet_property->props[107].data.guint32.max   = BS_BW_MAX;
    gnet_property->props[107].data.guint32.min   = 1024;


    /*
     * PROP_SEARCH_QUERIES_FORWARD_SIZE:
     *
     * General data:
     */
    gnet_property->props[108].name = "search_queries_forward_size";
    gnet_property->props[108].desc = _("Maximum size of search queries messages we forward to others  (in bytes).");
    gnet_property->props[108].ev_changed = event_new("search_queries_forward_size_changed");
    gnet_property->props[108].save = TRUE;
    gnet_property->props[108].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[108].type               = PROP_TYPE_GUINT32;
    gnet_property->props[108].data.guint32.def   = &search_queries_forward_size_def;
    gnet_property->props[108].data.guint32.value = &search_queries_forward_size;
    gnet_property->props[108].data.guint32.choices = NULL;
    gnet_property->props[108].data.guint32.max   = 256;
    gnet_property->props[108].data.guint32.min   = 64;


    /*
     * PROP_SEARCH_QUERIES_KICK_SIZE:
     *
     * General data:
     */
    gnet_property->props[109].name = "search_queries_kick_size";
    gnet_property->props[109].desc = _("Maximum size of search queries messages we allow, otherwise close the connection (in bytes).");
    gnet_property->props[109].ev_changed = event_new("search_queries_kick_size_changed");
    gnet_property->props[109].save = TRUE;
    gnet_property->props[109].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[109].type               = PROP_TYPE_GUINT32;
    gnet_property->props[109].data.guint32.def   = &search_queries_kick_size_def;
    gnet_property->props[109].data.guint32.value = &search_queries_kick_size;
    gnet_property->props[109].data.guint32.choices = NULL;
    gnet_property->props[109].data.guint32.max   = 1024;
    gnet_property->props[109].data.guint32.min   = 128;


    /*
     * PROP_SEARCH_ANSWERS_FORWARD_SIZE:
     *
     * General data:
     */
    gnet_property->props[110].name = "search_answers_forward_size";
    gnet_property->props[110].desc = _("Maximum size of search answers messages we forward to others (in bytes).");
    gnet_property->props[110].ev_changed = event_new("search_answers_forward_size_changed");
    gnet_property->props[110].save = TRUE;
    gnet_property->props[110].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[110].type               = PROP_TYPE_GUINT32;
    gnet_property->props[110].data.guint32.def   = &search_answers_forward_size_def;
    gnet_property->props[110].data.guint32.value = &search_answers_forward_size;
    gnet_property->props[110].data.guint32.choices = NULL;
    gnet_property->props[110].data.guint32.max   = 65536;
    gnet_property->props[110].data.guint32.min   = 4096;


    /*
     * PROP_SEARCH_ANSWERS_KICK_SIZE:
     *
     * General data:
     */
    gnet_property->props[111].name = "search_answers_kick_size";
    gnet_property->props[111].desc = _("Maximum size of search answers messages we allow, otherwise close the connection (in bytes).");
    gnet_property->props[111].ev_changed = event_new("search_answers_kick_size_changed");
    gnet_property->props[111].save = TRUE;
    gnet_property->props[111].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[111].type               = PROP_TYPE_GUINT32;
    gnet_property->props[111].data.guint32.def   = &search_answers_kick_size_def;
    gnet_property->props[111].data.guint32.value = &search_answers_kick_size;
    gnet_property->props[111].data.guint32.choices = NULL;
    gnet_property->props[111].data.guint32.max   = 65536;
    gnet_property->props[111].data.guint32.min   = 16384;


    /*
     * PROP_OTHER_MESSAGES_KICK_SIZE:
     *
     * General data:
     */
    gnet_property->props[112].name = "other_messages_kick_size";
    gnet_property->props[112].desc = _("Maximum size of unknown messages we allow, otherwise close the connection (in bytes).");
    gnet_property->props[112].ev_changed = event_new("other_messages_kick_size_changed");
    gnet_property->props[112].save = TRUE;
    gnet_property->props[112].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[112].type               = PROP_TYPE_GUINT32;
    gnet_property->props[112].data.guint32.def   = &other_messages_kick_size_def;
    gnet_property->props[112].data.guint32.value = &other_messages_kick_size;
    gnet_property->props[112].data.guint32.choices = NULL;
    gnet_property->props[112].data.guint32.max   = 65536;
    gnet_property->props[112].data.guint32.min   = 1024;


    /*
     * PROP_HOPS_RANDOM_FACTOR:
     *
     * General data:
     */
    gnet_property->props[113].name = "hops_random_factor";
    gnet_property->props[113].desc = _("Random factor for the hops field in search packets we send between 0 and 3 inclusive).");
    gnet_property->props[113].ev_changed = event_new("hops_random_factor_changed");
    gnet_property->props[113].save = TRUE;
    gnet_property->props[113].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[113].type               = PROP_TYPE_GUINT32;
    gnet_property->props[113].data.guint32.def   = &hops_random_factor_def;
    gnet_property->props[113].data.guint32.value = &hops_random_factor;
    gnet_property->props[113].data.guint32.choices = NULL;
    gnet_property->props[113].data.guint32.max   = 3;
    gnet_property->props[113].data.guint32.min   = 0;


    /*
     * PROP_SEND_PUSHES:
     *
     * General data:
     */
    gnet_property->props[114].name = "send_pushes";
    gnet_property->props[114].desc = _("Whether or not to send push requests.  If you are firewalled, gtk-gnutella will never send push requests anyway.  If you don't let gtk-gnutella send pushes, it will not show search results that would require a push.");
    gnet_property->props[114].ev_changed = event_new("send_pushes_changed");
    gnet_property->props[114].save = TRUE;
    gnet_property->props[114].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[114].type               = PROP_TYPE_BOOLEAN;
    gnet_property->props[114].data.boolean.def   = &send_pushes_def;
    gnet_property->props[114].data.boolean.value = &send_pushes;


    /*
     * PROP_MIN_DUP_MSG:
     *
     * General data:
     */
    gnet_property->props[115].name = "min_dup_msg";
    gnet_property->props[115].desc = _("Minimum amount of dup messages to enable kicking, per node (also see [min_dup_ratio]).");
    gnet_property->props[115].ev_changed = event_new("min_dup_msg_changed");
    gnet_property->props[115].save = TRUE;
    gnet_property->props[115].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[115].type               = PROP_TYPE_GUINT32;
    gnet_property->props[115].data.guint32.def   = &min_dup_msg_def;
    gnet_property->props[115].data.guint32.value = &min_dup_msg;
    gnet_property->props[115].data.guint32.choices = NULL;
    gnet_property->props[115].data.guint32.max   = 99;
    gnet_property->props[115].data.guint32.min   = 1;


    /*
     * PROP_MIN_DUP_RATIO:
     *
     * General data:
     */
    gnet_property->props[116].name = "min_dup_ratio";
    gnet_property->props[116].desc = _("Minimum ratio of dups on received messages, per node (between 0.00 and 100.00) (also see [min_dup_msg]) Note: the value is stored between 0 (0.0) and 10000 (100.0) in the config file.");
    gnet_property->props[116].ev_changed = event_new("min_dup_ratio_changed");
    gnet_property->props[116].save = TRUE;
    gnet_property->props[116].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[116].type               = PROP_TYPE_GUINT32;
    gnet_property->props[116].data.guint32.def   = &min_dup_ratio_def;
    gnet_property->props[116].data.guint32.value = &min_dup_ratio;
    gnet_property->props[116].data.guint32.choices = NULL;
    gnet_property->props[116].data.guint32.max   = 10000;
    gnet_property->props[116].data.guint32.min   = 0;


    /*
     * PROP_SCAN_EXTENSIONS:
     *
     * General data:
     */
    gnet_property->props[117].name = "shared_files_extensions";
    gnet_property->props[117].desc = _("Only files with the given extensions will be shared. The special --all-- extension matches all files, even if they don't have any extension.  Use with care.");
    gnet_property->props[117].ev_changed = event_new("scan_extensions_changed");
    gnet_property->props[117].save = TRUE;
    gnet_property->props[117].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[117].type               = PROP_TYPE_STRING;
    gnet_property->props[117].data.string.def    = &scan_extensions_def;
    gnet_property->props[117].data.string.value  = &scan_extensions;
    if (gnet_property->props[117].data.string.def) {
        *gnet_property->props[117].data.string.value =
            g_strdup(eval_subst(*gnet_property->props[117].data.string.def));
    }


    /*
     * PROP_SCAN_IGNORE_SYMLINK_DIRS:
     *
     * General data:
     */
    gnet_property->props[118].name = "scan_ignore_symlink_dirs";
    gnet_property->props[118].desc = _("Ignore symbolically linked directories when scanning files to share.");
    gnet_property->props[118].ev_changed = event_new("scan_ignore_symlink_dirs_changed");
    gnet_property->props[118].save = TRUE;
    gnet_property->props[118].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[118].type               = PROP_TYPE_BOOLEAN;
    gnet_property->props[118].data.boolean.def   = &scan_ignore_symlink_dirs_def;
    gnet_property->props[118].data.boolean.value = &scan_ignore_symlink_dirs;


    /*
     * PROP_SCAN_IGNORE_SYMLINK_REGFILES:
     *
     * General data:
     */
    gnet_property->props[119].name = "scan_ignore_symlink_regfiles";
    gnet_property->props[119].desc = _("Ignore symbolically linked regular files when scanning files to share.");
    gnet_property->props[119].ev_changed = event_new("scan_ignore_symlink_regfiles_changed");
    gnet_property->props[119].save = TRUE;
    gnet_property->props[119].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[119].type               = PROP_TYPE_BOOLEAN;
    gnet_property->props[119].data.boolean.def   = &scan_ignore_symlink_regfiles_def;
    gnet_property->props[119].data.boolean.value = &scan_ignore_symlink_regfiles;


    /*
     * PROP_SAVE_FILE_PATH:
     *
     * General data:
     */
    gnet_property->props[120].name = "store_downloading_files_to";
    gnet_property->props[120].desc = _("Store incomplete files in this directory.");
    gnet_property->props[120].ev_changed = event_new("save_file_path_changed");
    gnet_property->props[120].save = TRUE;
    gnet_property->props[120].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[120].type               = PROP_TYPE_STRING;
    gnet_property->props[120].data.string.def    = &save_file_path_def;
    gnet_property->props[120].data.string.value  = &save_file_path;
    if (gnet_property->props[120].data.string.def) {
        *gnet_property->props[120].data.string.value =
            g_strdup(eval_subst(*gnet_property->props[120].data.string.def));
    }


    /*
     * PROP_MOVE_FILE_PATH:
     *
     * General data:
     */
    gnet_property->props[121].name = "move_downloading_files_to";
    gnet_property->props[121].desc = _("Move complete files to this directory. If this is set to the SAME directory as the incomplete or corrupted files, files will be renamed with a trailing .OK");
    gnet_property->props[121].ev_changed = event_new("move_file_path_changed");
    gnet_property->props[121].save = TRUE;
    gnet_property->props[121].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[121].type               = PROP_TYPE_STRING;
    gnet_property->props[121].data.string.def    = &move_file_path_def;
    gnet_property->props[121].data.string.value  = &move_file_path;
    if (gnet_property->props[121].data.string.def) {
        *gnet_property->props[121].data.string.value =
            g_strdup(eval_subst(*gnet_property->props[121].data.string.def));
    }


    /*
     * PROP_BAD_FILE_PATH:
     *
     * General data:
     */
    gnet_property->props[122].name = "move_corrupted_files_to";
    gnet_property->props[122].desc = _("Move corrupted, downloaded files to this directory. If this is set to the SAME directory as the incomplete or completed files, files will be renamed with a trailing .BAD");
    gnet_property->props[122].ev_changed = event_new("bad_file_path_changed");
    gnet_property->props[122].save = TRUE;
    gnet_property->props[122].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[122].type               = PROP_TYPE_STRING;
    gnet_property->props[122].data.string.def    = &bad_file_path_def;
    gnet_property->props[122].data.string.value  = &bad_file_path;
    if (gnet_property->props[122].data.string.def) {
        *gnet_property->props[122].data.string.value =
            g_strdup(eval_subst(*gnet_property->props[122].data.string.def));
    }


    /*
     * PROP_SHARED_DIRS_PATHS:
     *
     * General data:
     */
    gnet_property->props[123].name = "shared_dirs";
    gnet_property->props[123].desc = _("Directories which contain shared files.");
    gnet_property->props[123].ev_changed = event_new("shared_dirs_paths_changed");
    gnet_property->props[123].save = TRUE;
    gnet_property->props[123].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[123].type               = PROP_TYPE_STRING;
    gnet_property->props[123].data.string.def    = &shared_dirs_paths_def;
    gnet_property->props[123].data.string.value  = &shared_dirs_paths;
    if (gnet_property->props[123].data.string.def) {
        *gnet_property->props[123].data.string.value =
            g_strdup(eval_subst(*gnet_property->props[123].data.string.def));
    }


    /*
     * PROP_LOCAL_NETMASKS_STRING:
     *
     * General data:
     */
    gnet_property->props[124].name = "local_netmasks";
    gnet_property->props[124].desc = _("List of networks considered local.  This is a list of IP addresses, separated by ';'.  The IP address can be given out fully, as in 192.168.0.1, or be optionally followed by '/' and a network mask prefix length. For instance, 192.168.0.1/24 would represent the whole 192.168.0.* network.");
    gnet_property->props[124].ev_changed = event_new("local_netmasks_string_changed");
    gnet_property->props[124].save = TRUE;
    gnet_property->props[124].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[124].type               = PROP_TYPE_STRING;
    gnet_property->props[124].data.string.def    = &local_netmasks_string_def;
    gnet_property->props[124].data.string.value  = &local_netmasks_string;
    if (gnet_property->props[124].data.string.def) {
        *gnet_property->props[124].data.string.value =
            g_strdup(eval_subst(*gnet_property->props[124].data.string.def));
    }


    /*
     * PROP_TOTAL_DOWNLOADS:
     *
     * General data:
     */
    gnet_property->props[125].name = "total_downloads";
    gnet_property->props[125].desc = _("Total number of completed downloads in this session.");
    gnet_property->props[125].ev_changed = event_new("total_downloads_changed");
    gnet_property->props[125].save = FALSE;
    gnet_property->props[125].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[125].type               = PROP_TYPE_GUINT32;
    gnet_property->props[125].data.guint32.def   = &total_downloads_def;
    gnet_property->props[125].data.guint32.value = &total_downloads;
    gnet_property->props[125].data.guint32.choices = NULL;
    gnet_property->props[125].data.guint32.max   = 0xFFFFFFFF;
    gnet_property->props[125].data.guint32.min   = 0x00000000;


    /*
     * PROP_UL_RUNNING:
     *
     * General data:
     */
    gnet_property->props[126].name = "ul_running";
    gnet_property->props[126].desc = _("Number of running uploads.");
    gnet_property->props[126].ev_changed = event_new("ul_running_changed");
    gnet_property->props[126].save = FALSE;
    gnet_property->props[126].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[126].type               = PROP_TYPE_GUINT32;
    gnet_property->props[126].data.guint32.def   = &ul_running_def;
    gnet_property->props[126].data.guint32.value = &ul_running;
    gnet_property->props[126].data.guint32.choices = NULL;
    gnet_property->props[126].data.guint32.max   = 0xFFFFFFFF;
    gnet_property->props[126].data.guint32.min   = 0x00000000;


    /*
     * PROP_UL_REGISTERED:
     *
     * General data:
     */
    gnet_property->props[127].name = "ul_registered";
    gnet_property->props[127].desc = _("Number of registered (pending) uploads.");
    gnet_property->props[127].ev_changed = event_new("ul_registered_changed");
    gnet_property->props[127].save = FALSE;
    gnet_property->props[127].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[127].type               = PROP_TYPE_GUINT32;
    gnet_property->props[127].data.guint32.def   = &ul_registered_def;
    gnet_property->props[127].data.guint32.value = &ul_registered;
    gnet_property->props[127].data.guint32.choices = NULL;
    gnet_property->props[127].data.guint32.max   = 0xFFFFFFFF;
    gnet_property->props[127].data.guint32.min   = 0x00000000;


    /*
     * PROP_TOTAL_UPLOADS:
     *
     * General data:
     */
    gnet_property->props[128].name = "total_uploads";
    gnet_property->props[128].desc = _("Total number of completed uploads in this session.");
    gnet_property->props[128].ev_changed = event_new("total_uploads_changed");
    gnet_property->props[128].save = FALSE;
    gnet_property->props[128].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[128].type               = PROP_TYPE_GUINT32;
    gnet_property->props[128].data.guint32.def   = &total_uploads_def;
    gnet_property->props[128].data.guint32.value = &total_uploads;
    gnet_property->props[128].data.guint32.choices = NULL;
    gnet_property->props[128].data.guint32.max   = 0xFFFFFFFF;
    gnet_property->props[128].data.guint32.min   = 0x00000000;


    /*
     * PROP_SERVENT_GUID:
     *
     * General data:
     */
    gnet_property->props[129].name = "guid";
    gnet_property->props[129].desc = _("Global Unique IDentifier of this node.");
    gnet_property->props[129].ev_changed = event_new("servent_guid_changed");
    gnet_property->props[129].save = TRUE;
    gnet_property->props[129].vector_size = 16;

    /* Type specific data: */
    gnet_property->props[129].type               = PROP_TYPE_STORAGE;
    gnet_property->props[129].data.storage.value = servent_guid;
    memset(servent_guid, 0, gnet_property->props[129].vector_size);


    /*
     * PROP_USE_SWARMING:
     *
     * General data:
     */
    gnet_property->props[130].name = "use_swarming";
    gnet_property->props[130].desc = _("Whether or not to use swarming (recommended = YES).");
    gnet_property->props[130].ev_changed = event_new("use_swarming_changed");
    gnet_property->props[130].save = TRUE;
    gnet_property->props[130].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[130].type               = PROP_TYPE_BOOLEAN;
    gnet_property->props[130].data.boolean.def   = &use_swarming_def;
    gnet_property->props[130].data.boolean.value = &use_swarming;


    /*
     * PROP_USE_AGGRESSIVE_SWARMING:
     *
     * General data:
     */
    gnet_property->props[131].name = "use_aggressive_swarming";
    gnet_property->props[131].desc = _("Whether or not to launch competing downloads when swarming and there are many sources available with a few chunks left.");
    gnet_property->props[131].ev_changed = event_new("use_aggressive_swarming_changed");
    gnet_property->props[131].save = TRUE;
    gnet_property->props[131].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[131].type               = PROP_TYPE_BOOLEAN;
    gnet_property->props[131].data.boolean.def   = &use_aggressive_swarming_def;
    gnet_property->props[131].data.boolean.value = &use_aggressive_swarming;


    /*
     * PROP_DL_MINCHUNKSIZE:
     *
     * General data:
     */
    gnet_property->props[132].name = "dl_minchunksize";
    gnet_property->props[132].desc = _("Minimum chunk size when swarming.  This is only a hint as gtk-gnutella will download less if you only have a few bytes to get for a file...");
    gnet_property->props[132].ev_changed = event_new("dl_minchunksize_changed");
    gnet_property->props[132].save = TRUE;
    gnet_property->props[132].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[132].type               = PROP_TYPE_GUINT32;
    gnet_property->props[132].data.guint32.def   = &dl_minchunksize_def;
    gnet_property->props[132].data.guint32.value = &dl_minchunksize;
    gnet_property->props[132].data.guint32.choices = NULL;
    gnet_property->props[132].data.guint32.max   = 100*1024*1024;
    gnet_property->props[132].data.guint32.min   = 64*1024;


    /*
     * PROP_DL_MAXCHUNKSIZE:
     *
     * General data:
     */
    gnet_property->props[133].name = "dl_maxchunksize";
    gnet_property->props[133].desc = _("Maximum chunk size when swarming.");
    gnet_property->props[133].ev_changed = event_new("dl_maxchunksize_changed");
    gnet_property->props[133].save = TRUE;
    gnet_property->props[133].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[133].type               = PROP_TYPE_GUINT32;
    gnet_property->props[133].data.guint32.def   = &dl_maxchunksize_def;
    gnet_property->props[133].data.guint32.value = &dl_maxchunksize;
    gnet_property->props[133].data.guint32.choices = NULL;
    gnet_property->props[133].data.guint32.max   = 1000*1024*1024;
    gnet_property->props[133].data.guint32.min   = 64*1024;


    /*
     * PROP_AUTO_DOWNLOAD_IDENTICAL:
     *
     * General data:
     */
    gnet_property->props[134].name = "auto_download_identical";
    gnet_property->props[134].desc = _("Whether or not to automatically queue search results that match a file in the download queue.");
    gnet_property->props[134].ev_changed = event_new("auto_download_identical_changed");
    gnet_property->props[134].save = TRUE;
    gnet_property->props[134].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[134].type               = PROP_TYPE_BOOLEAN;
    gnet_property->props[134].data.boolean.def   = &auto_download_identical_def;
    gnet_property->props[134].data.boolean.value = &auto_download_identical;


    /*
     * PROP_AUTO_FEED_DOWNLOAD_MESH:
     *
     * General data:
     */
    gnet_property->props[135].name = "auto_feed_download_mesh";
    gnet_property->props[135].desc = _("Whether or not to automatically feed the download mesh with data gathered from the query hits that flow through our node. This looks for new entries for files we are sharing or already have in our mesh.");
    gnet_property->props[135].ev_changed = event_new("auto_feed_download_mesh_changed");
    gnet_property->props[135].save = TRUE;
    gnet_property->props[135].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[135].type               = PROP_TYPE_BOOLEAN;
    gnet_property->props[135].data.boolean.def   = &auto_feed_download_mesh_def;
    gnet_property->props[135].data.boolean.value = &auto_feed_download_mesh;


    /*
     * PROP_STRICT_SHA1_MATCHING:
     *
     * General data:
     */
    gnet_property->props[136].name = "strict_sha1_matching";
    gnet_property->props[136].desc = _("When enabled, SHA1s must match. Otherwise, name and size will be sufficient.");
    gnet_property->props[136].ev_changed = event_new("strict_sha1_matching_changed");
    gnet_property->props[136].save = TRUE;
    gnet_property->props[136].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[136].type               = PROP_TYPE_BOOLEAN;
    gnet_property->props[136].data.boolean.def   = &strict_sha1_matching_def;
    gnet_property->props[136].data.boolean.value = &strict_sha1_matching;


    /*
     * PROP_USE_FUZZY_MATCHING:
     *
     * General data:
     */
    gnet_property->props[137].name = "use_fuzzy_matching";
    gnet_property->props[137].desc = _("Use fuzzy file name matching (recommended = NO; only rely on SHA1 matching to be safe).");
    gnet_property->props[137].ev_changed = event_new("use_fuzzy_matching_changed");
    gnet_property->props[137].save = TRUE;
    gnet_property->props[137].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[137].type               = PROP_TYPE_BOOLEAN;
    gnet_property->props[137].data.boolean.def   = &use_fuzzy_matching_def;
    gnet_property->props[137].data.boolean.value = &use_fuzzy_matching;


    /*
     * PROP_FUZZY_THRESHOLD:
     *
     * General data:
     */
    gnet_property->props[138].name = "fuzzy_threshold";
    gnet_property->props[138].desc = _("Fuzziness threshold for filename matching (higher = stricter). A value of 100 means the filenames must be 100% identical.  A value of 0 means any two filenames will always be considered to be identical.  The minimum is 50%.");
    gnet_property->props[138].ev_changed = event_new("fuzzy_threshold_changed");
    gnet_property->props[138].save = TRUE;
    gnet_property->props[138].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[138].type               = PROP_TYPE_GUINT32;
    gnet_property->props[138].data.guint32.def   = &fuzzy_threshold_def;
    gnet_property->props[138].data.guint32.value = &fuzzy_threshold;
    gnet_property->props[138].data.guint32.choices = NULL;
    gnet_property->props[138].data.guint32.max   = 100;
    gnet_property->props[138].data.guint32.min   = 50;


    /*
     * PROP_IS_FIREWALLED:
     *
     * General data:
     */
    gnet_property->props[139].name = "is_firewalled";
    gnet_property->props[139].desc = _("Whether gtk-gnutella thinks you're currently firewalled, TCP-wise.");
    gnet_property->props[139].ev_changed = event_new("is_firewalled_changed");
    gnet_property->props[139].save = TRUE;
    gnet_property->props[139].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[139].type               = PROP_TYPE_BOOLEAN;
    gnet_property->props[139].data.boolean.def   = &is_firewalled_def;
    gnet_property->props[139].data.boolean.value = &is_firewalled;


    /*
     * PROP_IS_INET_CONNECTED:
     *
     * General data:
     */
    gnet_property->props[140].name = "is_inet_connected";
    gnet_property->props[140].desc = _("Whether gtk-gnutella thinks it's connected to the Internet.");
    gnet_property->props[140].ev_changed = event_new("is_inet_connected_changed");
    gnet_property->props[140].save = FALSE;
    gnet_property->props[140].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[140].type               = PROP_TYPE_BOOLEAN;
    gnet_property->props[140].data.boolean.def   = &is_inet_connected_def;
    gnet_property->props[140].data.boolean.value = &is_inet_connected;


    /*
     * PROP_IS_UDP_FIREWALLED:
     *
     * General data:
     */
    gnet_property->props[141].name = "is_udp_firewalled";
    gnet_property->props[141].desc = _("Whether gtk-gnutella thinks you're currently firewalled, UDP-wise.");
    gnet_property->props[141].ev_changed = event_new("is_udp_firewalled_changed");
    gnet_property->props[141].save = TRUE;
    gnet_property->props[141].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[141].type               = PROP_TYPE_BOOLEAN;
    gnet_property->props[141].data.boolean.def   = &is_udp_firewalled_def;
    gnet_property->props[141].data.boolean.value = &is_udp_firewalled;


    /*
     * PROP_RECV_SOLICITED_UDP:
     *
     * General data:
     */
    gnet_property->props[142].name = "recv_solicited_udp";
    gnet_property->props[142].desc = _("Whether gtk-gnutella determined it could receive solicited UDP.");
    gnet_property->props[142].ev_changed = event_new("recv_solicited_udp_changed");
    gnet_property->props[142].save = TRUE;
    gnet_property->props[142].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[142].type               = PROP_TYPE_BOOLEAN;
    gnet_property->props[142].data.boolean.def   = &recv_solicited_udp_def;
    gnet_property->props[142].data.boolean.value = &recv_solicited_udp;


    /*
     * PROP_GNET_COMPACT_QUERY:
     *
     * General data:
     */
    gnet_property->props[143].name = "gnet_compact_query";
    gnet_property->props[143].desc = _("Remove unnecessary ballast from query string before processing or forwarding them. Reduces traffic at the cost of little CPU time.");
    gnet_property->props[143].ev_changed = event_new("gnet_compact_query_changed");
    gnet_property->props[143].save = TRUE;
    gnet_property->props[143].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[143].type               = PROP_TYPE_BOOLEAN;
    gnet_property->props[143].data.boolean.def   = &gnet_compact_query_def;
    gnet_property->props[143].data.boolean.value = &gnet_compact_query;


    /*
     * PROP_DOWNLOAD_OPTIMISTIC_START:
     *
     * General data:
     */
    gnet_property->props[144].name = "download_optimistic_start";
    gnet_property->props[144].desc = _("Also use sources that don't provide a SHA1 value for the first chunk of a file. This dramatically reduces the 'No URN on server' messages, but may result in overlap problems later if the first chunk was actually from a different file. Use with caution.");
    gnet_property->props[144].ev_changed = event_new("download_optimistic_start_changed");
    gnet_property->props[144].save = TRUE;
    gnet_property->props[144].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[144].type               = PROP_TYPE_BOOLEAN;
    gnet_property->props[144].data.boolean.def   = &download_optimistic_start_def;
    gnet_property->props[144].data.boolean.value = &download_optimistic_start;


    /*
     * PROP_LIBRARY_REBUILDING:
     *
     * General data:
     */
    gnet_property->props[145].name = "library_rebuilding";
    gnet_property->props[145].desc = _("Whether gtk-gnutella is currently rebuilding its library in the background.");
    gnet_property->props[145].ev_changed = event_new("library_rebuilding_changed");
    gnet_property->props[145].save = FALSE;
    gnet_property->props[145].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[145].type               = PROP_TYPE_BOOLEAN;
    gnet_property->props[145].data.boolean.def   = &library_rebuilding_def;
    gnet_property->props[145].data.boolean.value = &library_rebuilding;


    /*
     * PROP_SHA1_REBUILDING:
     *
     * General data:
     */
    gnet_property->props[146].name = "sha1_rebuilding";
    gnet_property->props[146].desc = _("Whether gtk-gnutella is currently computing SHA1 of shared files in the background.");
    gnet_property->props[146].ev_changed = event_new("sha1_rebuilding_changed");
    gnet_property->props[146].save = FALSE;
    gnet_property->props[146].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[146].type               = PROP_TYPE_BOOLEAN;
    gnet_property->props[146].data.boolean.def   = &sha1_rebuilding_def;
    gnet_property->props[146].data.boolean.value = &sha1_rebuilding;


    /*
     * PROP_SHA1_VERIFYING:
     *
     * General data:
     */
    gnet_property->props[147].name = "sha1_verifying";
    gnet_property->props[147].desc = _("Whether gtk-gnutella is currently verifying SHA1 of downloaded files in the background.");
    gnet_property->props[147].ev_changed = event_new("sha1_verifying_changed");
    gnet_property->props[147].save = FALSE;
    gnet_property->props[147].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[147].type               = PROP_TYPE_BOOLEAN;
    gnet_property->props[147].data.boolean.def   = &sha1_verifying_def;
    gnet_property->props[147].data.boolean.value = &sha1_verifying;


    /*
     * PROP_FILE_MOVING:
     *
     * General data:
     */
    gnet_property->props[148].name = "file_moving";
    gnet_property->props[148].desc = _("Whether gtk-gnutella is currently moving files across filesystems or simply copying in the background.");
    gnet_property->props[148].ev_changed = event_new("file_moving_changed");
    gnet_property->props[148].save = FALSE;
    gnet_property->props[148].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[148].type               = PROP_TYPE_BOOLEAN;
    gnet_property->props[148].data.boolean.def   = &file_moving_def;
    gnet_property->props[148].data.boolean.value = &file_moving;


    /*
     * PROP_PREFER_COMPRESSED_GNET:
     *
     * General data:
     */
    gnet_property->props[149].name = "prefer_compressed_gnet";
    gnet_property->props[149].desc = _("If active, only compressed incoming connections are allowed after the minimum number of connections has been established. Always allows for one non-compressed connection.");
    gnet_property->props[149].ev_changed = event_new("prefer_compressed_gnet_changed");
    gnet_property->props[149].save = TRUE;
    gnet_property->props[149].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[149].type               = PROP_TYPE_BOOLEAN;
    gnet_property->props[149].data.boolean.def   = &prefer_compressed_gnet_def;
    gnet_property->props[149].data.boolean.value = &prefer_compressed_gnet;


    /*
     * PROP_ONLINE_MODE:
     *
     * General data:
     */
    gnet_property->props[150].name = "online_mode";
    gnet_property->props[150].desc = _("If deactivated, only uploads and downloads will continue. All Gnet connections are disabled/terminated.");
    gnet_property->props[150].ev_changed = event_new("online_mode_changed");
    gnet_property->props[150].save = TRUE;
    gnet_property->props[150].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[150].type               = PROP_TYPE_BOOLEAN;
    gnet_property->props[150].data.boolean.def   = &online_mode_def;
    gnet_property->props[150].data.boolean.value = &online_mode;


    /*
     * PROP_DOWNLOAD_REQUIRE_URN:
     *
     * General data:
     */
    gnet_property->props[151].name = "download_require_urn";
    gnet_property->props[151].desc = _("Whether gtk-gnutella should make sure the server confirms the URN of the file we're requesting when it is known locally and a traditional request by name is used (i.e. gtk-gnutella is not issuing a /uri-res/N2R? request).  When set, it supersedes the optimistic first chunk setting.");
    gnet_property->props[151].ev_changed = event_new("download_require_urn_changed");
    gnet_property->props[151].save = TRUE;
    gnet_property->props[151].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[151].type               = PROP_TYPE_BOOLEAN;
    gnet_property->props[151].data.boolean.def   = &download_require_urn_def;
    gnet_property->props[151].data.boolean.value = &download_require_urn;


    /*
     * PROP_DOWNLOAD_REQUIRE_SERVER_NAME:
     *
     * General data:
     */
    gnet_property->props[152].name = "download_require_server_name";
    gnet_property->props[152].desc = _("Whether gtk-gnutella should make sure the server gives us back a non-empty identifying token.");
    gnet_property->props[152].ev_changed = event_new("download_require_server_name_changed");
    gnet_property->props[152].save = TRUE;
    gnet_property->props[152].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[152].type               = PROP_TYPE_BOOLEAN;
    gnet_property->props[152].data.boolean.def   = &download_require_server_name_def;
    gnet_property->props[152].data.boolean.value = &download_require_server_name;


    /*
     * PROP_MAX_ULTRAPEERS:
     *
     * General data:
     */
    gnet_property->props[153].name = "max_ultrapeers";
    gnet_property->props[153].desc = _("Maximum amount of Ultrapeers we should connect to as a leaf.");
    gnet_property->props[153].ev_changed = event_new("max_ultrapeers_changed");
    gnet_property->props[153].save = TRUE;
    gnet_property->props[153].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[153].type               = PROP_TYPE_GUINT32;
    gnet_property->props[153].data.guint32.def   = &max_ultrapeers_def;
    gnet_property->props[153].data.guint32.value = &max_ultrapeers;
    gnet_property->props[153].data.guint32.choices = NULL;
    gnet_property->props[153].data.guint32.max   = 4;
    gnet_property->props[153].data.guint32.min   = 0;


    /*
     * PROP_QUICK_CONNECT_POOL_SIZE:
     *
     * General data:
     */
    gnet_property->props[154].name = "quick_connect_pool_size";
    gnet_property->props[154].desc = _("To connect more quickly, gtk-gnutella will allow up to this many connections to be active while trying to fill up the connection slots.");
    gnet_property->props[154].ev_changed = event_new("quick_connect_pool_size_changed");
    gnet_property->props[154].save = TRUE;
    gnet_property->props[154].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[154].type               = PROP_TYPE_GUINT32;
    gnet_property->props[154].data.guint32.def   = &quick_connect_pool_size_def;
    gnet_property->props[154].data.guint32.value = &quick_connect_pool_size;
    gnet_property->props[154].data.guint32.choices = NULL;
    gnet_property->props[154].data.guint32.max   = 80;
    gnet_property->props[154].data.guint32.min   = 4;


    /*
     * PROP_MAX_LEAVES:
     *
     * General data:
     */
    gnet_property->props[155].name = "max_leaves";
    gnet_property->props[155].desc = _("Maximum amount of leaves we can accept.  To be promoted Ultra, you should reserve 32 bytes of bandwidth per leaf.");
    gnet_property->props[155].ev_changed = event_new("max_leaves_changed");
    gnet_property->props[155].save = TRUE;
    gnet_property->props[155].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[155].type               = PROP_TYPE_GUINT32;
    gnet_property->props[155].data.guint32.def   = &max_leaves_def;
    gnet_property->props[155].data.guint32.value = &max_leaves;
    gnet_property->props[155].data.guint32.choices = NULL;
    gnet_property->props[155].data.guint32.max   = 1000;
    gnet_property->props[155].data.guint32.min   = 50;


    /*
     * PROP_SEARCH_HANDLE_IGNORED_FILES:
     *
     * General data:
     */
    gnet_property->props[156].name = "search_handle_ignored_files";
    gnet_property->props[156].desc = _("What to do with files that will be ignored for downloading.");
    gnet_property->props[156].ev_changed = event_new("search_handle_ignored_files_changed");
    gnet_property->props[156].save = TRUE;
    gnet_property->props[156].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[156].type               = PROP_TYPE_MULTICHOICE;
    gnet_property->props[156].data.guint32.def   = &search_handle_ignored_files_def;
    gnet_property->props[156].data.guint32.value = &search_handle_ignored_files;
    gnet_property->props[156].data.guint32.max   = 0xFFFFFFFF;
    gnet_property->props[156].data.guint32.min   = 0x00000000;
    gnet_property->props[156].data.guint32.choices = search_handle_ignored_files_choices;


    /*
     * PROP_CONFIGURED_PEERMODE:
     *
     * General data:
     */
    gnet_property->props[157].name = "configured_peermode";
    gnet_property->props[157].desc = _("The peer mode you want to operate as for gtk-gnutella.  When auto is selected, gtk-gnutella will start as a leaf node and may be promoted to an ultra node if bandwidth and uptime permits, provided that you are not firewalled.");
    gnet_property->props[157].ev_changed = event_new("configured_peermode_changed");
    gnet_property->props[157].save = TRUE;
    gnet_property->props[157].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[157].type               = PROP_TYPE_MULTICHOICE;
    gnet_property->props[157].data.guint32.def   = &configured_peermode_def;
    gnet_property->props[157].data.guint32.value = &configured_peermode;
    gnet_property->props[157].data.guint32.max   = 0xFFFFFFFF;
    gnet_property->props[157].data.guint32.min   = 0x00000000;
    gnet_property->props[157].data.guint32.choices = configured_peermode_choices;


    /*
     * PROP_CURRENT_PEERMODE:
     *
     * General data:
     */
    gnet_property->props[158].name = "current_peermode";
    gnet_property->props[158].desc = _("Current peer mode for gtk-gnutella.");
    gnet_property->props[158].ev_changed = event_new("current_peermode_changed");
    gnet_property->props[158].save = FALSE;
    gnet_property->props[158].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[158].type               = PROP_TYPE_MULTICHOICE;
    gnet_property->props[158].data.guint32.def   = &current_peermode_def;
    gnet_property->props[158].data.guint32.value = &current_peermode;
    gnet_property->props[158].data.guint32.max   = 0xFFFFFFFF;
    gnet_property->props[158].data.guint32.min   = 0x00000000;
    gnet_property->props[158].data.guint32.choices = current_peermode_choices;


    /*
     * PROP_SYS_NOFILE:
     *
     * General data:
     */
    gnet_property->props[159].name = "sys_nofile";
    gnet_property->props[159].desc = _("How many file descriptors this process can open.");
    gnet_property->props[159].ev_changed = event_new("sys_nofile_changed");
    gnet_property->props[159].save = FALSE;
    gnet_property->props[159].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[159].type               = PROP_TYPE_GUINT32;
    gnet_property->props[159].data.guint32.def   = &sys_nofile_def;
    gnet_property->props[159].data.guint32.value = &sys_nofile;
    gnet_property->props[159].data.guint32.choices = NULL;
    gnet_property->props[159].data.guint32.max   = 0xFFFFFFFF;
    gnet_property->props[159].data.guint32.min   = 0x00000000;


    /*
     * PROP_SYS_PHYSMEM:
     *
     * General data:
     */
    gnet_property->props[160].name = "sys_physmem";
    gnet_property->props[160].desc = _("How much physical memory is available.");
    gnet_property->props[160].ev_changed = event_new("sys_physmem_changed");
    gnet_property->props[160].save = FALSE;
    gnet_property->props[160].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[160].type               = PROP_TYPE_GUINT32;
    gnet_property->props[160].data.guint32.def   = &sys_physmem_def;
    gnet_property->props[160].data.guint32.value = &sys_physmem;
    gnet_property->props[160].data.guint32.choices = NULL;
    gnet_property->props[160].data.guint32.max   = 0xFFFFFFFF;
    gnet_property->props[160].data.guint32.min   = 0x00000000;


    /*
     * PROP_DL_QUEUE_COUNT:
     *
     * General data:
     */
    gnet_property->props[161].name = "dl_queue_count";
    gnet_property->props[161].desc = _("How many downloads are currently held in the queue.");
    gnet_property->props[161].ev_changed = event_new("dl_queue_count_changed");
    gnet_property->props[161].save = FALSE;
    gnet_property->props[161].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[161].type               = PROP_TYPE_GUINT32;
    gnet_property->props[161].data.guint32.def   = &dl_queue_count_def;
    gnet_property->props[161].data.guint32.value = &dl_queue_count;
    gnet_property->props[161].data.guint32.choices = NULL;
    gnet_property->props[161].data.guint32.max   = 0xFFFFFFFF;
    gnet_property->props[161].data.guint32.min   = 0x00000000;


    /*
     * PROP_DL_RUNNING_COUNT:
     *
     * General data:
     */
    gnet_property->props[162].name = "dl_running_count";
    gnet_property->props[162].desc = _("How many downloads are currently running (downloading / connecting).");
    gnet_property->props[162].ev_changed = event_new("dl_running_count_changed");
    gnet_property->props[162].save = FALSE;
    gnet_property->props[162].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[162].type               = PROP_TYPE_GUINT32;
    gnet_property->props[162].data.guint32.def   = &dl_running_count_def;
    gnet_property->props[162].data.guint32.value = &dl_running_count;
    gnet_property->props[162].data.guint32.choices = NULL;
    gnet_property->props[162].data.guint32.max   = 0xFFFFFFFF;
    gnet_property->props[162].data.guint32.min   = 0x00000000;


    /*
     * PROP_DL_ACTIVE_COUNT:
     *
     * General data:
     */
    gnet_property->props[163].name = "dl_active_count";
    gnet_property->props[163].desc = _("How many downloads are currently active.");
    gnet_property->props[163].ev_changed = event_new("dl_active_count_changed");
    gnet_property->props[163].save = FALSE;
    gnet_property->props[163].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[163].type               = PROP_TYPE_GUINT32;
    gnet_property->props[163].data.guint32.def   = &dl_active_count_def;
    gnet_property->props[163].data.guint32.value = &dl_active_count;
    gnet_property->props[163].data.guint32.choices = NULL;
    gnet_property->props[163].data.guint32.max   = 0xFFFFFFFF;
    gnet_property->props[163].data.guint32.min   = 0x00000000;


    /*
     * PROP_DL_AQUEUED_COUNT:
     *
     * General data:
     */
    gnet_property->props[164].name = "dl_aqueued_count";
    gnet_property->props[164].desc = _("How many downloads are currently actively queued.");
    gnet_property->props[164].ev_changed = event_new("dl_aqueued_count_changed");
    gnet_property->props[164].save = FALSE;
    gnet_property->props[164].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[164].type               = PROP_TYPE_GUINT32;
    gnet_property->props[164].data.guint32.def   = &dl_aqueued_count_def;
    gnet_property->props[164].data.guint32.value = &dl_aqueued_count;
    gnet_property->props[164].data.guint32.choices = NULL;
    gnet_property->props[164].data.guint32.max   = 0xFFFFFFFF;
    gnet_property->props[164].data.guint32.min   = 0x00000000;


    /*
     * PROP_DL_PQUEUED_COUNT:
     *
     * General data:
     */
    gnet_property->props[165].name = "dl_pqueued_count";
    gnet_property->props[165].desc = _("How many downloads are currently passively queued.");
    gnet_property->props[165].ev_changed = event_new("dl_pqueued_count_changed");
    gnet_property->props[165].save = FALSE;
    gnet_property->props[165].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[165].type               = PROP_TYPE_GUINT32;
    gnet_property->props[165].data.guint32.def   = &dl_pqueued_count_def;
    gnet_property->props[165].data.guint32.value = &dl_pqueued_count;
    gnet_property->props[165].data.guint32.choices = NULL;
    gnet_property->props[165].data.guint32.max   = 0xFFFFFFFF;
    gnet_property->props[165].data.guint32.min   = 0x00000000;


    /*
     * PROP_FI_ALL_COUNT:
     *
     * General data:
     */
    gnet_property->props[166].name = "fi_all_count";
    gnet_property->props[166].desc = _("How many fileinfo do we have.");
    gnet_property->props[166].ev_changed = event_new("fi_all_count_changed");
    gnet_property->props[166].save = FALSE;
    gnet_property->props[166].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[166].type               = PROP_TYPE_GUINT32;
    gnet_property->props[166].data.guint32.def   = &fi_all_count_def;
    gnet_property->props[166].data.guint32.value = &fi_all_count;
    gnet_property->props[166].data.guint32.choices = NULL;
    gnet_property->props[166].data.guint32.max   = 0xFFFFFFFF;
    gnet_property->props[166].data.guint32.min   = 0x00000000;


    /*
     * PROP_FI_WITH_SOURCE_COUNT:
     *
     * General data:
     */
    gnet_property->props[167].name = "fi_with_source_count";
    gnet_property->props[167].desc = _("How many fileinfo with sources do we have.");
    gnet_property->props[167].ev_changed = event_new("fi_with_source_count_changed");
    gnet_property->props[167].save = FALSE;
    gnet_property->props[167].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[167].type               = PROP_TYPE_GUINT32;
    gnet_property->props[167].data.guint32.def   = &fi_with_source_count_def;
    gnet_property->props[167].data.guint32.value = &fi_with_source_count;
    gnet_property->props[167].data.guint32.choices = NULL;
    gnet_property->props[167].data.guint32.max   = 0xFFFFFFFF;
    gnet_property->props[167].data.guint32.min   = 0x00000000;


    /*
     * PROP_DL_QALIVE_COUNT:
     *
     * General data:
     */
    gnet_property->props[168].name = "dl_qalive_count";
    gnet_property->props[168].desc = _("How many queued downloads are currently responsive (remote servent answering requests).");
    gnet_property->props[168].ev_changed = event_new("dl_qalive_count_changed");
    gnet_property->props[168].save = FALSE;
    gnet_property->props[168].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[168].type               = PROP_TYPE_GUINT32;
    gnet_property->props[168].data.guint32.def   = &dl_qalive_count_def;
    gnet_property->props[168].data.guint32.value = &dl_qalive_count;
    gnet_property->props[168].data.guint32.choices = NULL;
    gnet_property->props[168].data.guint32.max   = 0xFFFFFFFF;
    gnet_property->props[168].data.guint32.min   = 0x00000000;


    /*
     * PROP_DL_BYTE_COUNT:
     *
     * General data:
     */
    gnet_property->props[169].name = "dl_byte_count";
    gnet_property->props[169].desc = _("Amount of bytes downloaded so far, HTTP headers notwithstanding.");
    gnet_property->props[169].ev_changed = event_new("dl_byte_count_changed");
    gnet_property->props[169].save = FALSE;
    gnet_property->props[169].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[169].type               = PROP_TYPE_GUINT64;
    gnet_property->props[169].data.guint64.def   = &dl_byte_count_def;
    gnet_property->props[169].data.guint64.value = &dl_byte_count;
    gnet_property->props[169].data.guint64.choices = NULL;
    gnet_property->props[169].data.guint64.max   = (guint64) -1;
    gnet_property->props[169].data.guint64.min   = 0x0000000000000000;


    /*
     * PROP_UL_BYTE_COUNT:
     *
     * General data:
     */
    gnet_property->props[170].name = "ul_byte_count";
    gnet_property->props[170].desc = _("Amount of bytes uploaded so far, HTTP headers notwithstanding.");
    gnet_property->props[170].ev_changed = event_new("ul_byte_count_changed");
    gnet_property->props[170].save = FALSE;
    gnet_property->props[170].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[170].type               = PROP_TYPE_GUINT64;
    gnet_property->props[170].data.guint64.def   = &ul_byte_count_def;
    gnet_property->props[170].data.guint64.value = &ul_byte_count;
    gnet_property->props[170].data.guint64.choices = NULL;
    gnet_property->props[170].data.guint64.max   = (guint64) -1;
    gnet_property->props[170].data.guint64.min   = 0x0000000000000000;


    /*
     * PROP_PFSP_SERVER:
     *
     * General data:
     */
    gnet_property->props[171].name = "pfsp_server";
    gnet_property->props[171].desc = _("Whether gtk-gnutella should serve partial files whilst they are still incompletely downloaded.  Recommended for network's health unless you already share many files, in which case it does no harm to leave it in, but will not matter as much.");
    gnet_property->props[171].ev_changed = event_new("pfsp_server_changed");
    gnet_property->props[171].save = TRUE;
    gnet_property->props[171].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[171].type               = PROP_TYPE_BOOLEAN;
    gnet_property->props[171].data.boolean.def   = &pfsp_server_def;
    gnet_property->props[171].data.boolean.value = &pfsp_server;


    /*
     * PROP_PFSP_FIRST_CHUNK:
     *
     * General data:
     */
    gnet_property->props[172].name = "pfsp_first_chunk";
    gnet_property->props[172].desc = _("When partial file sharing (PFSP) is enabled, gtk-gnutella will strive to download chunks in a random order, to maximize the spreading of the file in the network.  However, this makes auditing (file type, pre-viewing, etc...) of the file impossible. This field sets the size in bytes of the first chunk of data that should be continuously downloaded at the beginning of the file.  Don't set it too large.");
    gnet_property->props[172].ev_changed = event_new("pfsp_first_chunk_changed");
    gnet_property->props[172].save = TRUE;
    gnet_property->props[172].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[172].type               = PROP_TYPE_GUINT32;
    gnet_property->props[172].data.guint32.def   = &pfsp_first_chunk_def;
    gnet_property->props[172].data.guint32.value = &pfsp_first_chunk;
    gnet_property->props[172].data.guint32.choices = NULL;
    gnet_property->props[172].data.guint32.max   = 0xFFFFFFFF;
    gnet_property->props[172].data.guint32.min   = 0x00000000;


    /*
     * PROP_FUZZY_FILTER_DMESH:
     *
     * General data:
     */
    gnet_property->props[173].name = "fuzzy_filter_dmesh";
    gnet_property->props[173].desc = _("Whether to apply a fuzzy filter on download mesh entries.  The purpose of this filtering is to remove entries whose names are too different to be sensibly part of the same mesh. When activated, your mesh will probably be more consistent at the cost of extra CPU time, and at the cost of losing some valid entries in the process.");
    gnet_property->props[173].ev_changed = event_new("fuzzy_filter_dmesh_changed");
    gnet_property->props[173].save = TRUE;
    gnet_property->props[173].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[173].type               = PROP_TYPE_BOOLEAN;
    gnet_property->props[173].data.boolean.def   = &fuzzy_filter_dmesh_def;
    gnet_property->props[173].data.boolean.value = &fuzzy_filter_dmesh;


    /*
     * PROP_CRAWLER_VISIT_COUNT:
     *
     * General data:
     */
    gnet_property->props[174].name = "crawler_visit_count";
    gnet_property->props[174].desc = _("Number of crawler visits during this session.");
    gnet_property->props[174].ev_changed = event_new("crawler_visit_count_changed");
    gnet_property->props[174].save = FALSE;
    gnet_property->props[174].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[174].type               = PROP_TYPE_GUINT32;
    gnet_property->props[174].data.guint32.def   = &crawler_visit_count_def;
    gnet_property->props[174].data.guint32.value = &crawler_visit_count;
    gnet_property->props[174].data.guint32.choices = NULL;
    gnet_property->props[174].data.guint32.max   = 0xFFFFFFFF;
    gnet_property->props[174].data.guint32.min   = 0x00000000;


    /*
     * PROP_UDP_CRAWLER_VISIT_COUNT:
     *
     * General data:
     */
    gnet_property->props[175].name = "udp_crawler_visit_count";
    gnet_property->props[175].desc = _("Number of UDP crawler visits during this session.");
    gnet_property->props[175].ev_changed = event_new("udp_crawler_visit_count_changed");
    gnet_property->props[175].save = FALSE;
    gnet_property->props[175].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[175].type               = PROP_TYPE_GUINT32;
    gnet_property->props[175].data.guint32.def   = &udp_crawler_visit_count_def;
    gnet_property->props[175].data.guint32.value = &udp_crawler_visit_count;
    gnet_property->props[175].data.guint32.choices = NULL;
    gnet_property->props[175].data.guint32.max   = 0xFFFFFFFF;
    gnet_property->props[175].data.guint32.min   = 0x00000000;


    /*
     * PROP_HOST_RUNS_NTP:
     *
     * General data:
     */
    gnet_property->props[176].name = "host_runs_ntp";
    gnet_property->props[176].desc = _("Whether the clock of this host is kept accurate via NTP. When set, the computed clock skew is ignored. Normally, gtk-gnutella automatically determines whether you are running NTP locally, but it won't be able to determine whether your host is kept synchronized by regular calls to ntpdate, for instance.");
    gnet_property->props[176].ev_changed = event_new("host_runs_ntp_changed");
    gnet_property->props[176].save = TRUE;
    gnet_property->props[176].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[176].type               = PROP_TYPE_BOOLEAN;
    gnet_property->props[176].data.boolean.def   = &host_runs_ntp_def;
    gnet_property->props[176].data.boolean.value = &host_runs_ntp;


    /*
     * PROP_NTP_DETECTED:
     *
     * General data:
     */
    gnet_property->props[177].name = "ntp_detected";
    gnet_property->props[177].desc = _("Whether a running NTP daemon was detected locally.");
    gnet_property->props[177].ev_changed = event_new("ntp_detected_changed");
    gnet_property->props[177].save = FALSE;
    gnet_property->props[177].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[177].type               = PROP_TYPE_BOOLEAN;
    gnet_property->props[177].data.boolean.def   = &ntp_detected_def;
    gnet_property->props[177].data.boolean.value = &ntp_detected;


    /*
     * PROP_CLOCK_SKEW:
     *
     * General data:
     */
    gnet_property->props[178].name = "clock_skew";
    gnet_property->props[178].desc = _("The signed clock skew of this host compared to absolute time. Adding this skew to the host clock should give the true time.");
    gnet_property->props[178].ev_changed = event_new("clock_skew_changed");
    gnet_property->props[178].save = TRUE;
    gnet_property->props[178].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[178].type               = PROP_TYPE_GUINT32;
    gnet_property->props[178].data.guint32.def   = &clock_skew_def;
    gnet_property->props[178].data.guint32.value = &clock_skew;
    gnet_property->props[178].data.guint32.choices = NULL;
    gnet_property->props[178].data.guint32.max   = 0xFFFFFFFF;
    gnet_property->props[178].data.guint32.min   = 0x00000000;


    /*
     * PROP_NODE_MONITOR_UNSTABLE_IP:
     *
     * General data:
     */
    gnet_property->props[179].name = "node_monitor_unstable_ip";
    gnet_property->props[179].desc = _("Whether gtk-gnutella should keep track of the IP of unstable servents it encounters, preventing further connections attempts to/from them.");
    gnet_property->props[179].ev_changed = event_new("node_monitor_unstable_ip_changed");
    gnet_property->props[179].save = TRUE;
    gnet_property->props[179].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[179].type               = PROP_TYPE_BOOLEAN;
    gnet_property->props[179].data.boolean.def   = &node_monitor_unstable_ip_def;
    gnet_property->props[179].data.boolean.value = &node_monitor_unstable_ip;


    /*
     * PROP_NODE_MONITOR_UNSTABLE_SERVENTS:
     *
     * General data:
     */
    gnet_property->props[180].name = "node_monitor_unstable_servents";
    gnet_property->props[180].desc = _("Whether gtk-gnutella should determine the servent types (as identified by their vendor string) that are unstable, preventing further connections to/from them.  This only works when gtk-gnutella already keeps track of unstable IP addresses.");
    gnet_property->props[180].ev_changed = event_new("node_monitor_unstable_servents_changed");
    gnet_property->props[180].save = TRUE;
    gnet_property->props[180].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[180].type               = PROP_TYPE_BOOLEAN;
    gnet_property->props[180].data.boolean.def   = &node_monitor_unstable_servents_def;
    gnet_property->props[180].data.boolean.value = &node_monitor_unstable_servents;


    /*
     * PROP_DL_REMOVE_FILE_ON_MISMATCH:
     *
     * General data:
     */
    gnet_property->props[181].name = "dl_remove_file_on_mismatch";
    gnet_property->props[181].desc = _("Whether gtk-gnutella should automatically remove the file whenever it gets a resuming mismatch and retry from scratch. Until Tiger Tree Hashes are widespread, this is the easiest option.");
    gnet_property->props[181].ev_changed = event_new("dl_remove_file_on_mismatch_changed");
    gnet_property->props[181].save = TRUE;
    gnet_property->props[181].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[181].type               = PROP_TYPE_BOOLEAN;
    gnet_property->props[181].data.boolean.def   = &dl_remove_file_on_mismatch_def;
    gnet_property->props[181].data.boolean.value = &dl_remove_file_on_mismatch;


    /*
     * PROP_DL_MISMATCH_BACKOUT:
     *
     * General data:
     */
    gnet_property->props[182].name = "dl_mismatch_backout";
    gnet_property->props[182].desc = _("The amount of bytes which gtk-gnutella will strip off the already downloaded bytes after a resuming mismatch, in the hope that only this amount was corrupted, preventing proper resuming. Most of the time, a resuming mismatch indicates bad data on the server, but if the already downloaded data is bad then backing out some of it may allow us to recover from the problem.");
    gnet_property->props[182].ev_changed = event_new("dl_mismatch_backout_changed");
    gnet_property->props[182].save = TRUE;
    gnet_property->props[182].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[182].type               = PROP_TYPE_GUINT32;
    gnet_property->props[182].data.guint32.def   = &dl_mismatch_backout_def;
    gnet_property->props[182].data.guint32.value = &dl_mismatch_backout;
    gnet_property->props[182].data.guint32.choices = NULL;
    gnet_property->props[182].data.guint32.max   = 250000;
    gnet_property->props[182].data.guint32.min   = 0;


    /*
     * PROP_SERVER_HOSTNAME:
     *
     * General data:
     */
    gnet_property->props[183].name = "server_hostname";
    gnet_property->props[183].desc = _("The hostname of the server that can be used by downloaders to find the IP address via a DNS resolution.  If you have a dynamic IP address coupled with a dynamic DNS service, then this is valuable to downloaders: they may find your node even after a few rotations of your IP address.");
    gnet_property->props[183].ev_changed = event_new("server_hostname_changed");
    gnet_property->props[183].save = TRUE;
    gnet_property->props[183].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[183].type               = PROP_TYPE_STRING;
    gnet_property->props[183].data.string.def    = &server_hostname_def;
    gnet_property->props[183].data.string.value  = &server_hostname;
    if (gnet_property->props[183].data.string.def) {
        *gnet_property->props[183].data.string.value =
            g_strdup(eval_subst(*gnet_property->props[183].data.string.def));
    }


    /*
     * PROP_GIVE_SERVER_HOSTNAME:
     *
     * General data:
     */
    gnet_property->props[184].name = "give_server_hostname";
    gnet_property->props[184].desc = _("Whether gtk-gnutella should advertise the hostname of your server to downloaders and in query hits.");
    gnet_property->props[184].ev_changed = event_new("give_server_hostname_changed");
    gnet_property->props[184].save = TRUE;
    gnet_property->props[184].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[184].type               = PROP_TYPE_BOOLEAN;
    gnet_property->props[184].data.boolean.def   = &give_server_hostname_def;
    gnet_property->props[184].data.boolean.value = &give_server_hostname;


    /*
     * PROP_RESERVE_GTKG_NODES:
     *
     * General data:
     */
    gnet_property->props[185].name = "reserve_gtkg_nodes";
    gnet_property->props[185].desc = _("Percentage of the number of connections we should reserve for gtk-gnutella nodes.");
    gnet_property->props[185].ev_changed = event_new("reserve_gtkg_nodes_changed");
    gnet_property->props[185].save = TRUE;
    gnet_property->props[185].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[185].type               = PROP_TYPE_GUINT32;
    gnet_property->props[185].data.guint32.def   = &reserve_gtkg_nodes_def;
    gnet_property->props[185].data.guint32.value = &reserve_gtkg_nodes;
    gnet_property->props[185].data.guint32.choices = NULL;
    gnet_property->props[185].data.guint32.max   = 90;
    gnet_property->props[185].data.guint32.min   = 0;


    /*
     * PROP_UNIQUE_NODES:
     *
     * General data:
     */
    gnet_property->props[186].name = "unique_nodes";
    gnet_property->props[186].desc = _("Maximum percentage of slots a vendor can occupy.");
    gnet_property->props[186].ev_changed = event_new("unique_nodes_changed");
    gnet_property->props[186].save = TRUE;
    gnet_property->props[186].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[186].type               = PROP_TYPE_GUINT32;
    gnet_property->props[186].data.guint32.def   = &unique_nodes_def;
    gnet_property->props[186].data.guint32.value = &unique_nodes;
    gnet_property->props[186].data.guint32.choices = NULL;
    gnet_property->props[186].data.guint32.max   = 100;
    gnet_property->props[186].data.guint32.min   = 10;


    /*
     * PROP_DOWNLOAD_RX_SIZE:
     *
     * General data:
     */
    gnet_property->props[187].name = "download_rx_size";
    gnet_property->props[187].desc = _("Size of the RX socket buffer to be used for downloads, in kbytes. If you wish to avoid Gnutella downloads using up all your bandwidth, set it to a low value (default is 64K, which is fine). If you don't mind sucking up all the available bandwidth, increasing your connection latency, set it to a greater value. Remember: the smaller the value, the more you will be able to precisely control the incoming rate.");
    gnet_property->props[187].ev_changed = event_new("download_rx_size_changed");
    gnet_property->props[187].save = TRUE;
    gnet_property->props[187].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[187].type               = PROP_TYPE_GUINT32;
    gnet_property->props[187].data.guint32.def   = &download_rx_size_def;
    gnet_property->props[187].data.guint32.value = &download_rx_size;
    gnet_property->props[187].data.guint32.choices = NULL;
    gnet_property->props[187].data.guint32.max   = 128;
    gnet_property->props[187].data.guint32.min   = 2;


    /*
     * PROP_NODE_RX_SIZE:
     *
     * General data:
     */
    gnet_property->props[188].name = "node_rx_size";
    gnet_property->props[188].desc = _("Size of the RX socket buffer to be used for nodes, in kbytes. The lower the value, the faster the remote end will flow-control at the TCP/IP level if you don't read quickly enough, which would be the case if you limit the incoming bandwidth.");
    gnet_property->props[188].ev_changed = event_new("node_rx_size_changed");
    gnet_property->props[188].save = TRUE;
    gnet_property->props[188].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[188].type               = PROP_TYPE_GUINT32;
    gnet_property->props[188].data.guint32.def   = &node_rx_size_def;
    gnet_property->props[188].data.guint32.value = &node_rx_size;
    gnet_property->props[188].data.guint32.choices = NULL;
    gnet_property->props[188].data.guint32.max   = 128;
    gnet_property->props[188].data.guint32.min   = 2;


    /*
     * PROP_DL_HTTP_LATENCY:
     *
     * General data:
     */
    gnet_property->props[189].name = "dl_http_latency";
    gnet_property->props[189].desc = _("Average recent latency between the sending of the HTTP request and the reception of the reply from the remote server, in msecs.");
    gnet_property->props[189].ev_changed = event_new("dl_http_latency_changed");
    gnet_property->props[189].save = FALSE;
    gnet_property->props[189].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[189].type               = PROP_TYPE_GUINT32;
    gnet_property->props[189].data.guint32.def   = &dl_http_latency_def;
    gnet_property->props[189].data.guint32.value = &dl_http_latency;
    gnet_property->props[189].data.guint32.choices = NULL;
    gnet_property->props[189].data.guint32.max   = 0xFFFFFFFF;
    gnet_property->props[189].data.guint32.min   = 0x00000000;


    /*
     * PROP_NODE_LAST_ULTRA_CHECK:
     *
     * General data:
     */
    gnet_property->props[190].name = "node_last_ultra_check";
    gnet_property->props[190].desc = _("Last time at which we performed the ultrapeer requirement checks.");
    gnet_property->props[190].ev_changed = event_new("node_last_ultra_check_changed");
    gnet_property->props[190].save = TRUE;
    gnet_property->props[190].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[190].type               = PROP_TYPE_GUINT32;
    gnet_property->props[190].data.guint32.def   = &node_last_ultra_check_def;
    gnet_property->props[190].data.guint32.value = &node_last_ultra_check;
    gnet_property->props[190].data.guint32.choices = NULL;
    gnet_property->props[190].data.guint32.max   = 0xFFFFFFFF;
    gnet_property->props[190].data.guint32.min   = 0x00000000;


    /*
     * PROP_NODE_LAST_ULTRA_LEAF_SWITCH:
     *
     * General data:
     */
    gnet_property->props[191].name = "node_last_ultra_leaf_switch";
    gnet_property->props[191].desc = _("Last time an automatic switch between ultra and leaf mode occurred.");
    gnet_property->props[191].ev_changed = event_new("node_last_ultra_leaf_switch_changed");
    gnet_property->props[191].save = FALSE;
    gnet_property->props[191].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[191].type               = PROP_TYPE_GUINT32;
    gnet_property->props[191].data.guint32.def   = &node_last_ultra_leaf_switch_def;
    gnet_property->props[191].data.guint32.value = &node_last_ultra_leaf_switch;
    gnet_property->props[191].data.guint32.choices = NULL;
    gnet_property->props[191].data.guint32.max   = 0xFFFFFFFF;
    gnet_property->props[191].data.guint32.min   = 0x00000000;


    /*
     * PROP_UP_REQ_AVG_SERVENT_UPTIME:
     *
     * General data:
     */
    gnet_property->props[192].name = "up_req_avg_servent_uptime";
    gnet_property->props[192].desc = _("Whether we meet the sufficient average uptime requirement to become an Ultra node.");
    gnet_property->props[192].ev_changed = event_new("up_req_avg_servent_uptime_changed");
    gnet_property->props[192].save = FALSE;
    gnet_property->props[192].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[192].type               = PROP_TYPE_BOOLEAN;
    gnet_property->props[192].data.boolean.def   = &up_req_avg_servent_uptime_def;
    gnet_property->props[192].data.boolean.value = &up_req_avg_servent_uptime;


    /*
     * PROP_UP_REQ_AVG_IP_UPTIME:
     *
     * General data:
     */
    gnet_property->props[193].name = "up_req_avg_ip_uptime";
    gnet_property->props[193].desc = _("Whether we meet the sufficient average IP address uptime requirement to become an Ultra node.");
    gnet_property->props[193].ev_changed = event_new("up_req_avg_ip_uptime_changed");
    gnet_property->props[193].save = FALSE;
    gnet_property->props[193].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[193].type               = PROP_TYPE_BOOLEAN;
    gnet_property->props[193].data.boolean.def   = &up_req_avg_ip_uptime_def;
    gnet_property->props[193].data.boolean.value = &up_req_avg_ip_uptime;


    /*
     * PROP_UP_REQ_NODE_UPTIME:
     *
     * General data:
     */
    gnet_property->props[194].name = "up_req_node_uptime";
    gnet_property->props[194].desc = _("Whether we meet the sufficient node uptime requirement to become an Ultra node.");
    gnet_property->props[194].ev_changed = event_new("up_req_node_uptime_changed");
    gnet_property->props[194].save = FALSE;
    gnet_property->props[194].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[194].type               = PROP_TYPE_BOOLEAN;
    gnet_property->props[194].data.boolean.def   = &up_req_node_uptime_def;
    gnet_property->props[194].data.boolean.value = &up_req_node_uptime;


    /*
     * PROP_UP_REQ_NOT_FIREWALLED:
     *
     * General data:
     */
    gnet_property->props[195].name = "up_req_not_firewalled";
    gnet_property->props[195].desc = _("Whether we meet the non-firewalled requirement to become an Ultra node.");
    gnet_property->props[195].ev_changed = event_new("up_req_not_firewalled_changed");
    gnet_property->props[195].save = FALSE;
    gnet_property->props[195].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[195].type               = PROP_TYPE_BOOLEAN;
    gnet_property->props[195].data.boolean.def   = &up_req_not_firewalled_def;
    gnet_property->props[195].data.boolean.value = &up_req_not_firewalled;


    /*
     * PROP_UP_REQ_ENOUGH_CONN:
     *
     * General data:
     */
    gnet_property->props[196].name = "up_req_enough_conn";
    gnet_property->props[196].desc = _("Whether we meet the minimum amount of peer connections requirement to become an Ultra node.");
    gnet_property->props[196].ev_changed = event_new("up_req_enough_conn_changed");
    gnet_property->props[196].save = FALSE;
    gnet_property->props[196].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[196].type               = PROP_TYPE_BOOLEAN;
    gnet_property->props[196].data.boolean.def   = &up_req_enough_conn_def;
    gnet_property->props[196].data.boolean.value = &up_req_enough_conn;


    /*
     * PROP_UP_REQ_ENOUGH_FD:
     *
     * General data:
     */
    gnet_property->props[197].name = "up_req_enough_fd";
    gnet_property->props[197].desc = _("Whether we meet the amount of file descriptor requirement to become an Ultra node.");
    gnet_property->props[197].ev_changed = event_new("up_req_enough_fd_changed");
    gnet_property->props[197].save = FALSE;
    gnet_property->props[197].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[197].type               = PROP_TYPE_BOOLEAN;
    gnet_property->props[197].data.boolean.def   = &up_req_enough_fd_def;
    gnet_property->props[197].data.boolean.value = &up_req_enough_fd;


    /*
     * PROP_UP_REQ_ENOUGH_MEM:
     *
     * General data:
     */
    gnet_property->props[198].name = "up_req_enough_mem";
    gnet_property->props[198].desc = _("Whether we meet the memory requirements to become an Ultra node.");
    gnet_property->props[198].ev_changed = event_new("up_req_enough_mem_changed");
    gnet_property->props[198].save = FALSE;
    gnet_property->props[198].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[198].type               = PROP_TYPE_BOOLEAN;
    gnet_property->props[198].data.boolean.def   = &up_req_enough_mem_def;
    gnet_property->props[198].data.boolean.value = &up_req_enough_mem;


    /*
     * PROP_UP_REQ_ENOUGH_BW:
     *
     * General data:
     */
    gnet_property->props[199].name = "up_req_enough_bw";
    gnet_property->props[199].desc = _("Whether we meet the bandwidth requirements to become an Ultra node.");
    gnet_property->props[199].ev_changed = event_new("up_req_enough_bw_changed");
    gnet_property->props[199].save = FALSE;
    gnet_property->props[199].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[199].type               = PROP_TYPE_BOOLEAN;
    gnet_property->props[199].data.boolean.def   = &up_req_enough_bw_def;
    gnet_property->props[199].data.boolean.value = &up_req_enough_bw;


    /*
     * PROP_SEARCH_QUEUE_SIZE:
     *
     * General data:
     */
    gnet_property->props[200].name = "search_queue_size";
    gnet_property->props[200].desc = _("Size of the search queue holding the locally generated queries before they are sent on a given connection.  When full, the oldest query is dropped without being sent.  Set it so that it is slightly larger than the amount of opened searches.");
    gnet_property->props[200].ev_changed = event_new("search_queue_size_changed");
    gnet_property->props[200].save = TRUE;
    gnet_property->props[200].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[200].type               = PROP_TYPE_GUINT32;
    gnet_property->props[200].data.guint32.def   = &search_queue_size_def;
    gnet_property->props[200].data.guint32.value = &search_queue_size;
    gnet_property->props[200].data.guint32.choices = NULL;
    gnet_property->props[200].data.guint32.max   = 512;
    gnet_property->props[200].data.guint32.min   = 32;


    /*
     * PROP_SEARCH_QUEUE_SPACING:
     *
     * General data:
     */
    gnet_property->props[201].name = "search_queue_spacing";
    gnet_property->props[201].desc = _("Minimum amount of seconds between two consecutive queries sent to a given connection (for locally generated queries only!). The larger the value, the less negative impact it has on the network.");
    gnet_property->props[201].ev_changed = event_new("search_queue_spacing_changed");
    gnet_property->props[201].save = TRUE;
    gnet_property->props[201].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[201].type               = PROP_TYPE_GUINT32;
    gnet_property->props[201].data.guint32.def   = &search_queue_spacing_def;
    gnet_property->props[201].data.guint32.value = &search_queue_spacing;
    gnet_property->props[201].data.guint32.choices = NULL;
    gnet_property->props[201].data.guint32.max   = 60;
    gnet_property->props[201].data.guint32.min   = 10;


    /*
     * PROP_ENABLE_SHELL:
     *
     * General data:
     */
    gnet_property->props[202].name = "enable_shell";
    gnet_property->props[202].desc = _("Whether connection to gtk-gnutella via the 'shell' control interface should be allowed.");
    gnet_property->props[202].ev_changed = event_new("enable_shell_changed");
    gnet_property->props[202].save = TRUE;
    gnet_property->props[202].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[202].type               = PROP_TYPE_BOOLEAN;
    gnet_property->props[202].data.boolean.def   = &enable_shell_def;
    gnet_property->props[202].data.boolean.value = &enable_shell;


    /*
     * PROP_ENTRY_REMOVAL_TIMEOUT:
     *
     * General data:
     */
    gnet_property->props[203].name = "entry_removal_timeout";
    gnet_property->props[203].desc = _("Amount of seconds to leave 'dead' entries around so that they can still be displayed by the GUI along with the termination status.");
    gnet_property->props[203].ev_changed = event_new("entry_removal_timeout_changed");
    gnet_property->props[203].save = TRUE;
    gnet_property->props[203].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[203].type               = PROP_TYPE_GUINT32;
    gnet_property->props[203].data.guint32.def   = &entry_removal_timeout_def;
    gnet_property->props[203].data.guint32.value = &entry_removal_timeout;
    gnet_property->props[203].data.guint32.choices = NULL;
    gnet_property->props[203].data.guint32.max   = 60;
    gnet_property->props[203].data.guint32.min   = 1;


    /*
     * PROP_NODE_WATCH_SIMILAR_QUERIES:
     *
     * General data:
     */
    gnet_property->props[204].name = "node_watch_similar_queries";
    gnet_property->props[204].desc = _("Whether gtk-gnutella should actively monitor query strings by TTL and hop count and drop duplicates.  Only applies when not running as a leaf node, and only for queries with hop count > 0, i.e. not from our immediate neighbour.  Dropped queries will be accounted for in the 'Message throttle' counter.");
    gnet_property->props[204].ev_changed = event_new("node_watch_similar_queries_changed");
    gnet_property->props[204].save = TRUE;
    gnet_property->props[204].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[204].type               = PROP_TYPE_BOOLEAN;
    gnet_property->props[204].data.boolean.def   = &node_watch_similar_queries_def;
    gnet_property->props[204].data.boolean.value = &node_watch_similar_queries;


    /*
     * PROP_NODE_QUERIES_HALF_LIFE:
     *
     * General data:
     */
    gnet_property->props[205].name = "node_queries_half_life";
    gnet_property->props[205].desc = _("Half the duration during which gtk-gnutella should remember the recently relayed queries by TTL and hop count.  The default value of 5 should be just fine, but you can experiment with different settings if you want.  The higher it is set, the more likely you are to drop legitimate queries, so be careful.");
    gnet_property->props[205].ev_changed = event_new("node_queries_half_life_changed");
    gnet_property->props[205].save = TRUE;
    gnet_property->props[205].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[205].type               = PROP_TYPE_GUINT32;
    gnet_property->props[205].data.guint32.def   = &node_queries_half_life_def;
    gnet_property->props[205].data.guint32.value = &node_queries_half_life;
    gnet_property->props[205].data.guint32.choices = NULL;
    gnet_property->props[205].data.guint32.max   = 10;
    gnet_property->props[205].data.guint32.min   = 1;


    /*
     * PROP_NODE_REQUERY_THRESHOLD:
     *
     * General data:
     */
    gnet_property->props[206].name = "node_requery_threshold";
    gnet_property->props[206].desc = _("The minimum amount of seconds to enforce between two identical queries from leaf nodes.  If the requery too early, it is dropped and accounted for in the 'Message throttle' counter.  Too frequent requeries are harmful for the network, yet we must allow some amount of requerying given the dynamic nature of Gnutella connections.  You can't disable this checking, but you can lower the constraint significantly. Deviations from the default of 1700 have exponential effects on the network traffic.");
    gnet_property->props[206].ev_changed = event_new("node_requery_threshold_changed");
    gnet_property->props[206].save = TRUE;
    gnet_property->props[206].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[206].type               = PROP_TYPE_GUINT32;
    gnet_property->props[206].data.guint32.def   = &node_requery_threshold_def;
    gnet_property->props[206].data.guint32.value = &node_requery_threshold;
    gnet_property->props[206].data.guint32.choices = NULL;
    gnet_property->props[206].data.guint32.max   = 1800;
    gnet_property->props[206].data.guint32.min   = 1200;


    /*
     * PROP_LIBRARY_RESCAN_TIMESTAMP:
     *
     * General data:
     */
    gnet_property->props[207].name = "library_rescan_timestamp";
    gnet_property->props[207].desc = _("Time at which we started the last scan of the library.");
    gnet_property->props[207].ev_changed = event_new("library_rescan_timestamp_changed");
    gnet_property->props[207].save = FALSE;
    gnet_property->props[207].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[207].type               = PROP_TYPE_GUINT32;
    gnet_property->props[207].data.guint32.def   = &library_rescan_timestamp_def;
    gnet_property->props[207].data.guint32.value = &library_rescan_timestamp;
    gnet_property->props[207].data.guint32.choices = NULL;
    gnet_property->props[207].data.guint32.max   = 0xFFFFFFFF;
    gnet_property->props[207].data.guint32.min   = 0x00000000;


    /*
     * PROP_LIBRARY_RESCAN_TIME:
     *
     * General data:
     */
    gnet_property->props[208].name = "library_rescan_time";
    gnet_property->props[208].desc = _("Time spent scanning the library, in seconds.");
    gnet_property->props[208].ev_changed = event_new("library_rescan_time_changed");
    gnet_property->props[208].save = FALSE;
    gnet_property->props[208].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[208].type               = PROP_TYPE_GUINT32;
    gnet_property->props[208].data.guint32.def   = &library_rescan_time_def;
    gnet_property->props[208].data.guint32.value = &library_rescan_time;
    gnet_property->props[208].data.guint32.choices = NULL;
    gnet_property->props[208].data.guint32.max   = 0xFFFFFFFF;
    gnet_property->props[208].data.guint32.min   = 0x00000000;


    /*
     * PROP_QRP_INDEXING_TIMESTAMP:
     *
     * General data:
     */
    gnet_property->props[209].name = "qrp_indexing_timestamp";
    gnet_property->props[209].desc = _("Time at which we started shared file indexing.");
    gnet_property->props[209].ev_changed = event_new("qrp_indexing_timestamp_changed");
    gnet_property->props[209].save = FALSE;
    gnet_property->props[209].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[209].type               = PROP_TYPE_GUINT32;
    gnet_property->props[209].data.guint32.def   = &qrp_indexing_timestamp_def;
    gnet_property->props[209].data.guint32.value = &qrp_indexing_timestamp;
    gnet_property->props[209].data.guint32.choices = NULL;
    gnet_property->props[209].data.guint32.max   = 0xFFFFFFFF;
    gnet_property->props[209].data.guint32.min   = 0x00000000;


    /*
     * PROP_QRP_INDEXING_TIME:
     *
     * General data:
     */
    gnet_property->props[210].name = "qrp_indexing_time";
    gnet_property->props[210].desc = _("Time spent indexing shared files.");
    gnet_property->props[210].ev_changed = event_new("qrp_indexing_time_changed");
    gnet_property->props[210].save = FALSE;
    gnet_property->props[210].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[210].type               = PROP_TYPE_GUINT32;
    gnet_property->props[210].data.guint32.def   = &qrp_indexing_time_def;
    gnet_property->props[210].data.guint32.value = &qrp_indexing_time;
    gnet_property->props[210].data.guint32.choices = NULL;
    gnet_property->props[210].data.guint32.max   = 0xFFFFFFFF;
    gnet_property->props[210].data.guint32.min   = 0x00000000;


    /*
     * PROP_QRP_TIMESTAMP:
     *
     * General data:
     */
    gnet_property->props[211].name = "qrp_timestamp";
    gnet_property->props[211].desc = _("Time at which we started query routing table generation.");
    gnet_property->props[211].ev_changed = event_new("qrp_timestamp_changed");
    gnet_property->props[211].save = FALSE;
    gnet_property->props[211].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[211].type               = PROP_TYPE_GUINT32;
    gnet_property->props[211].data.guint32.def   = &qrp_timestamp_def;
    gnet_property->props[211].data.guint32.value = &qrp_timestamp;
    gnet_property->props[211].data.guint32.choices = NULL;
    gnet_property->props[211].data.guint32.max   = 0xFFFFFFFF;
    gnet_property->props[211].data.guint32.min   = 0x00000000;


    /*
     * PROP_QRP_COMPUTATION_TIME:
     *
     * General data:
     */
    gnet_property->props[212].name = "qrp_computation_time";
    gnet_property->props[212].desc = _("Time spent computing the QRP table, in seconds.");
    gnet_property->props[212].ev_changed = event_new("qrp_computation_time_changed");
    gnet_property->props[212].save = FALSE;
    gnet_property->props[212].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[212].type               = PROP_TYPE_GUINT32;
    gnet_property->props[212].data.guint32.def   = &qrp_computation_time_def;
    gnet_property->props[212].data.guint32.value = &qrp_computation_time;
    gnet_property->props[212].data.guint32.choices = NULL;
    gnet_property->props[212].data.guint32.max   = 0xFFFFFFFF;
    gnet_property->props[212].data.guint32.min   = 0x00000000;


    /*
     * PROP_QRP_PATCH_TIMESTAMP:
     *
     * General data:
     */
    gnet_property->props[213].name = "qrp_patch_timestamp";
    gnet_property->props[213].desc = _("Time at which we started computing our QRP patch.");
    gnet_property->props[213].ev_changed = event_new("qrp_patch_timestamp_changed");
    gnet_property->props[213].save = FALSE;
    gnet_property->props[213].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[213].type               = PROP_TYPE_GUINT32;
    gnet_property->props[213].data.guint32.def   = &qrp_patch_timestamp_def;
    gnet_property->props[213].data.guint32.value = &qrp_patch_timestamp;
    gnet_property->props[213].data.guint32.choices = NULL;
    gnet_property->props[213].data.guint32.max   = 0xFFFFFFFF;
    gnet_property->props[213].data.guint32.min   = 0x00000000;


    /*
     * PROP_QRP_PATCH_COMPUTATION_TIME:
     *
     * General data:
     */
    gnet_property->props[214].name = "qrp_patch_computation_time";
    gnet_property->props[214].desc = _("Time spent computing the QRP table patch, in seconds.");
    gnet_property->props[214].ev_changed = event_new("qrp_patch_computation_time_changed");
    gnet_property->props[214].save = FALSE;
    gnet_property->props[214].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[214].type               = PROP_TYPE_GUINT32;
    gnet_property->props[214].data.guint32.def   = &qrp_patch_computation_time_def;
    gnet_property->props[214].data.guint32.value = &qrp_patch_computation_time;
    gnet_property->props[214].data.guint32.choices = NULL;
    gnet_property->props[214].data.guint32.max   = 0xFFFFFFFF;
    gnet_property->props[214].data.guint32.min   = 0x00000000;


    /*
     * PROP_QRP_GENERATION:
     *
     * General data:
     */
    gnet_property->props[215].name = "qrp_generation";
    gnet_property->props[215].desc = _("Query routing table generation number.");
    gnet_property->props[215].ev_changed = event_new("qrp_generation_changed");
    gnet_property->props[215].save = FALSE;
    gnet_property->props[215].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[215].type               = PROP_TYPE_GUINT32;
    gnet_property->props[215].data.guint32.def   = &qrp_generation_def;
    gnet_property->props[215].data.guint32.value = &qrp_generation;
    gnet_property->props[215].data.guint32.choices = NULL;
    gnet_property->props[215].data.guint32.max   = 0xFFFFFFFF;
    gnet_property->props[215].data.guint32.min   = 0x00000000;


    /*
     * PROP_QRP_SLOTS:
     *
     * General data:
     */
    gnet_property->props[216].name = "qrp_slots";
    gnet_property->props[216].desc = _("Amount of slots used by our QRP table.");
    gnet_property->props[216].ev_changed = event_new("qrp_slots_changed");
    gnet_property->props[216].save = FALSE;
    gnet_property->props[216].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[216].type               = PROP_TYPE_GUINT32;
    gnet_property->props[216].data.guint32.def   = &qrp_slots_def;
    gnet_property->props[216].data.guint32.value = &qrp_slots;
    gnet_property->props[216].data.guint32.choices = NULL;
    gnet_property->props[216].data.guint32.max   = 0xFFFFFFFF;
    gnet_property->props[216].data.guint32.min   = 0x00000000;


    /*
     * PROP_QRP_SLOTS_FILLED:
     *
     * General data:
     */
    gnet_property->props[217].name = "qrp_slots_filled";
    gnet_property->props[217].desc = _("Amount of slots filled within our QRP table.");
    gnet_property->props[217].ev_changed = event_new("qrp_slots_filled_changed");
    gnet_property->props[217].save = FALSE;
    gnet_property->props[217].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[217].type               = PROP_TYPE_GUINT32;
    gnet_property->props[217].data.guint32.def   = &qrp_slots_filled_def;
    gnet_property->props[217].data.guint32.value = &qrp_slots_filled;
    gnet_property->props[217].data.guint32.choices = NULL;
    gnet_property->props[217].data.guint32.max   = 0xFFFFFFFF;
    gnet_property->props[217].data.guint32.min   = 0x00000000;


    /*
     * PROP_QRP_FILL_RATIO:
     *
     * General data:
     */
    gnet_property->props[218].name = "qrp_fill_ratio";
    gnet_property->props[218].desc = _("Percentage of slots filled within our QRP table.");
    gnet_property->props[218].ev_changed = event_new("qrp_fill_ratio_changed");
    gnet_property->props[218].save = FALSE;
    gnet_property->props[218].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[218].type               = PROP_TYPE_GUINT32;
    gnet_property->props[218].data.guint32.def   = &qrp_fill_ratio_def;
    gnet_property->props[218].data.guint32.value = &qrp_fill_ratio;
    gnet_property->props[218].data.guint32.choices = NULL;
    gnet_property->props[218].data.guint32.max   = 0xFFFFFFFF;
    gnet_property->props[218].data.guint32.min   = 0x00000000;


    /*
     * PROP_QRP_CONFLICT_RATIO:
     *
     * General data:
     */
    gnet_property->props[219].name = "qrp_conflict_ratio";
    gnet_property->props[219].desc = _("Percentage of hashing conflicts whilst inserting data in our QRP table.");
    gnet_property->props[219].ev_changed = event_new("qrp_conflict_ratio_changed");
    gnet_property->props[219].save = FALSE;
    gnet_property->props[219].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[219].type               = PROP_TYPE_GUINT32;
    gnet_property->props[219].data.guint32.def   = &qrp_conflict_ratio_def;
    gnet_property->props[219].data.guint32.value = &qrp_conflict_ratio;
    gnet_property->props[219].data.guint32.choices = NULL;
    gnet_property->props[219].data.guint32.max   = 0xFFFFFFFF;
    gnet_property->props[219].data.guint32.min   = 0x00000000;


    /*
     * PROP_QRP_HASHED_KEYWORDS:
     *
     * General data:
     */
    gnet_property->props[220].name = "qrp_hashed_keywords";
    gnet_property->props[220].desc = _("Amount of hashed keywords in our QRP table.");
    gnet_property->props[220].ev_changed = event_new("qrp_hashed_keywords_changed");
    gnet_property->props[220].save = FALSE;
    gnet_property->props[220].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[220].type               = PROP_TYPE_GUINT32;
    gnet_property->props[220].data.guint32.def   = &qrp_hashed_keywords_def;
    gnet_property->props[220].data.guint32.value = &qrp_hashed_keywords;
    gnet_property->props[220].data.guint32.choices = NULL;
    gnet_property->props[220].data.guint32.max   = 0xFFFFFFFF;
    gnet_property->props[220].data.guint32.min   = 0x00000000;


    /*
     * PROP_QRP_PATCH_RAW_LENGTH:
     *
     * General data:
     */
    gnet_property->props[221].name = "qrp_patch_raw_length";
    gnet_property->props[221].desc = _("Total raw size of the QRP table patch, in bytes.");
    gnet_property->props[221].ev_changed = event_new("qrp_patch_raw_length_changed");
    gnet_property->props[221].save = FALSE;
    gnet_property->props[221].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[221].type               = PROP_TYPE_GUINT32;
    gnet_property->props[221].data.guint32.def   = &qrp_patch_raw_length_def;
    gnet_property->props[221].data.guint32.value = &qrp_patch_raw_length;
    gnet_property->props[221].data.guint32.choices = NULL;
    gnet_property->props[221].data.guint32.max   = 0xFFFFFFFF;
    gnet_property->props[221].data.guint32.min   = 0x00000000;


    /*
     * PROP_QRP_PATCH_LENGTH:
     *
     * General data:
     */
    gnet_property->props[222].name = "qrp_patch_length";
    gnet_property->props[222].desc = _("Final QRP table patch length, after possible compression.");
    gnet_property->props[222].ev_changed = event_new("qrp_patch_length_changed");
    gnet_property->props[222].save = FALSE;
    gnet_property->props[222].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[222].type               = PROP_TYPE_GUINT32;
    gnet_property->props[222].data.guint32.def   = &qrp_patch_length_def;
    gnet_property->props[222].data.guint32.value = &qrp_patch_length;
    gnet_property->props[222].data.guint32.choices = NULL;
    gnet_property->props[222].data.guint32.max   = 0xFFFFFFFF;
    gnet_property->props[222].data.guint32.min   = 0x00000000;


    /*
     * PROP_QRP_PATCH_COMP_RATIO:
     *
     * General data:
     */
    gnet_property->props[223].name = "qrp_patch_comp_ratio";
    gnet_property->props[223].desc = _("QRP table patch compression ratio, in percent, 0 means none.");
    gnet_property->props[223].ev_changed = event_new("qrp_patch_comp_ratio_changed");
    gnet_property->props[223].save = FALSE;
    gnet_property->props[223].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[223].type               = PROP_TYPE_GUINT32;
    gnet_property->props[223].data.guint32.def   = &qrp_patch_comp_ratio_def;
    gnet_property->props[223].data.guint32.value = &qrp_patch_comp_ratio;
    gnet_property->props[223].data.guint32.choices = NULL;
    gnet_property->props[223].data.guint32.max   = 0xFFFFFFFF;
    gnet_property->props[223].data.guint32.min   = 0x00000000;


    /*
     * PROP_ANCIENT_VERSION_FORCE:
     *
     * General data:
     */
    gnet_property->props[224].name = "ancient_version_force";
    gnet_property->props[224].desc = _("This property must be set to the current version number of gtk-gnutella in order to allow it to run when it is ancient.");
    gnet_property->props[224].ev_changed = event_new("ancient_version_force_changed");
    gnet_property->props[224].save = TRUE;
    gnet_property->props[224].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[224].type               = PROP_TYPE_STRING;
    gnet_property->props[224].data.string.def    = &ancient_version_force_def;
    gnet_property->props[224].data.string.value  = &ancient_version_force;
    if (gnet_property->props[224].data.string.def) {
        *gnet_property->props[224].data.string.value =
            g_strdup(eval_subst(*gnet_property->props[224].data.string.def));
    }


    /*
     * PROP_ANCIENT_VERSION_LEFT_DAYS:
     *
     * General data:
     */
    gnet_property->props[225].name = "ancient_version_left_days";
    gnet_property->props[225].desc = _("Indicates that gtk-gnutella will expire in that many days.");
    gnet_property->props[225].ev_changed = event_new("ancient_version_left_days_changed");
    gnet_property->props[225].save = FALSE;
    gnet_property->props[225].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[225].type               = PROP_TYPE_GUINT32;
    gnet_property->props[225].data.guint32.def   = &ancient_version_left_days_def;
    gnet_property->props[225].data.guint32.value = &ancient_version_left_days;
    gnet_property->props[225].data.guint32.choices = NULL;
    gnet_property->props[225].data.guint32.max   = 0xFFFFFFFF;
    gnet_property->props[225].data.guint32.min   = 0x00000000;


    /*
     * PROP_FILE_DESCRIPTOR_SHORTAGE:
     *
     * General data:
     */
    gnet_property->props[226].name = "file_descriptor_shortage";
    gnet_property->props[226].desc = _("When set, gtk-gnutella is running short on file descriptors, but normal operations are still possible. The condition automatically clears itself after 10 minutes without any more shortage.");
    gnet_property->props[226].ev_changed = event_new("file_descriptor_shortage_changed");
    gnet_property->props[226].save = FALSE;
    gnet_property->props[226].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[226].type               = PROP_TYPE_BOOLEAN;
    gnet_property->props[226].data.boolean.def   = &file_descriptor_shortage_def;
    gnet_property->props[226].data.boolean.value = &file_descriptor_shortage;


    /*
     * PROP_FILE_DESCRIPTOR_RUNOUT:
     *
     * General data:
     */
    gnet_property->props[227].name = "file_descriptor_runout";
    gnet_property->props[227].desc = _("When set, gtk-gnutella has run out of file descriptors, and operations are necessarily degraded, if not impossible. The condition automatically clears itself after 10 minutes past the last occurance.");
    gnet_property->props[227].ev_changed = event_new("file_descriptor_runout_changed");
    gnet_property->props[227].save = FALSE;
    gnet_property->props[227].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[227].type               = PROP_TYPE_BOOLEAN;
    gnet_property->props[227].data.boolean.def   = &file_descriptor_runout_def;
    gnet_property->props[227].data.boolean.value = &file_descriptor_runout;


    /*
     * PROP_ENABLE_G2_SUPPORT:
     *
     * General data:
     */
    gnet_property->props[228].name = "enable_g2_support";
    gnet_property->props[228].desc = _("When set, gtk-gnutella will accept and handle G2 connections. ");
    gnet_property->props[228].ev_changed = event_new("enable_g2_support_changed");
    gnet_property->props[228].save = TRUE;
    gnet_property->props[228].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[228].type               = PROP_TYPE_BOOLEAN;
    gnet_property->props[228].data.boolean.def   = &enable_g2_support_def;
    gnet_property->props[228].data.boolean.value = &enable_g2_support;


    /*
     * PROP_CONVERT_SPACES:
     *
     * General data:
     */
    gnet_property->props[229].name = "convert_spaces";
    gnet_property->props[229].desc = _("If set, spaces in filenames are replaced with underscores.");
    gnet_property->props[229].ev_changed = event_new("convert_spaces_changed");
    gnet_property->props[229].save = TRUE;
    gnet_property->props[229].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[229].type               = PROP_TYPE_BOOLEAN;
    gnet_property->props[229].data.boolean.def   = &convert_spaces_def;
    gnet_property->props[229].data.boolean.value = &convert_spaces;


    /*
     * PROP_CONVERT_EVIL_CHARS:
     *
     * General data:
     */
    gnet_property->props[230].name = "convert_evil_chars";
    gnet_property->props[230].desc = _("If set, meta shell characters in filenames are replaced with underscores. (This must also be enabled for FAT partitions.)");
    gnet_property->props[230].ev_changed = event_new("convert_evil_chars_changed");
    gnet_property->props[230].save = TRUE;
    gnet_property->props[230].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[230].type               = PROP_TYPE_BOOLEAN;
    gnet_property->props[230].data.boolean.def   = &convert_evil_chars_def;
    gnet_property->props[230].data.boolean.value = &convert_evil_chars;


    /*
     * PROP_CONVERT_OLD_FILENAMES:
     *
     * General data:
     */
    gnet_property->props[231].name = "convert_old_filenames";
    gnet_property->props[231].desc = _("If set, gtk-gnutella will, upon startup, sanitize filenames by converting spaces and/or evil characters in them, according to your settings, on existing filenames in your temporary downloading directory. By default, the above settings apply only on newly created entries, not existing ones.");
    gnet_property->props[231].ev_changed = event_new("convert_old_filenames_changed");
    gnet_property->props[231].save = TRUE;
    gnet_property->props[231].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[231].type               = PROP_TYPE_BOOLEAN;
    gnet_property->props[231].data.boolean.def   = &convert_old_filenames_def;
    gnet_property->props[231].data.boolean.value = &convert_old_filenames;


    /*
     * PROP_TLS_ENFORCE:
     *
     * General data:
     */
    gnet_property->props[232].name = "tls_enforce";
    gnet_property->props[232].desc = _("If set, all outgoing connections are tunneled over TLS.");
    gnet_property->props[232].ev_changed = event_new("tls_enforce_changed");
    gnet_property->props[232].save = TRUE;
    gnet_property->props[232].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[232].type               = PROP_TYPE_BOOLEAN;
    gnet_property->props[232].data.boolean.def   = &tls_enforce_def;
    gnet_property->props[232].data.boolean.value = &tls_enforce;


    /*
     * PROP_GNET_DEFLATE_ENABLED:
     *
     * General data:
     */
    gnet_property->props[233].name = "gnet_deflate_enabled";
    gnet_property->props[233].desc = _("If not set, support for Gnutella connection compression is disabled.");
    gnet_property->props[233].ev_changed = event_new("gnet_deflate_enabled_changed");
    gnet_property->props[233].save = TRUE;
    gnet_property->props[233].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[233].type               = PROP_TYPE_BOOLEAN;
    gnet_property->props[233].data.boolean.def   = &gnet_deflate_enabled_def;
    gnet_property->props[233].data.boolean.value = &gnet_deflate_enabled;


    /*
     * PROP_ENABLE_UDP:
     *
     * General data:
     */
    gnet_property->props[234].name = "enable_udp";
    gnet_property->props[234].desc = _("Whether UDP shall be used in complement to TCP.  When set, gtk-gnutella will also listen for UDP traffic on the same port as the one configured for TCP and process incoming Gnutella traffic in almost the same way as if it was received via TCP.  It is safe to leave this set, which is the default behaviour.");
    gnet_property->props[234].ev_changed = event_new("enable_udp_changed");
    gnet_property->props[234].save = TRUE;
    gnet_property->props[234].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[234].type               = PROP_TYPE_BOOLEAN;
    gnet_property->props[234].data.boolean.def   = &enable_udp_def;
    gnet_property->props[234].data.boolean.value = &enable_udp;


    /*
     * PROP_PROCESS_OOB_QUERIES:
     *
     * General data:
     */
    gnet_property->props[235].name = "process_oob_queries";
    gnet_property->props[235].desc = _("Whether gtk-gnutella should honour the request for out-of-band delivery of query hits via UDP, provided UDP support is enabled.  It should not be necessary to add a port forwarding to enable this as your node will be the origin of the UDP traffic and can therefore receive replies sent to the transient UDP port opened by a masquerading firewall.  It is enabled by default because it is deemed safe, as your node controls the bulk of the emitted traffic and honours the bandwidth limitations.");
    gnet_property->props[235].ev_changed = event_new("process_oob_queries_changed");
    gnet_property->props[235].save = TRUE;
    gnet_property->props[235].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[235].type               = PROP_TYPE_BOOLEAN;
    gnet_property->props[235].data.boolean.def   = &process_oob_queries_def;
    gnet_property->props[235].data.boolean.value = &process_oob_queries;


    /*
     * PROP_SEND_OOB_QUERIES:
     *
     * General data:
     */
    gnet_property->props[236].name = "send_oob_queries";
    gnet_property->props[236].desc = _("Whether gtk-gnutella should send queries requesting out-of-band delivery of query hits via UDP.  The setting is ignored if you seem to be UDP-firewalled, i.e. cannot receive unsolicited UDP traffic.  You need to enable UDP support first.  This can cause the reception of vast quantities of UDP replies, so you may choose to disable this feature.  If disabled, your hits will travel through the Gnutella network and can be dropped by any flow-controlled relaying node, limiting the results you can get.");
    gnet_property->props[236].ev_changed = event_new("send_oob_queries_changed");
    gnet_property->props[236].save = TRUE;
    gnet_property->props[236].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[236].type               = PROP_TYPE_BOOLEAN;
    gnet_property->props[236].data.boolean.def   = &send_oob_queries_def;
    gnet_property->props[236].data.boolean.value = &send_oob_queries;


    /*
     * PROP_PROXY_OOB_QUERIES:
     *
     * General data:
     */
    gnet_property->props[237].name = "proxy_oob_queries";
    gnet_property->props[237].desc = _("Whether gtk-gnutella should, when running as ultrapeer, act as proxy for leaf queries that are not requesting OOB delivery of query hits: gtk-gnutella will claim the hits from the remote nodes and forward the hits to the proper leaf.  This is very beneficial for the leaves, but can cause huge bursts of UDP traffic coming back to you.  If you disable it all ultrapeers connected to you will have to relay the hits, possibly dropping other query messages and lowering the efficiency of the search network.");
    gnet_property->props[237].ev_changed = event_new("proxy_oob_queries_changed");
    gnet_property->props[237].save = TRUE;
    gnet_property->props[237].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[237].type               = PROP_TYPE_BOOLEAN;
    gnet_property->props[237].data.boolean.def   = &proxy_oob_queries_def;
    gnet_property->props[237].data.boolean.value = &proxy_oob_queries;


    /*
     * PROP_UPLOADS_STALLING:
     *
     * General data:
     */
    gnet_property->props[238].name = "uploads_stalling";
    gnet_property->props[238].desc = _("Whether uploads are frequently stalling, indicating that the bandwidth is saturated.  Avoid running as an ultra-node under those conditions.");
    gnet_property->props[238].ev_changed = event_new("uploads_stalling_changed");
    gnet_property->props[238].save = FALSE;
    gnet_property->props[238].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[238].type               = PROP_TYPE_BOOLEAN;
    gnet_property->props[238].data.boolean.def   = &uploads_stalling_def;
    gnet_property->props[238].data.boolean.value = &uploads_stalling;


    /*
     * PROP_ALLOW_AUTO_REQUERIES:
     *
     * General data:
     */
    gnet_property->props[239].name = "allow_auto_requeries";
    gnet_property->props[239].desc = _("If set to TRUE, automatic requeries are allowed.");
    gnet_property->props[239].ev_changed = event_new("allow_auto_requeries_changed");
    gnet_property->props[239].save = TRUE;
    gnet_property->props[239].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[239].type               = PROP_TYPE_BOOLEAN;
    gnet_property->props[239].data.boolean.def   = &allow_auto_requeries_def;
    gnet_property->props[239].data.boolean.value = &allow_auto_requeries;


    /*
     * PROP_USE_GLOBAL_HOSTILES_TXT:
     *
     * General data:
     */
    gnet_property->props[240].name = "use_global_hostiles_txt";
    gnet_property->props[240].desc = _("If set to TRUE, the global hostiles.txt is used as well as the private $GTK_GNUTELLA_DIR/hostiles.txt. This allows to separate your private ban list from the global one distributed with Gtk-Gnutella.");
    gnet_property->props[240].ev_changed = event_new("use_global_hostiles_txt_changed");
    gnet_property->props[240].save = TRUE;
    gnet_property->props[240].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[240].type               = PROP_TYPE_BOOLEAN;
    gnet_property->props[240].data.boolean.def   = &use_global_hostiles_txt_def;
    gnet_property->props[240].data.boolean.value = &use_global_hostiles_txt;


    /*
     * PROP_USE_SO_LINGER:
     *
     * General data:
     */
    gnet_property->props[241].name = "use_so_linger";
    gnet_property->props[241].desc = _("If set to TRUE, SO_LINGER is used for sockets.");
    gnet_property->props[241].ev_changed = event_new("use_so_linger_changed");
    gnet_property->props[241].save = TRUE;
    gnet_property->props[241].vector_size = 1;

    /* Type specific data: */
    gnet_property->props[241].type               = PROP_TYPE_BOOLEAN;
    gnet_property->props[241].data.boolean.def   = &use_so_linger_def;
    gnet_property->props[241].data.boolean.value = &use_so_linger;

    gnet_property->byName = g_hash_table_new(g_str_hash, g_str_equal);
    for (n = 0; n < GNET_PROPERTY_NUM; n ++) {
        g_hash_table_insert(gnet_property->byName,
            gnet_property->props[n].name, GINT_TO_POINTER(n+(NO_PROP+1)));
    }

    return gnet_property;
}

/**
 * Free memory allocated by the property set.
 */
void
gnet_prop_shutdown(void) {
    guint32 n;

    if (gnet_property->byName) {
        g_hash_table_destroy(gnet_property->byName);
        gnet_property->byName = NULL;
    }

    for (n = 0; n < GNET_PROPERTY_NUM; n ++) {
        if (gnet_property->props[n].type == PROP_TYPE_STRING) {
			gchar **p = gnet_property->props[n].data.string.value;
            struct event *e = gnet_property->props[n].ev_changed;
			if (*p)
				G_FREE_NULL(*p);
            if (e)
                event_destroy(e);
        }
    }

    G_FREE_NULL(gnet_property->props);
    G_FREE_NULL(gnet_property);
}

prop_def_t *
gnet_prop_get_def(property_t p)
{
    return prop_get_def(gnet_property, p);
}

/**
 * Add a change listener to a given property. If init is TRUE then
 * the listener is immediately called.
 */
void
gnet_prop_add_prop_changed_listener(
    property_t prop, prop_changed_listener_t l, gboolean init)
{
    prop_add_prop_changed_listener(gnet_property, prop, l, init);
}

/**
 * Add a change listener to a given property. If init is TRUE then
 * the listener is immediately called.
 */
void
gnet_prop_add_prop_changed_listener_full(
    property_t prop, prop_changed_listener_t l, gboolean init,
    enum frequency_type freq, guint32 interval)
{
    prop_add_prop_changed_listener_full(gnet_property, prop, l, init,
        freq, interval);
}

void
gnet_prop_remove_prop_changed_listener(
    property_t prop, prop_changed_listener_t l)
{
    prop_remove_prop_changed_listener(gnet_property, prop, l);
}

void
gnet_prop_set_boolean(
    property_t prop, const gboolean *src, size_t offset, size_t length)
{
    prop_set_boolean(gnet_property, prop, src, offset, length);
}

gboolean *
gnet_prop_get_boolean(
    property_t prop, gboolean *t, size_t offset, size_t length)
{
    return prop_get_boolean(gnet_property, prop, t, offset, length);
}

void
gnet_prop_set_guint32(
    property_t prop, const guint32 *src, size_t offset, size_t length)
{
    prop_set_guint32(gnet_property, prop, src, offset, length);
}

guint32 *
gnet_prop_get_guint32(
    property_t prop, guint32 *t, size_t offset, size_t length)
{
    return prop_get_guint32(gnet_property, prop, t, offset, length);
}

void
gnet_prop_set_guint64(
    property_t prop, const guint64 *src, size_t offset, size_t length)
{
    prop_set_guint64(gnet_property, prop, src, offset, length);
}

guint64 *
gnet_prop_get_guint64(
    property_t prop, guint64 *t, size_t offset, size_t length)
{
    return prop_get_guint64(gnet_property, prop, t, offset, length);
}

void
gnet_prop_set_string(property_t prop, const gchar *val)
{
    prop_set_string(gnet_property, prop, val);
}

gchar *
gnet_prop_get_string(property_t prop, gchar *t, size_t size)
{
    return prop_get_string(gnet_property, prop, t, size);
}

void
gnet_prop_set_storage(property_t p, const gchar *v, size_t l)
{
    prop_set_storage(gnet_property, p, v, l);
}

gchar *
gnet_prop_get_storage(property_t p, gchar *t, size_t l)
{
    return prop_get_storage(gnet_property, p, t, l);
}

gchar *
gnet_prop_to_string(property_t prop)
{
    return prop_to_string(gnet_property, prop);
}

const gchar *
gnet_prop_name(property_t p)
{
    return prop_name(gnet_property, p);
}

const gchar *
gnet_prop_description(property_t p)
{
    return prop_description(gnet_property, p);
}

property_t
gnet_prop_get_by_name(const gchar *name)
{
    return GPOINTER_TO_UINT(
        g_hash_table_lookup(gnet_property->byName, name));
}

GSList *
gnet_prop_get_by_regex(const gchar *pattern, gint *error)
{
    return prop_get_by_regex(gnet_property, pattern, error);
}

void
gnet_prop_set_from_string(property_t prop, const gchar *val)
{
	prop_set_from_string(gnet_property, prop, val, FALSE);	
}

/**
 * Returns a new stub struct for this property set. Just g_free it
 * when it is no longer needed. All fields are read only!
 */
prop_set_stub_t *
gnet_prop_get_stub(void)
{
    prop_set_stub_t *stub;

    stub          = g_new0(prop_set_stub_t, 1);
    stub->size    = GNET_PROPERTY_NUM;
    stub->offset  = GNET_PROPERTY_MIN;
    stub->get_def = gnet_prop_get_def;
    stub->get_by_name = gnet_prop_get_by_name;
    stub->to_string = gnet_prop_to_string;

    stub->prop_changed_listener.add =
        gnet_prop_add_prop_changed_listener;
    stub->prop_changed_listener.add_full =
        gnet_prop_add_prop_changed_listener_full;
    stub->prop_changed_listener.remove =
        gnet_prop_remove_prop_changed_listener;

    stub->boolean.get = gnet_prop_get_boolean;
    stub->boolean.set = gnet_prop_set_boolean;

    stub->guint32.get = gnet_prop_get_guint32;
    stub->guint32.set = gnet_prop_set_guint32;

    stub->guint64.get = gnet_prop_get_guint64;
    stub->guint64.set = gnet_prop_set_guint64;

    stub->string.get = gnet_prop_get_string;
    stub->string.set = gnet_prop_set_string;

    stub->storage.get = gnet_prop_get_storage;
    stub->storage.set = gnet_prop_set_storage;

    return stub;
}
