/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  GThumb
 *
 *  Copyright (C) 2001 The Free Software Foundation, Inc.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Street #330, Boston, MA 02111-1307, USA.
 */

#ifndef TOOLBAR_H
#define TOOLBAR_H

#include "icons/toolbar_dir.xpm"
#include "icons/toolbar_go_up.xpm"
#include "icons/toolbar_catalog.xpm"
#include "icons/toolbar_zoom_in.xpm"
#include "icons/toolbar_zoom_out.xpm"
#include "icons/toolbar_no_zoom.xpm"
#include "icons/toolbar_zoom_fit.xpm"
#include "icons/toolbar_fullscreen.xpm"

/* Definition of the toolbar. */

GnomeUIInfo toolbar_data[] = {
	{ GNOME_APP_UI_ITEM, 
	  N_("Up"), N_("Go up one level"), 
	  go_up_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_DATA, toolbar_go_up_xpm,
	  0, 0, NULL },

	{ GNOME_APP_UI_ITEM, 
	  N_("Refresh"), N_("Reload current directory"), 
	  refresh_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_PIXMAP_REFRESH, 
	  0, 0, NULL },

	{ GNOME_APP_UI_ITEM,
	  N_("Home"), N_("Go to the home directory"),
	  go_home_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_PIXMAP_HOME, 
	  0, 0, NULL },

	GNOMEUIINFO_SEPARATOR,

	{ GNOME_APP_UI_TOGGLEITEM,
	  N_("Dirs"), N_("Show directories"),
	  dir_browser_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_DATA, toolbar_dir_xpm,
	  0, 0, NULL },
	
	{ GNOME_APP_UI_TOGGLEITEM,
	  N_("Catalogs"), N_("Show catalogs"),
	  catalog_browser_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_DATA, toolbar_catalog_xpm,
	  0, 0, NULL },
	
	GNOMEUIINFO_SEPARATOR,

	{ GNOME_APP_UI_ITEM,
	  N_("Zoom In"), N_("Zoom in"),
	  zoom_in_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_DATA, toolbar_zoom_in_xpm,
	  0, 0, NULL },

	{ GNOME_APP_UI_ITEM,
	  N_("Zoom Out"), N_("Zoom out"),
	  zoom_out_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_DATA, toolbar_zoom_out_xpm,
	  0, 0, NULL },

	{ GNOME_APP_UI_ITEM,
	  N_("No Zoom"), N_("Actual Size"),
	  no_zoom_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_DATA, toolbar_no_zoom_xpm,
	  0, 0, NULL },

	{ GNOME_APP_UI_TOGGLEITEM,
	  N_("Zoom To Fit"), N_("Zoom to fit window"),
	  zoom_to_fit_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_DATA, toolbar_zoom_fit_xpm,
	  0, 0, NULL },

	GNOMEUIINFO_SEPARATOR,

	{ GNOME_APP_UI_ITEM,
	  N_("Fullscreen"), N_("View image in fullscreen mode"),
	  fullscreen_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_DATA, toolbar_fullscreen_xpm,
	  0, 0, NULL },

	GNOMEUIINFO_SEPARATOR,

	{ GNOME_APP_UI_ITEM, 
	  N_("Close"), N_("Close this window"), 
	  close_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_PIXMAP_CLOSE, 
	  0, 0, NULL },
	
    GNOMEUIINFO_END
};

#endif /* TOOLBAR_H */
