/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  GThumb
 *
 *  Copyright (C) 2001 The Free Software Foundation, Inc.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Street #330, Boston, MA 02111-1307, USA.
 */

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>
#include "gthumb-app.h"


enum {
	FOCUS_CHANGED,
	LAST_SIGNAL
};


static void gthumb_app_class_init         (GThumbAppClass *class);

static void gthumb_app_init               (GThumbApp *app);

static gint gthumb_app_key_press_event    (GtkWidget *widget,
                                           GdkEventKey *event);

static void gthumb_app_focus_changed      (GThumbApp *app,
                                           gboolean forward);


static GnomeAppClass *parent_class;
static guint gthumb_app_signals[LAST_SIGNAL] = { 0 };


GtkType
gthumb_app_get_type (void)
{
        static GtkType gthumbapp_type = 0;

        if (! gthumbapp_type) {
                GtkTypeInfo gnomeapp_info = {
                        "GThumbApp",
                        sizeof (GThumbApp),
                        sizeof (GThumbAppClass),
                        (GtkClassInitFunc) gthumb_app_class_init,
                        (GtkObjectInitFunc) gthumb_app_init,
                        NULL, /* reserved_1 */
                        NULL, /* reserved_2 */
                        (GtkClassInitFunc) NULL
                };

                gthumbapp_type = gtk_type_unique (gnome_app_get_type (), 
						  &gnomeapp_info);
        }

        return gthumbapp_type;
}


static void
gthumb_app_class_init (GThumbAppClass *class)
{
        GtkObjectClass *object_class;
        GtkWidgetClass *widget_class;

        object_class = (GtkObjectClass *) class;
        widget_class = (GtkWidgetClass *) class;
        parent_class = gtk_type_class (gtk_window_get_type ());

	gthumb_app_signals[FOCUS_CHANGED] =
                gtk_signal_new ("focus_changed",
                                GTK_RUN_LAST,
                                object_class->type,
                                GTK_SIGNAL_OFFSET (GThumbAppClass, focus_changed),
                                gtk_marshal_NONE__BOOL,
                                GTK_TYPE_NONE, 1,
				GTK_TYPE_BOOL);
	gtk_object_class_add_signals (object_class, gthumb_app_signals, 
                                      LAST_SIGNAL);

	widget_class->key_press_event = gthumb_app_key_press_event;
	class->focus_changed = gthumb_app_focus_changed;
}


static void
gthumb_app_init (GThumbApp *app)
{
}


GtkWidget *
gthumb_app_new (const gchar *appname, const gchar *title)
{
        GThumbApp *app;

        g_return_val_if_fail (appname != NULL, NULL);
                
        app = GTHUMB_APP (gtk_type_new (gthumb_app_get_type ()));
	gnome_app_construct (GNOME_APP (app), appname, title);

        return GTK_WIDGET (app);
}


static gint 
gthumb_app_key_press_event (GtkWidget *widget,
			    GdkEventKey *event)
{
	GtkWindow *window;
	gboolean handled;

	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (GTK_IS_WINDOW (widget), FALSE);
	g_return_val_if_fail (event != NULL, FALSE);

	window = GTK_WINDOW (widget);

	handled = FALSE;
  
	if (window->focus_widget &&
	    window->focus_widget != widget &&
	    GTK_WIDGET_IS_SENSITIVE (window->focus_widget))  {
		handled = gtk_widget_event (window->focus_widget, (GdkEvent*) event);
	}
    
	if (! handled)
		handled = gtk_accel_groups_activate (GTK_OBJECT (window), event->keyval, event->state);

	if (! handled) {
		switch (event->keyval) {
		case GDK_Up:
		case GDK_Down:
		case GDK_Left:
		case GDK_Right:
		case GDK_KP_Up:
		case GDK_KP_Down:
		case GDK_KP_Left:
		case GDK_KP_Right:
			handled = TRUE;
			break;

		case GDK_Tab:
		case GDK_ISO_Left_Tab:
			gtk_signal_emit (GTK_OBJECT (widget),
					 gthumb_app_signals[FOCUS_CHANGED],
					 event->keyval == GDK_Tab);
			handled = TRUE;
			break;

		default:
			break;
		}
	}

	if (! handled && GTK_WIDGET_CLASS (parent_class)->key_press_event)
		handled = GTK_WIDGET_CLASS (parent_class)->key_press_event (widget, event);
	
	return handled;
}


static void
gthumb_app_focus_changed (GThumbApp *app,
			  gboolean forward)
{
}
