/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  GThumb
 *
 *  Copyright (C) 2001 The Free Software Foundation, Inc.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Street #330, Boston, MA 02111-1307, USA.
 */

#ifndef TYPEDEFS_H
#define TYPEDEFS_H


#include <glib.h>

#define FILE_PREFIX    "file://"
#define CATALOG_PREFIX "catalog://"
#define SEARCH_PREFIX  "search://"

#define FILE_PREFIX_L    7
#define CATALOG_PREFIX_L 10
#define SEARCH_PREFIX_L  9

#define GLADE_FILE             "gthumb.glade"

#define RC_THUMBS_DIR          ".gqview/thumbnails"
#define RC_CATALOG_DIR         ".gqview/collections"
#define RC_COMMENTS_DIR        ".gqview/comments"
#define RC_BOOKMARKS_FILE      ".gqview/bookmarks"
#define RC_HISTORY_FILE        ".gqview/history"

#define CACHE_DIR              ".thumbnails"

#define CACHE_THUMB_EXT        ".png"
#define CATALOG_EXT            ".gqv"
#define COMMENT_EXT            ".xml"

#define CLIST_WIDTH_DEFAULT    100
#define CLIST_HEIGHT_DEFAULT   100

#define CLIST_ROW_PAD          5
#define CLIST_IMAGE_ROW_PAD    2

#define BOOKMARKS_MENU_MAX_LENGTH 35
#define HISTORY_LIST_MAX_LENGTH   35

enum {
	DIRECTION_FORWARD = 0,
	DIRECTION_REVERSE = 1
};


typedef enum {
	TOOLBAR_STYLE_DEFAULT = 0,
	TOOLBAR_STYLE_ICONS
} ToolbarStyle;


enum {
	NO_LIST = 0,
	DIR_LIST,
	CATALOG_LIST,
	CANCEL_BTN,
	NUM_CONTENT_TYPES
} SidebarContent;

/* keep the order of the items in sync with the order of the 
 * sort_by_radio_list structure in the file menu.h */
typedef enum {
	SORT_NONE,
	SORT_BY_NAME,
	SORT_BY_PATH,
	SORT_BY_SIZE,
	SORT_BY_TIME
} SortMethod;


typedef void (*ErrorFunc)      (gpointer data);

typedef void (*DoneFunc)       (gpointer data);

typedef void (*ProgressFunc)   (gfloat percent, 
				gpointer data);

typedef void (*AreaReadyFunc)  (guint x,
				guint y, 
				guint w, 
				guint h, 
				gpointer data);


#endif /* TYPEDEFS_H */

