/* matrix/matrix_source.c
 * 
 * Copyright (C) 1996, 1997, 1998, 1999, 2000 Gerard Jungman, Brian Gough
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

inline BASE
FUNCTION (gsl_matrix, get) (const TYPE (gsl_matrix) * m,
			    const size_t i, const size_t j)
{
  const BASE zero = ZERO;

  if (gsl_check_range)
    {
      if (i >= m->size1)	/* size_t is unsigned, can't be negative */
	{
	  GSL_ERROR_RETURN ("first index out of range", GSL_EINVAL, zero);
	}
      else if (j >= m->size2)	/* size_t is unsigned, can't be negative */
	{
	  GSL_ERROR_RETURN ("second index out of range", GSL_EINVAL, zero);
	}
    }
  return *(BASE *) (m->data + MULTIPLICITY * (i * m->tda + j));
}

inline void
FUNCTION (gsl_matrix, set) (TYPE (gsl_matrix) * m,
			    const size_t i, const size_t j,
			    const BASE x)
{
  if (gsl_check_range)
    {
      if (i >= m->size1)	/* size_t is unsigned, can't be negative */
	{
	  GSL_ERROR_RETURN_NOTHING ("first index out of range", GSL_EINVAL);
	}
      else if (j >= m->size2)	/* size_t is unsigned, can't be negative */
	{
	  GSL_ERROR_RETURN_NOTHING ("second index out of range", GSL_EINVAL);
	}
    }
  *(BASE *) (m->data + MULTIPLICITY * (i * m->tda + j)) = x;
}
