/* $Id: gvlang.c,v 1.3 2004/08/30 17:25:01 ellson Exp $ $Revision: 1.3 $ */
/* vim:set shiftwidth=4 ts=8: */
/*
    This software may only be used by you under license from AT&T Corp.
    ("AT&T").  A copy of AT&T's Source Code Agreement is available at
    AT&T's Internet website having the URL:
    <http://www.research.att.com/sw/tools/graphviz/license/source.html>
    If you received this software without first entering into a license
    with AT&T, you have an infringing copy of this software and cannot use
    it without violating AT&T's intellectual property rights.
*/

#include	"config.h"

#if ENABLE_GVRENDER

#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>

#include	"const.h"
#include	"types.h"
#include	"graph.h"   /* must follow types.h */ /* FOR AGWARN */
#include	"gvre.h"
#include	"gvrender.h"

extern struct gvre_s {
        gvrender_engine_t *gvre;
        char *name;
} gvrender_engines[];

char*
gvlang_name (int langID)
{
    struct  gvre_s *gvre;

    for (gvre = gvrender_engines; gvre->name; gvre++) {
        if (gvre->gvre->id == langID)
		return gvre->name;
    }
    return NULL;
}

#endif /* ENABLE_GVRENDER */
