/* $Id: gvcontext.c,v 1.1 2004/04/19 16:17:26 ellson Exp $ $Revision: 1.1 $ */
/* vim:set shiftwidth=4 ts=8: */
/*
    This software may only be used by you under license from AT&T Corp.
    ("AT&T").  A copy of AT&T's Source Code Agreement is available at
    AT&T's Internet website having the URL:
    <http://www.research.att.com/sw/tools/graphviz/license/source.html>
    If you received this software without first entering into a license
    with AT&T, you have an infringing copy of this software and cannot use
    it without violating AT&T's intellectual property rights.
*/

/*
    A gvcontext is a single instance of a GVC_t data structure providing
    for a set of plugins for processing one graph at a time, and a job
    description provividing for a sequence of graph jobs.

    Sometime in the future it may become the basis for a thread.
 */

#include        <stdio.h>
#include        <stdlib.h>
                                                                                
#include	"config.h"
#include	"types.h"
#include	"macros.h"
#include	"gvrender.h"

/* from common/utils.c */
extern void *zmalloc(size_t);

GVC_t *gvNEWcontext(char **info, char *user)
{
    GVC_t *gvc = zmalloc(sizeof(GVC_t));

    if (gvc) {
	gvc->info = info;
	gvc->user = user;
	gvc->onetime = TRUE;	/* force initial reset */
    }
    return gvc;
}

void gvBindContext(GVC_t * gvc, graph_t *g)
{
	gvc->g = g;
}

void gvFREEcontext(GVC_t * gvc)
{
    gvrender_delete_jobs(gvc);
    free(gvc);
}
