/*
 * GQmpeg
 * (C) 2001 John Ellis
 *
 * Author: John Ellis
 *
 * This software is released under the GNU General Public License (GNU GPL).
 * Please read the included file COPYING for more information.
 * This software comes with no warranty of any kind, use at your own risk!
 */


#include "gqmpeg.h"
#include "menus.h"

#include "btn_funcs.h"
#include "playlist-window.h"
#include "preferences.h"
#include "ui_menu.h"


static GtkWidget *preset_menu = NULL;


/*
 *----------------
 * the menus
 *----------------
 */

static void load_preset_from_menu(GtkWidget *widget, gpointer data)
{
	gint n = GPOINTER_TO_INT(data);

	load_preset(n);
}

void create_preset_menu(void)
{
	GtkWidget *menu;
	gint i;
        menu = gtk_menu_new();
        for (i=0; i<10; i++)
                {
		gchar *s;

                if (preset_name[i] && preset_file[i])
                        {
			s = g_strdup_printf("%d - %s", i + 1, preset_name[i]);
			menu_item_add(menu, s, GTK_SIGNAL_FUNC(load_preset_from_menu), GINT_TO_POINTER(i));
			g_free(s);
			}
		else
			{
			s = g_strdup_printf(_("%d - (empty)"), i + 1);
			menu_item_add(menu, s, NULL, NULL);
			g_free(s);
			}
                }

	menu_item_add_divider(menu);
	menu_item_add(menu, _("Set preset to playlist..."), GTK_SIGNAL_FUNC(set_preset_to_playlist), preset_file[i]);
	menu_item_add(menu, _("Set preset to song..."), GTK_SIGNAL_FUNC(set_preset_to_song), preset_file[i]);

        gtk_menu_item_set_submenu(GTK_MENU_ITEM(preset_menu), menu);
}

GtkWidget *create_main_menu(void)
{
	GtkWidget *menu;
	GtkWidget *submenu;
	GtkWidget *load_menu;
	GtkWidget *toggle_menu;
	GtkWidget *song_menu;

	menu = gtk_menu_new();

	menu_item_add(menu, _("Play"), GTK_SIGNAL_FUNC(btn_play_pressed), NULL);
	menu_item_add(menu, _("Pause"), GTK_SIGNAL_FUNC(btn_pause_pressed), NULL);
	menu_item_add(menu, _("Stop"), GTK_SIGNAL_FUNC(btn_stop_pressed), NULL);

	menu_item_add_divider(menu);

	menu_item_add(menu, _("Playlist..."), GTK_SIGNAL_FUNC(playlist_window_show), NULL);
	preset_menu = menu_item_add(menu, _("Presets"), NULL, NULL);
	load_menu = menu_item_add(menu, _("Open"), NULL, NULL);

	submenu = gtk_menu_new();
	menu_item_add(submenu, _("Playlist..."), GTK_SIGNAL_FUNC(btn_load_playlist_pressed), NULL);
	menu_item_add(submenu, _("File..."), GTK_SIGNAL_FUNC(btn_load_file_pressed), NULL);
	menu_item_add(submenu, _("Custom..."), GTK_SIGNAL_FUNC(btn_load_custom_pressed), NULL);
        gtk_menu_item_set_submenu(GTK_MENU_ITEM(load_menu),submenu);

	menu_item_add_divider(menu);

	toggle_menu = menu_item_add(menu, _("Toggle"), NULL, NULL);

	submenu = gtk_menu_new();
	menu_item_add(submenu, _("Shuffle"), GTK_SIGNAL_FUNC(btn_shuffle_pressed), NULL);
	menu_item_add(submenu, _("Repeat"), GTK_SIGNAL_FUNC(btn_repeat_pressed), NULL);
	menu_item_add(submenu, _("Time Display"), GTK_SIGNAL_FUNC(time_toggle_pressed), NULL);
	menu_item_add(submenu, _("Time Remaining"), GTK_SIGNAL_FUNC(time_remaining_pressed), NULL);
        gtk_menu_item_set_submenu(GTK_MENU_ITEM(toggle_menu), submenu);

	menu_item_add(menu, _("Preferences..."), GTK_SIGNAL_FUNC(show_configuration_window), NULL);

	menu_item_add_divider(menu);

	song_menu = menu_item_add(menu, _("Current song"), NULL, NULL);

	submenu = gtk_menu_new();
	menu_item_add(submenu, _("Song Info..."), GTK_SIGNAL_FUNC(current_song_info_pressed), NULL);
	menu_item_add(submenu, _("Add to playlist"), GTK_SIGNAL_FUNC(current_song_pl_add_pressed), NULL);
	menu_item_add(submenu, _("Remove from playlist"), GTK_SIGNAL_FUNC(current_song_pl_rem_pressed), NULL);
        gtk_menu_item_set_submenu(GTK_MENU_ITEM(song_menu), submenu);

	menu_item_add(menu, _("Run mixer..."), GTK_SIGNAL_FUNC(btn_mixer_pressed), NULL);
	menu_item_add_divider(menu);
	menu_item_add(menu, _("Skin Editor..."), GTK_SIGNAL_FUNC(btn_edit_skin_pressed), NULL);
	menu_item_add(menu, _("About..."), GTK_SIGNAL_FUNC(show_about_info), NULL);
	menu_item_add_divider(menu);
	menu_item_add(menu, _("Iconify"), GTK_SIGNAL_FUNC(btn_iconify_pressed), NULL);
	menu_item_add(menu, _("Exit"), GTK_SIGNAL_FUNC(gqmpeg_exit), NULL);

	create_preset_menu();

	return menu;
}

GtkWidget *create_dir_menu(void)
{
	GtkWidget *menu;

	menu = gtk_menu_new();

	menu_item_add(menu, _("Add"), GTK_SIGNAL_FUNC(plw_add_dir_pressed), NULL);
	menu_item_add(menu, _("Add Recursive"), GTK_SIGNAL_FUNC(plw_add_dir_recursive_pressed), NULL);

	return menu;
}

GtkWidget *create_file_menu(void)
{
	GtkWidget *menu;

	menu = gtk_menu_new();

	menu_item_add(menu, _("Add"), GTK_SIGNAL_FUNC(plw_filelist_add_pressed), NULL);
	menu_item_add(menu, _("Insert"), GTK_SIGNAL_FUNC(plw_filelist_insert_pressed), NULL);
	menu_item_add_divider(menu);
	menu_item_add(menu, _("Play"), GTK_SIGNAL_FUNC(plw_filelist_play_pressed), NULL);
	menu_item_add(menu, _("Add and Play"), GTK_SIGNAL_FUNC(plw_filelist_add_play_pressed), NULL);
	menu_item_add(menu, _("Song Info..."), GTK_SIGNAL_FUNC(plw_filelist_songinfo_pressed), NULL);
	menu_item_add_divider(menu);
	menu_item_add(menu, _("Copy"), GTK_SIGNAL_FUNC(plw_filelist_copy_pressed), NULL);
	menu_item_add(menu, _("Move"), GTK_SIGNAL_FUNC(plw_filelist_move_pressed), NULL);
	menu_item_add(menu, _("Rename"), GTK_SIGNAL_FUNC(plw_filelist_rename_pressed), NULL);
	menu_item_add(menu, _("Delete"), GTK_SIGNAL_FUNC(plw_filelist_delete_pressed), NULL);

	return menu;
}

GtkWidget *create_file_menu_list(void)
{
	GtkWidget *menu;

	menu = gtk_menu_new();

	menu_item_add(menu, _("Load"), GTK_SIGNAL_FUNC(plw_load_pressed), NULL);
	menu_item_add(menu, _("Append"), GTK_SIGNAL_FUNC(plw_append_pressed), NULL);
	menu_item_add_divider(menu);
	menu_item_add(menu, _("Copy"), GTK_SIGNAL_FUNC(plw_filelist_copy_pressed), NULL);
	menu_item_add(menu, _("Move"), GTK_SIGNAL_FUNC(plw_filelist_move_pressed), NULL);
	menu_item_add(menu, _("Rename"), GTK_SIGNAL_FUNC(plw_filelist_rename_pressed), NULL);
	menu_item_add(menu, _("Delete"), GTK_SIGNAL_FUNC(plw_filelist_delete_pressed), NULL);

	return menu;
}

static void playlist_menu_add_defaults(GtkWidget *menu)
{
	menu_item_add(menu, _("Play"), GTK_SIGNAL_FUNC(plw_playlist_play_pressed), NULL);
	menu_item_add_divider(menu);
	menu_item_add(menu, _("Remove"), GTK_SIGNAL_FUNC(plw_playlist_remove_pressed), NULL);
	menu_item_add(menu, _("Song Info..."), GTK_SIGNAL_FUNC(plw_playlist_songinfo_pressed), NULL);
	menu_item_add_divider(menu);
}

static void playlist_menu_add_shuffle(GtkWidget *menu)
{
	menu_item_add_divider(menu);
	menu_item_add(menu, _("Randomize list"), GTK_SIGNAL_FUNC(plw_playlist_randomize_pressed), NULL);
}

GtkWidget *create_playlist_menu(void)
{
	GtkWidget *menu;

	menu = gtk_menu_new();
	playlist_menu_add_defaults(menu);

	menu_item_add(menu, _("Copy"), GTK_SIGNAL_FUNC(plw_playlist_copy_pressed), NULL);
	menu_item_add(menu, _("Move"), GTK_SIGNAL_FUNC(plw_playlist_move_pressed), NULL);
	menu_item_add(menu, _("Rename"), GTK_SIGNAL_FUNC(plw_playlist_rename_pressed), NULL);
	menu_item_add(menu, _("Delete"), GTK_SIGNAL_FUNC(plw_playlist_delete_pressed), NULL);

	playlist_menu_add_shuffle(menu);

	return menu;
}

GtkWidget *create_playlist_menu_custom(void)
{
	GtkWidget *menu;

	menu = gtk_menu_new();
	playlist_menu_add_defaults(menu);

	menu_item_add(menu, _("Edit..."), GTK_SIGNAL_FUNC(plw_playlist_edit_pressed), NULL);

	playlist_menu_add_shuffle(menu);

	return menu;
}



