/*
 * GQmpeg
 * (C)1998, 1999 John Ellis
 *
 * Author: John Ellis
 *
 * This software is released under the GNU General Public License.
 * Please read the included file COPYING for more information.
 * This software comes with no warranty of any kind, use at you own risk!
 */

#include "gqmpeg.h"

#include "default_skin/background.xpm"
#include "default_skin/btn_play.xpm"
#include "default_skin/btn_stop.xpm"
#include "default_skin/btn_pause.xpm"
#include "default_skin/btn_prev.xpm"
#include "default_skin/btn_next.xpm"
#include "default_skin/btn_repeat.xpm"
#include "default_skin/btn_shuffle.xpm"
#include "default_skin/btn_playlist.xpm"
#include "default_skin/btn_config.xpm"
#include "default_skin/btn_mixer.xpm"
#include "default_skin/btn_exit.xpm"
#include "default_skin/btn_iconify.xpm"
#include "default_skin/btn_mode.xpm"
#include "default_skin/digsml.xpm"
#include "default_skin/digbig.xpm"
#include "default_skin/letters.xpm"
#include "default_skin/mpegver.xpm"
#include "default_skin/layer.xpm"
#include "default_skin/mode.xpm"
#include "default_skin/shuffle.xpm"
#include "default_skin/repeat.xpm"
#include "default_skin/stereo.xpm"
#include "default_skin/posbar.xpm"
#include "default_skin/volume.xpm"
#include "default_skin/volume_sl.xpm"
#include "default_skin/btn_p1.xpm"
#include "default_skin/btn_p2.xpm"
#include "default_skin/btn_p3.xpm"
#include "default_skin/btn_p4.xpm"
#include "default_skin/btn_p5.xpm"
#include "default_skin/btn_p6.xpm"
#include "default_skin/btn_p7.xpm"
#include "default_skin/btn_p8.xpm"

#include "default_skin/background_sm.xpm"
#include "default_skin/btn_play_sm.xpm"
#include "default_skin/btn_stop_sm.xpm"
#include "default_skin/btn_pause_sm.xpm"
#include "default_skin/btn_prev_sm.xpm"
#include "default_skin/btn_next_sm.xpm"
#include "default_skin/btn_mode_sm.xpm"
#include "default_skin/digmed.xpm"
#include "default_skin/repeat_sm.xpm"
#include "default_skin/shuffle_sm.xpm"
#include "default_skin/letters_sm.xpm"

SkinData *load_default_normal_skin()
{
	SkinData *s;
	GtkStyle *style;
	GdkPixmap *background;
	gint width, height;

	s = new_skin();

        style = gtk_widget_get_style(mainwindow);
	background = get_pixmap_from_data((gchar **)background_xpm);

	gdk_window_get_size (background, &width, &height);

	s->background = background;
	s->width = width;
	s->height = height;

	s->title = new_font_from_data((gchar **)letters_xpm, 27, FALSE, 5, 22);

	s->dig_small = new_digit_from_data((gchar **)digsml_xpm);
	s->dig_large = new_digit_from_data((gchar **)digbig_xpm);

	s->prev = new_button_from_data((gchar **)btn_prev_xpm, TRUE, FALSE, 4, 92,
				btn_prev_pressed, btn_prev_down, btn_prev_up);
	s->pause = new_button_from_data((gchar **)btn_pause_xpm, TRUE, TRUE, 40, 92,
				btn_pause_pressed, NULL, NULL);
	s->play = new_button_from_data((gchar **)btn_play_xpm, TRUE, TRUE, 76, 92,
				btn_play_pressed, NULL, NULL);
	s->stop = new_button_from_data((gchar **)btn_stop_xpm, TRUE, TRUE, 127, 92,
				btn_stop_pressed, NULL, NULL);
	s->next = new_button_from_data((gchar **)btn_next_xpm, TRUE, FALSE, 163, 92,
				btn_next_pressed, btn_next_down, btn_next_up);

	s->shuffle = new_button_from_data((gchar **)btn_shuffle_xpm, TRUE, FALSE, 199, 92,
				btn_shuffle_pressed, NULL, NULL);
	s->repeat = new_button_from_data((gchar **)btn_repeat_xpm, TRUE, FALSE, 234, 92,
				btn_repeat_pressed, NULL, NULL);
	s->playlist = new_button_from_data((gchar **)btn_playlist_xpm, TRUE, FALSE, 269, 108,
				playlist_window_show, NULL, NULL);
	s->config = new_button_from_data((gchar **)btn_config_xpm, TRUE, FALSE, 269, 92,
				show_configuration_window, NULL, NULL);
	s->iconify = new_button_from_data((gchar **)btn_iconify_xpm, TRUE, FALSE, 270, 3,
				btn_iconify_pressed, NULL, NULL);
	s->exit = new_button_from_data((gchar **)btn_exit_xpm, TRUE, FALSE, 287, 3,
				gqmpeg_exit, NULL, NULL);
	s->mixer = new_button_from_data((gchar **)btn_mixer_xpm, TRUE, FALSE, 287, 92,
				btn_mixer_pressed, NULL, NULL);
	s->skin_mode = new_button_from_data((gchar **)btn_mode_xpm, TRUE, FALSE, 250, 3,
				mode_button_pressed, NULL, NULL);

	s->stereo = new_item_from_data((gchar **)stereo_xpm, 3, 234, 48);
	s->item_shuffle = new_item_from_data((gchar **)shuffle_xpm, 2, 162, 77);
	s->item_repeat = new_item_from_data((gchar **)repeat_xpm, 2, 162, 83);
	s->mpegver = new_item_from_data((gchar **)mpegver_xpm, 3, 35, 81);
	s->layer = new_item_from_data((gchar **)layer_xpm, 4, 78, 81);
	s->mode = new_item_from_data((gchar **)mode_xpm, 5, 94, 81);

	s->min = new_number(s->dig_large, 2, FALSE, 55, 48);
	s->sec = new_number(s->dig_large, 2, TRUE, 89, 48);

	s->song_current = new_number(s->dig_large, 3, FALSE, 129, 48);
	s->song_total = new_number(s->dig_large, 3, FALSE, 185, 48);

	s->input_bits = new_number(s->dig_small, 3, FALSE, 5, 49);
	s->input_hz = new_number(s->dig_small, 2, FALSE, 5, 64);
	s->output_bits = new_number(s->dig_small, 2, FALSE, 233, 59);
	s->output_hz = new_number(s->dig_small, 2, FALSE, 269, 59);
	s->cpu = new_number(s->dig_small, 2, FALSE, 280, 77);

	s->position = new_slider_from_data((gchar **)posbar_xpm, TRUE, FALSE, FALSE, 155, 83, 6,
			NULL, position_slider_moved, position_slider_released,
			position_slider_moved);

	s->volume_item = new_item_from_data((gchar **)volume_xpm, 17, 210, 77);
	s->volume = new_slider_from_data((gchar **)volume_sl_xpm, FALSE, FALSE, FALSE, 47, 210, 77,
			s->volume_item, volume_slider_moved, NULL, volume_slider_moved);

	s->preset[0] = new_button_from_data((gchar **)btn_p1_xpm, TRUE, FALSE, 201, 108,
				preset_1_pressed, NULL, NULL);
	s->preset[1] = new_button_from_data((gchar **)btn_p2_xpm, TRUE, FALSE, 209, 108,
				preset_2_pressed, NULL, NULL);
	s->preset[2] = new_button_from_data((gchar **)btn_p3_xpm, TRUE, FALSE, 217, 108,
				preset_3_pressed, NULL, NULL);
	s->preset[3] = new_button_from_data((gchar **)btn_p4_xpm, TRUE, FALSE, 225, 108,
				preset_4_pressed, NULL, NULL);
	s->preset[4] = new_button_from_data((gchar **)btn_p5_xpm, TRUE, FALSE, 233, 108,
				preset_5_pressed, NULL, NULL);
	s->preset[5] = new_button_from_data((gchar **)btn_p6_xpm, TRUE, FALSE, 241, 108,
				preset_6_pressed, NULL, NULL);
	s->preset[6] = new_button_from_data((gchar **)btn_p7_xpm, TRUE, FALSE, 249, 108,
				preset_7_pressed, NULL, NULL);
	s->preset[7] = new_button_from_data((gchar **)btn_p8_xpm, TRUE, FALSE, 257, 108,
				preset_8_pressed, NULL, NULL);

	return s;
}

SkinData *load_default_small_skin()
{
	SkinData *s;
	GtkStyle *style;
	GdkPixmap *background;
	gint width, height;

	s = new_skin();

        style = gtk_widget_get_style(mainwindow);
	background = get_pixmap_from_data((gchar **)background_sm_xpm);

	gdk_window_get_size (background, &width, &height);

	s->background = background;
	s->width = width;
	s->height = height;

	s->title = new_font_from_data((gchar **)letters_sm_xpm, 16, FALSE, 3, 3);

	s->dig_large = new_digit_from_data((gchar **)digmed_xpm);

	s->prev = new_button_from_data((gchar **)btn_prev_sm_xpm, TRUE, FALSE, 105, 3,
				btn_prev_pressed, btn_prev_down, btn_prev_up);
	s->pause = new_button_from_data((gchar **)btn_pause_sm_xpm, TRUE, TRUE, 122, 3,
				btn_pause_pressed, NULL, NULL);
	s->play = new_button_from_data((gchar **)btn_play_sm_xpm, TRUE, TRUE, 139, 3,
				btn_play_pressed, NULL, NULL);
	s->stop = new_button_from_data((gchar **)btn_stop_sm_xpm, TRUE, TRUE, 156, 3,
				btn_stop_pressed, NULL, NULL);
	s->next = new_button_from_data((gchar **)btn_next_sm_xpm, TRUE, FALSE, 173, 3,
				btn_next_pressed, btn_next_down, btn_next_up);

	s->iconify = new_button_from_data((gchar **)btn_iconify_xpm, TRUE, FALSE, 270, 3,
				btn_iconify_pressed, NULL, NULL);
	s->exit = new_button_from_data((gchar **)btn_exit_xpm, TRUE, FALSE, 287, 3,
				gqmpeg_exit, NULL, NULL);
	s->skin_mode = new_button_from_data((gchar **)btn_mode_sm_xpm, TRUE, FALSE, 250, 3,
				mode_button_pressed, NULL, NULL);

	s->item_shuffle = new_item_from_data((gchar **)shuffle_sm_xpm, 2, 197, 5);
	s->item_repeat = new_item_from_data((gchar **)repeat_sm_xpm, 2, 197, 12);

	s->min = new_number(s->dig_large, 2, FALSE, 201, 3);
	s->sec = new_number(s->dig_large, 2, TRUE, 224, 3);

/*	s->cpu = new_number(s->dig_small, 2, FALSE, 280, 77);*/

	return s;
}

