/*
 * GQmpeg
 * (C)1998, 1999 John Ellis
 *
 * Author: John Ellis
 *
 * This software is released under the GNU General Public License.
 * Please read the included file COPYING for more information.
 * This software comes with no warranty of any kind, use at you own risk!
 */

#include "gqmpeg.h"

#define		MPG123_DOWNSAMPLE_AUTO 0
#define		MPG123_DOWNSAMPLE_22 1
#define		MPG123_DOWNSAMPLE_11 2
#define		MPG123_DOWNSAMPLE_CUSTOM 3

typedef struct _Mpg_Data Mpg_Data;
struct _Mpg_Data
{
	gint version;
	gint layer;
	gint error_protection;
	gint bit_rate;
	gint sample_rate;
	gint padding;
	gint extension;
	gint channel_mode;
	gint mode_extension;
	gint copyright;
	gint original;
	gint emphasis;

	gchar *version_text;
	gchar *version_number_text;
	gchar *layer_text;
	gchar *mode_text;

	gint stereo;			/* if true, 2 or more channels */
	gint file_length;		/* length of file in bytes */
	gint length;			/* length in seconds */
};

typedef struct _ID3_Data ID3_Data;
struct _ID3_Data
{
	gchar *title;
	gchar *artist;
	gchar *album;
	gchar *year;
	gchar *comment;
	gint8 genre;
	gchar *genre_description;
};

	/* options */
extern gint mpg123_buffer_enable;
extern gint mpg123_buffer;
extern gint mpg123_downsample;
extern gint mpg123_custom_sample_size;
extern gint mpg123_mono;
extern gint mpg123_8bit;
extern gint mpg123_device_enable;
extern gchar *mpg123_device;
extern gint mpg123_aggressive;
extern gint mpg123_use_freeamp;

/*
 * =========================== io_mpg123.c
 */
gint type_is_http(gchar *path);


/*
 * =========================== io_mpg123_cfg.c
 */
void mpg123_config_load(FILE *f, gchar *option, gchar *value, gchar *value_all);
void mpg123_config_save(FILE *f);
void mpg123_config_apply();
void mpg123_config_close();
GtkWidget *mpg123_config_init();

/*
 * =========================== mpg_hdrutil.c
 */
Mpg_Data *get_mpg_header_info(gchar *path);

/*
 * =========================== mpg_tagutil.c
 */
gchar* get_id3_genre(gint g);
ID3_Data *get_id3_tag(gchar *path);
gint set_id3_tag(gchar *path, gchar *title, gchar *artist, gchar *album,
		 gchar *year, gchar *comment, guint8 genre);
void free_id3_tag(ID3_Data *d);

/*
 * =========================== mpg_info.c
 */
GtkWidget *mpg_create_info_window(gchar *file);


