/*
 * (SLIK) SimpLIstic sKin functions
 * (C) 2002 John Ellis
 *
 * Author: John Ellis
 *
 * This software is released under the GNU General Public License (GNU GPL).
 * Please read the included file COPYING for more information.
 * This software comes with no warranty of any kind, use at your own risk!
 */

#ifndef UI2_TYPEDEFS_H
#define UI2_TYPEDEFS_H


/*
 *-------------------------------------
 * SLIK defines
 *-------------------------------------
 */

#define SLIK_VERSION "0.6.3"

#define SKIN_SIZE_MIN 4
#define SKIN_SIZE_MAX 2000

/*
 *-------------------------------------
 * SLIK data structures
 *-------------------------------------
 */

typedef gint WidgetType;

typedef struct _WidgetObjectData WidgetObjectData;
typedef struct _WidgetData WidgetData;

typedef struct _UIData UIData;
typedef struct _RegisterData RegisterData;
typedef struct _SkinData SkinData;

typedef struct _EditData EditData;


struct _WidgetObjectData
{
	WidgetType type;
	gchar *description;

	gint is_visible;

	/* general ui */
	void (*func_draw)(gpointer widget, const gchar *key, gint update, gint force, GdkPixbuf *pb, UIData *ui);
	void (*func_reset)(gpointer widget, const gchar *key, GdkPixbuf *pb, UIData *ui);
	gint (*func_press)(gpointer widget, const gchar *key, gint x, gint y, GdkPixbuf *pb, UIData *ui);
	void (*func_release)(gpointer widget, const gchar *key, gint x, gint y, GdkPixbuf *pb, UIData *ui);
	void (*func_motion)(gpointer widget, const gchar *key, gint x, gint y, GdkPixbuf *pb, UIData *ui);
	void (*func_back)(gpointer widget, GdkPixbuf *pb);
	void (*func_free)(gpointer widget);

	gint (*func_get_geometry)(gpointer widget, gint *x, gint *y, gint *w, gint *h);
	void (*func_set_coord)(gpointer widget, gint x, gint y);
	void (*func_set_size)(gpointer widget, gint dev_w, gint dev_h);

	/* loading */
	WidgetData *(*func_parse)(SkinData *skin, GList *list, const gchar *skin_dir, const gchar *key, gint edit);

	/* internal widget init stuff */
	void (*func_init)(gpointer widget, const gchar *key, UIData *ui);

	/* editor */
	GdkPixbuf *(*func_get_pixbuf)(gpointer widget);

	void (*func_edit_write)(FILE *f, WidgetData *wd, SkinData *skin, const gchar *dir);
	gpointer (*func_edit_read)(UIData *ui, WidgetData *wd, GList *list);
	void (*func_edit_free)(gpointer data);

	gpointer (*func_edit_props)(UIData *ui, WidgetData *wd, GtkWidget *vbox, gpointer detail);
	GtkWidget *(*func_edit_page_new)(EditData *ed);
	void (*func_edit_page_add)(GtkWidget *widget, gpointer data);

	gint (*func_edit_removable)(gpointer widget);
};


struct _WidgetData
{
	WidgetType type;
	gchar *key;
	gchar *text_id;
	gpointer widget;
	GList *data_list;

	const WidgetObjectData *od;

	gint hidden;
	gint in_bounds;

	gint anchor_right;
	gint anchor_bottom;
};


struct _RegisterData
{
	WidgetType type;
	gchar *key;
	gpointer callbacks;	/* struct containing update functions */
	guint callbacks_l;	/* byte size of callback data (used for copying) */
	gint private;		/* signal is internal to skin widgets ? (cleared on every skin change) */
	gpointer private_widget;	/* pointer to widget that holds this key (only used on unreg) */
};


struct _SkinData
{
	GdkPixbuf *overlay;	/* background */
	GdkPixbuf *pixbuf;	/* pixbuf */
	GdkPixmap *buffer;	/* offscreen buffer */
	GdkPixbuf *mask;	/* shape mask */
	GdkBitmap *mask_buffer;	/* bitmap version of mask */
	gint width;
	gint height;
	gint transparent;

	GdkPixbuf *real_overlay;	/* used to hold original image for borders / stretch / resize */

	gint stretch;		/* stretch image to a size? (width, height) */

	/* borders */
	gint has_border;
	gint border_left;
	gint border_right;
	gint border_top;
	gint border_bottom;
	gint border_left_stretch;
	gint border_right_stretch;
	gint border_top_stretch;
	gint border_bottom_stretch;

	/* resizing */
	gint sizeable;
	gint width_def;
	gint width_min;
	gint width_max;
	gint width_inc;
	gint height_def;
	gint height_min;
	gint height_max;
	gint height_inc;

	GList *widget_list;	/* widget list of WidgetData structs */

	UIData *ui;		/* ui attached to */

	gchar *background_filename;		/* used by editor */
	gchar *background_mask_filename;	/* " */
};


struct _UIData
{
	GtkWidget *window;
	GtkWidget *display;

	gchar *key;		/* key to reference ui */

	GList *register_list;	/* list of registered functions */
	SkinData *skin;
	gchar *skin_path;	/* location of skin, NULL for default? */
	gchar *skin_mode_key;	/* filename of skindata equivelent, NULL for default */

	gint decorations;	/* show decorations */
	gint allow_move;	/* move by dragging mouse */

	/* called for click on a button greater than 2 (3, 4, 5, etc.) */
	void (*click_func)(UIData *ui, gint button, guint32 time, gpointer data);
	gpointer click_data;

	WidgetData *active_widget;	/* widget with the mouse grab */
	gint in_press;
	gint in_move;

	gint press_x;
	gint press_y;
	gint press_root_x;
	gint press_root_y;

	gint frozen;

	gint root_win_idle;

	UIData *edit;

	gint destroyed;
};


struct _EditData
{
	GtkWidget *window;
	GtkWidget *hbox;
	GtkWidget *table;
	UIData *ui;
	UIData *parent;	/* UI being edited */

	/* the rest is private (and should be made that way) */

	WidgetData *active_widget;
	gint in_press;
	gint in_move;

	gint press_widget_x;
	gint press_widget_y;
	gint press_x;
	gint press_y;

	WidgetData *info_widget;

	GtkWidget *widget_clist;
	GtkWidget *spin_x;
	GtkWidget *spin_y;
	GtkWidget *description;
	GtkWidget *key_combo_entry;
	GtkWidget *data_entry;
	GtkWidget *text_id_entry;
	GtkWidget *image_entry;
	GtkWidget *widget_pixmap;
	GtkWidget *clip_mask_entry;

	GtkWidget *anchor_right_button;
	GtkWidget *anchor_bottom_button;

	GtkWidget *detail_vbox;
	GtkWidget *details;
	gpointer detail_data;
	WidgetType detail_type;

	gint click_to_focus;

	GtkWidget *save_path_entry;
	GtkWidget *save_key_entry;

	/* widget addition dialog */
	GtkWidget *widget_window;
	GtkWidget *notebook;

	GtkWidget *import_path_entry;

	GList *widget_id_list;		/* list of 'widget type' data pointers */

	GList *main_list;		/* list of 'add' backgrounds */
	gpointer main_page;		/* pointer to background page 'add' data */

	/* help dialog */
	GtkWidget *help_window;
	GtkWidget *help_text;
	gint help_follow;
	gint help_lines;		/* crappy, broken set postion in GtkText */

	gchar *help_path;
};


/*
 *-------------------------------------
 * SLIK globals
 *-------------------------------------
 */

extern gint slik_smart_placement;
extern gint slik_remember_position;

extern gint slik_double_size;

extern gint slik_colorshift_r;
extern gint slik_colorshift_g;
extern gint slik_colorshift_b;
extern gint slik_colorshift_a;
extern gint slik_colorshift_on;

extern gint slik_transparency_force;
extern gint slik_transparency_force_a;

extern gint debug_mode;
extern gint debug_skin;


#endif




