/*
    GQ -- a GTK-based LDAP client
    Copyright (C) 1998-2001 Bert Vermeulen

    This program is released under the Gnu General Public License with
    the additional exemption that compiling, linking, and/or using
    OpenSSL is allowed.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <ldap_schema.h>

enum schema_detail_type {
     SCHEMA_TYPE_OC,
     SCHEMA_TYPE_AT,
     SCHEMA_TYPE_MR,
     SCHEMA_TYPE_S
};


void new_schemamode(GHashTable *hash);
void add_schema_servers(GHashTable *hash, GtkWidget *treeroot);
void attach_server_schema(GtkWidget *item, GHashTable *hash);
void attach_schema_item(GtkWidget *tree, char *type, void *schemaobject, char *itemname);

gboolean schema_button_tree(GtkWidget *tree_item, GdkEventButton *event);
void schema_refresh_server(GtkWidget *widget, GtkWidget *item);

void make_detail_notebook(GHashTable *hash);
void popup_detail_callback(GtkWidget *dummy, GtkWidget *widget);
void popup_detail(enum schema_detail_type type, struct ldapserver *server, void *detail);

void make_oc_detail(GtkWidget *target_oc_vbox);
void fill_oc_detail_rightpane(GtkWidget *treeroot, GtkWidget *tree_item, GHashTable *hash);
void fill_oc_detail(GtkWidget *target_oc_vbox, struct ldapserver *server,
		    LDAPObjectClass *oc);

void make_at_detail(GtkWidget *target_at_vbox);
void fill_at_detail_rightpane(GtkWidget *treeroot, GtkWidget *tree_item, GHashTable *hash);
void fill_at_detail(GtkWidget *target_vbox, struct ldapserver *server,
		    LDAPAttributeType *at);

void make_mr_detail(GtkWidget *target_mr_vbox);
void fill_mr_detail_rightpane(GtkWidget *treeroot, GtkWidget *tree_item, GHashTable *hash);
void fill_mr_detail(GtkWidget *target_vbox, struct ldapserver *server,
		    LDAPMatchingRule *mr);

void make_s_detail(GtkWidget *target_vbox);
void fill_s_detail_rightpane(GtkWidget *treeroot, GtkWidget *tree_item, GHashTable *hash);
void fill_s_detail(GtkWidget *target_vbox, struct ldapserver *server,
		   LDAPSyntax *s);

void select_oc_from_clist(GtkWidget *clist, gint row, gint column,
			  GdkEventButton *event, gpointer data);
void select_at_from_clist(GtkWidget *clist, gint row, gint column,
			  GdkEventButton *event, gpointer data);
void select_mr_from_clist(GtkWidget *clist, gint row, gint column,
			  GdkEventButton *event, gpointer data);

void cleanup_schema_mode(void);
